/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.sql.loader;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.PostConstruct;
import net.turnbig.jdbcx.sql.loader.SqlTemplateLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.jdbcx.sql")
public class SqlLoader {
    private Logger logger = LoggerFactory.getLogger(SqlLoader.class);
    String[] templatePath;
    String templateEncoding = "UTF-8";
    Long updateDelay = 5000L;
    private Configuration configuration;

    @PostConstruct
    public void initConfiguration() throws IOException {
        if (this.templatePath == null || this.templatePath.length == 0) {
            throw new RuntimeException("no sql template path has been set");
        }
        SqlTemplateLoaderFactory sqlTemplateFactory = new SqlTemplateLoaderFactory();
        sqlTemplateFactory.setLocations(this.templatePath);
        SqlTemplateLoaderFactory.SqlTemplateLoader sqlTemplateLoader = sqlTemplateFactory.createSqlTemplateLoader();
        Configuration configuration = new Configuration(Configuration.getVersion());
        configuration.setTemplateLoader((TemplateLoader)sqlTemplateLoader);
        configuration.setTemplateUpdateDelayMilliseconds(this.updateDelay.longValue());
        configuration.setDefaultEncoding(this.templateEncoding);
        this.configuration = configuration;
    }

    private Template getTemplate(String name) {
        try {
            return this.configuration.getTemplate(name);
        }
        catch (IOException e) {
            this.logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String processTpl(Template template, Object model) throws IOException, TemplateException {
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }

    public String getSql(String sqlTplName) {
        try {
            Template template = this.getTemplate(sqlTplName);
            String result = this.processTpl(template, null);
            return result.trim();
        }
        catch (IOException e) {
            this.logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            this.logger.error("There got a grammar error in freemarker template " + sqlTplName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getSql(String sqlTplName, Object model) {
        try {
            Template template = this.getTemplate(sqlTplName);
            return this.processTpl(template, model);
        }
        catch (IOException e) {
            this.logger.error("Can not get freemarker template resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            this.logger.error("There got a grammar error in freemarker template " + sqlTplName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setTemplateEncoding(String templateEncoding) {
        this.templateEncoding = templateEncoding;
    }

    public void setUpdateDelay(Long updateDelay) {
        this.updateDelay = updateDelay;
    }

    public void setTemplatePath(String[] templatePath) {
        this.templatePath = templatePath;
    }
}

