/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.sql.loader;

import freemarker.cache.StringTemplateLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.turnbig.jdbcx.sql.loader.SqlTemplateParser;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SqlTemplateLoaderFactory
implements FactoryBean<SqlTemplateLoader>,
InitializingBean {
    private static final String SQL_TEMPLATE_SYNC_FOLDER = ".sql.template.sync";
    private static Logger logger = LoggerFactory.getLogger(SqlTemplateLoaderFactory.class);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private String[] locations;
    private SqlTemplateLoader sqlTemplateLoader = new SqlTemplateLoader();
    private static String syncSqlTplFolder;

    public void afterPropertiesSet() throws Exception {
        this.createSqlTemplateLoader();
    }

    public SqlTemplateLoader createSqlTemplateLoader() throws IOException {
        syncSqlTplFolder = MessageFormat.format("{0}{1}{2}", this.resourceLoader.getResource("/").getFile().getAbsolutePath(), File.separator, SQL_TEMPLATE_SYNC_FOLDER);
        new File(syncSqlTplFolder).mkdirs();
        for (String path : this.locations) {
            this.loadTemplates(path);
        }
        return this.sqlTemplateLoader;
    }

    public void loadTemplates(String path) throws IOException {
        Resource r = this.resourceLoader.getResource(path);
        if (r.exists()) {
            List<Object> templates;
            block4: {
                templates = new ArrayList();
                try {
                    templates = SqlTemplateLoaderFactory.parseTemplate(r.getFile());
                }
                catch (Exception e) {
                    if (!path.endsWith(".xml")) break block4;
                    int n = path.contains("/") ? path.lastIndexOf("/") : path.indexOf(":");
                    String filename = path.substring(n + 1);
                    String syncToFileName = syncSqlTplFolder + File.separator + filename;
                    logger.debug("It seems {} is not a disk file, sync to {}", (Object)syncToFileName);
                    InputStream is = r.getInputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(new File(syncToFileName)));
                    IOUtils.closeQuietly((InputStream)is);
                    templates = SqlTemplateLoaderFactory.parseTemplate(new File(syncToFileName));
                }
            }
            for (SqlTemplate sqlTemplate : templates) {
                this.sqlTemplateLoader.putTemplate(sqlTemplate.getName(), sqlTemplate.getTemplate(), sqlTemplate.getLastModified());
                this.sqlTemplateLoader.addMapper(this.sqlTemplateLoader.findTemplateSource(sqlTemplate.getName()), sqlTemplate.getTplFilePath());
            }
        }
    }

    public static List<SqlTemplate> parseTemplate(InputStream is) throws IOException {
        String content = IOUtils.toString((InputStream)is);
        logger.debug("It seems the sql template is in JAR file, copy it to {}", (Object)syncSqlTplFolder);
        ArrayList<SqlTemplate> list = new ArrayList<SqlTemplate>();
        SqlTemplates templates = SqlTemplateParser.fromXML(content);
        for (SqlTemplate sqlTemplate : templates.getTemplates()) {
            sqlTemplate.setLastModified(new Date().getTime());
            sqlTemplate.setTplFilePath("");
            list.add(sqlTemplate);
        }
        return list;
    }

    public static List<SqlTemplate> parseTemplate(File file) {
        ArrayList<SqlTemplate> result;
        block3: {
            File[] files;
            block2: {
                result = new ArrayList<SqlTemplate>();
                if (!file.isFile()) break block2;
                logger.debug("load template from : {}", (Object)file.getAbsolutePath());
                SqlTemplates templates = SqlTemplateParser.fromXML(file);
                for (SqlTemplate sqlTemplate : templates.getTemplates()) {
                    sqlTemplate.setLastModified(file.lastModified());
                    sqlTemplate.setTplFilePath(file.getAbsolutePath());
                    result.add(sqlTemplate);
                }
                break block3;
            }
            if (!file.isDirectory()) break block3;
            logger.debug("load template from folder : {}", (Object)file.getAbsolutePath());
            for (File f : files = file.listFiles()) {
                result.addAll(SqlTemplateLoaderFactory.parseTemplate(f));
            }
        }
        return result;
    }

    public SqlTemplateLoader getObject() throws Exception {
        return this.sqlTemplateLoader;
    }

    public Class<SqlTemplateLoader> getObjectType() {
        return SqlTemplateLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public SqlTemplateLoader getSqlTemplateLoader() {
        return this.sqlTemplateLoader;
    }

    @XmlRootElement(name="Template")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SqlTemplate {
        @XmlElement(name="name")
        private String name;
        @XmlElement(name="template")
        private String template;
        private long lastModified;
        private String tplFilePath;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public String toString() {
            return "SqlTemplate [name=" + this.name + ", template=" + this.template + ", lastModified=" + this.lastModified + "]";
        }

        public String getTplFilePath() {
            return this.tplFilePath;
        }

        public void setTplFilePath(String tplFilePath) {
            this.tplFilePath = tplFilePath;
        }
    }

    @XmlRootElement(name="Templates")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SqlTemplates {
        @XmlElement(name="Template")
        List<SqlTemplate> templates = new ArrayList<SqlTemplate>();

        public List<SqlTemplate> getTemplates() {
            return this.templates;
        }

        public void setTemplates(List<SqlTemplate> templates) {
            this.templates = templates;
        }
    }

    public static class SqlTemplateLoader
    extends StringTemplateLoader {
        private HashMap<Object, String> resourceMapper = new HashMap();

        public Object findTemplateSource(String name) {
            Object stringTemplateSource = super.findTemplateSource(name);
            if (stringTemplateSource != null && this.resourceMapper.containsKey(stringTemplateSource)) {
                String path = this.resourceMapper.get(stringTemplateSource);
                List<SqlTemplate> tpls = SqlTemplateLoaderFactory.parseTemplate(new File(path));
                for (SqlTemplate xmlTemplate : tpls) {
                    this.putTemplate(xmlTemplate.getName(), xmlTemplate.getTemplate(), xmlTemplate.getLastModified());
                    this.addMapper(super.findTemplateSource(name), xmlTemplate.getTplFilePath());
                }
            }
            return super.findTemplateSource(name);
        }

        public long getLastModified(Object templateSource) {
            String path = this.resourceMapper.get(templateSource);
            File f = new File(path);
            return f.lastModified();
        }

        public void addMapper(Object object, String path) {
            this.resourceMapper.put(object, path);
        }
    }
}

