/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.proxy;

import enkan.exception.MisconfigurationException;
import enkan.middleware.session.KeyValueStore;
import enkan.util.BeanBuilder;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.unit8.bouncr.component.BouncrConfiguration;
import net.unit8.bouncr.component.RealmCache;
import net.unit8.bouncr.entity.Application;
import net.unit8.bouncr.entity.Realm;
import net.unit8.bouncr.sign.JsonWebToken;
import net.unit8.bouncr.sign.JwtHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class MultiAppProxyClient
implements ProxyClient {
    private static final Logger LOG = LoggerFactory.getLogger(MultiAppProxyClient.class);
    private static final ProxyClient.ProxyTarget PROXY_TARGET = new ProxyClient.ProxyTarget(){};
    private final AttachmentKey<ClientConnection> clientAttachmentKey = AttachmentKey.create(ClientConnection.class);
    private final UndertowClient client = UndertowClient.getInstance();
    private final KeyValueStore store;
    private final RealmCache realmCache;
    private final BouncrConfiguration config;
    private final JsonWebToken jwt;
    private final JwtHeader jwtHeader;

    public MultiAppProxyClient(BouncrConfiguration config, KeyValueStore store, RealmCache realmCache, JsonWebToken jwt) {
        this.config = config;
        this.store = store;
        this.realmCache = realmCache;
        this.jwt = jwt;
        this.jwtHeader = (JwtHeader)BeanBuilder.builder((Object)new JwtHeader()).set(JwtHeader::setAlg, (Object)"none").build();
    }

    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        return PROXY_TARGET;
    }

    private String calculatePathTo(String path, Application application) {
        String passTo = application.getUriToPass().getPath();
        if (passTo != null && passTo.endsWith("/")) {
            passTo = passTo.substring(0, passTo.length() - 1);
        }
        return passTo + path.substring(application.getVirtualPath().length());
    }

    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        Realm realm = this.realmCache.matches(exchange.getRequestPath());
        if (realm == null) {
            exchange.setStatusCode(404);
            exchange.endExchange();
            return;
        }
        this.parseToken(exchange).ifPresent(token -> {
            Optional<HashMap<String, Object>> userCache = this.authenticate((String)token);
            userCache.ifPresent(u -> {
                Map permissionsByRealm = (Map)u.remove("permissionsByRealm");
                List permissions = (List)permissionsByRealm.get(realm.getId().toString());
                HashMap body = new HashMap(u);
                body.put("permissions", Optional.ofNullable(permissions).orElse(Collections.emptyList()));
                exchange.getRequestHeaders().put(HttpString.tryFromString((String)this.config.getBackendHeaderName()), this.jwt.sign(body, this.jwtHeader, (byte[])null));
            });
        });
        Application application = this.realmCache.getApplication(realm);
        ClientConnection existing = (ClientConnection)exchange.getConnection().getAttachment(this.clientAttachmentKey);
        if (existing != null) {
            if (existing.isOpen()) {
                String path = exchange.getRequestURI();
                if (path.startsWith(application.getVirtualPath())) {
                    String passTo = this.calculatePathTo(path, application);
                    exchange.setRequestPath(passTo);
                    exchange.setRequestURI(passTo);
                }
                callback.completed(exchange, (Object)new ProxyConnection(existing, "/"));
                return;
            }
            exchange.getConnection().removeAttachment(this.clientAttachmentKey);
        }
        try {
            URI uri = application.getUriToPass();
            LOG.debug("PASS: {}", (Object)uri);
            this.client.connect((ClientCallback)new ConnectNotifier(callback, exchange), new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null), exchange.getIoThread(), exchange.getConnection().getByteBufferPool(), OptionMap.EMPTY);
        }
        catch (URISyntaxException e) {
            throw new MisconfigurationException("bouncr.proxy.WRONG_URI", new Object[]{application.getUriToPass(), e});
        }
    }

    private Optional<String> parseToken(HttpServerExchange exchange) {
        if (exchange.getRequestHeaders().contains("Authorization")) {
            String authorizationValue = exchange.getRequestHeaders().getFirst("Authorization");
            String[] tokens = authorizationValue.split("\\s+");
            if (tokens[0].equalsIgnoreCase("Bearer")) {
                return Optional.of(tokens[1]);
            }
            return Optional.empty();
        }
        if (exchange.getRequestCookies().containsKey(this.config.getTokenName())) {
            Cookie tokenCookie = (Cookie)exchange.getRequestCookies().get(this.config.getTokenName());
            return Optional.of(tokenCookie.getValue());
        }
        return Optional.empty();
    }

    private Optional<HashMap<String, Object>> authenticate(String token) {
        return Optional.ofNullable((HashMap)this.store.read(token));
    }

    private final class ConnectNotifier
    implements ClientCallback<ClientConnection> {
        private final ProxyCallback<ProxyConnection> callback;
        private final HttpServerExchange exchange;

        private ConnectNotifier(ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange) {
            this.callback = callback;
            this.exchange = exchange;
        }

        public void completed(ClientConnection connection) {
            ServerConnection serverConnection = this.exchange.getConnection();
            serverConnection.putAttachment(MultiAppProxyClient.this.clientAttachmentKey, (Object)connection);
            serverConnection.addCloseListener(serverConnection1 -> IoUtils.safeClose((Closeable)connection));
            connection.getCloseSetter().set(channel -> serverConnection.removeAttachment(MultiAppProxyClient.this.clientAttachmentKey));
            this.exchange.setRelativePath("/");
            Realm realm = MultiAppProxyClient.this.realmCache.matches(this.exchange.getRequestPath());
            Application application = MultiAppProxyClient.this.realmCache.getApplication(realm);
            String path = this.exchange.getRequestURI();
            if (path.startsWith(application.getVirtualPath())) {
                String passTo = MultiAppProxyClient.this.calculatePathTo(path, application);
                this.exchange.setRequestPath(passTo);
                this.exchange.setRequestURI(passTo);
            }
            this.callback.completed(this.exchange, (Object)new ProxyConnection(connection, "/"));
        }

        public void failed(IOException e) {
            this.callback.failed(this.exchange);
        }
    }
}

