/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.proxy;

import enkan.collection.OptionMap;
import enkan.component.ComponentLifecycle;
import enkan.component.WebServerComponent;
import enkan.exception.MisconfigurationException;
import enkan.exception.UnreachableException;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.X509CertificateCredential;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.unit8.bouncr.component.BouncrConfiguration;
import net.unit8.bouncr.component.RealmCache;
import net.unit8.bouncr.component.StoreProvider;
import net.unit8.bouncr.proxy.CacheRefreshHandler;
import net.unit8.bouncr.proxy.HealthCheckHandler;
import net.unit8.bouncr.proxy.MultiAppProxyClient;
import net.unit8.bouncr.proxy.cert.ReloadableTrustManager;
import net.unit8.bouncr.sign.JsonWebToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class ReverseProxyComponent
extends WebServerComponent<ReverseProxyComponent> {
    private static final Logger LOG = LoggerFactory.getLogger(ReverseProxyComponent.class);
    private static IoCallback callback = new IoCallback(){

        public void onComplete(HttpServerExchange exchange, Sender sender) {
        }

        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
        }
    };
    private int ioThreads = 4;
    private int maxRequestTime = 30000;
    private boolean rewriteHostHeader = false;
    private boolean reuseXForwarded = true;
    private Undertow server;

    protected ComponentLifecycle<ReverseProxyComponent> lifecycle() {
        return new ComponentLifecycle<ReverseProxyComponent>(){

            public void start(ReverseProxyComponent component) {
                StoreProvider storeProvider = (StoreProvider)ReverseProxyComponent.this.getDependency(StoreProvider.class);
                RealmCache realmCache = (RealmCache)ReverseProxyComponent.this.getDependency(RealmCache.class);
                BouncrConfiguration config = (BouncrConfiguration)ReverseProxyComponent.this.getDependency(BouncrConfiguration.class);
                JsonWebToken jwt = (JsonWebToken)ReverseProxyComponent.this.getDependency(JsonWebToken.class);
                if (ReverseProxyComponent.this.server == null) {
                    OptionMap options = ReverseProxyComponent.this.buildOptionMap();
                    MultiAppProxyClient proxyClient = new MultiAppProxyClient(config, storeProvider.getStore(StoreProvider.StoreType.BOUNCR_TOKEN), realmCache, jwt);
                    ProxyHandler proxyHandler = ProxyHandler.builder().setProxyClient((ProxyClient)proxyClient).setMaxRequestTime(ReverseProxyComponent.this.maxRequestTime).setRewriteHostHeader(ReverseProxyComponent.this.rewriteHostHeader).setReuseXForwarded(ReverseProxyComponent.this.reuseXForwarded).setNext((HttpHandler)ResponseCodeHandler.HANDLE_404).build();
                    HealthCheckHandler healthCheckHandler = new HealthCheckHandler();
                    CacheRefreshHandler cacheRefreshHandler = new CacheRefreshHandler(realmCache);
                    IdentityManager identityManager = new IdentityManager(){

                        public Account verify(Account account) {
                            return account;
                        }

                        public Account verify(String id, Credential credential) {
                            return null;
                        }

                        public Account verify(Credential credential) {
                            if (credential instanceof X509CertificateCredential) {
                                final X509CertificateCredential x509cert = (X509CertificateCredential)credential;
                                return new Account(){

                                    public Principal getPrincipal() {
                                        return x509cert.getCertificate().getSubjectX500Principal();
                                    }

                                    public Set<String> getRoles() {
                                        return Collections.emptySet();
                                    }
                                };
                            }
                            return null;
                        }
                    };
                    Undertow.Builder builder = Undertow.builder().setHandler(ReverseProxyComponent.this.addSecurity((HttpHandler)Handlers.path().addPrefixPath("/_healthcheck", (HttpHandler)healthCheckHandler).addPrefixPath("/_refresh", (HttpHandler)cacheRefreshHandler).addPrefixPath("/", (HttpHandler)proxyHandler), identityManager, options));
                    if (options.getBoolean("http?", true)) {
                        builder.addHttpListener(options.getInt("port"), options.getString("host"));
                    }
                    if (options.getBoolean("ssl?", false)) {
                        builder.addHttpsListener(options.getInt("sslPort"), options.getString("host"), ReverseProxyComponent.this.createSSLContext(options));
                    }
                    if (options.get((Object)"truststore") != null) {
                        builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
                    }
                    ReverseProxyComponent.this.server = builder.build();
                    ReverseProxyComponent.this.server.start();
                    LOG.info("start server {}:{}", (Object)options.getString("host"), (Object)options.getInt("port"));
                }
            }

            public void stop(ReverseProxyComponent component) {
                if (ReverseProxyComponent.this.server != null) {
                    ReverseProxyComponent.this.server.stop();
                    ReverseProxyComponent.this.server = null;
                }
            }
        };
    }

    public void setMaxRequestTime(int maxRequestTime) {
        this.maxRequestTime = maxRequestTime;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    private KeyManager[] getKeyManagers(OptionMap options) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keystore = (KeyStore)options.get((Object)"keystore");
        if (keystore != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, options.getString("keystorePassword").toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        return null;
    }

    private SSLContext createSSLContext(OptionMap options) {
        try {
            TrustManager[] trustManagerArray;
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            ReloadableTrustManager trustManager = (ReloadableTrustManager)this.getDependency(ReloadableTrustManager.class);
            KeyManager[] keyManagerArray = this.getKeyManagers(options);
            if (trustManager.initialized()) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = trustManager;
            } else {
                trustManagerArray = null;
            }
            context.init(keyManagerArray, trustManagerArray, null);
            return context;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new MisconfigurationException("bouncr.", new Object[]{e});
        }
    }

    private static void setBody(Sender sender, Object body) throws IOException {
        block19: {
            if (body == null) {
                return;
            }
            if (body instanceof String) {
                sender.send((String)body);
            } else if (body instanceof InputStream) {
                int size;
                ReadableByteChannel chan = Channels.newChannel((InputStream)body);
                ByteBuffer buf = ByteBuffer.allocate(4096);
                while ((size = chan.read(buf)) > 0) {
                    buf.flip();
                    sender.send(buf, callback);
                    buf.clear();
                }
                sender.close(IoCallback.END_EXCHANGE);
            } else {
                if (body instanceof File) {
                    try (FileInputStream fis = new FileInputStream((File)body);
                         FileChannel chan = fis.getChannel();){
                        int size;
                        ByteBuffer buf = ByteBuffer.allocate(4096);
                        while ((size = chan.read(buf)) > 0) {
                            buf.flip();
                            sender.send(buf, callback);
                            buf.clear();
                        }
                        sender.close(IoCallback.END_EXCHANGE);
                        break block19;
                    }
                }
                throw new UnreachableException();
            }
        }
    }

    private HttpHandler addSecurity(HttpHandler toWrap, IdentityManager identityManager, OptionMap options) {
        Object handler = toWrap;
        KeyStore truststore = (KeyStore)options.get((Object)"truststore");
        if (truststore != null) {
            handler = new AuthenticationCallHandler(handler);
            handler = new AuthenticationConstraintHandler((HttpHandler)handler){

                protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
                    return false;
                }
            };
            List<ClientCertAuthenticationMechanism> mechanisms = Collections.singletonList(new ClientCertAuthenticationMechanism("Bouncr"));
            handler = new AuthenticationMechanismsHandler(handler, mechanisms);
            handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, handler);
        }
        return handler;
    }
}

