/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.proxy.cert;

import enkan.component.ComponentLifecycle;
import enkan.component.SystemComponent;
import enkan.exception.MisconfigurationException;
import enkan.exception.UnreachableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.stream.Stream;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ReloadableTrustManager
extends SystemComponent
implements X509TrustManager {
    private X509TrustManager trustManager;
    private TrustManagerFactory trustManagerFactory;
    private String truststorePath;
    private String truststorePassword;
    private KeyStore trustStore;
    private boolean isInitialized = false;

    private void load() throws CertificateException, NoSuchAlgorithmException, IOException {
        try (FileInputStream in = new FileInputStream(new File(this.truststorePath));){
            this.trustStore.load(in, this.truststorePassword.toCharArray());
        }
    }

    public void reload() {
        try {
            this.trustStore = KeyStore.getInstance("JKS");
            this.load();
            this.trustManagerFactory.init(this.trustStore);
            this.trustManager = Stream.of(this.trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findAny().orElseThrow(() -> new MisconfigurationException("", new Object[0]));
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnreachableException((Throwable)e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addEntry(X509Certificate cert) {
        try (FileOutputStream out = new FileOutputStream(this.truststorePath);){
            this.trustStore.setCertificateEntry(cert.getSubjectX500Principal().getName(), cert);
            this.trustStore.store(out, this.truststorePassword.toCharArray());
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected ComponentLifecycle lifecycle() {
        return new ComponentLifecycle<ReloadableTrustManager>(){

            public void start(ReloadableTrustManager component) {
                if (ReloadableTrustManager.this.truststorePath != null && !ReloadableTrustManager.this.truststorePath.isEmpty()) {
                    try {
                        ReloadableTrustManager.this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        ReloadableTrustManager.this.reload();
                        ReloadableTrustManager.this.isInitialized = true;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new UnreachableException((Throwable)e);
                    }
                }
            }

            public void stop(ReloadableTrustManager component) {
                ReloadableTrustManager.this.isInitialized = false;
            }
        };
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    public boolean initialized() {
        return this.isInitialized;
    }

    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }
}

