/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.proxy.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class BouncrSSLSocketFactory
extends SSLSocketFactory {
    private static ThreadLocal<KeyStoreInfo> keyStoreInfo = ThreadLocal.withInitial(() -> new KeyStoreInfo());
    private SSLSocketFactory delegate;

    public BouncrSSLSocketFactory() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance("JKS");
            try (FileInputStream in = new FileInputStream(keyStoreInfo.get().getTruststorePath());){
                trustStore.load(in, keyStoreInfo.get().getTruststorePassword().toCharArray());
            }
            tmf.init(trustStore);
            ctx.init(null, tmf.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG"));
            this.delegate = ctx.getSocketFactory();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setTruststorePath(String truststorePath) {
        keyStoreInfo.get().setTruststorePath(truststorePath);
    }

    public static void setTruststorePassword(String truststorePassword) {
        keyStoreInfo.get().setTruststorePassword(truststorePassword);
    }

    public static SocketFactory getDefault() {
        return new BouncrSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return this.delegate.createSocket(socket, s, i, b);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        return this.delegate.createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        return this.delegate.createSocket(s, i, inetAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.delegate.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
    }

    static class KeyStoreInfo
    implements Serializable {
        private String truststorePath;
        private String truststorePassword;

        KeyStoreInfo() {
        }

        public String getTruststorePath() {
            return this.truststorePath;
        }

        public void setTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }
    }
}

