/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.resource.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import xapi.dev.resource.api.ClasspathResource;
import xapi.dev.resource.impl.JarBackedResource;
import xapi.util.X_Util;

public class ResourceCollection
implements Iterable<ClasspathResource> {
    private final Iterable<ClasspathResource> iter;

    public ResourceCollection(File file) {
        this.iter = new FileResourceIterable(file);
    }

    public ResourceCollection(String pkg, JarFile jarFile) {
        pkg = pkg.replace('\\', '/');
        if (!pkg.endsWith("/")) {
            pkg = pkg + "/";
        }
        this.iter = new JarResourceIterable(pkg, jarFile);
    }

    @Override
    public Iterator<ClasspathResource> iterator() {
        return this.iter.iterator();
    }

    static ResourceCollection fromUrl(URL url, String pkg) {
        File file;
        boolean jarFile;
        boolean fileUrl;
        String path = url.toExternalForm();
        boolean jarUrl = path.startsWith("jar:");
        if (jarUrl) {
            path = path.substring("jar:".length());
        }
        if (fileUrl = path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (jarFile = path.contains(".jar!")) {
            path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
        }
        if (!(file = new File(path)).exists() && !(file = new File(path = path.replace("%20", " "))).exists()) {
            throw X_Util.rethrow((Throwable)new FileNotFoundException());
        }
        try {
            if (url.getProtocol().equals("jar")) {
                return new ResourceCollection(pkg, ((JarURLConnection)url.openConnection()).getJarFile());
            }
            assert (url.getProtocol().equals("file")) : "ResourceCollection only handles url and file protocols";
            if (jarFile) {
                return new ResourceCollection(pkg, new JarFile(file));
            }
            return new ResourceCollection(file);
        }
        catch (IOException e) {
            throw X_Util.rethrow((Throwable)e);
        }
    }

    protected static class JarResourceIterator
    implements Iterator<ClasspathResource> {
        private JarFile jarFile;
        private JarEntry jarEntry;
        private final int priority;

        public JarResourceIterator(JarEntry entry, JarFile jarFile) {
            this(entry, jarFile, 0);
        }

        public JarResourceIterator(JarEntry entry, JarFile jarFile, int priority) {
            this.jarEntry = entry;
            this.jarFile = jarFile;
            this.priority = priority;
        }

        @Override
        public boolean hasNext() {
            return this.jarFile != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClasspathResource next() {
            try {
                JarBackedResource jarBackedResource = new JarBackedResource(this.jarFile, this.jarEntry, this.priority);
                return jarBackedResource;
            }
            finally {
                this.jarFile = null;
                this.jarEntry = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ResouceCollection does not support Iterator.remove()");
        }
    }

    protected static class FileResourceIterator
    implements Iterator<ClasspathResource> {
        File root;
        File[] directory;
        File parent;

        public FileResourceIterator(File file) {
            this.root = file;
            this.directory = file.listFiles();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ClasspathResource next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ResouceCollection does not support Iterator.remove()");
        }
    }

    public class FileResourceIterable
    implements Iterable<ClasspathResource> {
        private File file;

        public FileResourceIterable(File file) {
            assert (file.isDirectory());
            this.file = file;
        }

        @Override
        public Iterator<ClasspathResource> iterator() {
            return new FileResourceIterator(this.file);
        }
    }

    public class JarResourceIterable
    implements Iterable<ClasspathResource> {
        final JarEntry entry;
        private final JarFile jarFile;

        public JarResourceIterable(String pkg, JarFile jarFile) {
            this.entry = jarFile.getJarEntry(pkg);
            this.jarFile = jarFile;
            assert (this.entry.isDirectory());
        }

        @Override
        public Iterator<ClasspathResource> iterator() {
            return new JarResourceIterator(this.entry, this.jarFile);
        }
    }
}

