/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.resource.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import xapi.dev.resource.api.ClasspathResource;
import xapi.dev.resource.impl.DelegateClasspathResource;
import xapi.dev.resource.impl.StringReader;
import xapi.util.X_Debug;
import xapi.util.X_Util;

public class StringDataResource
extends DelegateClasspathResource {
    public StringDataResource(ClasspathResource source) {
        super(source);
    }

    public Iterable<String> readLines() throws IOException {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(StringDataResource.this.open()));
                    return new StringReader(reader);
                }
                catch (IOException e) {
                    throw X_Util.rethrow((Throwable)e);
                }
            }
        };
    }

    public String readAll() {
        StringBuilder b = new StringBuilder();
        try {
            for (String line : this.readLines()) {
                b.append(line).append('\n');
            }
            return b.toString();
        }
        catch (IOException e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }
}

