/*
 * Decompiled with CFR 0.152.
 */
package xapi.shell;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.junit.BeforeClass;
import org.junit.Test;
import xapi.file.X_File;
import xapi.inject.impl.JavaInjector;
import xapi.io.api.LineReader;
import xapi.io.api.StringReader;
import xapi.log.X_Log;
import xapi.shell.X_Shell;
import xapi.shell.api.ShellCommand;
import xapi.shell.api.ShellSession;
import xapi.test.Assert;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.api.SuccessHandler;

public class ShellTesting {
    private static final String success = "succ\ness";
    private static final int exitStatus = 111;

    @BeforeClass
    public static void prepare() {
        System.setProperty("xapi.multithreaded", "10");
        JavaInjector.instance(ShellCommand.class);
    }

    public static void main(String[] args) {
        System.out.print(success);
        System.exit(111);
    }

    @Test(timeout=15000L)
    public void testInvokeJavaMain() {
        Moment start = X_Time.now();
        String[] classpath = System.getProperty("java.class.path").split(File.pathSeparator);
        StringReader reader = new StringReader();
        ShellSession result = X_Shell.launchJava(ShellTesting.class, (String[])classpath, (String[])new String[]{"-Xmx128M"}, (String[])new String[0]);
        result.stdOut((LineReader)reader);
        X_Log.debug((Object[])new Object[]{this.getClass(), "Bootstrap shell", X_Time.difference((Moment)start)});
        try {
            reader.waitToEnd(14000L, 0);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while waiting for process to end");
        }
        Assert.assertEquals((Object)success, (Object)reader.toString());
        Assert.assertEquals((long)111L, (long)result.join());
        X_Log.trace((Object[])new Object[]{this.getClass(), "Process Runtime", X_Time.difference((Moment)start)});
    }

    @Test(timeout=10000L)
    public void testShell() throws Throwable {
        final CountDownLatch job = new CountDownLatch(1);
        final Throwable[] error = new Throwable[1];
        X_Time.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ShellTesting.this.runTest();
                }
                catch (Throwable e) {
                    X_Log.error((Object[])new Object[]{"Error testing shell commands", e});
                    error[0] = e;
                }
                finally {
                    job.countDown();
                }
            }
        });
        job.await();
        if (error[0] != null) {
            throw error[0];
        }
    }

    private void runTest() throws Exception {
        StringReader d = new StringReader();
        StringReader e = new StringReader();
        final boolean[] success = new boolean[1];
        ShellSession shell = X_Shell.newService().newCommand(new String[]{"sh", "-ac", X_File.unzippedResourcePath((String)"xapi/sh.sh", null)}).run((SuccessHandler)new SuccessHandler<ShellSession>(){

            public void onSuccess(ShellSession t) {
                success[0] = true;
            }
        }, null);
        shell.stdOut((LineReader)d);
        shell.stdErr((LineReader)e);
        shell.stdIn("echo \"test success\"");
        shell.stdIn("exit");
        d.waitToEnd();
        Assert.assertEquals((Object)"test success", (Object)d.toString().trim());
        Assert.assertTrue((boolean)success[0]);
    }
}

