/*
 * Decompiled with CFR 0.152.
 */
package xapi.collect.impl;

import java.util.Iterator;

public class SimpleStack<T>
implements Iterable<T> {
    Node<T> tail = new Node();
    final Node<T> head = this.tail;

    @Override
    public Iterator<T> iterator() {
        return new NodeIterator();
    }

    public T head() {
        return this.head.next == null ? null : (T)this.head.next.value;
    }

    public T tail() {
        return this.tail.value;
    }

    public synchronized void add(T item) {
        Node<T> node = this.newNode();
        node.value = item;
        this.tail.next = node;
        this.tail = node;
    }

    public synchronized void clear() {
        this.tail = this.head;
        this.head.next = null;
    }

    public synchronized SimpleStack<T> consume(SimpleStack<T> other) {
        this.tail.next = other.head.next;
        if (this.tail.next != null) {
            this.tail = other.tail;
        }
        other.tail = other.head;
        other.head.next = null;
        return this;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public String join(String separator) {
        StringBuilder b = new StringBuilder();
        Iterator<T> iter = this.iterator();
        if (iter.hasNext()) {
            b.append(iter.next());
        }
        while (iter.hasNext()) {
            b.append(separator).append(iter.next());
        }
        return b.toString();
    }

    protected Node<T> newNode() {
        return new Node();
    }

    protected final class NodeIterator
    implements Iterator<T> {
        private Node<T> next;

        protected NodeIterator() {
            this.next = SimpleStack.this.head.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            try {
                Object t = this.next.value;
                return t;
            }
            finally {
                this.next = this.next.next;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Node<T> {
        protected Node<T> next;
        protected T value;

        protected Node() {
        }
    }
}

