/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.util.TreeMap;
import java.util.regex.Pattern;

public class ImportSection {
    private final TreeMap<String, String> imports = new TreeMap();
    private final TreeMap<String, String> importStatic = new TreeMap();
    private static final Pattern skipImports = Pattern.compile("((java[.]lang.[^.]*)|((void)|(boolean)|(short)|(char)|(int)|(long)|(float)|(double)|(String)|(Object)|(Void)|(Boolean)|(Short)|(Character)|(Integer)|(Long)|(Float)|(Double)))[;]*");
    private static final Pattern trimmer = Pattern.compile("(\\[\\])|(\\s*import\\s+)|(static\\s+)|(\\s*;\\s*)");

    public ImportSection addImports(String ... imports) {
        for (String iport : imports) {
            this.addImport(iport);
        }
        return this;
    }

    public String addImport(String importName) {
        return this.tryImport(importName, importName.contains("static "));
    }

    public String addStatic(String importName) {
        return this.tryImport(importName, true);
    }

    public ImportSection addStatics(String ... imports) {
        for (String iport : imports) {
            this.addStatic(iport);
        }
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(10);
        for (String importName : this.imports.values()) {
            if (importName.length() <= 0) continue;
            b.append("import ").append(importName).append(';').append('\n');
        }
        for (String importName : this.importStatic.values()) {
            if (importName.length() <= 0) continue;
            b.append("import static ").append(importName).append(';').append('\n');
        }
        return b.toString() + '\n';
    }

    public ImportSection reserveSimpleName(String cls) {
        if (!this.imports.containsKey(cls)) {
            this.imports.put(cls, "");
        }
        return this;
    }

    public ImportSection reserveMethodName(String name) {
        if (!this.imports.containsKey(name)) {
            this.imports.put(name, "");
        }
        return this;
    }

    public String addImport(Class<?> cls) {
        if (cls.isPrimitive() || "java.lang".equals(cls.getPackage().getName())) {
            return cls.getSimpleName();
        }
        String existing = this.imports.get(cls.getSimpleName());
        if (existing != null) {
            if (existing.equals(cls.getCanonicalName())) {
                return cls.getSimpleName();
            }
            return cls.getCanonicalName();
        }
        this.imports.put(cls.getSimpleName(), cls.getCanonicalName());
        return cls.getSimpleName();
    }

    public ImportSection addImports(Class<?> ... imports) {
        for (Class<?> cls : imports) {
            this.addImport(cls);
        }
        return this;
    }

    protected boolean canMinimize(String importName) {
        String simpleName = importName.substring(importName.lastIndexOf(46) + 1);
        String existing = this.imports.get(simpleName);
        return existing == null || "".equals(existing) || existing.equals(importName);
    }

    protected String tryImport(String importName, boolean staticImport) {
        String suffix;
        TreeMap<String, String> map = staticImport ? this.importStatic : this.imports;
        int arrayDepth = 0;
        int index = importName.indexOf(".");
        if (index == -1) {
            return importName;
        }
        index = importName.indexOf("[]");
        while (index != -1) {
            importName = importName.substring(0, index) + (index < importName.length() - 2 ? importName.substring(index + 2) : "");
            index = importName.indexOf("[]", index);
            ++arrayDepth;
        }
        index = (importName = trimmer.matcher(importName.trim()).replaceAll("")).indexOf(60);
        if (index == -1) {
            suffix = "";
        } else {
            suffix = importName.substring(index);
            importName = importName.substring(0, index);
        }
        while (arrayDepth-- > 0) {
            suffix = suffix + "[]";
        }
        if (skipImports.matcher(importName).matches()) {
            return importName.replace("java.lang.", "") + suffix;
        }
        String shortname = (importName = importName.replace('$', '.')).substring(1 + importName.lastIndexOf(46));
        if ("*".equals(shortname)) {
            map.put(importName, importName);
            return importName + suffix;
        }
        String existing = map.get(shortname);
        if (existing == null) {
            map.put(shortname, importName);
            return shortname + suffix;
        }
        if (existing.equals(importName)) {
            return shortname + suffix;
        }
        return importName + suffix;
    }
}

