/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import xapi.collect.impl.StringStack;

public class PrintBuffer {
    static final char NEW_LINE = '\n';
    static final String INDENT = "  ";
    StringBuilder target;
    String indent = "";
    PrintStack head;
    PrintStack tail;
    protected boolean indented = false;

    protected static String join(String sep, String[] args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(args[0]);
        int m = args.length;
        for (int i = 1; i < m; ++i) {
            b.append(sep).append(args[i]);
        }
        return b.toString();
    }

    public PrintBuffer() {
        this(new StringBuilder());
    }

    public PrintBuffer(PrintBuffer preamble) {
        this(new StringBuilder());
        this.head.setValue(preamble);
    }

    public PrintBuffer(StringBuilder target) {
        this.target = target;
        this.tail = this.head = new PrintStack();
    }

    protected void onAppend() {
    }

    public PrintBuffer append(Object obj) {
        this.onAppend();
        this.target.append(obj);
        return this;
    }

    public PrintBuffer print(String str) {
        this.printIndent();
        this.append(str);
        return this;
    }

    public PrintBuffer append(String str) {
        this.onAppend();
        this.target.append(str);
        return this;
    }

    public PrintBuffer append(CharSequence s) {
        this.onAppend();
        this.target.append(s);
        return this;
    }

    public PrintBuffer append(CharSequence s, int start, int end) {
        this.onAppend();
        this.target.append(s, start, end);
        return this;
    }

    public PrintBuffer append(char[] str) {
        this.onAppend();
        this.target.append(str);
        return this;
    }

    public PrintBuffer append(char[] str, int offset, int len) {
        this.onAppend();
        this.target.append(str, offset, len);
        return this;
    }

    public PrintBuffer append(boolean b) {
        this.onAppend();
        this.target.append(b);
        return this;
    }

    public PrintBuffer append(char c) {
        this.onAppend();
        this.target.append(c);
        return this;
    }

    public PrintBuffer append(int i) {
        this.onAppend();
        this.target.append(i);
        return this;
    }

    public PrintBuffer append(long lng) {
        this.onAppend();
        this.target.append(lng);
        return this;
    }

    public PrintBuffer append(float f) {
        this.onAppend();
        this.target.append(f);
        return this;
    }

    public PrintBuffer append(double d) {
        this.onAppend();
        this.target.append(d);
        return this;
    }

    public PrintBuffer indent() {
        this.indent = this.indent + INDENT;
        return this;
    }

    private void printIndent() {
        if (!this.indented) {
            this.target.append(this.indent);
            this.indented = true;
        }
    }

    public PrintBuffer indentln(Object obj) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(obj);
        this.println();
        return this;
    }

    public PrintBuffer indentln(String str) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.append(str);
        this.println();
        return this;
    }

    public PrintBuffer indentln(CharSequence s) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(s);
        this.println();
        return this;
    }

    public PrintBuffer indentln(char[] str) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(str);
        this.println();
        return this;
    }

    public PrintBuffer outdent() {
        int end = Math.max(0, this.indent.length() - INDENT.length());
        this.indent = end > 0 ? this.indent.substring(0, end) : "";
        return this;
    }

    public PrintBuffer println() {
        this.onAppend();
        this.target.append('\n');
        this.indented = false;
        return this;
    }

    public PrintBuffer println(Object obj) {
        this.printIndent();
        this.onAppend();
        this.target.append(obj);
        this.println();
        return this;
    }

    public PrintBuffer println(String str) {
        this.printIndent();
        this.onAppend();
        this.append(str);
        this.println();
        return this;
    }

    public PrintBuffer println(CharSequence s) {
        this.printIndent();
        this.onAppend();
        this.target.append(s);
        this.println();
        return this;
    }

    public PrintBuffer println(char[] str) {
        this.printIndent();
        this.onAppend();
        this.target.append(str);
        this.println();
        return this;
    }

    public PrintBuffer printBefore(String prefix) {
        PrintBuffer buffer = new PrintBuffer(new StringBuilder(prefix));
        this.addToBeginning(buffer);
        return buffer;
    }

    public void addToBeginning(PrintBuffer buffer) {
        assert (this.notContained(buffer)) : "Infinite recursion!";
        PrintStack newHead = new PrintStack();
        newHead.next = this.head;
        newHead.setValue(buffer);
        this.head = newHead;
    }

    public PrintBuffer printAfter(String suffix) {
        PrintBuffer buffer = new PrintBuffer(new StringBuilder(suffix));
        this.addToEnd(buffer);
        return buffer;
    }

    public void addToEnd(PrintBuffer buffer) {
        assert (this.notContained(buffer)) : "Infinite recursion! On [" + buffer + "] in " + this;
        PrintStack newTail = new PrintStack();
        newTail.setValue(buffer);
        newTail.setPrefix(this.target.toString());
        this.target.setLength(0);
        this.tail.next = newTail;
        this.tail = newTail;
    }

    private boolean notContained(PrintBuffer buffer) {
        if (buffer == this) {
            System.err.println("Trying to add a buffer to itself");
            return false;
        }
        StringStack next = this.head;
        while (next != null) {
            if (next.getValue() == buffer) {
                System.err.println("Trying to add a buffer that is already a child");
                return false;
            }
            next = next.next;
        }
        next = buffer.head;
        while (next != null) {
            if (next.getValue() == this) {
                System.err.println("Trying to add an ancestor to a child");
                return false;
            }
            next = next.next;
        }
        return true;
    }

    protected String header() {
        return "";
    }

    protected String footer() {
        return "";
    }

    protected void clearIndent() {
        this.indented = false;
    }

    public String toString() {
        StringBuilder body = new StringBuilder(this.header());
        body.append(this.head);
        body.append((CharSequence)this.target);
        return body + this.footer();
    }

    public boolean isEmpty() {
        return this.target.length() == 0 && this.head.next == null;
    }

    public boolean isNotEmpty() {
        return this.target.length() > 0 || this.head.next != null;
    }

    protected static final class PrintStack
    extends StringStack<PrintBuffer> {
        protected PrintStack() {
        }
    }
}

