/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.util.LinkedHashMap;
import java.util.Map;
import xapi.dev.source.PrintBuffer;

public class XmlBuffer
extends PrintBuffer {
    private String tagName;
    private PrintBuffer attributes;
    private PrintBuffer comment = new PrintBuffer();
    private PrintBuffer before = new PrintBuffer();
    private Map<String, StringBuilder> attributeMap;

    public XmlBuffer() {
        this.indent = "  ";
    }

    public XmlBuffer(String tagName) {
        this();
        this.setTagName(tagName);
    }

    public XmlBuffer setTagName(String name) {
        if (this.tagName != null) {
            this.indent();
        }
        this.tagName = name;
        return this;
    }

    public XmlBuffer setAttribute(String name, String value) {
        this.ensureAttributes();
        StringBuilder attr = this.attributeMap.get(name);
        String val = value == null ? " " : "=\"" + value.replaceAll("\"", "&quot;") + "\" ";
        if (attr == null) {
            this.attributes.print(name);
            attr = new StringBuilder(val);
            this.attributeMap.put(name, attr);
            PrintBuffer attrBuf = new PrintBuffer(attr);
            this.attributes.addToEnd(attrBuf);
        } else {
            attr.setLength(0);
            attr.append(val);
        }
        return this;
    }

    private void ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new PrintBuffer();
            this.attributeMap = new LinkedHashMap<String, StringBuilder>();
        }
    }

    public XmlBuffer makeTag(String name) {
        XmlBuffer buffer = new XmlBuffer(name);
        buffer.indent = this.indent + "  ";
        this.addToEnd(buffer);
        return buffer;
    }

    public XmlBuffer makeTagAtBeginning(String name) {
        XmlBuffer buffer = new XmlBuffer(name);
        buffer.indent = this.indent + "  ";
        this.addToBeginning(buffer);
        return buffer;
    }

    @Override
    public String toString() {
        String body;
        if (this.tagName == null) {
            assert (this.attributes == null) : "Cannot add attributes to an XmlBuffer with no tag name: \nAttributes: " + this.attributes + "\nBody: " + super.toString();
            return super.toString();
        }
        String origIndent = this.indent.replaceFirst("  ", "");
        StringBuilder b = new StringBuilder(origIndent);
        String text = this.before.toString();
        if (text.length() > 0) {
            b.append(text);
        }
        if ((text = this.comment.toString()).length() > 0) {
            if (!text.startsWith("<!--")) {
                b.append("<!--\n");
            }
            b.append(this.indent);
            b.append(text);
            if (!text.endsWith("-->")) {
                b.append("\n-->");
            }
            b.append(origIndent);
        }
        b.append("<").append(this.tagName);
        if (this.attributes != null) {
            b.append(" ").append(this.attributes);
        }
        if ((body = super.toString()).length() == 0) {
            if (this.shouldShortenEmptyTag(this.tagName)) {
                b.append("/>\n");
            } else {
                b.append("> </").append(this.tagName).append(">\n");
            }
        } else {
            b.append(">\n").append(body).append(origIndent).append("</").append(this.tagName).append(">\n");
        }
        return b.toString();
    }

    protected boolean shouldShortenEmptyTag(String tag) {
        return !"script".equals(tag);
    }

    @Override
    public XmlBuffer append(Object obj) {
        super.append(obj);
        return this;
    }

    @Override
    public XmlBuffer print(String str) {
        super.print(str);
        return this;
    }

    @Override
    public XmlBuffer append(String str) {
        super.append(str);
        return this;
    }

    @Override
    public XmlBuffer append(CharSequence s) {
        super.append(s);
        return this;
    }

    @Override
    public XmlBuffer append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    @Override
    public XmlBuffer append(char[] str) {
        super.append(str);
        return this;
    }

    @Override
    public XmlBuffer append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    @Override
    public XmlBuffer append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public XmlBuffer append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public XmlBuffer append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public XmlBuffer append(long lng) {
        super.append(lng);
        return this;
    }

    @Override
    public XmlBuffer append(float f) {
        super.append(f);
        return this;
    }

    @Override
    public XmlBuffer append(double d) {
        super.append(d);
        return this;
    }

    @Override
    public XmlBuffer indent() {
        super.indent();
        return this;
    }

    @Override
    public XmlBuffer indentln(Object obj) {
        super.indentln(obj);
        return this;
    }

    @Override
    public XmlBuffer indentln(String str) {
        super.indentln(str);
        return this;
    }

    @Override
    public XmlBuffer indentln(CharSequence s) {
        super.indentln(s);
        return this;
    }

    @Override
    public XmlBuffer indentln(char[] str) {
        super.indentln(str);
        return this;
    }

    @Override
    public XmlBuffer outdent() {
        super.outdent();
        return this;
    }

    @Override
    public XmlBuffer println() {
        super.println();
        return this;
    }

    @Override
    public XmlBuffer println(Object obj) {
        super.println(obj);
        return this;
    }

    @Override
    public XmlBuffer println(String str) {
        super.println(str);
        return this;
    }

    @Override
    public XmlBuffer println(CharSequence s) {
        super.println(s);
        return this;
    }

    @Override
    public XmlBuffer println(char[] str) {
        super.println(str);
        return this;
    }

    @Override
    public PrintBuffer printBefore(String prefix) {
        return this.before.printBefore(prefix);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.tagName == null && this.comment.isEmpty() && this.before.isEmpty();
    }
}

