/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.read;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import xapi.collect.impl.SimpleStack;
import xapi.source.read.JavaLexer;

public final class JavaModel {
    private JavaModel() {
    }

    public static class IsParameter {
        HasAnnotations annotations;
        int modifier;
        IsNamedType type;
        public boolean varargs;

        public IsParameter(String name, String type) {
            this.type = new IsNamedType(name, type);
        }

        public String getType() {
            return this.type.typeName();
        }

        public String getName() {
            return this.type.name;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            String modifiers = Modifier.toString(this.modifier);
            if (modifiers.length() > 0) {
                b.append(modifiers).append(" ");
            }
            if (this.annotations != null) {
                b.append(this.annotations);
            }
            b.append(this.getType());
            if (this.varargs) {
                b.append(" ... ");
            } else {
                b.append(" ");
            }
            b.append(this.getName());
            return b.toString();
        }
    }

    public static class HasAnnotations {
        public final SimpleStack<IsAnnotation> annotations = new SimpleStack();

        public void addAnnotation(IsAnnotation annotation) {
            this.annotations.add(annotation);
        }

        public Iterable<IsAnnotation> getAnnotations() {
            return this.annotations;
        }

        public String toString() {
            return this.annotations.join(" ");
        }
    }

    public static class HasModifier {
        int modifier;
    }

    public static class IsAnnotation
    extends IsQualified {
        public final SimpleStack<AnnotationMember> members = new SimpleStack();

        public IsAnnotation(String type) {
            super(type);
        }

        public void addMember(AnnotationMember member) {
            assert (member != null);
            this.members.add(member);
        }

        public void addMember(String name, String initializer) {
            if (name == null) {
                name = "value";
            }
            if ((name = name.trim()).length() == 0) {
                name = "value";
            }
            this.addMember(new AnnotationMember(name, initializer));
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder("@");
            b.append(this.qualifiedName);
            if (!this.members.isEmpty()) {
                b.append("(");
                Iterator<AnnotationMember> iter = this.members.iterator();
                while (iter.hasNext()) {
                    b.append(iter.next());
                    if (!iter.hasNext()) continue;
                    b.append(", ");
                }
                b.append(")");
            }
            return b.toString();
        }
    }

    public static class AnnotationMember {
        String name;
        String value;
        boolean isArray;

        public AnnotationMember(String name, String initializer) {
            this.name = name;
            initializer = initializer == null ? "" : initializer.trim();
            this.value = initializer;
            this.isArray = initializer.lastIndexOf(125) != -1;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.name);
            if (this.value.length() > 0) {
                b.append(" = ");
                b.append(this.value);
            }
            return b.toString();
        }
    }

    public static class IsGeneric
    extends IsNamedType {
        public static final int SUPER = -1;
        public static final int CONCRETE = 0;
        public static final int EXTENDS = 1;
        int bounds;

        public IsGeneric(String name, String type) {
            super(name, type);
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.name);
            if (this.bounds != 0) {
                if (this.bounds == -1) {
                    b.append(" super ");
                } else if (this.bounds == 1) {
                    b.append(" extends ");
                } else assert (false) : "Generic bounds > 1 and < -1 not allowed. You supplied " + this.bounds;
            }
            b.append(this.qualifiedName);
            return b.toString();
        }
    }

    public static class IsVariable
    extends IsNamedType {
        public String initializer;

        public IsVariable(String name, String type, String initializer) {
            super(name, type);
            this.initializer = initializer;
        }
    }

    public static class IsNamedType
    extends IsType {
        String name;

        public IsNamedType() {
        }

        public IsNamedType(String name, String type) {
            super(type);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String typeName() {
            return super.toString();
        }

        @Override
        public String toString() {
            return this.typeName() + " " + this.name;
        }
    }

    public static class IsType
    extends IsQualified {
        public final SimpleStack<IsGeneric> generics;
        public int arrayDepth;

        public IsType() {
            this.generics = new SimpleStack();
        }

        public IsType(String type) {
            super(JavaLexer.stripTypeMods(type));
            int ind = type.indexOf("[]");
            while (ind > -1) {
                ++this.arrayDepth;
                type = type.replace("[]", "");
                ind = type.indexOf("[]");
            }
            ind = type.indexOf(60);
            this.generics = ind == -1 ? new SimpleStack() : JavaLexer.extractGenerics(type, ind);
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(super.toString());
            if (!this.generics.isEmpty()) {
                b.append("<");
                for (IsGeneric generic : this.generics) {
                    b.append(generic.toString());
                }
                b.append(">");
            }
            int depth = this.arrayDepth;
            while (depth-- > 0) {
                b.append("[]");
            }
            return b.toString();
        }
    }

    public static class IsQualified {
        String qualifiedName;
        String simpleName;
        String packageName;

        public IsQualified() {
        }

        public IsQualified(String type) {
            this.qualifiedName = this.simpleName = type;
            this.packageName = "";
        }

        public IsQualified(String pkg, String cls) {
            this.setType(pkg, cls);
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public String getPackage() {
            return this.packageName;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public void setType(String pkg, String cls) {
            this.simpleName = cls;
            this.packageName = pkg;
            this.qualifiedName = this.packageName.length() > 0 ? this.packageName + "." + cls : cls;
        }

        public String toString() {
            return this.getQualifiedName();
        }
    }
}

