/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.read;

public class JavaVisitor {

    public static interface ClassBodyVisitor<Param> {
        public void visitCodeBlock(String var1, boolean var2, Param var3);

        public FieldVisitor<Param> visitField(String var1, Param var2);

        public MethodVisitor<Param> visitMethod(String var1, Param var2);

        public ClassVisitor<Param> visitInnerClass(String var1, Param var2);
    }

    public static interface EnumDefinitionVisitor<Param>
    extends ClassVisitor<Param> {
        public ParameterVisitor<Param> visitParams(String var1, Param var2);

        @Override
        public ClassBodyVisitor<Param> visitBody(String var1, Param var2);
    }

    public static interface EnumVisitor<Param>
    extends ClassVisitor<Param> {
        public EnumDefinitionVisitor<Param> visitItem(String var1, Param var2);
    }

    public static interface ClassVisitor<Param>
    extends MemberVisitor<Param>,
    ImportVisitor<Param> {
        public void visitCopyright(String var1, Param var2);

        public void visitPackage(String var1, Param var2);

        public void visitName(String var1, Param var2);

        public void visitSuperclass(String var1, Param var2);

        public void visitInterface(String var1, Param var2);

        public ClassBodyVisitor<Param> visitBody(String var1, Param var2);
    }

    public static interface ImportVisitor<Param> {
        public void visitImport(String var1, boolean var2, Param var3);
    }

    public static interface MethodVisitor<Param>
    extends ExecutableVisitor<Param> {
        public void visitReturnType(TypeData var1, Param var2);

        public void visitName(String var1, Param var2);
    }

    public static interface ConstructorVisitor<Param>
    extends ExecutableVisitor<Param> {
    }

    public static interface ExecutableVisitor<Param>
    extends MemberVisitor<Param> {
        public ParameterVisitor<Param> visitParameter();

        public void visitException(String var1, Param var2);
    }

    public static interface ParameterVisitor<Param>
    extends AnnotationVisitor<Param>,
    ModifierVisitor<Param> {
        public void visitType(TypeData var1, String var2, boolean var3, Param var4);
    }

    public static interface FieldVisitor<Param>
    extends MemberVisitor<Param> {
        public void visitName(String var1, Param var2);

        public void visitInitializer(String var1, Param var2);
    }

    public static interface MemberVisitor<Param>
    extends AnnotationVisitor<Param>,
    GenericVisitor<Param>,
    JavadocVisitor<Param>,
    ModifierVisitor<Param> {
    }

    public static interface GenericVisitor<Param> {
        public void visitGeneric(String var1, Param var2);
    }

    public static interface AnnotationMemberVisitor<Param> {
        public void visitMember(String var1, String var2, Param var3);
    }

    public static interface AnnotationVisitor<Param> {
        public AnnotationMemberVisitor<Param> visitAnnotation(String var1, String var2, Param var3);
    }

    public static interface TypeVisitor<Param>
    extends ModifierVisitor<Param> {
    }

    public static interface ModifierVisitor<Param> {
        public void visitModifier(int var1, Param var2);
    }

    public static interface JavadocVisitor<Param> {
        public void visitJavadoc(String var1, Param var2);
    }

    public static class TypeData {
        public static final TypeData NONE = new TypeData("");
        public String pkgName = "";
        public String clsName;
        public String simpleName;
        public String generics = "";
        public int arrayDepth;

        public TypeData(String pkgName, String enclosingClass) {
            this(enclosingClass);
            this.pkgName = pkgName;
        }

        public TypeData(String className) {
            this.clsName = className;
            int end = className.lastIndexOf(46);
            this.simpleName = end == -1 ? this.clsName : this.clsName.substring(end + 1);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.pkgName.length() > 0) {
                b.append(this.pkgName).append('.');
            }
            b.append(this.clsName).append(this.generics);
            b.append(this.getArrayDefinition());
            return b.toString();
        }

        protected String getArrayDefinition() {
            StringBuilder b = new StringBuilder();
            int i = this.arrayDepth;
            while (i-- > 0) {
                b.append("[]");
            }
            return b.toString();
        }

        public String getImportName() {
            int index = this.clsName.indexOf(46);
            return this.pkgName.length() == 0 ? "" : this.pkgName + "." + (index == -1 ? this.clsName : this.clsName.substring(0, index));
        }

        public String getQualifiedName() {
            return (this.pkgName.length() == 0 ? "" : this.pkgName + ".") + this.clsName;
        }

        public String getSimpleName() {
            return this.clsName + (this.generics.length() > 0 ? this.generics : "") + this.getArrayDefinition();
        }
    }
}

