/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.write;

import xapi.source.write.Stack;
import xapi.source.write.ToStringer;

public class Template
extends Stack {
    public Template(String template, String ... replaceables) {
        super("", ToStringer.DEFAULT_TO_STRINGER);
        this.compile(template, replaceables);
    }

    public void setToStringer(ToStringer toString) {
        Stack s = this;
        while (s != null) {
            s.toString = toString;
            s = s.next;
        }
    }

    @Override
    public String apply(Object ... args) {
        return super.apply(args);
    }

    private final void compile(String template, String[] replaceables) {
        int numLive = 0;
        int[] tokenPositions = new int[replaceables.length];
        int[] liveIndices = new int[replaceables.length];
        int i = replaceables.length;
        while (i-- > 0) {
            int next = template.indexOf(replaceables[i]);
            if (next <= -1) continue;
            liveIndices[numLive++] = i;
            tokenPositions[i] = template.indexOf(replaceables[i]);
        }
        if (numLive == 0) {
            this.next = new Stack(template, this.toString);
            return;
        }
        Template.crossSort(liveIndices, tokenPositions, numLive - 1);
        this.lexTemplate(this, template, replaceables, liveIndices, tokenPositions, 0, numLive);
    }

    private final void lexTemplate(Stack head, String template, String[] replaceables, int[] liveIndices, int[] tokenPositions, int curPos, int numLive) {
        int nextIndex = liveIndices[0];
        int nextPos = tokenPositions[nextIndex];
        assert (nextPos > -1);
        String constant = template.substring(curPos, nextPos);
        String replaceable = replaceables[nextIndex];
        curPos = nextPos + replaceable.length();
        Stack tail = head.push(constant, nextIndex);
        int newPosition = template.indexOf(replaceable, nextPos + 1);
        if (newPosition == -1) {
            if (--numLive == 0) {
                tail.next = new Stack(curPos == template.length() ? "" : template.substring(curPos), this.toString);
                return;
            }
            System.arraycopy(liveIndices, 1, liveIndices, 0, numLive);
        } else {
            tokenPositions[nextIndex] = newPosition;
            if (numLive > 1 && newPosition > tokenPositions[liveIndices[1]]) {
                int test = 1;
                while (newPosition > tokenPositions[liveIndices[test]]) {
                    liveIndices[test - 1] = liveIndices[test];
                    if (++test != numLive) continue;
                }
                liveIndices[test - 1] = nextIndex;
            }
        }
        this.lexTemplate(tail, template, replaceables, liveIndices, tokenPositions, curPos, numLive);
    }

    private static void crossSort(int[] pointers, int[] values, int endIndex) {
        int i;
        int j = i = 0;
        while (i < endIndex) {
            int ai = pointers[i + 1];
            while (values[ai] < values[pointers[j]]) {
                pointers[j + 1] = pointers[j];
                if (j-- != 0) continue;
            }
            pointers[j + 1] = ai;
            j = ++i;
        }
    }
}

