/*
    Copyright 2014 Wouter Danes

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

*/

package net.wouterdanes.docker.provider.model;

/**
 * This class stores information about an exposed port on a docker container
 */
public class ExposedPort {
    private final String containerPort;
    private final int externalPort;
    private final String host;

    public ExposedPort(final String containerPort, final int externalPort, final String host) {
        this.containerPort = containerPort;
        this.externalPort = externalPort;
        this.host = host;
    }

    public String getContainerPort() {
        return containerPort;
    }

    public int getExternalPort() {
        return externalPort;
    }

    public String getHost() {
        return host;
    }
}
