/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package network.unique.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import network.unique.model.AddressDto
import network.unique.model.EthereumAddressDto
import network.unique.model.NestingAddressDto
import network.unique.model.TokenIdQuery

import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class AddressUtilsApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost")
        }
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @return AddressDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun addressUtilsControllerEthereumToSubstrate(address: kotlin.String) : AddressDto {
        val localVarResponse = addressUtilsControllerEthereumToSubstrateWithHttpInfo(address = address)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as AddressDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @return ApiResponse<AddressDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun addressUtilsControllerEthereumToSubstrateWithHttpInfo(address: kotlin.String) : ApiResponse<AddressDto?> {
        val localVariableConfig = addressUtilsControllerEthereumToSubstrateRequestConfig(address = address)

        return request<Unit, AddressDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation addressUtilsControllerEthereumToSubstrate
     *
     * @param address The ss-58 encoded address
     * @return RequestConfig
     */
    fun addressUtilsControllerEthereumToSubstrateRequestConfig(address: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("address", listOf(address.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/address-utils/mirror/ethereum-to-substrate",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param address collection and token id, encoded as ethereum address
     * @return TokenIdQuery
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun addressUtilsControllerNestingAddressToCollection(address: kotlin.String) : TokenIdQuery {
        val localVarResponse = addressUtilsControllerNestingAddressToCollectionWithHttpInfo(address = address)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TokenIdQuery
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param address collection and token id, encoded as ethereum address
     * @return ApiResponse<TokenIdQuery?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun addressUtilsControllerNestingAddressToCollectionWithHttpInfo(address: kotlin.String) : ApiResponse<TokenIdQuery?> {
        val localVariableConfig = addressUtilsControllerNestingAddressToCollectionRequestConfig(address = address)

        return request<Unit, TokenIdQuery>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation addressUtilsControllerNestingAddressToCollection
     *
     * @param address collection and token id, encoded as ethereum address
     * @return RequestConfig
     */
    fun addressUtilsControllerNestingAddressToCollectionRequestConfig(address: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("address", listOf(address.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/address-utils/nesting/address-to-ids",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return NestingAddressDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun addressUtilsControllerNestingTokenIdToAddress(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String? = null) : NestingAddressDto {
        val localVarResponse = addressUtilsControllerNestingTokenIdToAddressWithHttpInfo(collectionId = collectionId, tokenId = tokenId, at = at)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as NestingAddressDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return ApiResponse<NestingAddressDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun addressUtilsControllerNestingTokenIdToAddressWithHttpInfo(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : ApiResponse<NestingAddressDto?> {
        val localVariableConfig = addressUtilsControllerNestingTokenIdToAddressRequestConfig(collectionId = collectionId, tokenId = tokenId, at = at)

        return request<Unit, NestingAddressDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation addressUtilsControllerNestingTokenIdToAddress
     *
     * @param collectionId 
     * @param tokenId 
     * @param at Hash of execution block (optional)
     * @return RequestConfig
     */
    fun addressUtilsControllerNestingTokenIdToAddressRequestConfig(collectionId: java.math.BigDecimal, tokenId: java.math.BigDecimal, at: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (at != null) {
                    put("at", listOf(at.toString()))
                }
                put("collectionId", listOf(collectionId.toString()))
                put("tokenId", listOf(tokenId.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/address-utils/nesting/ids-to-address",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @param ss58prefix  (optional)
     * @return AddressDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun addressUtilsControllerNormalize(address: kotlin.String, ss58prefix: java.math.BigDecimal? = null) : AddressDto {
        val localVarResponse = addressUtilsControllerNormalizeWithHttpInfo(address = address, ss58prefix = ss58prefix)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as AddressDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @param ss58prefix  (optional)
     * @return ApiResponse<AddressDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun addressUtilsControllerNormalizeWithHttpInfo(address: kotlin.String, ss58prefix: java.math.BigDecimal?) : ApiResponse<AddressDto?> {
        val localVariableConfig = addressUtilsControllerNormalizeRequestConfig(address = address, ss58prefix = ss58prefix)

        return request<Unit, AddressDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation addressUtilsControllerNormalize
     *
     * @param address The ss-58 encoded address
     * @param ss58prefix  (optional)
     * @return RequestConfig
     */
    fun addressUtilsControllerNormalizeRequestConfig(address: kotlin.String, ss58prefix: java.math.BigDecimal?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("address", listOf(address.toString()))
                if (ss58prefix != null) {
                    put("ss58prefix", listOf(ss58prefix.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/address-utils/normalize",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @return EthereumAddressDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun addressUtilsControllerSubstrateToEthereum(address: kotlin.String) : EthereumAddressDto {
        val localVarResponse = addressUtilsControllerSubstrateToEthereumWithHttpInfo(address = address)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EthereumAddressDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * 
     * 
     * @param address The ss-58 encoded address
     * @return ApiResponse<EthereumAddressDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun addressUtilsControllerSubstrateToEthereumWithHttpInfo(address: kotlin.String) : ApiResponse<EthereumAddressDto?> {
        val localVariableConfig = addressUtilsControllerSubstrateToEthereumRequestConfig(address = address)

        return request<Unit, EthereumAddressDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation addressUtilsControllerSubstrateToEthereum
     *
     * @param address The ss-58 encoded address
     * @return RequestConfig
     */
    fun addressUtilsControllerSubstrateToEthereumRequestConfig(address: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("address", listOf(address.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/address-utils/mirror/substrate-to-ethereum",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
