/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package network.unique.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import network.unique.model.ApiRequestBody

import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class QueryApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost")
        }
    }

    /**
     * Direct get to any Polkadot getter
     * For read Polkadot &lt;a href&#x3D;\&quot;https://polkadot.js.org/docs/substrate/constants\&quot;&gt;constants&lt;/a&gt; select the appropriate value from the interface &lt;code&gt;api.&amp;lt;endpoint&amp;gt;.&amp;lt;module&amp;gt;.&amp;lt;method&amp;gt;&lt;/code&gt;.
     * @param endpoint 
     * @param module 
     * @param method 
     * @return kotlin.Any
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun queryControllerGet(endpoint: kotlin.String, module: kotlin.String, method: kotlin.String) : kotlin.Any {
        val localVarResponse = queryControllerGetWithHttpInfo(endpoint = endpoint, module = module, method = method)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.Any
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Direct get to any Polkadot getter
     * For read Polkadot &lt;a href&#x3D;\&quot;https://polkadot.js.org/docs/substrate/constants\&quot;&gt;constants&lt;/a&gt; select the appropriate value from the interface &lt;code&gt;api.&amp;lt;endpoint&amp;gt;.&amp;lt;module&amp;gt;.&amp;lt;method&amp;gt;&lt;/code&gt;.
     * @param endpoint 
     * @param module 
     * @param method 
     * @return ApiResponse<kotlin.Any?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun queryControllerGetWithHttpInfo(endpoint: kotlin.String, module: kotlin.String, method: kotlin.String) : ApiResponse<kotlin.Any?> {
        val localVariableConfig = queryControllerGetRequestConfig(endpoint = endpoint, module = module, method = method)

        return request<Unit, kotlin.Any>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation queryControllerGet
     *
     * @param endpoint 
     * @param module 
     * @param method 
     * @return RequestConfig
     */
    fun queryControllerGetRequestConfig(endpoint: kotlin.String, module: kotlin.String, method: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/v1/query/{endpoint}/{module}/{method}".replace("{"+"endpoint"+"}", encodeURIComponent(endpoint.toString())).replace("{"+"module"+"}", encodeURIComponent(module.toString())).replace("{"+"method"+"}", encodeURIComponent(method.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
     * Direct call to any Polkadot method
     * For call Polkadot method &lt;a href&#x3D;\&quot;https://polkadot.js.org/docs/substrate/storage/#number-u32\&quot;&gt;The current block number being processed&lt;/a&gt;  &lt;ul&gt;&lt;li&gt;&lt;code&gt;number(): u32&lt;FrameSystemPhase&gt;&lt;/code&gt;&lt;/li&gt;  &lt;li&gt;&lt;code&gt;interface: api.query.system.number&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; select the appropriate value from the interface &lt;code&gt;api.&amp;lt;endpoint&amp;gt;.&amp;lt;module&amp;gt;.&amp;lt;method&amp;gt;&lt;/code&gt; and pass the parameters to the method in the args list.
     * @param endpoint 
     * @param module 
     * @param method 
     * @param apiRequestBody 
     * @return kotlin.Any
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun queryControllerQuery(endpoint: kotlin.String, module: kotlin.String, method: kotlin.String, apiRequestBody: ApiRequestBody) : kotlin.Any {
        val localVarResponse = queryControllerQueryWithHttpInfo(endpoint = endpoint, module = module, method = method, apiRequestBody = apiRequestBody)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.Any
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Direct call to any Polkadot method
     * For call Polkadot method &lt;a href&#x3D;\&quot;https://polkadot.js.org/docs/substrate/storage/#number-u32\&quot;&gt;The current block number being processed&lt;/a&gt;  &lt;ul&gt;&lt;li&gt;&lt;code&gt;number(): u32&lt;FrameSystemPhase&gt;&lt;/code&gt;&lt;/li&gt;  &lt;li&gt;&lt;code&gt;interface: api.query.system.number&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; select the appropriate value from the interface &lt;code&gt;api.&amp;lt;endpoint&amp;gt;.&amp;lt;module&amp;gt;.&amp;lt;method&amp;gt;&lt;/code&gt; and pass the parameters to the method in the args list.
     * @param endpoint 
     * @param module 
     * @param method 
     * @param apiRequestBody 
     * @return ApiResponse<kotlin.Any?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun queryControllerQueryWithHttpInfo(endpoint: kotlin.String, module: kotlin.String, method: kotlin.String, apiRequestBody: ApiRequestBody) : ApiResponse<kotlin.Any?> {
        val localVariableConfig = queryControllerQueryRequestConfig(endpoint = endpoint, module = module, method = method, apiRequestBody = apiRequestBody)

        return request<ApiRequestBody, kotlin.Any>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation queryControllerQuery
     *
     * @param endpoint 
     * @param module 
     * @param method 
     * @param apiRequestBody 
     * @return RequestConfig
     */
    fun queryControllerQueryRequestConfig(endpoint: kotlin.String, module: kotlin.String, method: kotlin.String, apiRequestBody: ApiRequestBody) : RequestConfig<ApiRequestBody> {
        val localVariableBody = apiRequestBody
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/v1/query/{endpoint}/{module}/{method}".replace("{"+"endpoint"+"}", encodeURIComponent(endpoint.toString())).replace("{"+"module"+"}", encodeURIComponent(module.toString())).replace("{"+"method"+"}", encodeURIComponent(method.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
