(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-css-generator-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-css-generator-js-legacy'.");
    }root['kotlin-css-generator-js-legacy'] = factory(typeof this['kotlin-css-generator-js-legacy'] === 'undefined' ? {} : this['kotlin-css-generator-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var roundToInt = Kotlin.kotlin.math.roundToInt_yrwdxr$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var substringBefore = Kotlin.kotlin.text.substringBefore_j4ogox$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var endsWith = Kotlin.kotlin.text.endsWith_7epoxm$;
  var math = Kotlin.kotlin.math;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var substringBefore_0 = Kotlin.kotlin.text.substringBefore_8cymmc$;
  var numberToInt = Kotlin.numberToInt;
  var endsWith_0 = Kotlin.kotlin.text.endsWith_sgbm27$;
  var toInt_0 = Kotlin.kotlin.text.toInt_6ic1pp$;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var substring = Kotlin.kotlin.text.substring_fc3b62$;
  var coerceIn = Kotlin.kotlin.ranges.coerceIn_nig4hr$;
  var coerceIn_0 = Kotlin.kotlin.ranges.coerceIn_e4yvb3$;
  var RegexOption = Kotlin.kotlin.text.RegexOption;
  var Regex_init = Kotlin.kotlin.text.Regex_init_sb3q2$;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var repeat = Kotlin.kotlin.text.repeat_94bcnn$;
  var toString = Kotlin.kotlin.text.toString_dqglrj$;
  var contains = Kotlin.kotlin.text.contains_li3zpu$;
  var JsMath = Math;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var equals = Kotlin.equals;
  var slice = Kotlin.kotlin.text.slice_fc3b62$;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var Annotation = Kotlin.kotlin.Annotation;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var sorted = Kotlin.kotlin.collections.sorted_exjks8$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var hashCode = Kotlin.hashCode;
  var toBoxedChar = Kotlin.toBoxedChar;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var contains_0 = Kotlin.kotlin.collections.contains_mjy6jw$;
  var unboxChar = Kotlin.unboxChar;
  var ensureNotNull = Kotlin.ensureNotNull;
  var contains_1 = Kotlin.kotlin.text.contains_sgbm27$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  AlignContent.prototype = Object.create(CssProperty.prototype);
  AlignContent.prototype.constructor = AlignContent;
  AlignItems.prototype = Object.create(CssProperty.prototype);
  AlignItems.prototype.constructor = AlignItems;
  AlignSelf.prototype = Object.create(CssProperty.prototype);
  AlignSelf.prototype.constructor = AlignSelf;
  All.prototype = Object.create(CssProperty.prototype);
  All.prototype.constructor = All;
  AnimationDirection.prototype = Object.create(CssProperty.prototype);
  AnimationDirection.prototype.constructor = AnimationDirection;
  AnimationFillMode.prototype = Object.create(CssProperty.prototype);
  AnimationFillMode.prototype.constructor = AnimationFillMode;
  AnimationFrame.prototype = Object.create(CssProperty.prototype);
  AnimationFrame.prototype.constructor = AnimationFrame;
  AnimationPlayState.prototype = Object.create(CssProperty.prototype);
  AnimationPlayState.prototype.constructor = AnimationPlayState;
  BackfaceVisibility.prototype = Object.create(CssProperty.prototype);
  BackfaceVisibility.prototype.constructor = BackfaceVisibility;
  BackgroundAttachment.prototype = Object.create(CssProperty.prototype);
  BackgroundAttachment.prototype.constructor = BackgroundAttachment;
  BackgroundBlendMode.prototype = Object.create(CssProperty.prototype);
  BackgroundBlendMode.prototype.constructor = BackgroundBlendMode;
  BackgroundPosition.prototype = Object.create(CssProperty.prototype);
  BackgroundPosition.prototype.constructor = BackgroundPosition;
  BackgroundRepeat.prototype = Object.create(CssProperty.prototype);
  BackgroundRepeat.prototype.constructor = BackgroundRepeat;
  BackgroundSize.prototype = Object.create(CssProperty.prototype);
  BackgroundSize.prototype.constructor = BackgroundSize;
  BorderStyle.prototype = Object.create(CssProperty.prototype);
  BorderStyle.prototype.constructor = BorderStyle;
  BorderWidth.prototype = Object.create(CssProperty.prototype);
  BorderWidth.prototype.constructor = BorderWidth;
  BorderCollapse.prototype = Object.create(CssProperty.prototype);
  BorderCollapse.prototype.constructor = BorderCollapse;
  BorderImageWidth.prototype = Object.create(CssProperty.prototype);
  BorderImageWidth.prototype.constructor = BorderImageWidth;
  BorderSpacing.prototype = Object.create(CssProperty.prototype);
  BorderSpacing.prototype.constructor = BorderSpacing;
  BoxDecorationBreak.prototype = Object.create(CssProperty.prototype);
  BoxDecorationBreak.prototype.constructor = BoxDecorationBreak;
  BoxShadow.prototype = Object.create(CssProperty.prototype);
  BoxShadow.prototype.constructor = BoxShadow;
  BoxSizing.prototype = Object.create(CssProperty.prototype);
  BoxSizing.prototype.constructor = BoxSizing;
  Break.prototype = Object.create(CssProperty.prototype);
  Break.prototype.constructor = Break;
  CaptionSide.prototype = Object.create(CssProperty.prototype);
  CaptionSide.prototype.constructor = CaptionSide;
  Clear.prototype = Object.create(CssProperty.prototype);
  Clear.prototype.constructor = Clear;
  Clip.prototype = Object.create(CssProperty.prototype);
  Clip.prototype.constructor = Clip;
  ClipPath.prototype = Object.create(CssProperty.prototype);
  ClipPath.prototype.constructor = ClipPath;
  ClipOrigin.prototype = Object.create(CssProperty.prototype);
  ClipOrigin.prototype.constructor = ClipOrigin;
  Color.prototype = Object.create(CssProperty.prototype);
  Color.prototype.constructor = Color;
  Length.prototype = Object.create(CssProperty.prototype);
  Length.prototype.constructor = Length;
  Fill.prototype = Object.create(CssProperty.prototype);
  Fill.prototype.constructor = Fill;
  Content.prototype = Object.create(CssProperty.prototype);
  Content.prototype.constructor = Content;
  Count.prototype = Object.create(CssProperty.prototype);
  Count.prototype.constructor = Count;
  CssFloat.prototype = Object.create(CssProperty.prototype);
  CssFloat.prototype.constructor = CssFloat;
  TextProperty.prototype = Object.create(CssProperty.prototype);
  TextProperty.prototype.constructor = TextProperty;
  DelayDuration.prototype = Object.create(CssProperty.prototype);
  DelayDuration.prototype.constructor = DelayDuration;
  Direction.prototype = Object.create(CssProperty.prototype);
  Direction.prototype.constructor = Direction;
  Display.prototype = Object.create(CssProperty.prototype);
  Display.prototype.constructor = Display;
  EmptyCells.prototype = Object.create(CssProperty.prototype);
  EmptyCells.prototype.constructor = EmptyCells;
  FlexDirection.prototype = Object.create(CssProperty.prototype);
  FlexDirection.prototype.constructor = FlexDirection;
  FlexGrowShrink.prototype = Object.create(CssProperty.prototype);
  FlexGrowShrink.prototype.constructor = FlexGrowShrink;
  FlexWrap.prototype = Object.create(CssProperty.prototype);
  FlexWrap.prototype.constructor = FlexWrap;
  FontSize.prototype = Object.create(CssProperty.prototype);
  FontSize.prototype.constructor = FontSize;
  FontStretch.prototype = Object.create(CssProperty.prototype);
  FontStretch.prototype.constructor = FontStretch;
  FontStyle.prototype = Object.create(CssProperty.prototype);
  FontStyle.prototype.constructor = FontStyle;
  FontWeight.prototype = Object.create(CssProperty.prototype);
  FontWeight.prototype.constructor = FontWeight;
  FontKerning.prototype = Object.create(CssProperty.prototype);
  FontKerning.prototype.constructor = FontKerning;
  FontSizeAdjust.prototype = Object.create(CssProperty.prototype);
  FontSizeAdjust.prototype.constructor = FontSizeAdjust;
  FontVariant.prototype = Object.create(CssProperty.prototype);
  FontVariant.prototype.constructor = FontVariant;
  FontVariantCaps.prototype = Object.create(CssProperty.prototype);
  FontVariantCaps.prototype.constructor = FontVariantCaps;
  Grid.prototype = Object.create(CssProperty.prototype);
  Grid.prototype.constructor = Grid;
  GridAuto.prototype = Object.create(CssProperty.prototype);
  GridAuto.prototype.constructor = GridAuto;
  GridFlow.prototype = Object.create(CssProperty.prototype);
  GridFlow.prototype.constructor = GridFlow;
  GridValue.prototype = Object.create(CssProperty.prototype);
  GridValue.prototype.constructor = GridValue;
  TemplateRowColumn.prototype = Object.create(CssProperty.prototype);
  TemplateRowColumn.prototype.constructor = TemplateRowColumn;
  Hyphens.prototype = Object.create(CssProperty.prototype);
  Hyphens.prototype.constructor = Hyphens;
  Image.prototype = Object.create(CssProperty.prototype);
  Image.prototype.constructor = Image;
  ImageRepeat.prototype = Object.create(CssProperty.prototype);
  ImageRepeat.prototype.constructor = ImageRepeat;
  ImageSlice.prototype = Object.create(CssProperty.prototype);
  ImageSlice.prototype.constructor = ImageSlice;
  ImageSource.prototype = Object.create(CssProperty.prototype);
  ImageSource.prototype.constructor = ImageSource;
  InitialInherit.prototype = Object.create(CssProperty.prototype);
  InitialInherit.prototype.constructor = InitialInherit;
  Isolation.prototype = Object.create(CssProperty.prototype);
  Isolation.prototype.constructor = Isolation;
  JustifyContent.prototype = Object.create(CssProperty.prototype);
  JustifyContent.prototype.constructor = JustifyContent;
  LetterSpacing.prototype = Object.create(CssProperty.prototype);
  LetterSpacing.prototype.constructor = LetterSpacing;
  ListStylePosition.prototype = Object.create(CssProperty.prototype);
  ListStylePosition.prototype.constructor = ListStylePosition;
  ListStyleType.prototype = Object.create(CssProperty.prototype);
  ListStyleType.prototype.constructor = ListStyleType;
  MeasurementUoM.prototype = Object.create(Enum.prototype);
  MeasurementUoM.prototype.constructor = MeasurementUoM;
  Measurement.prototype = Object.create(CssProperty.prototype);
  Measurement.prototype.constructor = Measurement;
  LineHeight.prototype = Object.create(CssProperty.prototype);
  LineHeight.prototype.constructor = LineHeight;
  MixBlendMode.prototype = Object.create(CssProperty.prototype);
  MixBlendMode.prototype.constructor = MixBlendMode;
  ObjectFit.prototype = Object.create(CssProperty.prototype);
  ObjectFit.prototype.constructor = ObjectFit;
  OutlineWidth.prototype = Object.create(CssProperty.prototype);
  OutlineWidth.prototype.constructor = OutlineWidth;
  Overflow.prototype = Object.create(CssProperty.prototype);
  Overflow.prototype.constructor = Overflow;
  PageBreak.prototype = Object.create(CssProperty.prototype);
  PageBreak.prototype.constructor = PageBreak;
  Perspective.prototype = Object.create(CssProperty.prototype);
  Perspective.prototype.constructor = Perspective;
  PointerEvents.prototype = Object.create(CssProperty.prototype);
  PointerEvents.prototype.constructor = PointerEvents;
  Position.prototype = Object.create(CssProperty.prototype);
  Position.prototype.constructor = Position;
  HangingPunctuation.prototype = Object.create(CssProperty.prototype);
  HangingPunctuation.prototype.constructor = HangingPunctuation;
  Resize.prototype = Object.create(CssProperty.prototype);
  Resize.prototype.constructor = Resize;
  ScrollBehavior.prototype = Object.create(CssProperty.prototype);
  ScrollBehavior.prototype.constructor = ScrollBehavior;
  Span.prototype = Object.create(CssProperty.prototype);
  Span.prototype.constructor = Span;
  TableLayout.prototype = Object.create(CssProperty.prototype);
  TableLayout.prototype.constructor = TableLayout;
  TextAlign.prototype = Object.create(CssProperty.prototype);
  TextAlign.prototype.constructor = TextAlign;
  TextAlignLast.prototype = Object.create(CssProperty.prototype);
  TextAlignLast.prototype.constructor = TextAlignLast;
  TextDecorationLine.prototype = Object.create(CssProperty.prototype);
  TextDecorationLine.prototype.constructor = TextDecorationLine;
  TextDecorationStyle.prototype = Object.create(CssProperty.prototype);
  TextDecorationStyle.prototype.constructor = TextDecorationStyle;
  TextJustify.prototype = Object.create(CssProperty.prototype);
  TextJustify.prototype.constructor = TextJustify;
  TextTransform.prototype = Object.create(CssProperty.prototype);
  TextTransform.prototype.constructor = TextTransform;
  TimingFunction.prototype = Object.create(CssProperty.prototype);
  TimingFunction.prototype.constructor = TimingFunction;
  Transform.prototype = Object.create(CssProperty.prototype);
  Transform.prototype.constructor = Transform;
  TransformStyle.prototype = Object.create(CssProperty.prototype);
  TransformStyle.prototype.constructor = TransformStyle;
  UnicodeBidi.prototype = Object.create(CssProperty.prototype);
  UnicodeBidi.prototype.constructor = UnicodeBidi;
  UserSelect.prototype = Object.create(CssProperty.prototype);
  UserSelect.prototype.constructor = UserSelect;
  VerticalAlign.prototype = Object.create(CssProperty.prototype);
  VerticalAlign.prototype.constructor = VerticalAlign;
  Visibility.prototype = Object.create(CssProperty.prototype);
  Visibility.prototype.constructor = Visibility;
  WhiteSpace.prototype = Object.create(CssProperty.prototype);
  WhiteSpace.prototype.constructor = WhiteSpace;
  WordBreak.prototype = Object.create(CssProperty.prototype);
  WordBreak.prototype.constructor = WordBreak;
  WordSpacing.prototype = Object.create(CssProperty.prototype);
  WordSpacing.prototype.constructor = WordSpacing;
  WordWrap.prototype = Object.create(CssProperty.prototype);
  WordWrap.prototype.constructor = WordWrap;
  WritingMode.prototype = Object.create(CssProperty.prototype);
  WritingMode.prototype.constructor = WritingMode;
  ZIndex.prototype = Object.create(CssProperty.prototype);
  ZIndex.prototype.constructor = ZIndex;
  FontFace.prototype = Object.create(CssGenerator.prototype);
  FontFace.prototype.constructor = FontFace;
  KeyFrames.prototype = Object.create(CssGenerator.prototype);
  KeyFrames.prototype.constructor = KeyFrames;
  Style.prototype = Object.create(CssGenerator.prototype);
  Style.prototype.constructor = Style;
  ConditionalStyle.prototype = Object.create(Style.prototype);
  ConditionalStyle.prototype.constructor = ConditionalStyle;
  MaxCountValidator.prototype = Object.create(Validator.prototype);
  MaxCountValidator.prototype.constructor = MaxCountValidator;
  InitialInheritSingleValue.prototype = Object.create(Validator.prototype);
  InitialInheritSingleValue.prototype.constructor = InitialInheritSingleValue;
  function css(definition) {
    return definition;
  }
  function style(definition) {
    var css = new ConditionalStyle();
    definition(css);
    return css;
  }
  function CssBuilder() {
    this.definition = new Style();
  }
  CssBuilder.prototype.style_8xi0to$ = function (definition) {
    definition(this.definition);
  };
  CssBuilder.prototype.getCss_6taknv$ = function (minified) {
    if (minified === void 0)
      minified = false;
    return this.definition.generateCss_c48ccp$(void 0, minified);
  };
  CssBuilder.prototype.toString = function () {
    return 'CssBuilder(' + this.definition.generateCss_c48ccp$() + ')';
  };
  CssBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CssBuilder',
    interfaces: []
  };
  function AlignContent(value) {
    AlignContent$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function AlignContent$Companion() {
    AlignContent$Companion_instance = this;
    this.stretch = new AlignContent('stretch');
    this.center = new AlignContent('center');
    this.flexStart = new AlignContent('flex-start');
    this.flexEnd = new AlignContent('flex-end');
    this.spaceBetween = new AlignContent('space-between');
    this.spaceAround = new AlignContent('space-around');
    this.initial = new AlignContent('initial');
    this.inherit = new AlignContent('inherit');
  }
  AlignContent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AlignContent$Companion_instance = null;
  function AlignContent$Companion_getInstance() {
    if (AlignContent$Companion_instance === null) {
      new AlignContent$Companion();
    }return AlignContent$Companion_instance;
  }
  AlignContent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AlignContent',
    interfaces: [CssProperty]
  };
  function AlignItems(value) {
    AlignItems$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function AlignItems$Companion() {
    AlignItems$Companion_instance = this;
    this.stretch = new AlignItems('stretch');
    this.center = new AlignItems('center');
    this.flexStart = new AlignItems('flex-start');
    this.flexEnd = new AlignItems('flex-end');
    this.baseline = new AlignItems('baseline');
    this.initial = new AlignItems('initial');
    this.inherit = new AlignItems('inherit');
  }
  AlignItems$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AlignItems$Companion_instance = null;
  function AlignItems$Companion_getInstance() {
    if (AlignItems$Companion_instance === null) {
      new AlignItems$Companion();
    }return AlignItems$Companion_instance;
  }
  AlignItems.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AlignItems',
    interfaces: [CssProperty]
  };
  function AlignSelf(value) {
    AlignSelf$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function AlignSelf$Companion() {
    AlignSelf$Companion_instance = this;
    this.auto = new AlignSelf('auto');
    this.stretch = new AlignSelf('stretch');
    this.center = new AlignSelf('center');
    this.flexStart = new AlignSelf('flex-start');
    this.flexEnd = new AlignSelf('flex-end');
    this.baseline = new AlignSelf('baseline');
    this.initial = new AlignSelf('initial');
    this.inherit = new AlignSelf('inherit');
  }
  AlignSelf$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AlignSelf$Companion_instance = null;
  function AlignSelf$Companion_getInstance() {
    if (AlignSelf$Companion_instance === null) {
      new AlignSelf$Companion();
    }return AlignSelf$Companion_instance;
  }
  AlignSelf.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AlignSelf',
    interfaces: [CssProperty]
  };
  function All(value) {
    All$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function All$Companion() {
    All$Companion_instance = this;
    this.unset = new All('unset');
    this.revert = new All('revert');
    this.initial = new All('initial');
    this.inherit = new All('inherit');
  }
  All$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var All$Companion_instance = null;
  function All$Companion_getInstance() {
    if (All$Companion_instance === null) {
      new All$Companion();
    }return All$Companion_instance;
  }
  All.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'All',
    interfaces: [CssProperty]
  };
  function AnimationDirection(value) {
    AnimationDirection$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function AnimationDirection$Companion() {
    AnimationDirection$Companion_instance = this;
    this.normal = new AnimationDirection('normal');
    this.reverse = new AnimationDirection('reverse');
    this.alternate = new AnimationDirection('alternate');
    this.alternateReverse = new AnimationDirection('alternate-reverse');
    this.initial = new AnimationDirection('initial');
    this.inherit = new AnimationDirection('inherit');
  }
  AnimationDirection$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnimationDirection$Companion_instance = null;
  function AnimationDirection$Companion_getInstance() {
    if (AnimationDirection$Companion_instance === null) {
      new AnimationDirection$Companion();
    }return AnimationDirection$Companion_instance;
  }
  AnimationDirection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnimationDirection',
    interfaces: [CssProperty]
  };
  function AnimationFillMode(value) {
    AnimationFillMode$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function AnimationFillMode$Companion() {
    AnimationFillMode$Companion_instance = this;
    this.none = new AnimationFillMode('none');
    this.forwards = new AnimationFillMode('forwards');
    this.backwards = new AnimationFillMode('backwards');
    this.both = new AnimationFillMode('both');
    this.initial = new AnimationFillMode('initial');
    this.inherit = new AnimationFillMode('inherit');
  }
  AnimationFillMode$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnimationFillMode$Companion_instance = null;
  function AnimationFillMode$Companion_getInstance() {
    if (AnimationFillMode$Companion_instance === null) {
      new AnimationFillMode$Companion();
    }return AnimationFillMode$Companion_instance;
  }
  AnimationFillMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnimationFillMode',
    interfaces: [CssProperty]
  };
  function AnimationFrame(value) {
    AnimationFrame$Companion_getInstance();
    if (value === void 0)
      value = '';
    CssProperty.call(this, value);
  }
  function AnimationFrame$Companion() {
    AnimationFrame$Companion_instance = this;
    this.none = new AnimationFrame('none');
    this.initial = new AnimationFrame('initial');
    this.inherit = new AnimationFrame('inherit');
  }
  AnimationFrame$Companion.prototype.name_61zpoe$ = function (name) {
    return new AnimationFrame(name);
  };
  AnimationFrame$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnimationFrame$Companion_instance = null;
  function AnimationFrame$Companion_getInstance() {
    if (AnimationFrame$Companion_instance === null) {
      new AnimationFrame$Companion();
    }return AnimationFrame$Companion_instance;
  }
  AnimationFrame.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnimationFrame',
    interfaces: [CssProperty]
  };
  function AnimationPlayState(value) {
    AnimationPlayState$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function AnimationPlayState$Companion() {
    AnimationPlayState$Companion_instance = this;
    this.paused = new AnimationPlayState('paused');
    this.running = new AnimationPlayState('running');
    this.initial = new AnimationPlayState('initial');
    this.inherit = new AnimationPlayState('inherit');
  }
  AnimationPlayState$Companion.prototype.name_61zpoe$ = function (name) {
    return new AnimationPlayState(name);
  };
  AnimationPlayState$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnimationPlayState$Companion_instance = null;
  function AnimationPlayState$Companion_getInstance() {
    if (AnimationPlayState$Companion_instance === null) {
      new AnimationPlayState$Companion();
    }return AnimationPlayState$Companion_instance;
  }
  AnimationPlayState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnimationPlayState',
    interfaces: [CssProperty]
  };
  function BackfaceVisibility(value) {
    BackfaceVisibility$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BackfaceVisibility$Companion() {
    BackfaceVisibility$Companion_instance = this;
    this.visible = new BackfaceVisibility('visible');
    this.hidden = new BackfaceVisibility('hidden');
    this.initial = new BackfaceVisibility('initial');
    this.inherit = new BackfaceVisibility('inherit');
  }
  BackfaceVisibility$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BackfaceVisibility$Companion_instance = null;
  function BackfaceVisibility$Companion_getInstance() {
    if (BackfaceVisibility$Companion_instance === null) {
      new BackfaceVisibility$Companion();
    }return BackfaceVisibility$Companion_instance;
  }
  BackfaceVisibility.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BackfaceVisibility',
    interfaces: [CssProperty]
  };
  function BackgroundAttachment(value) {
    BackgroundAttachment$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BackgroundAttachment$Companion() {
    BackgroundAttachment$Companion_instance = this;
    this.scroll = new BackgroundAttachment('scroll');
    this.fixed = new BackgroundAttachment('fixed');
    this.local = new BackgroundAttachment('local');
    this.initial = new BackgroundAttachment('initial');
    this.inherit = new BackgroundAttachment('inherit');
  }
  BackgroundAttachment$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BackgroundAttachment$Companion_instance = null;
  function BackgroundAttachment$Companion_getInstance() {
    if (BackgroundAttachment$Companion_instance === null) {
      new BackgroundAttachment$Companion();
    }return BackgroundAttachment$Companion_instance;
  }
  BackgroundAttachment.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BackgroundAttachment',
    interfaces: [CssProperty]
  };
  function BackgroundBlendMode(value) {
    BackgroundBlendMode$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BackgroundBlendMode$Companion() {
    BackgroundBlendMode$Companion_instance = this;
    this.normal = new BackgroundBlendMode('normal');
    this.multiply = new BackgroundBlendMode('multiply');
    this.screen = new BackgroundBlendMode('screen');
    this.overlay = new BackgroundBlendMode('overlay');
    this.darken = new BackgroundBlendMode('darken');
    this.lighten = new BackgroundBlendMode('lighten');
    this.colorDodge = new BackgroundBlendMode('color-dodge');
    this.saturation = new BackgroundBlendMode('saturation');
    this.color = new BackgroundBlendMode('color');
    this.luminosity = new BackgroundBlendMode('luminosity');
  }
  BackgroundBlendMode$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BackgroundBlendMode$Companion_instance = null;
  function BackgroundBlendMode$Companion_getInstance() {
    if (BackgroundBlendMode$Companion_instance === null) {
      new BackgroundBlendMode$Companion();
    }return BackgroundBlendMode$Companion_instance;
  }
  BackgroundBlendMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BackgroundBlendMode',
    interfaces: [CssProperty]
  };
  function BackgroundPosition(value) {
    BackgroundPosition$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BackgroundPosition$Companion() {
    BackgroundPosition$Companion_instance = this;
    this.left = new BackgroundPosition('left');
    this.center = new BackgroundPosition('center');
    this.right = new BackgroundPosition('right');
    this.initial = new BackgroundPosition('initial');
    this.inherit = new BackgroundPosition('inherit');
  }
  BackgroundPosition$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BackgroundPosition$Companion_instance = null;
  function BackgroundPosition$Companion_getInstance() {
    if (BackgroundPosition$Companion_instance === null) {
      new BackgroundPosition$Companion();
    }return BackgroundPosition$Companion_instance;
  }
  BackgroundPosition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BackgroundPosition',
    interfaces: [CssProperty]
  };
  function BackgroundRepeat(value) {
    BackgroundRepeat$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BackgroundRepeat$Companion() {
    BackgroundRepeat$Companion_instance = this;
    this.repeat = new BackgroundRepeat('repeat');
    this.repeatX = new BackgroundRepeat('repeat-x');
    this.repeatY = new BackgroundRepeat('repeat-y');
    this.noRepeat = new BackgroundRepeat('no-repeat');
    this.space = new BackgroundRepeat('space');
    this.round = new BackgroundRepeat('round');
    this.initial = new BackgroundRepeat('initial');
    this.inherit = new BackgroundRepeat('inherit');
    this.unset = new BackgroundRepeat('unset');
  }
  BackgroundRepeat$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BackgroundRepeat$Companion_instance = null;
  function BackgroundRepeat$Companion_getInstance() {
    if (BackgroundRepeat$Companion_instance === null) {
      new BackgroundRepeat$Companion();
    }return BackgroundRepeat$Companion_instance;
  }
  BackgroundRepeat.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BackgroundRepeat',
    interfaces: [CssProperty]
  };
  function BackgroundSize(value) {
    BackgroundSize$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BackgroundSize$Companion() {
    BackgroundSize$Companion_instance = this;
    this.auto = new BackgroundSize('auto');
    this.cover = new BackgroundSize('cover');
    this.contain = new BackgroundSize('contain');
    this.initial = new BackgroundSize('initial');
    this.inherit = new BackgroundSize('inherit');
  }
  BackgroundSize$Companion.prototype.px_za3lpa$ = function (px) {
    return new BackgroundSize(px.toString() + 'px');
  };
  BackgroundSize$Companion.prototype.perc_14dthe$ = function (pc) {
    return new BackgroundSize(pc.toString() + '%');
  };
  BackgroundSize$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BackgroundSize$Companion_instance = null;
  function BackgroundSize$Companion_getInstance() {
    if (BackgroundSize$Companion_instance === null) {
      new BackgroundSize$Companion();
    }return BackgroundSize$Companion_instance;
  }
  BackgroundSize.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BackgroundSize',
    interfaces: [CssProperty]
  };
  function BorderStyle(value) {
    BorderStyle$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BorderStyle$Companion() {
    BorderStyle$Companion_instance = this;
    this.none = new BorderStyle('none');
    this.hidden = new BorderStyle('hidden');
    this.dotted = new BorderStyle('dotted');
    this.dashed = new BorderStyle('dashed');
    this.solid = new BorderStyle('solid');
    this.double = new BorderStyle('double');
    this.groove = new BorderStyle('groove');
    this.ridge = new BorderStyle('ridge');
    this.inset = new BorderStyle('inset');
    this.outset = new BorderStyle('outset');
    this.initial = new BorderStyle('initial');
    this.inherit = new BorderStyle('inherit');
  }
  BorderStyle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BorderStyle$Companion_instance = null;
  function BorderStyle$Companion_getInstance() {
    if (BorderStyle$Companion_instance === null) {
      new BorderStyle$Companion();
    }return BorderStyle$Companion_instance;
  }
  BorderStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderStyle',
    interfaces: [CssProperty]
  };
  function BorderWidth(value) {
    BorderWidth$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BorderWidth$Companion() {
    BorderWidth$Companion_instance = this;
    this.thin = new BorderWidth('thin');
    this.medium = new BorderWidth('medium');
    this.thick = new BorderWidth('thick');
    this.initial = new BorderWidth('initial');
    this.inherit = new BorderWidth('inherit');
  }
  BorderWidth$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BorderWidth$Companion_instance = null;
  function BorderWidth$Companion_getInstance() {
    if (BorderWidth$Companion_instance === null) {
      new BorderWidth$Companion();
    }return BorderWidth$Companion_instance;
  }
  BorderWidth.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderWidth',
    interfaces: [CssProperty]
  };
  function BorderCollapse(value) {
    BorderCollapse$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BorderCollapse$Companion() {
    BorderCollapse$Companion_instance = this;
    this.separate = new BorderCollapse('separate');
    this.collapse = new BorderCollapse('collapse');
  }
  BorderCollapse$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BorderCollapse$Companion_instance = null;
  function BorderCollapse$Companion_getInstance() {
    if (BorderCollapse$Companion_instance === null) {
      new BorderCollapse$Companion();
    }return BorderCollapse$Companion_instance;
  }
  BorderCollapse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderCollapse',
    interfaces: [CssProperty]
  };
  function BorderImageWidth(value) {
    BorderImageWidth$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BorderImageWidth$Companion() {
    BorderImageWidth$Companion_instance = this;
    this.auto = new BorderImageWidth('auto');
    this.initial = new BorderImageWidth('initial');
    this.inherit = new BorderImageWidth('inherit');
  }
  BorderImageWidth$Companion.prototype.px_za3lpa$ = function (nr) {
    return new BorderImageWidth(nr.toString() + 'px');
  };
  BorderImageWidth$Companion.prototype.nr_za3lpa$ = function (nr) {
    return new BorderImageWidth(nr.toString());
  };
  BorderImageWidth$Companion.prototype.perc_za3lpa$ = function (nr) {
    return new BorderImageWidth(nr.toString() + '%');
  };
  BorderImageWidth$Companion.prototype.perc_14dthe$ = function (nr) {
    return new BorderImageWidth(nr.toString() + '%');
  };
  BorderImageWidth$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BorderImageWidth$Companion_instance = null;
  function BorderImageWidth$Companion_getInstance() {
    if (BorderImageWidth$Companion_instance === null) {
      new BorderImageWidth$Companion();
    }return BorderImageWidth$Companion_instance;
  }
  BorderImageWidth.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderImageWidth',
    interfaces: [CssProperty]
  };
  function BorderSpacing(value) {
    BorderSpacing$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BorderSpacing$Companion() {
    BorderSpacing$Companion_instance = this;
    this.initial = new BorderSpacing('initial');
    this.inherit = new BorderSpacing('inherit');
  }
  BorderSpacing$Companion.prototype.px_za3lpa$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'px');
  };
  BorderSpacing$Companion.prototype.em_za3lpa$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'em');
  };
  BorderSpacing$Companion.prototype.em_14dthe$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'em');
  };
  BorderSpacing$Companion.prototype.perc_za3lpa$ = function (nr) {
    return new BorderSpacing(nr.toString() + '%');
  };
  BorderSpacing$Companion.prototype.perc_14dthe$ = function (nr) {
    return new BorderSpacing(nr.toString() + '%');
  };
  BorderSpacing$Companion.prototype.pc_za3lpa$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'pc');
  };
  BorderSpacing$Companion.prototype.pc_14dthe$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'pc');
  };
  BorderSpacing$Companion.prototype.cm_za3lpa$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'cm');
  };
  BorderSpacing$Companion.prototype.cm_14dthe$ = function (nr) {
    return new BorderSpacing(nr.toString() + 'cm');
  };
  BorderSpacing$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BorderSpacing$Companion_instance = null;
  function BorderSpacing$Companion_getInstance() {
    if (BorderSpacing$Companion_instance === null) {
      new BorderSpacing$Companion();
    }return BorderSpacing$Companion_instance;
  }
  BorderSpacing.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderSpacing',
    interfaces: [CssProperty]
  };
  function BoxDecorationBreak(value) {
    BoxDecorationBreak$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BoxDecorationBreak$Companion() {
    BoxDecorationBreak$Companion_instance = this;
    this.slice = new BoxDecorationBreak('slice');
    this.clone = new BoxDecorationBreak('clone');
    this.initial = new BoxDecorationBreak('initial');
    this.inherit = new BoxDecorationBreak('inherit');
    this.unset = new BoxDecorationBreak('unset');
  }
  BoxDecorationBreak$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BoxDecorationBreak$Companion_instance = null;
  function BoxDecorationBreak$Companion_getInstance() {
    if (BoxDecorationBreak$Companion_instance === null) {
      new BoxDecorationBreak$Companion();
    }return BoxDecorationBreak$Companion_instance;
  }
  BoxDecorationBreak.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BoxDecorationBreak',
    interfaces: [CssProperty]
  };
  function BoxShadow(value) {
    BoxShadow$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BoxShadow$Companion() {
    BoxShadow$Companion_instance = this;
    this.none = new BoxShadow('none');
    this.inset = new BoxShadow('inset');
    this.initial = new BoxShadow('initial');
    this.inherit = new BoxShadow('inherit');
  }
  BoxShadow$Companion.prototype.text_61zpoe$ = function (txt) {
    return new BoxShadow(txt);
  };
  BoxShadow$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BoxShadow$Companion_instance = null;
  function BoxShadow$Companion_getInstance() {
    if (BoxShadow$Companion_instance === null) {
      new BoxShadow$Companion();
    }return BoxShadow$Companion_instance;
  }
  BoxShadow.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BoxShadow',
    interfaces: [CssProperty]
  };
  function BoxSizing(value) {
    BoxSizing$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function BoxSizing$Companion() {
    BoxSizing$Companion_instance = this;
    this.contextBox = new BoxSizing('content-box');
    this.borderBox = new BoxSizing('border-box');
    this.initial = new BoxShadow('initial');
    this.inherit = new BoxShadow('inherit');
  }
  BoxSizing$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BoxSizing$Companion_instance = null;
  function BoxSizing$Companion_getInstance() {
    if (BoxSizing$Companion_instance === null) {
      new BoxSizing$Companion();
    }return BoxSizing$Companion_instance;
  }
  BoxSizing.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BoxSizing',
    interfaces: [CssProperty]
  };
  function Break(value) {
    Break$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Break$Companion() {
    Break$Companion_instance = this;
    this.auto = new Break('auto');
    this.all = new Break('all');
    this.always = new Break('always');
    this.avoid = new Break('avoid');
    this.avoidColumn = new Break('avoid-column');
    this.avoidPage = new Break('avoid-page');
    this.avoidRegion = new Break('avoid-region');
    this.column = new Break('column');
    this.left = new Break('left');
    this.page = new Break('page');
    this.recto = new Break('recto');
    this.region = new Break('region');
    this.right = new Break('right');
    this.verso = new Break('verso');
    this.initial = new Break('initial');
    this.inherit = new Break('inherit');
  }
  Break$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Break$Companion_instance = null;
  function Break$Companion_getInstance() {
    if (Break$Companion_instance === null) {
      new Break$Companion();
    }return Break$Companion_instance;
  }
  Break.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Break',
    interfaces: [CssProperty]
  };
  function CaptionSide(value) {
    CaptionSide$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function CaptionSide$Companion() {
    CaptionSide$Companion_instance = this;
    this.top = new CaptionSide('top');
    this.bottom = new CaptionSide('bottom');
    this.initial = new CaptionSide('initial');
    this.inherit = new CaptionSide('inherit');
  }
  CaptionSide$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CaptionSide$Companion_instance = null;
  function CaptionSide$Companion_getInstance() {
    if (CaptionSide$Companion_instance === null) {
      new CaptionSide$Companion();
    }return CaptionSide$Companion_instance;
  }
  CaptionSide.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CaptionSide',
    interfaces: [CssProperty]
  };
  function Clear(value) {
    Clear$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Clear$Companion() {
    Clear$Companion_instance = this;
    this.none = new Clear('none');
    this.left = new Clear('left');
    this.right = new Clear('right');
    this.both = new Clear('both');
    this.initial = new Clear('initial');
    this.inherit = new Clear('inherit');
  }
  Clear$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Clear$Companion_instance = null;
  function Clear$Companion_getInstance() {
    if (Clear$Companion_instance === null) {
      new Clear$Companion();
    }return Clear$Companion_instance;
  }
  Clear.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Clear',
    interfaces: [CssProperty]
  };
  function Clip(value) {
    Clip$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Clip$Companion() {
    Clip$Companion_instance = this;
    this.auto = new Clip('auto');
    this.initial = new Clip('initial');
    this.inherit = new Clip('inherit');
  }
  Clip$Companion.prototype.rect_tjonv8$ = function (top, right, bottom, left) {
    return new Clip('rect(' + top + 'px,' + right + 'px,' + bottom + 'px,' + left + 'px)');
  };
  Clip$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Clip$Companion_instance = null;
  function Clip$Companion_getInstance() {
    if (Clip$Companion_instance === null) {
      new Clip$Companion();
    }return Clip$Companion_instance;
  }
  Clip.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Clip',
    interfaces: [CssProperty]
  };
  function ClipPath(value) {
    ClipPath$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ClipPath$Companion() {
    ClipPath$Companion_instance = this;
    this.auto = new ClipPath('auto');
    this.marginBox = new ClipPath('margin-box');
    this.borderBox = new ClipPath('border-box');
    this.paddingBox = new ClipPath('padding-box');
    this.contentBox = new ClipPath('content-box');
    this.fillBox = new ClipPath('fill-box');
    this.strokeBox = new ClipPath('stroke-box');
    this.viewBox = new ClipPath('view-box');
    this.none = new ClipPath('none');
  }
  ClipPath$Companion.prototype.circle_14dthe$ = function (perc) {
    return new ClipPath('circle(' + perc + '%)');
  };
  ClipPath$Companion.prototype.ellipse_lu1900$ = function (radiusX, radiusY) {
    return new ClipPath('ellipse(' + radiusX + '%,' + radiusY + '%)');
  };
  ClipPath$Companion.prototype.ellipse_6y0v78$ = function (radiusX, radiusY, positionX, positionY) {
    return new ClipPath('ellipse(' + radiusX + '%,' + radiusY + '% at ' + positionX + '%,' + positionY + '%)');
  };
  ClipPath$Companion.prototype.other_61zpoe$ = function (text) {
    return new ClipPath(text);
  };
  ClipPath$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ClipPath$Companion_instance = null;
  function ClipPath$Companion_getInstance() {
    if (ClipPath$Companion_instance === null) {
      new ClipPath$Companion();
    }return ClipPath$Companion_instance;
  }
  ClipPath.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClipPath',
    interfaces: [CssProperty]
  };
  function ClipOrigin(value) {
    ClipOrigin$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ClipOrigin$Companion() {
    ClipOrigin$Companion_instance = this;
    this.borderBox = new ClipOrigin('border-box');
    this.paddingBox = new ClipOrigin('padding-box');
    this.contentBox = new ClipOrigin('content-box');
    this.initial = new ClipOrigin('initial');
    this.inherit = new ClipOrigin('inherit');
  }
  ClipOrigin$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ClipOrigin$Companion_instance = null;
  function ClipOrigin$Companion_getInstance() {
    if (ClipOrigin$Companion_instance === null) {
      new ClipOrigin$Companion();
    }return ClipOrigin$Companion_instance;
  }
  ClipOrigin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClipOrigin',
    interfaces: [CssProperty]
  };
  var hexString;
  function toColorHex($receiver, minimumDigits) {
    if (minimumDigits === void 0)
      minimumDigits = 2;
    var result = StringBuilder_init();
    var value = $receiver;
    while (value > 0) {
      result.append_s8itvh$(hexString.charCodeAt(value % 16));
      value = value / 16 | 0;
    }
    while (result.length < minimumDigits) {
      result.append_pdl1vj$('0');
    }
    return result.reverse().toString();
  }
  function Color(value) {
    Color$Companion_getInstance();
    CssProperty.call(this, value);
    this.rgb_0 = null;
  }
  Color.prototype.hasAlpha = function () {
    return this.isRgba() || this.isHexa() || this.isHsla();
  };
  Color.prototype.getAlpha = function () {
    if (this.isHexa() || this.isRgba())
      return this.toRGBA_8be2vx$().alpha;
    else if (this.isHsla())
      return this.fromHSLANotation_8be2vx$().alpha;
    else {
      return 1.0;
    }
  };
  Color.prototype.toHex = function () {
    if (this.isHsla() || this.isHsl()) {
      return this.fromHSLANotation_8be2vx$().asRGBA().asHex();
    } else {
      return this.toRGBA_8be2vx$().asHex();
    }
  };
  Color.prototype.isHsla = function () {
    var tmp$;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    return startsWith(v, 'hsla');
  };
  Color.prototype.isHsl = function () {
    var tmp$;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    return startsWith(v, 'hsl(');
  };
  Color.prototype.isRgba = function () {
    var tmp$;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    return startsWith(v, 'rgba(');
  };
  Color.prototype.isRgb = function () {
    var tmp$;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    return startsWith(v, 'rgb(');
  };
  Color.prototype.isHex = function () {
    var tmp$;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    return startsWith(v, '#') && v.length < 8;
  };
  Color.prototype.isHexa = function () {
    var tmp$;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    return startsWith(v, '#') && v.length > 7;
  };
  Color.prototype.withAlpha_14dthe$ = function (alpha) {
    if (startsWith(this.value, 'hsl', true)) {
      var $receiver = this.fromHSLANotation_8be2vx$();
      return hsla($receiver.hue, $receiver.saturation, $receiver.lightness, Color$Companion_getInstance().normalizeAlpha_14dthe$(alpha) * $receiver.alpha);
    } else {
      var $receiver_0 = this.toRGBA_8be2vx$();
      return rgba($receiver_0.red, $receiver_0.green, $receiver_0.blue, Color$Companion_getInstance().normalizeAlpha_14dthe$(alpha) * $receiver_0.alpha);
    }
  };
  Color.prototype.changeAlpha_14dthe$ = function (alpha) {
    if (startsWith(this.value, 'hsl', true)) {
      var $receiver = this.fromHSLANotation_8be2vx$();
      return hsla($receiver.hue, $receiver.saturation, $receiver.lightness, Color$Companion_getInstance().normalizeAlpha_14dthe$(alpha));
    } else {
      var $receiver_0 = this.toRGBA_8be2vx$();
      return rgba($receiver_0.red, $receiver_0.green, $receiver_0.blue, Color$Companion_getInstance().normalizeAlpha_14dthe$(alpha));
    }
  };
  Color.prototype.blend_9qian5$ = function (backgroundColor) {
    var source = this.toRGBA_8be2vx$();
    var background = backgroundColor.toRGBA_8be2vx$();
    var targetR = (1 - source.alpha) * background.red + source.alpha * source.red;
    var targetG = (1 - source.alpha) * background.green + source.alpha * source.green;
    var targetB = (1 - source.alpha) * background.blue + source.alpha * source.blue;
    return rgb(roundToInt(targetR), roundToInt(targetG), roundToInt(targetB));
  };
  Color.prototype.lighten_za3lpa$ = function (percent) {
    var tmp$;
    var isHSLA = startsWith(this.value, 'hsl', true);
    var hsla_0 = isHSLA ? this.fromHSLANotation_8be2vx$() : this.toRGBA_8be2vx$().asHSLA();
    var lightness = hsla_0.lightness + roundToInt(hsla_0.lightness * (Color$Companion_getInstance().normalizePercent_za3lpa$(percent) / 100.0)) | 0;
    var newHSLa = hsla_0.copy_gb4hak$(void 0, void 0, Color$Companion_getInstance().normalizePercent_za3lpa$(lightness));
    if (isHSLA) {
      tmp$ = hsla(newHSLa.hue, newHSLa.saturation, newHSLa.lightness, newHSLa.alpha);
    } else {
      var $receiver = newHSLa.asRGBA();
      tmp$ = rgba($receiver.red, $receiver.green, $receiver.blue, $receiver.alpha);
    }
    return tmp$;
  };
  Color.prototype.darken_za3lpa$ = function (percent) {
    var tmp$;
    var isHSLA = startsWith(this.value, 'hsl', true);
    var hsla_0 = isHSLA ? this.fromHSLANotation_8be2vx$() : this.toRGBA_8be2vx$().asHSLA();
    var darkness = hsla_0.lightness - roundToInt(hsla_0.lightness * (Color$Companion_getInstance().normalizePercent_za3lpa$(percent) / 100.0)) | 0;
    var newHSLa = hsla_0.copy_gb4hak$(void 0, void 0, Color$Companion_getInstance().normalizePercent_za3lpa$(darkness));
    if (isHSLA) {
      tmp$ = hsla(newHSLa.hue, newHSLa.saturation, newHSLa.lightness, newHSLa.alpha);
    } else {
      var $receiver = newHSLa.asRGBA();
      tmp$ = rgba($receiver.red, $receiver.green, $receiver.blue, $receiver.alpha);
    }
    return tmp$;
  };
  Color.prototype.contrast_za3lpa$ = function (percent) {
    var tmp$, tmp$_0;
    var isHSLA = startsWith(this.value, 'hsl', true);
    var hsla_0 = isHSLA ? this.fromHSLANotation_8be2vx$() : this.toRGBA_8be2vx$().asHSLA();
    if (hsla_0.lightness > 50) {
      tmp$ = hsla_0.lightness - roundToInt(hsla_0.lightness * (Color$Companion_getInstance().normalizePercent_za3lpa$(percent) / 100.0)) | 0;
    } else {
      tmp$ = hsla_0.lightness + roundToInt(hsla_0.lightness * (Color$Companion_getInstance().normalizePercent_za3lpa$(percent) / 100.0)) | 0;
    }
    var darkness = tmp$;
    var newHSLa = hsla_0.copy_gb4hak$(void 0, void 0, Color$Companion_getInstance().normalizePercent_za3lpa$(darkness));
    if (isHSLA) {
      tmp$_0 = hsla(newHSLa.hue, newHSLa.saturation, newHSLa.lightness, newHSLa.alpha);
    } else {
      var $receiver = newHSLa.asRGBA();
      tmp$_0 = rgba($receiver.red, $receiver.green, $receiver.blue, $receiver.alpha);
    }
    return tmp$_0;
  };
  Color.prototype.saturate_za3lpa$ = function (percent) {
    var tmp$;
    var isHSLA = startsWith(this.value, 'hsl', true);
    var hsla_0 = isHSLA ? this.fromHSLANotation_8be2vx$() : this.toRGBA_8be2vx$().asHSLA();
    var saturation = hsla_0.saturation + roundToInt(hsla_0.saturation * (Color$Companion_getInstance().normalizePercent_za3lpa$(percent) / 100.0)) | 0;
    var newHSLa = hsla_0.copy_gb4hak$(void 0, Color$Companion_getInstance().normalizePercent_za3lpa$(saturation));
    if (isHSLA) {
      tmp$ = hsla(newHSLa.hue, newHSLa.saturation, newHSLa.lightness, newHSLa.alpha);
    } else {
      var $receiver = newHSLa.asRGBA();
      tmp$ = rgba($receiver.red, $receiver.green, $receiver.blue, $receiver.alpha);
    }
    return tmp$;
  };
  Color.prototype.desaturate_za3lpa$ = function (percent) {
    var tmp$;
    var isHSLA = startsWith(this.value, 'hsl', true);
    var hsla_0 = isHSLA ? this.fromHSLANotation_8be2vx$() : this.toRGBA_8be2vx$().asHSLA();
    var desaturation = hsla_0.saturation - roundToInt(hsla_0.saturation * (Color$Companion_getInstance().normalizePercent_za3lpa$(percent) / 100.0)) | 0;
    var newHSLa = hsla_0.copy_gb4hak$(void 0, Color$Companion_getInstance().normalizePercent_za3lpa$(desaturation));
    if (isHSLA) {
      tmp$ = hsla(newHSLa.hue, newHSLa.saturation, newHSLa.lightness, newHSLa.alpha);
    } else {
      var $receiver = newHSLa.asRGBA();
      tmp$ = rgba($receiver.red, $receiver.green, $receiver.blue, $receiver.alpha);
    }
    return tmp$;
  };
  function Color$RGBA(red, green, blue, alpha) {
    if (alpha === void 0)
      alpha = 1.0;
    this.red = red;
    this.green = green;
    this.blue = blue;
    this.alpha = alpha;
  }
  Color$RGBA.prototype.asHSLA = function () {
    var tmp$;
    var r = this.red / 255.0;
    var g = this.green / 255.0;
    var b = this.blue / 255.0;
    var cMax = JsMath.max(r, g, b);
    var cMin = JsMath.min(r, g, b);
    var chroma = cMax - cMin;
    var lg = Color$Companion_getInstance().normalizeFractionalPercent_14dthe$((cMax + cMin) / 2);
    var tmp$_0;
    if (chroma !== 0.0) {
      var tmp$_1 = Color$Companion_getInstance();
      var x = 2.0 * lg - 1.0;
      tmp$_0 = tmp$_1.normalizeFractionalPercent_14dthe$(chroma / (1.0 - JsMath.abs(x)));
    } else
      tmp$_0 = 0.0;
    var s = tmp$_0;
    if (cMax === cMin)
      tmp$ = 0.0;
    else if (cMax === r)
      tmp$ = 60 * ((g - b) / chroma % 6.0);
    else if (cMax === g)
      tmp$ = 60 * ((b - r) / chroma + 2);
    else if (cMax === b)
      tmp$ = 60 * ((r - g) / chroma + 4);
    else {
      throw IllegalStateException_init('Unexpected value for max'.toString());
    }
    var h = tmp$;
    return new Color$HSLA(Color$Companion_getInstance().normalizeHue_14dthe$(h), roundToInt(s * 100), roundToInt(lg * 100), this.alpha);
  };
  Color$RGBA.prototype.asHex = function () {
    var result = StringBuilder_init();
    result.append_pdl1vj$(toColorHex(this.red, 2));
    result.append_pdl1vj$(toColorHex(this.green, 2));
    result.append_pdl1vj$(toColorHex(this.blue, 2));
    return result.toString();
  };
  Color$RGBA.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RGBA',
    interfaces: []
  };
  Color$RGBA.prototype.component1 = function () {
    return this.red;
  };
  Color$RGBA.prototype.component2 = function () {
    return this.green;
  };
  Color$RGBA.prototype.component3 = function () {
    return this.blue;
  };
  Color$RGBA.prototype.component4 = function () {
    return this.alpha;
  };
  Color$RGBA.prototype.copy_gb4hak$ = function (red, green, blue, alpha) {
    return new Color$RGBA(red === void 0 ? this.red : red, green === void 0 ? this.green : green, blue === void 0 ? this.blue : blue, alpha === void 0 ? this.alpha : alpha);
  };
  Color$RGBA.prototype.toString = function () {
    return 'RGBA(red=' + Kotlin.toString(this.red) + (', green=' + Kotlin.toString(this.green)) + (', blue=' + Kotlin.toString(this.blue)) + (', alpha=' + Kotlin.toString(this.alpha)) + ')';
  };
  Color$RGBA.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.red) | 0;
    result = result * 31 + Kotlin.hashCode(this.green) | 0;
    result = result * 31 + Kotlin.hashCode(this.blue) | 0;
    result = result * 31 + Kotlin.hashCode(this.alpha) | 0;
    return result;
  };
  Color$RGBA.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.red, other.red) && Kotlin.equals(this.green, other.green) && Kotlin.equals(this.blue, other.blue) && Kotlin.equals(this.alpha, other.alpha)))));
  };
  function Color$HSLA(hue, saturation, lightness, alpha) {
    if (alpha === void 0)
      alpha = 1.0;
    this.hue = hue;
    this.saturation = saturation;
    this.lightness = lightness;
    this.alpha = alpha;
  }
  function Color$HSLA$asRGBA$hueToRGB(m1, m2, h) {
    var tmp$;
    var hu = h < 0 ? h + 1 : h > 1 ? h - 1 : h;
    if (hu < 1.0 / 6)
      tmp$ = m1 + (m2 - m1) * 6 * hu;
    else if (hu < 1.0 / 2)
      tmp$ = m2;
    else if (hu < 2.0 / 3)
      tmp$ = m1 + (m2 - m1) * 6 * (2.0 / 3 - hu);
    else
      tmp$ = m1;
    return tmp$;
  }
  Color$HSLA.prototype.asRGBA = function () {
    var hueToRGB = Color$HSLA$asRGBA$hueToRGB;
    var lightness255 = (this.lightness * 255 | 0) / 100 | 0;
    if (this.saturation === 0)
      return new Color$RGBA(lightness255, lightness255, lightness255);
    var h = this.hue % 360.0 / 360.0;
    var s = this.saturation / 100.0;
    var lg = this.lightness / 100.0;
    var m2 = lg < 0.5 ? lg * (1 + s) : lg + s - lg * s;
    var m1 = 2 * lg - m2;
    var r = Color$Companion_getInstance().normalizeFractionalPercent_14dthe$(hueToRGB(m1, m2, h + 1.0 / 3));
    var g = Color$Companion_getInstance().normalizeFractionalPercent_14dthe$(hueToRGB(m1, m2, h));
    var b = Color$Companion_getInstance().normalizeFractionalPercent_14dthe$(hueToRGB(m1, m2, h - 1.0 / 3));
    return new Color$RGBA(roundToInt(r * 255), roundToInt(g * 255), roundToInt(b * 255), this.alpha);
  };
  Color$HSLA.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HSLA',
    interfaces: []
  };
  Color$HSLA.prototype.component1 = function () {
    return this.hue;
  };
  Color$HSLA.prototype.component2 = function () {
    return this.saturation;
  };
  Color$HSLA.prototype.component3 = function () {
    return this.lightness;
  };
  Color$HSLA.prototype.component4 = function () {
    return this.alpha;
  };
  Color$HSLA.prototype.copy_gb4hak$ = function (hue, saturation, lightness, alpha) {
    return new Color$HSLA(hue === void 0 ? this.hue : hue, saturation === void 0 ? this.saturation : saturation, lightness === void 0 ? this.lightness : lightness, alpha === void 0 ? this.alpha : alpha);
  };
  Color$HSLA.prototype.toString = function () {
    return 'HSLA(hue=' + Kotlin.toString(this.hue) + (', saturation=' + Kotlin.toString(this.saturation)) + (', lightness=' + Kotlin.toString(this.lightness)) + (', alpha=' + Kotlin.toString(this.alpha)) + ')';
  };
  Color$HSLA.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.hue) | 0;
    result = result * 31 + Kotlin.hashCode(this.saturation) | 0;
    result = result * 31 + Kotlin.hashCode(this.lightness) | 0;
    result = result * 31 + Kotlin.hashCode(this.alpha) | 0;
    return result;
  };
  Color$HSLA.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.hue, other.hue) && Kotlin.equals(this.saturation, other.saturation) && Kotlin.equals(this.lightness, other.lightness) && Kotlin.equals(this.alpha, other.alpha)))));
  };
  function Color$fromHSLANotation$getHSLParameter(closure$match, this$Color) {
    return function (index) {
      var tmp$, tmp$_0, tmp$_1;
      tmp$_1 = (tmp$_0 = (tmp$ = closure$match != null ? closure$match.groups : null) != null ? tmp$.get_za3lpa$(index) : null) != null ? tmp$_0.value : null;
      if (tmp$_1 == null) {
        throw IllegalArgumentException_init('Expected hsl or hsla notation, got ' + this$Color.value);
      }return tmp$_1;
    };
  }
  Color.prototype.fromHSLANotation_8be2vx$ = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    var match = Color$Companion_getInstance().HSLA_REGEX_0.find_905azu$(this.value);
    var getHSLParameter = Color$fromHSLANotation$getHSLParameter(match, this);
    var hueShape = getHSLParameter(1);
    if (endsWith(hueShape, 'grad', true))
      tmp$ = toDouble(substringBefore(hueShape, 'grad')) * (9.0 / 10);
    else if (endsWith(hueShape, 'rad', true))
      tmp$ = toDouble(substringBefore(hueShape, 'rad')) * 180 / math.PI;
    else if (endsWith(hueShape, 'turn', true))
      tmp$ = toDouble(substringBefore(hueShape, 'turn')) * 360.0;
    else if (endsWith(hueShape, 'deg', true))
      tmp$ = toDouble(substringBefore(hueShape, 'deg'));
    else
      tmp$ = toDouble(hueShape);
    var hue = Color$Companion_getInstance().normalizeHue_14dthe$(tmp$);
    var saturation = Color$Companion_getInstance().normalizePercent_za3lpa$(toInt(getHSLParameter(2)));
    var lightness = Color$Companion_getInstance().normalizePercent_za3lpa$(toInt(getHSLParameter(3)));
    tmp$_4 = (tmp$_3 = (tmp$_2 = (tmp$_1 = (tmp$_0 = match != null ? match.groups : null) != null ? tmp$_0.get_za3lpa$(4) : null) != null ? tmp$_1.value : null) != null ? toDouble(tmp$_2) : null) != null ? tmp$_3 : 1.0;
    var alpha = Color$Companion_getInstance().normalizeAlpha_14dthe$(tmp$_4);
    return new Color$HSLA(hue, saturation, lightness, alpha);
  };
  function Color$fromRGBANotation$getRGBParameter(closure$match, this$Color) {
    return function (index) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      tmp$_1 = (tmp$_0 = (tmp$ = closure$match != null ? closure$match.groups : null) != null ? tmp$.get_za3lpa$(index) : null) != null ? tmp$_0.value : null;
      if (tmp$_1 == null) {
        throw IllegalArgumentException_init('Expected rgb or rgba notation, got ' + this$Color.value);
      }var group = tmp$_1;
      if (endsWith_0(group, 37))
        tmp$_2 = numberToInt(Color$Companion_getInstance().normalizeFractionalPercent_14dthe$(toDouble(substringBefore_0(group, 37)) / 100.0) * 255.0);
      else
        tmp$_2 = Color$Companion_getInstance().normalizeRGB_za3lpa$(toInt(group));
      return tmp$_2;
    };
  }
  Color.prototype.fromRGBANotation_8be2vx$ = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var match = Color$Companion_getInstance().RGBA_REGEX_0.find_905azu$(this.value);
    var getRGBParameter = Color$fromRGBANotation$getRGBParameter(match, this);
    var red = getRGBParameter(1);
    var green = getRGBParameter(2);
    var blue = getRGBParameter(3);
    tmp$_3 = (tmp$_2 = (tmp$_1 = (tmp$_0 = (tmp$ = match != null ? match.groups : null) != null ? tmp$.get_za3lpa$(4) : null) != null ? tmp$_0.value : null) != null ? toDouble(tmp$_1) : null) != null ? tmp$_2 : 1.0;
    var alpha = Color$Companion_getInstance().normalizeAlpha_14dthe$(tmp$_3);
    return new Color$RGBA(red, green, blue, alpha);
  };
  Color.prototype.toRGBA_8be2vx$ = function () {
    var tmp$, tmp$_0;
    var v = (tmp$ = this.rgb_0) != null ? tmp$ : this.value;
    if (startsWith(v, 'rgb'))
      tmp$_0 = this.fromRGBANotation_8be2vx$();
    else if (startsWith(v, '#') && v.length === 4)
      tmp$_0 = new Color$RGBA(toInt_0(String.fromCharCode(v.charCodeAt(1)) + String.fromCharCode(v.charCodeAt(1)), 16), toInt_0(String.fromCharCode(v.charCodeAt(2)) + String.fromCharCode(v.charCodeAt(2)), 16), toInt_0(String.fromCharCode(v.charCodeAt(3)) + String.fromCharCode(v.charCodeAt(3)), 16));
    else if (startsWith(v, '#') && v.length === 7)
      tmp$_0 = new Color$RGBA(toInt_0(substring(v, new IntRange(1, 2)), 16), toInt_0(substring(v, new IntRange(3, 4)), 16), toInt_0(substring(v, new IntRange(5, 6)), 16));
    else if (startsWith(v, '#') && v.length === 9)
      tmp$_0 = new Color$RGBA(toInt_0(substring(v, new IntRange(1, 2)), 16), toInt_0(substring(v, new IntRange(3, 4)), 16), toInt_0(substring(v, new IntRange(5, 6)), 16), toInt_0(substring(v, new IntRange(7, 8)), 16) / 255.0);
    else
      throw IllegalArgumentException_init('Only hexadecimal, rgb, and rgba notations are accepted, got ' + v);
    return tmp$_0;
  };
  function Color$Companion() {
    Color$Companion_instance = this;
    this.initial = new Color('initial');
    this.inherit = new Color('inherit');
    this.unset = new Color('unset');
    this.transparent = new Color('transparent');
    this.currentColor = new Color('currentColor');
    this.aliceBlue = Color_init('aliceblue', '#f0f8ff');
    this.antiqueWhite = Color_init('antiquewhite', '#faebd7');
    this.aqua = Color_init('aqua', '#00ffff');
    this.aquamarine = Color_init('aquamarine', '#7fffd4');
    this.azure = Color_init('azure', '#f0ffff');
    this.beige = Color_init('beige', '#f5f5dc');
    this.bisque = Color_init('bisque', '#ffe4c4');
    this.black = Color_init('black', '#000000');
    this.blanchedAlmond = Color_init('blanchedalmond', '#ffebcd');
    this.blue = Color_init('blue', '#0000ff');
    this.blueViolet = Color_init('blueviolet', '#8a2be2');
    this.brown = Color_init('brown', '#a52a2a');
    this.burlyWood = Color_init('burlywood', '#deb887');
    this.cadetBlue = Color_init('cadetblue', '#5f9ea0');
    this.chartreuse = Color_init('chartreuse', '#7fff00');
    this.chocolate = Color_init('chocolate', '#d2691e');
    this.coral = Color_init('coral', '#ff7f50');
    this.cornflowerBlue = Color_init('cornflowerblue', '#6495ed');
    this.cornsilk = Color_init('cornsilk', '#fff8dc');
    this.crimson = Color_init('crimson', '#dc143c');
    this.cyan = Color_init('cyan', '#00ffff');
    this.darkBlue = Color_init('darkblue', '#00008b');
    this.darkCyan = Color_init('darkcyan', '#008b8b');
    this.darkGoldenrod = Color_init('darkgoldenrod', '#b8860b');
    this.darkGray = Color_init('darkgray', '#a9a9a9');
    this.darkGreen = Color_init('darkgreen', '#006400');
    this.darkGrey = Color_init('darkgrey', '#a9a9a9');
    this.darkKhaki = Color_init('darkkhaki', '#bdb76b');
    this.darkMagenta = Color_init('darkmagenta', '#8b008b');
    this.darkOliveGreen = Color_init('darkolivegreen', '#556b2f');
    this.darkOrange = Color_init('darkorange', '#ff8c00');
    this.darkOrchid = Color_init('darkorchid', '#9932cc');
    this.darkRed = Color_init('darkred', '#8b0000');
    this.darkSalmon = Color_init('darksalmon', '#e9967a');
    this.darkSeaGreen = Color_init('darkseagreen', '#8fbc8f');
    this.darkSlateBlue = Color_init('darkslateblue', '#483d8b');
    this.darkSlateGray = Color_init('darkslategray', '#2f4f4f');
    this.darkSlateGrey = Color_init('darkslategrey', '#2f4f4f');
    this.darkTurquoise = Color_init('darkturquoise', '#00ced1');
    this.darkViolet = Color_init('darkviolet', '#9400d3');
    this.deepPink = Color_init('deeppink', '#ff1493');
    this.deepSkyBlue = Color_init('deepskyblue', '#00bfff');
    this.dimGray = Color_init('dimgray', '#696969');
    this.dimGrey = Color_init('dimgrey', '#696969');
    this.dodgerBlue = Color_init('dodgerblue', '#1e90ff');
    this.firebrick = Color_init('firebrick', '#b22222');
    this.floralWhite = Color_init('floralwhite', '#fffaf0');
    this.forestGreen = Color_init('forestgreen', '#228b22');
    this.fuchsia = Color_init('fuchsia', '#ff00ff');
    this.gainsboro = Color_init('gainsboro', '#dcdcdc');
    this.ghostWhite = Color_init('ghostwhite', '#f8f8ff');
    this.gold = Color_init('gold', '#ffd700');
    this.goldenrod = Color_init('goldenrod', '#daa520');
    this.gray = Color_init('gray', '#808080');
    this.green = Color_init('green', '#008000');
    this.greenYellow = Color_init('greenyellow', '#adff2f');
    this.grey = Color_init('grey', '#808080');
    this.honeydew = Color_init('honeydew', '#f0fff0');
    this.hotPink = Color_init('hotpink', '#ff69b4');
    this.indianRed = Color_init('indianred', '#cd5c5c');
    this.indigo = Color_init('indigo', '#4b0082');
    this.ivory = Color_init('ivory', '#fffff0');
    this.khaki = Color_init('khaki', '#f0e68c');
    this.lavender = Color_init('lavender', '#e6e6fa');
    this.lavenderBlush = Color_init('lavenderblush', '#fff0f5');
    this.lawnGreen = Color_init('lawngreen', '#7cfc00');
    this.lemonChiffon = Color_init('lemonchiffon', '#fffacd');
    this.lightBlue = Color_init('lightblue', '#add8e6');
    this.lightCoral = Color_init('lightcoral', '#f08080');
    this.lightCyan = Color_init('lightcyan', '#e0ffff');
    this.lightGoldenrodYellow = Color_init('lightgoldenrodyellow', '#fafad2');
    this.lightGray = Color_init('lightgray', '#d3d3d3');
    this.lightGreen = Color_init('lightgreen', '#90ee90');
    this.lightGrey = Color_init('lightgrey', '#d3d3d3');
    this.lightPink = Color_init('lightpink', '#ffb6c1');
    this.lightSalmon = Color_init('lightsalmon', '#ffa07a');
    this.lightSeaGreen = Color_init('lightseagreen', '#20b2aa');
    this.lightSkyBlue = Color_init('lightskyblue', '#87cefa');
    this.lightSlateGray = Color_init('lightslategray', '#778899');
    this.lightSlateGrey = Color_init('lightslategrey', '#778899');
    this.lightSteelBlue = Color_init('lightsteelblue', '#b0c4de');
    this.lightYellow = Color_init('lightyellow', '#ffffe0');
    this.lime = Color_init('lime', '#00ff00');
    this.limeGreen = Color_init('limegreen', '#32cd32');
    this.linen = Color_init('linen', '#faf0e6');
    this.magenta = Color_init('magenta', '#ff00ff');
    this.maroon = Color_init('maroon', '#800000');
    this.mediumAquamarine = Color_init('mediumaquamarine', '#66cdaa');
    this.mediumBlue = Color_init('mediumblue', '#0000cd');
    this.mediumOrchid = Color_init('mediumorchid', '#ba55d3');
    this.mediumPurple = Color_init('mediumpurple', '#9370d8');
    this.mediumSeaGreen = Color_init('mediumseagreen', '#3cb371');
    this.mediumSlateBlue = Color_init('mediumslateblue', '#7b68ee');
    this.mediumSpringGreen = Color_init('mediumspringgreen', '#00fa9a');
    this.mediumTurquoise = Color_init('mediumturquoise', '#48d1cc');
    this.mediumVioletRed = Color_init('mediumvioletred', '#c71585');
    this.midnightBlue = Color_init('midnightblue', '#191970');
    this.mintCream = Color_init('mintcream', '#f5fffa');
    this.mistyRose = Color_init('mistyrose', '#ffe4e1');
    this.moccasin = Color_init('moccasin', '#ffe4b5');
    this.navajoWhite = Color_init('navajowhite', '#ffdead');
    this.navy = Color_init('navy', '#000080');
    this.oldLace = Color_init('oldlace', '#fdf5e6');
    this.olive = Color_init('olive', '#808000');
    this.oliveDrab = Color_init('olivedrab', '#6b8e23');
    this.orange = Color_init('orange', '#ffa500');
    this.orangeRed = Color_init('orangered', '#ff4500');
    this.orchid = Color_init('orchid', '#da70d6');
    this.paleGoldenrod = Color_init('palegoldenrod', '#eee8aa');
    this.paleGreen = Color_init('palegreen', '#98fb98');
    this.paleTurquoise = Color_init('paleturquoise', '#afeeee');
    this.paleVioletRed = Color_init('palevioletred', '#db7093');
    this.papayaWhip = Color_init('papayawhip', '#ffefd5');
    this.peachPuff = Color_init('peachpuff', '#ffdab9');
    this.peru = Color_init('peru', '#cd853f');
    this.pink = Color_init('pink', '#ffc0cb');
    this.plum = Color_init('plum', '#dda0dd');
    this.powderBlue = Color_init('powderblue', '#b0e0e6');
    this.purple = Color_init('purple', '#800080');
    this.red = Color_init('red', '#ff0000');
    this.rosyBrown = Color_init('rosybrown', '#bc8f8f');
    this.royalBlue = Color_init('royalblue', '#4169e1');
    this.saddleBrown = Color_init('saddlebrown', '#8b4513');
    this.salmon = Color_init('salmon', '#fa8072');
    this.sandyBrown = Color_init('sandybrown', '#f4a460');
    this.seaGreen = Color_init('seagreen', '#2e8b57');
    this.seaShell = Color_init('seashell', '#fff5ee');
    this.sienna = Color_init('sienna', '#a0522d');
    this.silver = Color_init('silver', '#c0c0c0');
    this.skyBlue = Color_init('skyblue', '#87ceeb');
    this.slateBlue = Color_init('slateblue', '#6a5acd');
    this.slateGray = Color_init('slategray', '#708090');
    this.slateGrey = Color_init('slategrey', '#708090');
    this.snow = Color_init('snow', '#fffafa');
    this.springGreen = Color_init('springgreen', '#00ff7f');
    this.steelBlue = Color_init('steelblue', '#4682b4');
    this.tan = Color_init('tan', '#d2b48c');
    this.teal = Color_init('teal', '#008080');
    this.thistle = Color_init('thistle', '#d8bfd8');
    this.tomato = Color_init('tomato', '#ff6347');
    this.turquoise = Color_init('turquoise', '#40e0d0');
    this.violet = Color_init('violet', '#ee82ee');
    this.wheat = Color_init('wheat', '#f5deb3');
    this.white = Color_init('white', '#ffffff');
    this.whiteSmoke = Color_init('whitesmoke', '#f5f5f5');
    this.yellow = Color_init('yellow', '#ffff00');
    this.yellowGreen = Color_init('yellowgreen', '#9acd32');
    this.HSLA_REGEX_wt41q7$_0 = lazy(Color$Companion$HSLA_REGEX$lambda);
    this.RGBA_REGEX_7xeq8d$_0 = lazy(Color$Companion$RGBA_REGEX$lambda);
  }
  Color$Companion.prototype.normalizeFractionalPercent_14dthe$ = function (value) {
    return coerceIn(value, 0.0, 1.0);
  };
  Color$Companion.prototype.normalizePercent_za3lpa$ = function (value) {
    return coerceIn_0(value, 0, 100);
  };
  Color$Companion.prototype.normalizeRGB_za3lpa$ = function (value) {
    return coerceIn_0(value, 0, 255);
  };
  Color$Companion.prototype.normalizeHue_14dthe$ = function (value) {
    return roundToInt((value % 360 + 360) % 360);
  };
  Color$Companion.prototype.normalizeAlpha_14dthe$ = function (value) {
    return this.normalizeFractionalPercent_14dthe$(value);
  };
  Object.defineProperty(Color$Companion.prototype, 'HSLA_REGEX_0', {
    configurable: true,
    get: function () {
      return this.HSLA_REGEX_wt41q7$_0.value;
    }
  });
  Object.defineProperty(Color$Companion.prototype, 'RGBA_REGEX_0', {
    configurable: true,
    get: function () {
      return this.RGBA_REGEX_7xeq8d$_0.value;
    }
  });
  function Color$Companion$HSLA_REGEX$lambda() {
    return Regex_init('^hsla?\\((-?[0-9]+\\.?[0-9]*(?:deg|grad|rad|turn)?)\\s*[, ]?\\s*(\\d{1,3})%\\s*[, ]\\s*(\\d{1,3})%\\s*[, ]?\\s*(\\d|(?:\\d?\\.\\d+))?\\)$', RegexOption.IGNORE_CASE);
  }
  function Color$Companion$RGBA_REGEX$lambda() {
    return Regex_init('^rgba?\\((\\d{1,3}%?)\\s*[, ]\\s*(\\d{1,3}%?)\\s*[, ]\\s*(\\d{1,3}%?)[, ]?\\s*(\\d|(?:\\d?\\.\\d+))?\\)$', RegexOption.IGNORE_CASE);
  }
  Color$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Color$Companion_instance = null;
  function Color$Companion_getInstance() {
    if (Color$Companion_instance === null) {
      new Color$Companion();
    }return Color$Companion_instance;
  }
  Color.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Color',
    interfaces: [CssProperty]
  };
  function Color_init(value, rgb, $this) {
    $this = $this || Object.create(Color.prototype);
    Color.call($this, value);
    $this.rgb_0 = rgb;
    return $this;
  }
  function withZeros($receiver) {
    var b = 3 - $receiver.length | 0;
    return $receiver + repeat('0', JsMath.max(0, b));
  }
  function hex(value) {
    return new Color('#' + withZeros(toString(value, 16)));
  }
  function rgb(red, green, blue) {
    return new Color('rgb(' + red + ', ' + green + ', ' + blue + ')');
  }
  function rgba(red, green, blue, alpha) {
    return new Color('rgba(' + red + ', ' + green + ', ' + blue + ', ' + formatAlpha(alpha) + ')');
  }
  function hsl(hue, saturation, lightness) {
    return new Color('hsl(' + hue + ', ' + saturation + '%, ' + lightness + '%)');
  }
  function hsla(hue, saturation, lightness, alpha) {
    return new Color('hsla(' + hue + ', ' + saturation + '%, ' + lightness + '%, ' + formatAlpha(alpha) + ')');
  }
  function blackAlpha(alpha) {
    return Color$Companion_getInstance().black.withAlpha_14dthe$(alpha);
  }
  function whiteAlpha(alpha) {
    return Color$Companion_getInstance().white.withAlpha_14dthe$(alpha);
  }
  function formatAlpha(alpha) {
    var it = alpha.toString();
    return contains(it, '.') ? it : it + '.0';
  }
  function Length(value) {
    Length$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Length$Companion() {
    Length$Companion_instance = this;
    this.initial = new Length('initial');
    this.inherit = new Length('inherit');
  }
  Length$Companion.prototype.px_za3lpa$ = function (nr) {
    return new Length(nr.toString() + 'px');
  };
  Length$Companion.prototype.em_za3lpa$ = function (nr) {
    return new Length(nr.toString() + 'em');
  };
  Length$Companion.prototype.em_14dthe$ = function (nr) {
    return new Length(nr.toString() + 'em');
  };
  Length$Companion.prototype.perc_za3lpa$ = function (nr) {
    return new Length(nr.toString() + '%');
  };
  Length$Companion.prototype.perc_14dthe$ = function (nr) {
    return new Length(nr.toString() + '%');
  };
  Length$Companion.prototype.pc_za3lpa$ = function (nr) {
    return new Length(nr.toString() + 'pc');
  };
  Length$Companion.prototype.pc_14dthe$ = function (nr) {
    return new Length(nr.toString() + 'pc');
  };
  Length$Companion.prototype.cm_za3lpa$ = function (nr) {
    return new Length(nr.toString() + 'cm');
  };
  Length$Companion.prototype.cm_14dthe$ = function (nr) {
    return new Length(nr.toString() + 'cm');
  };
  Length$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Length$Companion_instance = null;
  function Length$Companion_getInstance() {
    if (Length$Companion_instance === null) {
      new Length$Companion();
    }return Length$Companion_instance;
  }
  Length.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Length',
    interfaces: [CssProperty]
  };
  function Fill(value) {
    Fill$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Fill$Companion() {
    Fill$Companion_instance = this;
    this.balance = new Fill('balance');
    this.auto = new Fill('auto');
    this.initial = new Fill('initial');
    this.inherit = new Fill('inherit');
  }
  Fill$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Fill$Companion_instance = null;
  function Fill$Companion_getInstance() {
    if (Fill$Companion_instance === null) {
      new Fill$Companion();
    }return Fill$Companion_instance;
  }
  Fill.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Fill',
    interfaces: [CssProperty]
  };
  function Content(value) {
    Content$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Content$Companion() {
    Content$Companion_instance = this;
    this.normal = new Content('normal');
    this.none = new Content('none');
    this.counter = new Content('counter');
    this.openQuote = new Content('open-quote');
    this.closeQuote = new Content('close-quote');
    this.noOpenQuote = new Content('no-open-quote');
    this.noCloseQuote = new Content('no-close-quote');
    this.initial = new Content('initial');
    this.inherit = new Content('inherit');
  }
  Content$Companion.prototype.attr_61zpoe$ = function (attribute) {
    return new Content('attr(' + attribute + ')');
  };
  Content$Companion.prototype.string_61zpoe$ = function (txt) {
    return new Content('"' + txt + '"');
  };
  Content$Companion.prototype.url_61zpoe$ = function (url) {
    return new Content('url(' + url + ')');
  };
  Content$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Content$Companion_instance = null;
  function Content$Companion_getInstance() {
    if (Content$Companion_instance === null) {
      new Content$Companion();
    }return Content$Companion_instance;
  }
  Content.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Content',
    interfaces: [CssProperty]
  };
  function Count(value) {
    Count$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Count$Companion() {
    Count$Companion_instance = this;
    this.auto = new Count('auto');
    this.infinite = new Count('infinite');
    this.initial = new Count('initial');
    this.inherit = new Count('inherit');
  }
  Count$Companion.prototype.count_za3lpa$ = function (number) {
    return new Count(number.toString());
  };
  Count$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Count$Companion_instance = null;
  function Count$Companion_getInstance() {
    if (Count$Companion_instance === null) {
      new Count$Companion();
    }return Count$Companion_instance;
  }
  Count.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Count',
    interfaces: [CssProperty]
  };
  function CssFloat(value) {
    CssFloat$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function CssFloat$Companion() {
    CssFloat$Companion_instance = this;
    this.none = new CssFloat('none');
    this.left = new CssFloat('left');
    this.right = new CssFloat('right');
    this.initial = new CssFloat('initial');
    this.inherit = new CssFloat('inherit');
  }
  CssFloat$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CssFloat$Companion_instance = null;
  function CssFloat$Companion_getInstance() {
    if (CssFloat$Companion_instance === null) {
      new CssFloat$Companion();
    }return CssFloat$Companion_instance;
  }
  CssFloat.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CssFloat',
    interfaces: [CssProperty]
  };
  function CssValue() {
  }
  CssValue.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CssValue',
    interfaces: []
  };
  function CssProperty(value) {
    this.value = value;
  }
  CssProperty.prototype.css = function () {
    return this.value;
  };
  CssProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CssProperty',
    interfaces: [CssValue]
  };
  function text(value) {
    return new TextProperty(value);
  }
  function TextProperty(value) {
    CssProperty.call(this, value);
  }
  TextProperty.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextProperty',
    interfaces: [CssProperty]
  };
  function DelayDuration(value) {
    DelayDuration$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function DelayDuration$Companion() {
    DelayDuration$Companion_instance = this;
    this.initial = new DelayDuration('initial');
    this.inherit = new DelayDuration('inherit');
  }
  DelayDuration$Companion.prototype.seconds_za3lpa$ = function (seconds) {
    return new DelayDuration(seconds.toString() + 's');
  };
  DelayDuration$Companion.prototype.millis_za3lpa$ = function (milliSeconds) {
    return new DelayDuration(milliSeconds.toString() + 'ms');
  };
  DelayDuration$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DelayDuration$Companion_instance = null;
  function DelayDuration$Companion_getInstance() {
    if (DelayDuration$Companion_instance === null) {
      new DelayDuration$Companion();
    }return DelayDuration$Companion_instance;
  }
  DelayDuration.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DelayDuration',
    interfaces: [CssProperty]
  };
  function Direction(value) {
    Direction$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Direction$Companion() {
    Direction$Companion_instance = this;
    this.ltr = new Direction('ltr');
    this.rtl = new Direction('rtl');
    this.initial = new Direction('initial');
    this.inherit = new Direction('inherit');
  }
  Direction$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Direction$Companion_instance = null;
  function Direction$Companion_getInstance() {
    if (Direction$Companion_instance === null) {
      new Direction$Companion();
    }return Direction$Companion_instance;
  }
  Direction.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Direction',
    interfaces: [CssProperty]
  };
  function Display(value) {
    Display$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Display$Companion() {
    Display$Companion_instance = this;
    this.inline = new Display('inline');
    this.block = new Display('block');
    this.contents = new Display('contents');
    this.flex = new Display('flex');
    this.grid = new Display('grid');
    this.inlineBlock = new Display('inline-block');
    this.inlineFlex = new Display('inline-flex');
    this.inlineGrid = new Display('inline-grid');
    this.inlineTable = new Display('inline-table');
    this.listItem = new Display('list-item');
    this.runIn = new Display('run-in');
    this.table = new Display('table');
    this.tableCaption = new Display('table-caption');
    this.tableColumnGroup = new Display('table-column-group');
    this.tableHeaderGroup = new Display('table-header-group');
    this.tableFooterGroup = new Display('table-footer-group');
    this.tableRowGroup = new Display('table-row-group');
    this.tableCell = new Display('table-cell');
    this.tableColumn = new Display('table-column');
    this.tableRow = new Display('table-row');
    this.none = new Display('none');
    this.initial = new Display('initial');
    this.inherit = new Display('inherit');
  }
  Display$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Display$Companion_instance = null;
  function Display$Companion_getInstance() {
    if (Display$Companion_instance === null) {
      new Display$Companion();
    }return Display$Companion_instance;
  }
  Display.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Display',
    interfaces: [CssProperty]
  };
  function EmptyCells(value) {
    EmptyCells$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function EmptyCells$Companion() {
    EmptyCells$Companion_instance = this;
    this.show = new EmptyCells('show');
    this.hide = new EmptyCells('hide');
    this.initial = new EmptyCells('initial');
    this.inherit = new EmptyCells('inherit');
  }
  EmptyCells$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EmptyCells$Companion_instance = null;
  function EmptyCells$Companion_getInstance() {
    if (EmptyCells$Companion_instance === null) {
      new EmptyCells$Companion();
    }return EmptyCells$Companion_instance;
  }
  EmptyCells.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EmptyCells',
    interfaces: [CssProperty]
  };
  function FlexDirection(value) {
    FlexDirection$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FlexDirection$Companion() {
    FlexDirection$Companion_instance = this;
    this.row = new FlexDirection('row');
    this.rowReverse = new FlexDirection('row-reverse');
    this.column = new FlexDirection('column');
    this.columnReverse = new FlexDirection('column-reverse');
    this.initial = new FlexDirection('initial');
    this.inherit = new FlexDirection('inherit');
  }
  FlexDirection$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FlexDirection$Companion_instance = null;
  function FlexDirection$Companion_getInstance() {
    if (FlexDirection$Companion_instance === null) {
      new FlexDirection$Companion();
    }return FlexDirection$Companion_instance;
  }
  FlexDirection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FlexDirection',
    interfaces: [CssProperty]
  };
  function FlexGrowShrink(value) {
    FlexGrowShrink$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FlexGrowShrink$Companion() {
    FlexGrowShrink$Companion_instance = this;
    this.initial = new FlexGrowShrink('initial');
    this.inherit = new FlexGrowShrink('inherit');
  }
  FlexGrowShrink$Companion.prototype.number_za3lpa$ = function (number) {
    return new FlexGrowShrink(number.toString());
  };
  FlexGrowShrink$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FlexGrowShrink$Companion_instance = null;
  function FlexGrowShrink$Companion_getInstance() {
    if (FlexGrowShrink$Companion_instance === null) {
      new FlexGrowShrink$Companion();
    }return FlexGrowShrink$Companion_instance;
  }
  FlexGrowShrink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FlexGrowShrink',
    interfaces: [CssProperty]
  };
  function FlexWrap(value) {
    FlexWrap$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FlexWrap$Companion() {
    FlexWrap$Companion_instance = this;
    this.nowrap = new FlexWrap('nowrap');
    this.wrap = new FlexWrap('wrap');
    this.wrapReverse = new FlexWrap('wrap-reverse');
    this.initial = new FlexWrap('initial');
    this.inherit = new FlexWrap('inherit');
  }
  FlexWrap$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FlexWrap$Companion_instance = null;
  function FlexWrap$Companion_getInstance() {
    if (FlexWrap$Companion_instance === null) {
      new FlexWrap$Companion();
    }return FlexWrap$Companion_instance;
  }
  FlexWrap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FlexWrap',
    interfaces: [CssProperty]
  };
  function FontSize(value) {
    FontSize$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontSize$Companion() {
    FontSize$Companion_instance = this;
    this.xxSmall = new FontSize('xx-small');
    this.xSmall = new FontSize('x-small');
    this.small = new FontSize('small');
    this.medium = new FontSize('medium');
    this.large = new FontSize('large');
    this.xLarge = new FontSize('x-large');
    this.xxLarge = new FontSize('xx-large');
    this.smaller = new FontSize('smaller');
    this.larger = new FontSize('larger');
    this.initial = new FontSize('initial');
    this.inherit = new FontSize('inherit');
  }
  FontSize$Companion.prototype.px_za3lpa$ = function (nr) {
    return new FontSize(nr.toString() + 'px');
  };
  FontSize$Companion.prototype.em_za3lpa$ = function (nr) {
    return new FontSize(nr.toString() + 'em');
  };
  FontSize$Companion.prototype.em_14dthe$ = function (nr) {
    return new FontSize(nr.toString() + 'em');
  };
  FontSize$Companion.prototype.perc_za3lpa$ = function (nr) {
    return new FontSize(nr.toString() + '%');
  };
  FontSize$Companion.prototype.perc_14dthe$ = function (nr) {
    return new FontSize(nr.toString() + '%');
  };
  FontSize$Companion.prototype.pc_za3lpa$ = function (nr) {
    return new FontSize(nr.toString() + 'pc');
  };
  FontSize$Companion.prototype.pc_14dthe$ = function (nr) {
    return new FontSize(nr.toString() + 'pc');
  };
  FontSize$Companion.prototype.cm_za3lpa$ = function (nr) {
    return new FontSize(nr.toString() + 'cm');
  };
  FontSize$Companion.prototype.cm_14dthe$ = function (nr) {
    return new FontSize(nr.toString() + 'cm');
  };
  FontSize$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontSize$Companion_instance = null;
  function FontSize$Companion_getInstance() {
    if (FontSize$Companion_instance === null) {
      new FontSize$Companion();
    }return FontSize$Companion_instance;
  }
  FontSize.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontSize',
    interfaces: [CssProperty]
  };
  function FontStretch(value) {
    FontStretch$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontStretch$Companion() {
    FontStretch$Companion_instance = this;
    this.normal = new FontStretch('normal');
    this.condensed = new FontStretch('condensed');
    this.ultraCondensed = new FontStretch('ultra-condensed');
    this.extraCondensed = new FontStretch('extra-condensed');
    this.semiCondensed = new FontStretch('semi-condensed');
    this.expanded = new FontStretch('expanded');
    this.semiExpanded = new FontStretch('semi-expanded');
    this.extraExpanded = new FontStretch('extra-expanded');
    this.ultraExpanded = new FontStretch('ultra-expanded');
    this.initial = new FontWeight('initial');
    this.inherit = new FontWeight('inherit');
  }
  FontStretch$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontStretch$Companion_instance = null;
  function FontStretch$Companion_getInstance() {
    if (FontStretch$Companion_instance === null) {
      new FontStretch$Companion();
    }return FontStretch$Companion_instance;
  }
  FontStretch.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontStretch',
    interfaces: [CssProperty]
  };
  function FontStyle(value) {
    FontStyle$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontStyle$Companion() {
    FontStyle$Companion_instance = this;
    this.normal = new FontStyle('normal');
    this.italic = new FontStyle('italic');
    this.oblique = new FontStyle('oblique');
    this.initial = new FontStyle('initial');
    this.inherit = new FontStyle('inherit');
  }
  FontStyle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontStyle$Companion_instance = null;
  function FontStyle$Companion_getInstance() {
    if (FontStyle$Companion_instance === null) {
      new FontStyle$Companion();
    }return FontStyle$Companion_instance;
  }
  FontStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontStyle',
    interfaces: [CssProperty]
  };
  function FontWeight(value) {
    FontWeight$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontWeight$Companion() {
    FontWeight$Companion_instance = this;
    this.normal = new FontWeight('normal');
    this.bold = new FontWeight('bold');
    this._100 = new FontWeight('100');
    this._200 = new FontWeight('200');
    this._300 = new FontWeight('300');
    this._400 = new FontWeight('400');
    this._500 = new FontWeight('500');
    this._600 = new FontWeight('600');
    this._700 = new FontWeight('700');
    this._800 = new FontWeight('800');
    this._900 = new FontWeight('900');
    this.initial = new FontWeight('initial');
    this.inherit = new FontWeight('inherit');
  }
  FontWeight$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontWeight$Companion_instance = null;
  function FontWeight$Companion_getInstance() {
    if (FontWeight$Companion_instance === null) {
      new FontWeight$Companion();
    }return FontWeight$Companion_instance;
  }
  FontWeight.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontWeight',
    interfaces: [CssProperty]
  };
  function FontKerning(value) {
    FontKerning$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontKerning$Companion() {
    FontKerning$Companion_instance = this;
    this.auto = new FontKerning('auto');
    this.normal = new FontKerning('normal');
    this.none = new FontKerning('none');
  }
  FontKerning$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontKerning$Companion_instance = null;
  function FontKerning$Companion_getInstance() {
    if (FontKerning$Companion_instance === null) {
      new FontKerning$Companion();
    }return FontKerning$Companion_instance;
  }
  FontKerning.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontKerning',
    interfaces: [CssProperty]
  };
  function FontSizeAdjust(value) {
    FontSizeAdjust$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontSizeAdjust$Companion() {
    FontSizeAdjust$Companion_instance = this;
    this.none = new FontSizeAdjust('none');
    this.initial = new FontSizeAdjust('initial');
    this.inherit = new FontSizeAdjust('inherit');
  }
  FontSizeAdjust$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontSizeAdjust$Companion_instance = null;
  function FontSizeAdjust$Companion_getInstance() {
    if (FontSizeAdjust$Companion_instance === null) {
      new FontSizeAdjust$Companion();
    }return FontSizeAdjust$Companion_instance;
  }
  FontSizeAdjust.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontSizeAdjust',
    interfaces: [CssProperty]
  };
  function FontVariant(value) {
    FontVariant$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontVariant$Companion() {
    FontVariant$Companion_instance = this;
    this.normal = new FontVariant('normal');
    this.smallCaps = new FontVariant('small-caps');
    this.initial = new FontVariant('initial');
    this.inherit = new FontVariant('inherit');
  }
  FontVariant$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontVariant$Companion_instance = null;
  function FontVariant$Companion_getInstance() {
    if (FontVariant$Companion_instance === null) {
      new FontVariant$Companion();
    }return FontVariant$Companion_instance;
  }
  FontVariant.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontVariant',
    interfaces: [CssProperty]
  };
  function FontVariantCaps(value) {
    FontVariantCaps$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function FontVariantCaps$Companion() {
    FontVariantCaps$Companion_instance = this;
    this.normal = new FontVariantCaps('normal');
    this.smallCaps = new FontVariantCaps('small-caps');
    this.allSmallCaps = new FontVariantCaps('all-small-caps');
    this.petiteCaps = new FontVariantCaps('petite-caps');
    this.allPetiteCaps = new FontVariantCaps('all-petite-caps');
    this.unicase = new FontVariantCaps('unicase');
    this.initial = new FontVariantCaps('initial');
    this.inherit = new FontVariantCaps('inherit');
    this.unset = new FontVariantCaps('unset');
  }
  FontVariantCaps$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FontVariantCaps$Companion_instance = null;
  function FontVariantCaps$Companion_getInstance() {
    if (FontVariantCaps$Companion_instance === null) {
      new FontVariantCaps$Companion();
    }return FontVariantCaps$Companion_instance;
  }
  FontVariantCaps.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontVariantCaps',
    interfaces: [CssProperty]
  };
  function Grid(value) {
    Grid$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Grid$Companion() {
    Grid$Companion_instance = this;
    this.none = new Grid('none');
    this.initial = new Grid('initial');
    this.inherit = new Grid('inherit');
  }
  Grid$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Grid$Companion_instance = null;
  function Grid$Companion_getInstance() {
    if (Grid$Companion_instance === null) {
      new Grid$Companion();
    }return Grid$Companion_instance;
  }
  Grid.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Grid',
    interfaces: [CssProperty]
  };
  function GridAuto(value) {
    GridAuto$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function GridAuto$Companion() {
    GridAuto$Companion_instance = this;
    this.auto = new GridAuto('auto');
    this.maxContent = new GridAuto('max-content');
    this.minContent = new GridAuto('min-content');
  }
  GridAuto$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GridAuto$Companion_instance = null;
  function GridAuto$Companion_getInstance() {
    if (GridAuto$Companion_instance === null) {
      new GridAuto$Companion();
    }return GridAuto$Companion_instance;
  }
  GridAuto.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GridAuto',
    interfaces: [CssProperty]
  };
  function GridFlow(value) {
    GridFlow$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function GridFlow$Companion() {
    GridFlow$Companion_instance = this;
    this.row = new GridFlow('row');
    this.column = new GridFlow('column');
    this.dense = new GridFlow('dense');
    this.rowDense = new GridFlow('row dense');
    this.columnDense = new GridFlow('column dense');
  }
  GridFlow$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GridFlow$Companion_instance = null;
  function GridFlow$Companion_getInstance() {
    if (GridFlow$Companion_instance === null) {
      new GridFlow$Companion();
    }return GridFlow$Companion_instance;
  }
  GridFlow.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GridFlow',
    interfaces: [CssProperty]
  };
  function GridValue(value) {
    GridValue$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function GridValue$Companion() {
    GridValue$Companion_instance = this;
    this.auto = new GridValue('auto');
  }
  GridValue$Companion.prototype.span_za3lpa$ = function (column) {
    return new GridValue('span ' + column);
  };
  GridValue$Companion.prototype.column_za3lpa$ = function (line) {
    return new GridValue(line.toString());
  };
  GridValue$Companion.prototype.row_za3lpa$ = function (line) {
    return new GridValue(line.toString());
  };
  GridValue$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GridValue$Companion_instance = null;
  function GridValue$Companion_getInstance() {
    if (GridValue$Companion_instance === null) {
      new GridValue$Companion();
    }return GridValue$Companion_instance;
  }
  GridValue.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GridValue',
    interfaces: [CssProperty]
  };
  function TemplateRowColumn(value) {
    TemplateRowColumn$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TemplateRowColumn$Companion() {
    TemplateRowColumn$Companion_instance = this;
    this.none = new GridValue('none');
    this.auto = new GridValue('auto');
    this.maxContent = new GridValue('max-content');
    this.minContent = new GridValue('min-content');
    this.initial = new GridValue('initial');
    this.inherit = new GridValue('inherit');
  }
  TemplateRowColumn$Companion.prototype.length_l5dsl4$ = function (length) {
    return new GridValue(length.value);
  };
  TemplateRowColumn$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TemplateRowColumn$Companion_instance = null;
  function TemplateRowColumn$Companion_getInstance() {
    if (TemplateRowColumn$Companion_instance === null) {
      new TemplateRowColumn$Companion();
    }return TemplateRowColumn$Companion_instance;
  }
  TemplateRowColumn.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TemplateRowColumn',
    interfaces: [CssProperty]
  };
  function Hyphens(value) {
    Hyphens$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Hyphens$Companion() {
    Hyphens$Companion_instance = this;
    this.none = new Hyphens('none');
    this.manual = new Hyphens('manual');
    this.auto = new Hyphens('auto');
    this.initial = new Hyphens('initial');
    this.inherit = new Hyphens('inherit');
  }
  Hyphens$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Hyphens$Companion_instance = null;
  function Hyphens$Companion_getInstance() {
    if (Hyphens$Companion_instance === null) {
      new Hyphens$Companion();
    }return Hyphens$Companion_instance;
  }
  Hyphens.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Hyphens',
    interfaces: [CssProperty]
  };
  function Image(value) {
    Image$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Image$Companion() {
    Image$Companion_instance = this;
    this.none = new Image('none');
    this.initial = new Image('initial');
    this.inherit = new Image('inherit');
  }
  Image$Companion.prototype.url_61zpoe$ = function (url) {
    return new Image('url(' + url + ')');
  };
  Image$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Image$Companion_instance = null;
  function Image$Companion_getInstance() {
    if (Image$Companion_instance === null) {
      new Image$Companion();
    }return Image$Companion_instance;
  }
  Image.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Image',
    interfaces: [CssProperty]
  };
  function ImageRepeat(value) {
    ImageRepeat$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ImageRepeat$Companion() {
    ImageRepeat$Companion_instance = this;
    this.repeat = new ImageRepeat('repeat');
    this.round = new ImageRepeat('round');
    this.initial = new ImageRepeat('initial');
    this.inherit = new ImageRepeat('inherit');
  }
  ImageRepeat$Companion.prototype.stretch_61zpoe$ = function (url) {
    return new ImageRepeat('stretch');
  };
  ImageRepeat$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ImageRepeat$Companion_instance = null;
  function ImageRepeat$Companion_getInstance() {
    if (ImageRepeat$Companion_instance === null) {
      new ImageRepeat$Companion();
    }return ImageRepeat$Companion_instance;
  }
  ImageRepeat.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ImageRepeat',
    interfaces: [CssProperty]
  };
  function ImageSlice(value) {
    ImageSlice$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ImageSlice$Companion() {
    ImageSlice$Companion_instance = this;
    this.repeat = new ImageSlice('repeat');
    this.fill = new ImageSlice('fill');
    this.initial = new ImageSlice('initial');
    this.inherit = new ImageSlice('inherit');
  }
  ImageSlice$Companion.prototype.nr_za3lpa$ = function (nr) {
    return new ImageSlice(nr.toString());
  };
  ImageSlice$Companion.prototype.perc_za3lpa$ = function (perc) {
    return new ImageSlice(perc.toString() + '%');
  };
  ImageSlice$Companion.prototype.perc_14dthe$ = function (perc) {
    return new ImageSlice(perc.toString() + '%');
  };
  ImageSlice$Companion.prototype.stretch_61zpoe$ = function (url) {
    return new ImageSlice('stretch');
  };
  ImageSlice$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ImageSlice$Companion_instance = null;
  function ImageSlice$Companion_getInstance() {
    if (ImageSlice$Companion_instance === null) {
      new ImageSlice$Companion();
    }return ImageSlice$Companion_instance;
  }
  ImageSlice.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ImageSlice',
    interfaces: [CssProperty]
  };
  function ImageSource(value) {
    ImageSource$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ImageSource$Companion() {
    ImageSource$Companion_instance = this;
    this.none = new ImageSource('none');
    this.initial = new ImageSource('initial');
    this.inherit = new ImageSource('inherit');
  }
  ImageSource$Companion.prototype.text_61zpoe$ = function (txt) {
    return new ImageSource(txt);
  };
  ImageSource$Companion.prototype.image_61zpoe$ = function (url) {
    return new ImageSource("'" + url + "'");
  };
  ImageSource$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ImageSource$Companion_instance = null;
  function ImageSource$Companion_getInstance() {
    if (ImageSource$Companion_instance === null) {
      new ImageSource$Companion();
    }return ImageSource$Companion_instance;
  }
  ImageSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ImageSource',
    interfaces: [CssProperty]
  };
  function InitialInherit(value) {
    InitialInherit$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function InitialInherit$Companion() {
    InitialInherit$Companion_instance = this;
    this.initial = new InitialInherit('initial');
    this.inherit = new InitialInherit('inherit');
  }
  InitialInherit$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InitialInherit$Companion_instance = null;
  function InitialInherit$Companion_getInstance() {
    if (InitialInherit$Companion_instance === null) {
      new InitialInherit$Companion();
    }return InitialInherit$Companion_instance;
  }
  InitialInherit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InitialInherit',
    interfaces: [CssProperty]
  };
  function Isolation(value) {
    Isolation$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Isolation$Companion() {
    Isolation$Companion_instance = this;
    this.auto = new Isolation('auto');
    this.isolate = new Isolation('isolate');
    this.initial = new Isolation('initial');
    this.inherit = new Isolation('inherit');
  }
  Isolation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Isolation$Companion_instance = null;
  function Isolation$Companion_getInstance() {
    if (Isolation$Companion_instance === null) {
      new Isolation$Companion();
    }return Isolation$Companion_instance;
  }
  Isolation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Isolation',
    interfaces: [CssProperty]
  };
  function JustifyContent(value) {
    JustifyContent$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function JustifyContent$Companion() {
    JustifyContent$Companion_instance = this;
    this.flexStart = new JustifyContent('flex-start');
    this.flexEnd = new JustifyContent('flex-end');
    this.center = new JustifyContent('center');
    this.spaceBetween = new JustifyContent('space-between');
    this.spaceAround = new JustifyContent('space-around');
    this.initial = new JustifyContent('initial');
    this.inherit = new JustifyContent('inherit');
  }
  JustifyContent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var JustifyContent$Companion_instance = null;
  function JustifyContent$Companion_getInstance() {
    if (JustifyContent$Companion_instance === null) {
      new JustifyContent$Companion();
    }return JustifyContent$Companion_instance;
  }
  JustifyContent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JustifyContent',
    interfaces: [CssProperty]
  };
  function LetterSpacing(value) {
    LetterSpacing$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function LetterSpacing$Companion() {
    LetterSpacing$Companion_instance = this;
    this.normal = new LetterSpacing('normal');
    this.initial = new LetterSpacing('initial');
    this.inherit = new LetterSpacing('inherit');
  }
  LetterSpacing$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var LetterSpacing$Companion_instance = null;
  function LetterSpacing$Companion_getInstance() {
    if (LetterSpacing$Companion_instance === null) {
      new LetterSpacing$Companion();
    }return LetterSpacing$Companion_instance;
  }
  LetterSpacing.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LetterSpacing',
    interfaces: [CssProperty]
  };
  function ListStylePosition(value) {
    ListStylePosition$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ListStylePosition$Companion() {
    ListStylePosition$Companion_instance = this;
    this.inside = new ListStylePosition('inside');
    this.outside = new ListStylePosition('outside');
    this.initial = new ListStylePosition('initial');
    this.inherit = new ListStylePosition('inherit');
  }
  ListStylePosition$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ListStylePosition$Companion_instance = null;
  function ListStylePosition$Companion_getInstance() {
    if (ListStylePosition$Companion_instance === null) {
      new ListStylePosition$Companion();
    }return ListStylePosition$Companion_instance;
  }
  ListStylePosition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ListStylePosition',
    interfaces: [CssProperty]
  };
  function ListStyleType(value) {
    ListStyleType$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ListStyleType$Companion() {
    ListStyleType$Companion_instance = this;
    this.disc = new ListStyleType('disc');
    this.armenian = new ListStyleType('armenian');
    this.circle = new ListStyleType('circle');
    this.cjkIdeographic = new ListStyleType('cjk-ideographic');
    this.decimal = new ListStyleType('decimal');
    this.decimalLeadingZero = new ListStyleType('decimal-leading-zero');
    this.georgian = new ListStyleType('georgian');
    this.hebrew = new ListStyleType('hebrew');
    this.hiragana = new ListStyleType('hiragana');
    this.hiraganaIroha = new ListStyleType('hiragana-iroha');
    this.katakana = new ListStyleType('katakana');
    this.katakanaIroha = new ListStyleType('katakana-iroha');
    this.lowerAlpha = new ListStyleType('lower-alpha');
    this.lowerGreek = new ListStyleType('lower-greek');
    this.lowerLatin = new ListStyleType('lower-latin');
    this.lowerRoman = new ListStyleType('lower-roman');
    this.none = new ListStyleType('none');
    this.square = new ListStyleType('square');
    this.upperAlpha = new ListStyleType('upper-alpha');
    this.upperGreek = new ListStyleType('upper-greek');
    this.upperLatin = new ListStyleType('upper-latin');
    this.upperRoman = new ListStyleType('upper-roman');
    this.initial = new ListStyleType('initial');
    this.inherit = new ListStyleType('inherit');
  }
  ListStyleType$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ListStyleType$Companion_instance = null;
  function ListStyleType$Companion_getInstance() {
    if (ListStyleType$Companion_instance === null) {
      new ListStyleType$Companion();
    }return ListStyleType$Companion_instance;
  }
  ListStyleType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ListStyleType',
    interfaces: [CssProperty]
  };
  function MeasurementUoM(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function MeasurementUoM_initFields() {
    MeasurementUoM_initFields = function () {
    };
    MeasurementUoM$NONE_instance = new MeasurementUoM('NONE', 0);
    MeasurementUoM$PX_instance = new MeasurementUoM('PX', 1);
    MeasurementUoM$EM_instance = new MeasurementUoM('EM', 2);
    MeasurementUoM$REL_instance = new MeasurementUoM('REL', 3);
    MeasurementUoM$REM_instance = new MeasurementUoM('REM', 4);
    MeasurementUoM$PC_instance = new MeasurementUoM('PC', 5);
    MeasurementUoM$PRC_instance = new MeasurementUoM('PRC', 6);
    MeasurementUoM$CM_instance = new MeasurementUoM('CM', 7);
    MeasurementUoM$FR_instance = new MeasurementUoM('FR', 8);
  }
  var MeasurementUoM$NONE_instance;
  function MeasurementUoM$NONE_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$NONE_instance;
  }
  var MeasurementUoM$PX_instance;
  function MeasurementUoM$PX_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$PX_instance;
  }
  var MeasurementUoM$EM_instance;
  function MeasurementUoM$EM_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$EM_instance;
  }
  var MeasurementUoM$REL_instance;
  function MeasurementUoM$REL_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$REL_instance;
  }
  var MeasurementUoM$REM_instance;
  function MeasurementUoM$REM_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$REM_instance;
  }
  var MeasurementUoM$PC_instance;
  function MeasurementUoM$PC_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$PC_instance;
  }
  var MeasurementUoM$PRC_instance;
  function MeasurementUoM$PRC_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$PRC_instance;
  }
  var MeasurementUoM$CM_instance;
  function MeasurementUoM$CM_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$CM_instance;
  }
  var MeasurementUoM$FR_instance;
  function MeasurementUoM$FR_getInstance() {
    MeasurementUoM_initFields();
    return MeasurementUoM$FR_instance;
  }
  MeasurementUoM.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MeasurementUoM',
    interfaces: [Enum]
  };
  function MeasurementUoM$values() {
    return [MeasurementUoM$NONE_getInstance(), MeasurementUoM$PX_getInstance(), MeasurementUoM$EM_getInstance(), MeasurementUoM$REL_getInstance(), MeasurementUoM$REM_getInstance(), MeasurementUoM$PC_getInstance(), MeasurementUoM$PRC_getInstance(), MeasurementUoM$CM_getInstance(), MeasurementUoM$FR_getInstance()];
  }
  MeasurementUoM.values = MeasurementUoM$values;
  function MeasurementUoM$valueOf(name) {
    switch (name) {
      case 'NONE':
        return MeasurementUoM$NONE_getInstance();
      case 'PX':
        return MeasurementUoM$PX_getInstance();
      case 'EM':
        return MeasurementUoM$EM_getInstance();
      case 'REL':
        return MeasurementUoM$REL_getInstance();
      case 'REM':
        return MeasurementUoM$REM_getInstance();
      case 'PC':
        return MeasurementUoM$PC_getInstance();
      case 'PRC':
        return MeasurementUoM$PRC_getInstance();
      case 'CM':
        return MeasurementUoM$CM_getInstance();
      case 'FR':
        return MeasurementUoM$FR_getInstance();
      default:throwISE('No enum constant nl.astraeus.css.properties.MeasurementUoM.' + name);
    }
  }
  MeasurementUoM.valueOf_61zpoe$ = MeasurementUoM$valueOf;
  function Measurement(value, uom) {
    Measurement$Companion_getInstance();
    if (uom === void 0)
      uom = MeasurementUoM$NONE_getInstance();
    CssProperty.call(this, value);
    this.uom = uom;
  }
  Measurement.prototype.toString = function () {
    return Kotlin.callGetter(this, CssProperty.prototype, 'value');
  };
  function Measurement$Companion() {
    Measurement$Companion_instance = this;
    this.auto = new Measurement('auto');
    this.initial = new Measurement('initial');
    this.inherit = new Measurement('inherit');
    this.normal = new Measurement('normal');
  }
  Measurement$Companion.prototype.fromString_61zpoe$ = function (value) {
    if (equals(value, '0'))
      return new Measurement('0', MeasurementUoM$PX_getInstance());
    else if (endsWith(value, 'px'))
      return new Measurement(slice(value, new IntRange(0, value.length - 2 | 0)), MeasurementUoM$PX_getInstance());
    else if (endsWith(value, 'rel'))
      return new Measurement(slice(value, new IntRange(0, value.length - 3 | 0)), MeasurementUoM$REL_getInstance());
    else {
      throw new NotImplementedError_init('An operation is not implemented: ' + ('Unable to parse ' + value));
    }
  };
  Measurement$Companion.prototype.px_za3lpa$ = function (nr) {
    if (nr === 0) {
      return new Measurement('0', MeasurementUoM$PX_getInstance());
    } else {
      return new Measurement(nr.toString() + 'px', MeasurementUoM$PX_getInstance());
    }
  };
  Measurement$Companion.prototype.px_14dthe$ = function (nr) {
    return get_px_0(nr);
  };
  Measurement$Companion.prototype.em_za3lpa$ = function (nr) {
    return get_em(nr);
  };
  Measurement$Companion.prototype.em_14dthe$ = function (nr) {
    return get_em_0(nr);
  };
  Measurement$Companion.prototype.prc_za3lpa$ = function (nr) {
    return get_prc(nr);
  };
  Measurement$Companion.prototype.prc_14dthe$ = function (nr) {
    return get_prc_0(nr);
  };
  Measurement$Companion.prototype.pc_za3lpa$ = function (nr) {
    return get_pc(nr);
  };
  Measurement$Companion.prototype.pc_14dthe$ = function (nr) {
    return get_pc_0(nr);
  };
  Measurement$Companion.prototype.cm_za3lpa$ = function (nr) {
    return get_cm(nr);
  };
  Measurement$Companion.prototype.cm_14dthe$ = function (nr) {
    return get_cm_0(nr);
  };
  Measurement$Companion.prototype.fr_za3lpa$ = function (nr) {
    return get_fr(nr);
  };
  Measurement$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Measurement$Companion_instance = null;
  function Measurement$Companion_getInstance() {
    if (Measurement$Companion_instance === null) {
      new Measurement$Companion();
    }return Measurement$Companion_instance;
  }
  Measurement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Measurement',
    interfaces: [CssProperty]
  };
  function get_px($receiver) {
    var tmp$;
    if ($receiver === 0) {
      tmp$ = '';
    } else {
      tmp$ = 'px';
    }
    return new Measurement($receiver.toString() + tmp$, MeasurementUoM$PX_getInstance());
  }
  function get_em($receiver) {
    var tmp$;
    if ($receiver === 0) {
      tmp$ = '';
    } else {
      tmp$ = 'em';
    }
    return new Measurement($receiver.toString() + tmp$, MeasurementUoM$EM_getInstance());
  }
  function get_rem($receiver) {
    var tmp$;
    if ($receiver === 0) {
      tmp$ = '';
    } else {
      tmp$ = 'rem';
    }
    return new Measurement($receiver.toString() + tmp$, MeasurementUoM$REM_getInstance());
  }
  function get_prc($receiver) {
    return new Measurement($receiver.toString() + '%', MeasurementUoM$PRC_getInstance());
  }
  function get_pc($receiver) {
    return new Measurement($receiver.toString() + 'pc', MeasurementUoM$PC_getInstance());
  }
  function get_cm($receiver) {
    return new Measurement($receiver.toString() + 'cm', MeasurementUoM$CM_getInstance());
  }
  function get_fr($receiver) {
    return new Measurement($receiver.toString() + 'fr', MeasurementUoM$FR_getInstance());
  }
  function px($receiver) {
    return Measurement$Companion_getInstance().px_za3lpa$($receiver);
  }
  function get_px_0($receiver) {
    return new Measurement($receiver.toString() + 'px', MeasurementUoM$PX_getInstance());
  }
  function get_em_0($receiver) {
    return new Measurement($receiver.toString() + 'em', MeasurementUoM$EM_getInstance());
  }
  function get_rem_0($receiver) {
    return new Measurement($receiver.toString() + 'rem', MeasurementUoM$REM_getInstance());
  }
  function get_prc_0($receiver) {
    return new Measurement($receiver.toString() + '%', MeasurementUoM$PRC_getInstance());
  }
  function get_pc_0($receiver) {
    return new Measurement($receiver.toString() + 'pc', MeasurementUoM$PC_getInstance());
  }
  function get_cm_0($receiver) {
    return new Measurement($receiver.toString() + 'cm', MeasurementUoM$CM_getInstance());
  }
  function px_0($receiver) {
    return Measurement$Companion_getInstance().px_14dthe$($receiver);
  }
  function LineHeight(value) {
    LineHeight$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function LineHeight$Companion() {
    LineHeight$Companion_instance = this;
    this.normal = new LineHeight('normal');
    this.initial = new LineHeight('initial');
    this.inherit = new LineHeight('inherit');
  }
  LineHeight$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var LineHeight$Companion_instance = null;
  function LineHeight$Companion_getInstance() {
    if (LineHeight$Companion_instance === null) {
      new LineHeight$Companion();
    }return LineHeight$Companion_instance;
  }
  LineHeight.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineHeight',
    interfaces: [CssProperty]
  };
  function MixBlendMode(value) {
    MixBlendMode$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function MixBlendMode$Companion() {
    MixBlendMode$Companion_instance = this;
    this.normal = new MixBlendMode('normal');
    this.multiply = new MixBlendMode('multiply');
    this.screen = new MixBlendMode('screen');
    this.overlay = new MixBlendMode('overlay');
    this.darken = new MixBlendMode('darken');
    this.lighten = new MixBlendMode('lighten');
    this.colorDodge = new MixBlendMode('color-dodge');
    this.colorBurn = new MixBlendMode('color-burn');
    this.difference = new MixBlendMode('difference');
    this.exclusion = new MixBlendMode('exclusion');
    this.hue = new MixBlendMode('hue');
    this.saturation = new MixBlendMode('saturation');
    this.color = new MixBlendMode('color');
    this.luminosity = new MixBlendMode('luminosity');
  }
  MixBlendMode$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var MixBlendMode$Companion_instance = null;
  function MixBlendMode$Companion_getInstance() {
    if (MixBlendMode$Companion_instance === null) {
      new MixBlendMode$Companion();
    }return MixBlendMode$Companion_instance;
  }
  MixBlendMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MixBlendMode',
    interfaces: [CssProperty]
  };
  function ObjectFit(value) {
    ObjectFit$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ObjectFit$Companion() {
    ObjectFit$Companion_instance = this;
    this.fill = new ObjectFit('fill');
    this.contain = new ObjectFit('contain');
    this.cover = new ObjectFit('cover');
    this.scaleDown = new ObjectFit('scale-down');
    this.none = new ObjectFit('none');
    this.initial = new ObjectFit('initial');
    this.inherit = new ObjectFit('inherit');
  }
  ObjectFit$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ObjectFit$Companion_instance = null;
  function ObjectFit$Companion_getInstance() {
    if (ObjectFit$Companion_instance === null) {
      new ObjectFit$Companion();
    }return ObjectFit$Companion_instance;
  }
  ObjectFit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ObjectFit',
    interfaces: [CssProperty]
  };
  function OutlineWidth(value) {
    OutlineWidth$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function OutlineWidth$Companion() {
    OutlineWidth$Companion_instance = this;
    this.thin = new OutlineWidth('thin');
    this.medium = new OutlineWidth('medium');
    this.thick = new OutlineWidth('thick');
    this.initial = new BorderWidth('initial');
    this.inherit = new BorderWidth('inherit');
  }
  OutlineWidth$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OutlineWidth$Companion_instance = null;
  function OutlineWidth$Companion_getInstance() {
    if (OutlineWidth$Companion_instance === null) {
      new OutlineWidth$Companion();
    }return OutlineWidth$Companion_instance;
  }
  OutlineWidth.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OutlineWidth',
    interfaces: [CssProperty]
  };
  function Overflow(value) {
    Overflow$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Overflow$Companion() {
    Overflow$Companion_instance = this;
    this.visible = new Overflow('visible');
    this.hidden = new Overflow('hidden');
    this.scroll = new Overflow('scroll');
    this.auto = new Overflow('auto');
    this.initial = new BorderWidth('initial');
    this.inherit = new BorderWidth('inherit');
  }
  Overflow$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Overflow$Companion_instance = null;
  function Overflow$Companion_getInstance() {
    if (Overflow$Companion_instance === null) {
      new Overflow$Companion();
    }return Overflow$Companion_instance;
  }
  Overflow.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Overflow',
    interfaces: [CssProperty]
  };
  function PageBreak(value) {
    PageBreak$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function PageBreak$Companion() {
    PageBreak$Companion_instance = this;
    this.auto = new PageBreak('auto');
    this.always = new PageBreak('always');
    this.avoid = new PageBreak('avoid');
    this.left = new PageBreak('left');
    this.right = new PageBreak('right');
    this.initial = new PageBreak('initial');
    this.inherit = new PageBreak('inherit');
  }
  PageBreak$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PageBreak$Companion_instance = null;
  function PageBreak$Companion_getInstance() {
    if (PageBreak$Companion_instance === null) {
      new PageBreak$Companion();
    }return PageBreak$Companion_instance;
  }
  PageBreak.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PageBreak',
    interfaces: [CssProperty]
  };
  function Perspective(value) {
    Perspective$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Perspective$Companion() {
    Perspective$Companion_instance = this;
    this.none = new Perspective('none');
    this.initial = new Perspective('initial');
    this.inherit = new Perspective('inherit');
  }
  Perspective$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Perspective$Companion_instance = null;
  function Perspective$Companion_getInstance() {
    if (Perspective$Companion_instance === null) {
      new Perspective$Companion();
    }return Perspective$Companion_instance;
  }
  Perspective.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Perspective',
    interfaces: [CssProperty]
  };
  function PointerEvents(value) {
    PointerEvents$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function PointerEvents$Companion() {
    PointerEvents$Companion_instance = this;
    this.auto = new PointerEvents('auto');
    this.none = new PointerEvents('none');
    this.initial = new PointerEvents('initial');
    this.inherit = new PointerEvents('inherit');
  }
  PointerEvents$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PointerEvents$Companion_instance = null;
  function PointerEvents$Companion_getInstance() {
    if (PointerEvents$Companion_instance === null) {
      new PointerEvents$Companion();
    }return PointerEvents$Companion_instance;
  }
  PointerEvents.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PointerEvents',
    interfaces: [CssProperty]
  };
  function Position(value) {
    Position$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Position$Companion() {
    Position$Companion_instance = this;
    this.static = new Position('static');
    this.absolute = new Position('absolute');
    this.fixed = new Position('fixed');
    this.relative = new Position('relative');
    this.sticky = new Position('sticky');
    this.initial = new Position('initial');
    this.inherit = new Position('inherit');
  }
  Position$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Position$Companion_instance = null;
  function Position$Companion_getInstance() {
    if (Position$Companion_instance === null) {
      new Position$Companion();
    }return Position$Companion_instance;
  }
  Position.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Position',
    interfaces: [CssProperty]
  };
  function HangingPunctuation(value) {
    HangingPunctuation$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function HangingPunctuation$Companion() {
    HangingPunctuation$Companion_instance = this;
    this.none = new HangingPunctuation('none');
    this.first = new HangingPunctuation('first');
    this.last = new HangingPunctuation('last');
    this.allowEnd = new HangingPunctuation('allow-end');
    this.forceEnd = new HangingPunctuation('force-end');
    this.initial = new HangingPunctuation('initial');
    this.inherit = new HangingPunctuation('inherit');
  }
  HangingPunctuation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var HangingPunctuation$Companion_instance = null;
  function HangingPunctuation$Companion_getInstance() {
    if (HangingPunctuation$Companion_instance === null) {
      new HangingPunctuation$Companion();
    }return HangingPunctuation$Companion_instance;
  }
  HangingPunctuation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HangingPunctuation',
    interfaces: [CssProperty]
  };
  function Resize(value) {
    Resize$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Resize$Companion() {
    Resize$Companion_instance = this;
    this.none = new Resize('none');
    this.both = new Resize('both');
    this.horizontal = new Resize('horizontal');
    this.vertical = new Resize('vertical');
    this.initial = new Resize('initial');
    this.inherit = new Resize('inherit');
  }
  Resize$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Resize$Companion_instance = null;
  function Resize$Companion_getInstance() {
    if (Resize$Companion_instance === null) {
      new Resize$Companion();
    }return Resize$Companion_instance;
  }
  Resize.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Resize',
    interfaces: [CssProperty]
  };
  function ScrollBehavior(value) {
    ScrollBehavior$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ScrollBehavior$Companion() {
    ScrollBehavior$Companion_instance = this;
    this.auto = new ScrollBehavior('auto');
    this.smooth = new ScrollBehavior('smooth');
    this.initial = new ScrollBehavior('initial');
    this.inherit = new ScrollBehavior('inherit');
  }
  ScrollBehavior$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ScrollBehavior$Companion_instance = null;
  function ScrollBehavior$Companion_getInstance() {
    if (ScrollBehavior$Companion_instance === null) {
      new ScrollBehavior$Companion();
    }return ScrollBehavior$Companion_instance;
  }
  ScrollBehavior.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ScrollBehavior',
    interfaces: [CssProperty]
  };
  function Span(value) {
    Span$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Span$Companion() {
    Span$Companion_instance = this;
    this.none = new Clip('none');
    this.all = new Clip('all');
    this.initial = new Clip('initial');
    this.inherit = new Clip('inherit');
  }
  Span$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Span$Companion_instance = null;
  function Span$Companion_getInstance() {
    if (Span$Companion_instance === null) {
      new Span$Companion();
    }return Span$Companion_instance;
  }
  Span.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Span',
    interfaces: [CssProperty]
  };
  function TableLayout(value) {
    TableLayout$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TableLayout$Companion() {
    TableLayout$Companion_instance = this;
    this.auto = new TableLayout('auto');
    this.fixed = new TableLayout('fixed');
    this.initial = new TableLayout('initial');
    this.inherit = new TableLayout('auto');
  }
  TableLayout$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TableLayout$Companion_instance = null;
  function TableLayout$Companion_getInstance() {
    if (TableLayout$Companion_instance === null) {
      new TableLayout$Companion();
    }return TableLayout$Companion_instance;
  }
  TableLayout.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TableLayout',
    interfaces: [CssProperty]
  };
  function TextAlign(value) {
    TextAlign$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TextAlign$Companion() {
    TextAlign$Companion_instance = this;
    this.left = new TextAlign('left');
    this.right = new TextAlign('right');
    this.center = new TextAlign('center');
    this.justify = new TextAlign('justify');
    this.initial = new TextAlign('initial');
    this.inherit = new TextAlign('inherit');
  }
  TextAlign$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextAlign$Companion_instance = null;
  function TextAlign$Companion_getInstance() {
    if (TextAlign$Companion_instance === null) {
      new TextAlign$Companion();
    }return TextAlign$Companion_instance;
  }
  TextAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextAlign',
    interfaces: [CssProperty]
  };
  function TextAlignLast(value) {
    TextAlignLast$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TextAlignLast$Companion() {
    TextAlignLast$Companion_instance = this;
    this.auto = new TextAlignLast('auto');
    this.left = new TextAlignLast('left');
    this.right = new TextAlignLast('right');
    this.center = new TextAlignLast('center');
    this.justify = new TextAlignLast('justify');
    this.start = new TextAlignLast('start');
    this.end = new TextAlignLast('end');
    this.initial = new TextAlignLast('initial');
    this.inherit = new TextAlignLast('inherit');
  }
  TextAlignLast$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextAlignLast$Companion_instance = null;
  function TextAlignLast$Companion_getInstance() {
    if (TextAlignLast$Companion_instance === null) {
      new TextAlignLast$Companion();
    }return TextAlignLast$Companion_instance;
  }
  TextAlignLast.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextAlignLast',
    interfaces: [CssProperty]
  };
  function TextDecorationLine(value) {
    TextDecorationLine$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TextDecorationLine$Companion() {
    TextDecorationLine$Companion_instance = this;
    this.none = new TextDecorationLine('none');
    this.underline = new TextDecorationLine('underline');
    this.overline = new TextDecorationLine('overline');
    this.lineThrough = new TextDecorationLine('line-through');
    this.initial = new TextDecorationLine('initial');
    this.inherit = new TextDecorationLine('inherit');
  }
  TextDecorationLine$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextDecorationLine$Companion_instance = null;
  function TextDecorationLine$Companion_getInstance() {
    if (TextDecorationLine$Companion_instance === null) {
      new TextDecorationLine$Companion();
    }return TextDecorationLine$Companion_instance;
  }
  TextDecorationLine.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextDecorationLine',
    interfaces: [CssProperty]
  };
  function TextDecorationStyle(value) {
    TextDecorationStyle$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TextDecorationStyle$Companion() {
    TextDecorationStyle$Companion_instance = this;
    this.solid = new TextDecorationStyle('solid');
    this.double = new TextDecorationStyle('double');
    this.dotted = new TextDecorationStyle('dotted');
    this.dashed = new TextDecorationStyle('dashed');
    this.wavy = new TextDecorationStyle('wavy');
    this.initial = new TextDecorationStyle('initial');
    this.inherit = new TextDecorationStyle('inherit');
  }
  TextDecorationStyle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextDecorationStyle$Companion_instance = null;
  function TextDecorationStyle$Companion_getInstance() {
    if (TextDecorationStyle$Companion_instance === null) {
      new TextDecorationStyle$Companion();
    }return TextDecorationStyle$Companion_instance;
  }
  TextDecorationStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextDecorationStyle',
    interfaces: [CssProperty]
  };
  function TextJustify(value) {
    TextJustify$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TextJustify$Companion() {
    TextJustify$Companion_instance = this;
    this.auto = new TextJustify('auto');
    this.interWord = new TextJustify('inter-word');
    this.interCharacter = new TextJustify('inter-character');
    this.none = new TextJustify('none');
    this.initial = new TextJustify('initial');
    this.inherit = new TextJustify('inherit');
  }
  TextJustify$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextJustify$Companion_instance = null;
  function TextJustify$Companion_getInstance() {
    if (TextJustify$Companion_instance === null) {
      new TextJustify$Companion();
    }return TextJustify$Companion_instance;
  }
  TextJustify.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextJustify',
    interfaces: [CssProperty]
  };
  function TextTransform(value) {
    TextTransform$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TextTransform$Companion() {
    TextTransform$Companion_instance = this;
    this.none = new TextTransform('none');
    this.capitalize = new TextTransform('capitalize');
    this.uppercase = new TextTransform('uppercase');
    this.lowercase = new TextTransform('lowercase');
    this.initial = new TextTransform('initial');
    this.inherit = new TextTransform('inherit');
  }
  TextTransform$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TextTransform$Companion_instance = null;
  function TextTransform$Companion_getInstance() {
    if (TextTransform$Companion_instance === null) {
      new TextTransform$Companion();
    }return TextTransform$Companion_instance;
  }
  TextTransform.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextTransform',
    interfaces: [CssProperty]
  };
  function TimingFunction(value) {
    TimingFunction$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TimingFunction$Companion() {
    TimingFunction$Companion_instance = this;
    this.linear = new TimingFunction('linear');
    this.ease = new TimingFunction('ease');
    this.easeIn = new TimingFunction('ease-in');
    this.easeOut = new TimingFunction('ease-out');
    this.easeInOut = new TimingFunction('ease-in-out');
    this.stepStart = new TimingFunction('step-start');
    this.stepEnd = new TimingFunction('step-end');
    this.initial = new TimingFunction('initial');
    this.inherit = new TimingFunction('inherit');
  }
  TimingFunction$Companion.prototype.steps_fzusl$ = function (steps, start) {
    var tmp$;
    if (start) {
      tmp$ = 'start';
    } else {
      tmp$ = 'end';
    }
    return new TimingFunction('steps(' + steps + ', ' + tmp$);
  };
  TimingFunction$Companion.prototype.cubicBezier_6y0v78$ = function (n1, n2, n3, n4) {
    return new TimingFunction('cubic-bezier(' + n1 + ', ' + n2 + ', ' + n3 + ', ' + n4 + ')');
  };
  TimingFunction$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TimingFunction$Companion_instance = null;
  function TimingFunction$Companion_getInstance() {
    if (TimingFunction$Companion_instance === null) {
      new TimingFunction$Companion();
    }return TimingFunction$Companion_instance;
  }
  TimingFunction.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TimingFunction',
    interfaces: [CssProperty]
  };
  function Transform(value) {
    Transform$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Transform$Companion() {
    Transform$Companion_instance = this;
    this.none = new Transform('none');
    this.initial = new Transform('initial');
    this.inherit = new Transform('inherit');
  }
  Transform$Companion.prototype.matrix_15yvbs$ = function (n1, n2, n3, n4, n5, n6) {
    return new Transform('matrix(' + n1 + ', ' + n2 + ', ' + n3 + ', ' + n4 + ', ' + n5 + ', ' + n6 + ')');
  };
  Transform$Companion.prototype.matrix3d_wnsr0s$ = function (n01, n02, n03, n04, n05, n06, n07, n08, n09, n10, n11, n12, n13, n14, n15, n16) {
    return new Transform('matrix3d(' + n01 + ', ' + n02 + ', ' + n03 + ', ' + n04 + ', ' + n05 + ', ' + n06 + ', ' + n07 + ', ' + n08 + ', ' + n09 + ', ' + n10 + ', ' + n11 + ', ' + n12 + ', ' + n13 + ', ' + n14 + ', ' + n15 + ', ' + n16 + ')');
  };
  Transform$Companion.prototype.translate_lu1900$ = function (x, y) {
    return new Transform('translate(' + x + ', ' + y + ')');
  };
  Transform$Companion.prototype.translate3d_yvo9jy$ = function (x, y, z) {
    return new Transform('translate3d(' + x + ', ' + y + ', ' + z + ')');
  };
  Transform$Companion.prototype.translateX_14dthe$ = function (x) {
    return new Transform('translateX(' + x + ')');
  };
  Transform$Companion.prototype.translateY_14dthe$ = function (y) {
    return new Transform('translateY(' + y + ')');
  };
  Transform$Companion.prototype.translateZ_14dthe$ = function (z) {
    return new Transform('translateZ(' + z + ')');
  };
  Transform$Companion.prototype.scale_lu1900$ = function (x, y) {
    return new Transform('scale(' + x + ', ' + y + ')');
  };
  Transform$Companion.prototype.scale3d_yvo9jy$ = function (x, y, z) {
    return new Transform('scale3d(' + x + ', ' + y + ', ' + z + ')');
  };
  Transform$Companion.prototype.scaleX_14dthe$ = function (x) {
    return new Transform('scaleX(' + x + ')');
  };
  Transform$Companion.prototype.scaleY_14dthe$ = function (y) {
    return new Transform('scaleY(' + y + ')');
  };
  Transform$Companion.prototype.scaleZ_14dthe$ = function (z) {
    return new Transform('scaleZ(' + z + ')');
  };
  Transform$Companion.prototype.rotate_14dthe$ = function (angle) {
    return new Transform('rotate(' + angle + ')');
  };
  Transform$Companion.prototype.rotate3d_6y0v78$ = function (x, y, z, angle) {
    return new Transform('scale3d(' + x + ', ' + y + ', ' + z + ', ' + angle);
  };
  Transform$Companion.prototype.rotateX_14dthe$ = function (x) {
    return new Transform('rotateX(' + x + ')');
  };
  Transform$Companion.prototype.rotateY_14dthe$ = function (y) {
    return new Transform('rotateY(' + y + ')');
  };
  Transform$Companion.prototype.rotateZ_14dthe$ = function (z) {
    return new Transform('rotateZ(' + z + ')');
  };
  Transform$Companion.prototype.skew_lu1900$ = function (x, y) {
    return new Transform('skew(' + x + ', ' + y + ')');
  };
  Transform$Companion.prototype.skewX_14dthe$ = function (x) {
    return new Transform('skew(' + x + ')');
  };
  Transform$Companion.prototype.skewY_14dthe$ = function (y) {
    return new Transform('skew(' + y + ')');
  };
  Transform$Companion.prototype.perspective_l5dsl4$ = function (length) {
    return new Transform('perspective(' + length.css() + ')');
  };
  Transform$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Transform$Companion_instance = null;
  function Transform$Companion_getInstance() {
    if (Transform$Companion_instance === null) {
      new Transform$Companion();
    }return Transform$Companion_instance;
  }
  Transform.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Transform',
    interfaces: [CssProperty]
  };
  function TransformStyle(value) {
    TransformStyle$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function TransformStyle$Companion() {
    TransformStyle$Companion_instance = this;
    this.flat = new TransformStyle('flat');
    this.preserve3d = new TransformStyle('preserve-3d');
    this.initial = new TransformStyle('initial');
    this.inherit = new TransformStyle('inherit');
  }
  TransformStyle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var TransformStyle$Companion_instance = null;
  function TransformStyle$Companion_getInstance() {
    if (TransformStyle$Companion_instance === null) {
      new TransformStyle$Companion();
    }return TransformStyle$Companion_instance;
  }
  TransformStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TransformStyle',
    interfaces: [CssProperty]
  };
  function UnicodeBidi(value) {
    UnicodeBidi$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function UnicodeBidi$Companion() {
    UnicodeBidi$Companion_instance = this;
    this.normal = new UnicodeBidi('normal');
    this.embed = new UnicodeBidi('embed');
    this.bidiOverride = new UnicodeBidi('bidi-override');
    this.initial = new UnicodeBidi('initial');
    this.inherit = new UnicodeBidi('inherit');
  }
  UnicodeBidi$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UnicodeBidi$Companion_instance = null;
  function UnicodeBidi$Companion_getInstance() {
    if (UnicodeBidi$Companion_instance === null) {
      new UnicodeBidi$Companion();
    }return UnicodeBidi$Companion_instance;
  }
  UnicodeBidi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnicodeBidi',
    interfaces: [CssProperty]
  };
  function UserSelect(value) {
    UserSelect$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function UserSelect$Companion() {
    UserSelect$Companion_instance = this;
    this.auto = new UserSelect('auto');
    this.none = new UserSelect('none');
    this.text = new UserSelect('text');
    this.all = new UserSelect('all');
  }
  UserSelect$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UserSelect$Companion_instance = null;
  function UserSelect$Companion_getInstance() {
    if (UserSelect$Companion_instance === null) {
      new UserSelect$Companion();
    }return UserSelect$Companion_instance;
  }
  UserSelect.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UserSelect',
    interfaces: [CssProperty]
  };
  function VerticalAlign(value) {
    VerticalAlign$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function VerticalAlign$Companion() {
    VerticalAlign$Companion_instance = this;
    this.baseline = new VerticalAlign('baseline');
    this.sub = new VerticalAlign('sub');
    this._super = new VerticalAlign('super');
    this.top = new VerticalAlign('top');
    this.textTop = new VerticalAlign('text-top');
    this.middle = new VerticalAlign('middle');
    this.bottom = new VerticalAlign('bottom');
    this.textBottom = new VerticalAlign('text-bottom');
    this.initial = new VerticalAlign('initial');
    this.inherit = new VerticalAlign('inherit');
  }
  VerticalAlign$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var VerticalAlign$Companion_instance = null;
  function VerticalAlign$Companion_getInstance() {
    if (VerticalAlign$Companion_instance === null) {
      new VerticalAlign$Companion();
    }return VerticalAlign$Companion_instance;
  }
  VerticalAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'VerticalAlign',
    interfaces: [CssProperty]
  };
  function Visibility(value) {
    Visibility$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function Visibility$Companion() {
    Visibility$Companion_instance = this;
    this.visible = new Visibility('visible');
    this.hidden = new Visibility('hidden');
    this.collapse = new Visibility('collapse');
    this.initial = new Visibility('initial');
    this.inherit = new Visibility('inherit');
  }
  Visibility$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Visibility$Companion_instance = null;
  function Visibility$Companion_getInstance() {
    if (Visibility$Companion_instance === null) {
      new Visibility$Companion();
    }return Visibility$Companion_instance;
  }
  Visibility.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Visibility',
    interfaces: [CssProperty]
  };
  function WhiteSpace(value) {
    WhiteSpace$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function WhiteSpace$Companion() {
    WhiteSpace$Companion_instance = this;
    this.normal = new WhiteSpace('normal');
    this.nowrap = new WhiteSpace('nowrap');
    this.pre = new WhiteSpace('pre');
    this.preLine = new WhiteSpace('pre-line');
    this.preWrap = new WhiteSpace('pre-wrap');
    this.initial = new WhiteSpace('initial');
    this.inherit = new WhiteSpace('inherit');
  }
  WhiteSpace$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var WhiteSpace$Companion_instance = null;
  function WhiteSpace$Companion_getInstance() {
    if (WhiteSpace$Companion_instance === null) {
      new WhiteSpace$Companion();
    }return WhiteSpace$Companion_instance;
  }
  WhiteSpace.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WhiteSpace',
    interfaces: [CssProperty]
  };
  function WordBreak(value) {
    WordBreak$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function WordBreak$Companion() {
    WordBreak$Companion_instance = this;
    this.normal = new WordBreak('normal');
    this.breakAll = new WordBreak('break-all');
    this.keepAll = new WordBreak('keep-all');
    this.breakWord = new WordBreak('break-word');
    this.initial = new WordBreak('initial');
    this.inherit = new WordBreak('inherit');
  }
  WordBreak$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var WordBreak$Companion_instance = null;
  function WordBreak$Companion_getInstance() {
    if (WordBreak$Companion_instance === null) {
      new WordBreak$Companion();
    }return WordBreak$Companion_instance;
  }
  WordBreak.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WordBreak',
    interfaces: [CssProperty]
  };
  function WordSpacing(value) {
    WordSpacing$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function WordSpacing$Companion() {
    WordSpacing$Companion_instance = this;
    this.normal = new WordSpacing('normal');
    this.initial = new WordSpacing('initial');
    this.inherit = new WordSpacing('inherit');
  }
  WordSpacing$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var WordSpacing$Companion_instance = null;
  function WordSpacing$Companion_getInstance() {
    if (WordSpacing$Companion_instance === null) {
      new WordSpacing$Companion();
    }return WordSpacing$Companion_instance;
  }
  WordSpacing.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WordSpacing',
    interfaces: [CssProperty]
  };
  function WordWrap(value) {
    WordWrap$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function WordWrap$Companion() {
    WordWrap$Companion_instance = this;
    this.normal = new WordWrap('normal');
    this.breakWord = new WordWrap('break-word');
    this.initial = new WordWrap('initial');
    this.inherit = new WordWrap('inherit');
  }
  WordWrap$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var WordWrap$Companion_instance = null;
  function WordWrap$Companion_getInstance() {
    if (WordWrap$Companion_instance === null) {
      new WordWrap$Companion();
    }return WordWrap$Companion_instance;
  }
  WordWrap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WordWrap',
    interfaces: [CssProperty]
  };
  function WritingMode(value) {
    WritingMode$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function WritingMode$Companion() {
    WritingMode$Companion_instance = this;
    this.horizontalTb = new WritingMode('horizontal-tb');
    this.verticalRl = new WritingMode('vertical-rl');
    this.verticalLr = new WritingMode('vertical-lr');
  }
  WritingMode$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var WritingMode$Companion_instance = null;
  function WritingMode$Companion_getInstance() {
    if (WritingMode$Companion_instance === null) {
      new WritingMode$Companion();
    }return WritingMode$Companion_instance;
  }
  WritingMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WritingMode',
    interfaces: [CssProperty]
  };
  function ZIndex(value) {
    ZIndex$Companion_getInstance();
    CssProperty.call(this, value);
  }
  function ZIndex$Companion() {
    ZIndex$Companion_instance = this;
    this.auto = new ZIndex('auto');
    this.initial = new ZIndex('initial');
    this.inherit = new ZIndex('inherit');
  }
  ZIndex$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ZIndex$Companion_instance = null;
  function ZIndex$Companion_getInstance() {
    if (ZIndex$Companion_instance === null) {
      new ZIndex$Companion();
    }return ZIndex$Companion_instance;
  }
  ZIndex.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZIndex',
    interfaces: [CssProperty]
  };
  function CssBlock(selector, content) {
    this.selector = selector;
    this.content = content;
  }
  CssBlock.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CssBlock',
    interfaces: []
  };
  CssBlock.prototype.component1 = function () {
    return this.selector;
  };
  CssBlock.prototype.component2 = function () {
    return this.content;
  };
  CssBlock.prototype.copy_puj7f4$ = function (selector, content) {
    return new CssBlock(selector === void 0 ? this.selector : selector, content === void 0 ? this.content : content);
  };
  CssBlock.prototype.toString = function () {
    return 'CssBlock(selector=' + Kotlin.toString(this.selector) + (', content=' + Kotlin.toString(this.content)) + ')';
  };
  CssBlock.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.selector) | 0;
    result = result * 31 + Kotlin.hashCode(this.content) | 0;
    return result;
  };
  CssBlock.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.selector, other.selector) && Kotlin.equals(this.content, other.content)))));
  };
  function CssFunctions() {
    CssFunctions_instance = this;
  }
  CssFunctions.prototype.darken_ozibgv$ = function (color, percentage) {
    return color;
  };
  CssFunctions.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CssFunctions',
    interfaces: []
  };
  var CssFunctions_instance = null;
  function CssFunctions_getInstance() {
    if (CssFunctions_instance === null) {
      new CssFunctions();
    }return CssFunctions_instance;
  }
  function FontFace() {
    CssGenerator.call(this);
  }
  FontFace.prototype.getValidator_61zpoe$ = function (name) {
    return null;
  };
  FontFace.prototype.fontFamily_61zpoe$ = function (font) {
    var $receiver = this.props;
    var key = 'font-family';
    var value = listOf(new CssProperty(font));
    $receiver.put_xwzc9p$(key, value);
  };
  FontFace.prototype.fontSize_jn53nw$ = function (size) {
    var $receiver = this.props;
    var key = 'font-size';
    var value = listOf(size);
    $receiver.put_xwzc9p$(key, value);
  };
  FontFace.prototype.src_61zpoe$ = function (src) {
    var $receiver = this.props;
    var value = listOf(new CssProperty(src));
    $receiver.put_xwzc9p$('src', value);
  };
  FontFace.prototype.fontStretch_lpsr2m$ = function (stretch) {
    var $receiver = this.props;
    var key = 'font-stretch';
    var value = listOf(stretch);
    $receiver.put_xwzc9p$(key, value);
  };
  FontFace.prototype.fontStyle_uctcke$ = function (style) {
    var $receiver = this.props;
    var key = 'font-style';
    var value = listOf(style);
    $receiver.put_xwzc9p$(key, value);
  };
  FontFace.prototype.fontWeight_jagd7v$ = function (weight) {
    var $receiver = this.props;
    var key = 'font-weight';
    var value = listOf(weight);
    $receiver.put_xwzc9p$(key, value);
  };
  FontFace.prototype.unicodeRange_61zpoe$ = function (unicodeRange) {
    var $receiver = this.props;
    var key = 'unicode-range';
    var value = listOf(new CssProperty(unicodeRange));
    $receiver.put_xwzc9p$(key, value);
  };
  FontFace.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FontFace',
    interfaces: [CssGenerator]
  };
  function KeyFrames() {
    CssGenerator.call(this);
    this.frames = LinkedHashMap_init();
  }
  KeyFrames.prototype.getValidator_61zpoe$ = function (name) {
    return emptyList();
  };
  KeyFrames.prototype.percentage_x7nkv6$ = function (percentage, style) {
    var css = new Style();
    style(css);
    this.frames.put_xwzc9p$(percentage, style);
  };
  KeyFrames.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KeyFrames',
    interfaces: [CssGenerator]
  };
  function CssTagMarker() {
  }
  CssTagMarker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CssTagMarker',
    interfaces: [Annotation]
  };
  function prp(css) {
    var tmp$;
    var result = ArrayList_init();
    for (tmp$ = 0; tmp$ !== css.length; ++tmp$) {
      var c = css[tmp$];
      result.add_11rb$(new CssProperty(c.css()));
    }
    return result;
  }
  function prp_0(css) {
    var tmp$;
    var result = ArrayList_init();
    for (tmp$ = 0; tmp$ !== css.length; ++tmp$) {
      var c = css[tmp$];
      result.add_11rb$(new CssProperty(c));
    }
    return result;
  }
  function CssGenerator() {
    this.definitions = LinkedHashMap_init();
    this.props = LinkedHashMap_init();
  }
  CssGenerator.prototype.propertyCss_fpwsa1$_0 = function (indent, name, props) {
    var tmp$, tmp$_0;
    var builder = StringBuilder_init();
    if ((tmp$ = this.getValidator_61zpoe$(name)) != null) {
      var tmp$_1;
      tmp$_1 = tmp$.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        if (!element.validate_pen8qx$(props)) {
          println("Validate error '" + name + "' - " + element.getMessage_61zpoe$(name));
        }}
    }tmp$_0 = props.iterator();
    while (tmp$_0.hasNext()) {
      var prop = tmp$_0.next();
      if (builder.length > 0) {
        builder.append_pdl1vj$(' ');
      }builder.append_pdl1vj$(prop.css());
    }
    var paddedName = StringBuilder_init();
    paddedName.append_pdl1vj$(indent);
    paddedName.append_pdl1vj$(name);
    paddedName.append_pdl1vj$(':');
    while (paddedName.length < 32) {
      paddedName.append_s8itvh$(32);
    }
    return paddedName.toString() + builder + ';' + '\n';
  };
  CssGenerator.prototype.generatePropertyCss_ivxn3r$ = function (indent, sortProperties) {
    var tmp$, tmp$_0, tmp$_1;
    var builder = StringBuilder_init();
    if (sortProperties) {
      tmp$ = sorted(this.props.keys).iterator();
      while (tmp$.hasNext()) {
        var name = tmp$.next();
        var tmp$_2;
        if ((tmp$_0 = this.props.get_11rb$(name)) != null)
          tmp$_2 = tmp$_0;
        else {
          throw IllegalStateException_init((name + ' not found in properties after sorting!').toString());
        }
        var prop = tmp$_2;
        builder.append_pdl1vj$(this.propertyCss_fpwsa1$_0(indent, name, prop));
      }
    } else {
      tmp$_1 = this.props.entries.iterator();
      while (tmp$_1.hasNext()) {
        var tmp$_3 = tmp$_1.next();
        var name_0 = tmp$_3.key;
        var prop_0 = tmp$_3.value;
        builder.append_pdl1vj$(this.propertyCss_fpwsa1$_0(indent, name_0, prop_0));
      }
    }
    return builder.toString();
  };
  function CssGenerator$generateCss$generateBlock($receiver, indent, selectors, block) {
    if (!selectors.isEmpty() && block != null) {
      $receiver.append_pdl1vj$(indent);
      $receiver.append_pdl1vj$(joinToString(selectors, ',\n'));
      $receiver.append_pdl1vj$(' {\n');
      $receiver.append_pdl1vj$(block.content);
      $receiver.append_pdl1vj$(indent);
      $receiver.append_pdl1vj$('}\n\n');
    }}
  CssGenerator.prototype.generateCss_c48ccp$$default = function (indent, minified, warnOnRedeclaration, allowCommaInSelector, combineEqualBlocks, sortProperties) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var blocks = this.generateCssBlocks_y6kqds$(void 0, indent, minified, warnOnRedeclaration, allowCommaInSelector, sortProperties);
    var builder = StringBuilder_init();
    var generateBlock = CssGenerator$generateCss$generateBlock;
    if (!combineEqualBlocks) {
      var first = true;
      var selectors = ArrayList_init();
      var lastBlock = null;
      tmp$ = blocks.iterator();
      while (tmp$.hasNext()) {
        var block = tmp$.next();
        if (first) {
          first = false;
          selectors.add_11rb$(block.selector);
          lastBlock = block;
        } else {
          if (lastBlock != null && equals(lastBlock.content, block.content)) {
            selectors.add_11rb$(block.selector);
            tmp$_0 = block;
          } else {
            generateBlock(builder, indent, selectors, lastBlock);
            selectors.clear();
            selectors.add_11rb$(block.selector);
            tmp$_0 = block;
          }
          lastBlock = tmp$_0;
        }
      }
      generateBlock(builder, indent, selectors, lastBlock);
    } else {
      var blockHashes = LinkedHashMap_init();
      tmp$_1 = blocks.iterator();
      while (tmp$_1.hasNext()) {
        var block_0 = tmp$_1.next();
        var key = hashCode(block_0.content);
        var tmp$_6;
        var value = blockHashes.get_11rb$(key);
        if (value == null) {
          var answer = ArrayList_init();
          blockHashes.put_xwzc9p$(key, answer);
          tmp$_6 = answer;
        } else {
          tmp$_6 = value;
        }
        tmp$_6.add_11rb$(block_0);
      }
      var done = LinkedHashSet_init();
      tmp$_2 = blocks.iterator();
      while (tmp$_2.hasNext()) {
        var block_1 = tmp$_2.next();
        var hashCode_0 = hashCode(block_1.content);
        if (!done.contains_11rb$(hashCode_0)) {
          if ((tmp$_3 = blockHashes.get_11rb$(hashCode_0)) != null) {
            var destination = ArrayList_init_0(collectionSizeOrDefault(tmp$_3, 10));
            var tmp$_7;
            tmp$_7 = tmp$_3.iterator();
            while (tmp$_7.hasNext()) {
              var item = tmp$_7.next();
              destination.add_11rb$(item.selector);
            }
            var slctrs = destination;
            generateBlock(builder, indent, slctrs, block_1);
            done.add_11rb$(hashCode_0);
          }}}
    }
    if (minified) {
      var stripped = StringBuilder_init();
      var skip = [toBoxedChar(32), toBoxedChar(9), toBoxedChar(10), toBoxedChar(13)];
      tmp$_4 = iterator(builder);
      while (tmp$_4.hasNext()) {
        var char = unboxChar(tmp$_4.next());
        if (!contains_0(skip, toBoxedChar(char))) {
          stripped.append_s8itvh$(char);
        }}
      tmp$_5 = stripped.toString();
    } else {
      tmp$_5 = builder.toString();
    }
    return tmp$_5;
  };
  CssGenerator.prototype.generateCss_c48ccp$ = function (indent, minified, warnOnRedeclaration, allowCommaInSelector, combineEqualBlocks, sortProperties, callback$default) {
    if (indent === void 0)
      indent = '';
    if (minified === void 0)
      minified = false;
    if (warnOnRedeclaration === void 0)
      warnOnRedeclaration = true;
    if (allowCommaInSelector === void 0)
      allowCommaInSelector = false;
    if (combineEqualBlocks === void 0)
      combineEqualBlocks = false;
    if (sortProperties === void 0)
      sortProperties = false;
    return callback$default ? callback$default(indent, minified, warnOnRedeclaration, allowCommaInSelector, combineEqualBlocks, sortProperties) : this.generateCss_c48ccp$$default(indent, minified, warnOnRedeclaration, allowCommaInSelector, combineEqualBlocks, sortProperties);
  };
  CssGenerator.prototype.generateCssBlocks_y6kqds$$default = function (namespace, indent, minified, warnOnRedeclaration, allowCommaInSelector, sortProperties) {
    var tmp$, tmp$_0, tmp$_1;
    var blocks = ArrayList_init();
    tmp$ = this.definitions.keys.iterator();
    while (tmp$.hasNext()) {
      var name = tmp$.next();
      var props = ensureNotNull(this.definitions.get_11rb$(name));
      var css = StringBuilder_init();
      if (warnOnRedeclaration && props.size > 1) {
        css.append_pdl1vj$('  ' + indent + "/* style '" + name + "' is defined " + props.size + ' times! */' + '\n');
      }var finalStyle = new Style();
      tmp$_0 = props.iterator();
      while (tmp$_0.hasNext()) {
        var prop = tmp$_0.next();
        prop(finalStyle);
      }
      css.append_pdl1vj$(finalStyle.generatePropertyCss_ivxn3r$('  ' + indent, sortProperties));
      if (!isBlank(css)) {
        var builder = StringBuilder_init();
        if (!(allowCommaInSelector || !contains_1(name, 44))) {
          var message = 'Comma is not allowed in selector (option is set in generateCss call)';
          throw IllegalStateException_init(message.toString());
        }if ((tmp$_1 = finalStyle.fontFace) != null) {
          builder.append_pdl1vj$('  ' + indent);
          builder.append_pdl1vj$('@font-face {\n');
          builder.append_pdl1vj$(tmp$_1.generatePropertyCss_ivxn3r$('    ' + indent, sortProperties));
          builder.append_pdl1vj$('  ' + indent);
          builder.append_pdl1vj$('}\n');
        }var kf = finalStyle.keyFrames;
        var tmp$_2;
        tmp$_2 = sorted(kf.keys).iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          var css_0 = kf.get_11rb$(element);
          builder.append_pdl1vj$('  ' + indent);
          builder.append_pdl1vj$('@keyframes ');
          builder.append_pdl1vj$(element);
          builder.append_pdl1vj$(' {\n');
          if (css_0 != null) {
            var tmp$_3;
            tmp$_3 = css_0.frames.entries.iterator();
            while (tmp$_3.hasNext()) {
              var tmp$_4 = tmp$_3.next();
              var nr = tmp$_4.key;
              var style = tmp$_4.value;
              builder.append_pdl1vj$('    ' + indent);
              builder.append_pdl1vj$(nr.toString() + '% ');
              builder.append_pdl1vj$('    ' + indent);
              builder.append_pdl1vj$('{\n');
              var finalStyle_0 = new Style();
              style(finalStyle_0);
              builder.append_pdl1vj$(finalStyle_0.generatePropertyCss_ivxn3r$('      ' + indent, sortProperties));
              builder.append_pdl1vj$('    ' + indent);
              builder.append_pdl1vj$('}\n');
            }
            builder.append_pdl1vj$('  ' + indent);
            builder.append_pdl1vj$('}\n');
          }}
        builder.append_gw00v9$(css);
        var $receiver = namespace + name;
        var tmp$_5;
        blocks.add_11rb$(new CssBlock(trim(Kotlin.isCharSequence(tmp$_5 = $receiver) ? tmp$_5 : throwCCE()).toString(), builder.toString()));
      }var $receiver_0 = namespace + name;
      var tmp$_6;
      blocks.addAll_brywnq$(finalStyle.generateCssBlocks_y6kqds$(trim(Kotlin.isCharSequence(tmp$_6 = $receiver_0) ? tmp$_6 : throwCCE()).toString(), indent, minified, warnOnRedeclaration, allowCommaInSelector, sortProperties));
    }
    if (Kotlin.isType(this, ConditionalStyle)) {
      var mq = this.media;
      var tmp$_7;
      tmp$_7 = sorted(mq.keys).iterator();
      while (tmp$_7.hasNext()) {
        var element_0 = tmp$_7.next();
        var css_1 = mq.get_11rb$(element_0);
        if (css_1 != null) {
          var mediaStyle = new ConditionalStyle();
          css_1(mediaStyle);
          var $receiver_1 = indent + '@media ' + element_0;
          var tmp$_8;
          blocks.add_11rb$(new CssBlock(trim(Kotlin.isCharSequence(tmp$_8 = $receiver_1) ? tmp$_8 : throwCCE()).toString(), mediaStyle.generateCss_c48ccp$('  ' + indent, minified, warnOnRedeclaration, allowCommaInSelector, void 0, sortProperties)));
        }}
      var mq_0 = this.supports;
      var tmp$_9;
      tmp$_9 = sorted(mq_0.keys).iterator();
      while (tmp$_9.hasNext()) {
        var element_1 = tmp$_9.next();
        var css_2 = mq_0.get_11rb$(element_1);
        if (css_2 != null) {
          var mediaStyle_0 = new ConditionalStyle();
          css_2(mediaStyle_0);
          var $receiver_2 = indent + '@supports ' + element_1;
          var tmp$_10;
          blocks.add_11rb$(new CssBlock(trim(Kotlin.isCharSequence(tmp$_10 = $receiver_2) ? tmp$_10 : throwCCE()).toString(), mediaStyle_0.generateCss_c48ccp$('  ' + indent, minified, warnOnRedeclaration, allowCommaInSelector, void 0, sortProperties)));
        }}
    }return blocks;
  };
  CssGenerator.prototype.generateCssBlocks_y6kqds$ = function (namespace, indent, minified, warnOnRedeclaration, allowCommaInSelector, sortProperties, callback$default) {
    if (namespace === void 0)
      namespace = '';
    if (indent === void 0)
      indent = '';
    if (minified === void 0)
      minified = false;
    if (warnOnRedeclaration === void 0)
      warnOnRedeclaration = true;
    if (allowCommaInSelector === void 0)
      allowCommaInSelector = false;
    if (sortProperties === void 0)
      sortProperties = false;
    return callback$default ? callback$default(namespace, indent, minified, warnOnRedeclaration, allowCommaInSelector, sortProperties) : this.generateCssBlocks_y6kqds$$default(namespace, indent, minified, warnOnRedeclaration, allowCommaInSelector, sortProperties);
  };
  CssGenerator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CssGenerator',
    interfaces: []
  };
  function DescriptionProvider() {
  }
  DescriptionProvider.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DescriptionProvider',
    interfaces: []
  };
  function ValueDescriptionProvider(value) {
    this.value = value;
  }
  ValueDescriptionProvider.prototype.description = function () {
    return this.value;
  };
  ValueDescriptionProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ValueDescriptionProvider',
    interfaces: [DescriptionProvider]
  };
  function txt(name) {
    return new ValueDescriptionProvider(name);
  }
  function id(name) {
    return new ValueDescriptionProvider('#' + name);
  }
  function cls(name) {
    return new ValueDescriptionProvider('.' + name);
  }
  function attr(name) {
    return new ValueDescriptionProvider('[' + name + ']');
  }
  function attrEquals(name, value) {
    return new ValueDescriptionProvider('[' + name + '=' + value + ']');
  }
  function attrContains(name, value) {
    return new ValueDescriptionProvider('[' + name + '*=' + value + ']');
  }
  function attrEntriesContain(name, value) {
    return new ValueDescriptionProvider('[' + name + '~=' + value + ']');
  }
  function attrEndsWith(name, value) {
    return new ValueDescriptionProvider('[' + name + '$' + '=' + value + ']');
  }
  function attrStartsWith(name, value) {
    return new ValueDescriptionProvider('[' + name + '^=' + value + ']');
  }
  function id_0(name) {
    return new ValueDescriptionProvider('#' + name.description());
  }
  function cls_0(name) {
    return new ValueDescriptionProvider('.' + name.description());
  }
  function attr_0(name) {
    return new ValueDescriptionProvider('[' + name.description() + ']');
  }
  function attrEquals_0(name, value) {
    return new ValueDescriptionProvider('[' + name.description() + '=' + value + ']');
  }
  function attrContains_0(name, value) {
    return new ValueDescriptionProvider('[' + name.description() + '*=' + value + ']');
  }
  function attrEntriesContain_0(name, value) {
    return new ValueDescriptionProvider('[' + name.description() + '~=' + value + ']');
  }
  function attrEndsWith_0(name, value) {
    return new ValueDescriptionProvider('[' + name.description() + '$' + '=' + value + ']');
  }
  function attrStartsWith_0(name, value) {
    return new ValueDescriptionProvider('[' + name.description() + '^=' + value + ']');
  }
  function Style() {
    CssGenerator.call(this);
    this.fontFace = null;
    this.keyFrames = LinkedHashMap_init();
    this.validators_lo7eco$_0 = mapOf([to('background-position', listOf(new InitialInheritSingleValue())), to('background-size', listOf(new MaxCountValidator(2))), to('border-radius', listOf_0([new MaxCountValidator(4), new InitialInheritSingleValue()])), to('animation-iteration-mode', listOf(new MaxCountValidator(4))), to('animation-timing-function', listOf(new MaxCountValidator(4))), to('border-image-repeat', listOf(new MaxCountValidator(2))), to('border-image-slice', listOf(new MaxCountValidator(4))), to('border-spacing', listOf(new MaxCountValidator(4))), to('border-style', listOf(new MaxCountValidator(4)))]);
  }
  Style.prototype.getValidator_61zpoe$ = function (name) {
    return this.validators_lo7eco$_0.get_11rb$(name);
  };
  Style.prototype.addStyle_hqvr3v$_0 = function (selector, style) {
    var tmp$, tmp$_0;
    var tmp$_1 = this.definitions;
    var value = (tmp$ = this.definitions.get_11rb$(selector)) != null ? tmp$ : ArrayList_init();
    tmp$_1.put_xwzc9p$(selector, value);
    (tmp$_0 = this.definitions.get_11rb$(selector)) != null ? tmp$_0.add_11rb$(style) : null;
  };
  Style.prototype.and_zbrnxy$ = function (selectors, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== selectors.length; ++tmp$) {
      var selector = selectors[tmp$];
      this.addStyle_hqvr3v$_0(selector.description(), style);
    }
  };
  Style.prototype.and_a6jodh$ = function (selectors, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== selectors.length; ++tmp$) {
      var selector = selectors[tmp$];
      this.addStyle_hqvr3v$_0(selector, style);
    }
  };
  Style.prototype.select_zbrnxy$ = function (selectors, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== selectors.length; ++tmp$) {
      var selector = selectors[tmp$];
      this.addStyle_hqvr3v$_0(' ' + selector.description(), style);
    }
  };
  Style.prototype.select_a6jodh$ = function (selectors, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== selectors.length; ++tmp$) {
      var selector = selectors[tmp$];
      this.addStyle_hqvr3v$_0(' ' + selector, style);
    }
  };
  Style.prototype.descendant_zbrnxy$ = function (descNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== descNames.length; ++tmp$) {
      var descName = descNames[tmp$];
      this.addStyle_hqvr3v$_0(' ' + descName.description(), style);
    }
  };
  Style.prototype.descendant_a6jodh$ = function (descNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== descNames.length; ++tmp$) {
      var descName = descNames[tmp$];
      this.addStyle_hqvr3v$_0(' ' + descName, style);
    }
  };
  Style.prototype.child_zbrnxy$ = function (childNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== childNames.length; ++tmp$) {
      var childName = childNames[tmp$];
      this.addStyle_hqvr3v$_0(' > ' + childName.description(), style);
    }
  };
  Style.prototype.child_a6jodh$ = function (childNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== childNames.length; ++tmp$) {
      var childName = childNames[tmp$];
      this.addStyle_hqvr3v$_0(' > ' + childName, style);
    }
  };
  Style.prototype.sibling_zbrnxy$ = function (childNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== childNames.length; ++tmp$) {
      var childName = childNames[tmp$];
      this.addStyle_hqvr3v$_0(' ~ ' + childName.description(), style);
    }
  };
  Style.prototype.sibling_a6jodh$ = function (childNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== childNames.length; ++tmp$) {
      var childName = childNames[tmp$];
      this.addStyle_hqvr3v$_0(' ~ ' + childName, style);
    }
  };
  Style.prototype.adjSibling_zbrnxy$ = function (childNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== childNames.length; ++tmp$) {
      var childName = childNames[tmp$];
      this.addStyle_hqvr3v$_0(' + ' + childName.description(), style);
    }
  };
  Style.prototype.adjSibling_a6jodh$ = function (childNames, style) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== childNames.length; ++tmp$) {
      var childName = childNames[tmp$];
      this.addStyle_hqvr3v$_0(' + ' + childName, style);
    }
  };
  Style.prototype.active_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':active', style);
  };
  Style.prototype.focus_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':focus', style);
  };
  Style.prototype.focusWithin_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':focus-within', style);
  };
  Style.prototype.hover_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':hover', style);
  };
  Style.prototype.firstChild_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':first-child', style);
  };
  Style.prototype.lastChild_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':last-child', style);
  };
  Style.prototype.pseudoElement_kfna6f$ = function (selector, style) {
    this.addStyle_hqvr3v$_0(':' + selector.description(), style);
  };
  Style.prototype.pseudoChild_kfna6f$ = function (selector, style) {
    this.addStyle_hqvr3v$_0('::' + selector.description(), style);
  };
  Style.prototype.visited_8xi0to$ = function (style) {
    this.addStyle_hqvr3v$_0(':visited', style);
  };
  Style.prototype.not_kfna6f$ = function (selector, style) {
    this.addStyle_hqvr3v$_0(':not(' + selector.description() + ')', style);
  };
  Style.prototype.plain_puj7f4$ = function (name, value) {
    var $receiver = this.props;
    var value_0 = prp_0([value]);
    $receiver.put_xwzc9p$(name, value_0);
  };
  Style.prototype.plain_l22c4i$ = function (name, value) {
    var $receiver = this.props;
    var value_0 = prp([value]);
    $receiver.put_xwzc9p$(name, value_0);
  };
  Style.prototype.alignContent_9wgdtk$ = function (value) {
    var $receiver = this.props;
    var key = 'align-content';
    var value_0 = prp([value]);
    $receiver.put_xwzc9p$(key, value_0);
  };
  Style.prototype.alignItems_duof7j$ = function (alignItems) {
    var $receiver = this.props;
    var key = 'align-items';
    var value = prp([alignItems]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.all_k9g5yb$ = function (all) {
    var $receiver = this.props;
    var value = prp([all]);
    $receiver.put_xwzc9p$('all', value);
  };
  Style.prototype.alignSelf_e76hpp$ = function (alignSelf) {
    var $receiver = this.props;
    var key = 'align-self';
    var value = prp([alignSelf]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animation_61zpoe$ = function (text) {
    var $receiver = this.props;
    var key = 'animation';
    var value = prp_0([text]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationDelay_2ipz0t$ = function (delay) {
    var $receiver = this.props;
    var key = 'animation-delay';
    var value = prp([delay]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationDirection_cveylb$ = function (direction) {
    var $receiver = this.props;
    var key = 'animation-direction';
    var value = prp([direction]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationDuration_2ipz0t$ = function (duration) {
    var $receiver = this.props;
    var key = 'animation-duration';
    var value = prp([duration]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationFillMode_b4r68q$ = function (fillMode) {
    var $receiver = this.props;
    var key = 'animation-fill-mode';
    var value = prp([fillMode]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationIterationMode_ifw6a6$ = function (iterationMode) {
    var $receiver = this.props;
    var key = 'animation-iteration-mode';
    var value = prp(iterationMode.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationFrame_yh28d$ = function (frame) {
    var $receiver = this.props;
    var key = 'animation-frame';
    var value = prp([frame]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationName_vqirvp$ = function (name) {
    var $receiver = this.props;
    var key = 'animation-name';
    var value = prp_0(name.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationPlayState_5l54ey$ = function (state) {
    var $receiver = this.props;
    var key = 'animation-play-state';
    var value = prp(state.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.animationTimingFunction_x31iub$ = function (timingFunction) {
    var $receiver = this.props;
    var key = 'animation-timing-function';
    var value = prp(timingFunction.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backfaceVisibility_k5deey$ = function (backfaceVisibility) {
    var $receiver = this.props;
    var value = prp([backfaceVisibility]);
    $receiver.put_xwzc9p$('', value);
  };
  Style.prototype.background_61zpoe$ = function (background) {
    var $receiver = this.props;
    var key = 'background';
    var value = prp_0([background]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundAttachment_r0d2t$ = function (attachment) {
    var $receiver = this.props;
    var key = 'background-attachment';
    var value = prp([attachment]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundBlendMode_y7p3ya$ = function (blendMode) {
    var $receiver = this.props;
    var key = 'background-blend-mode';
    var value = prp([blendMode]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundClip_go0rom$ = function (clip) {
    var $receiver = this.props;
    var key = 'background-clip';
    var value = prp([clip]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'background-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundImage_9n91ex$ = function (image) {
    var $receiver = this.props;
    var key = 'background-image';
    var value = prp([image]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundImage_61zpoe$ = function (value) {
    var $receiver = this.props;
    var key = 'background-image';
    var value_0 = prp_0([value]);
    $receiver.put_xwzc9p$(key, value_0);
  };
  Style.prototype.backgroundOrigin_go0rom$ = function (origin) {
    var $receiver = this.props;
    var key = 'background-origin';
    var value = prp([origin]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundPosition_c7luth$ = function (position) {
    var $receiver = this.props;
    var key = 'background-position';
    var value = prp([position]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundRepeat_mt0tkd$ = function (repeat) {
    var $receiver = this.props;
    var key = 'background-repeat';
    var value = prp([repeat]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.backgroundSize_541mnk$ = function (size) {
    var $receiver = this.props;
    var key = 'background-size';
    var value = prp(size.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.border_61zpoe$ = function (border) {
    var $receiver = this.props;
    var value = prp_0([border]);
    $receiver.put_xwzc9p$('border', value);
  };
  Style.prototype.border_riaoly$ = function (width, style, color) {
    var $receiver = this.props;
    var value = prp([width, style, color]);
    $receiver.put_xwzc9p$('border', value);
  };
  Style.prototype.borderBottom_61zpoe$ = function (borderBottom) {
    var $receiver = this.props;
    var key = 'border-bottom';
    var value = prp_0([borderBottom]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderBottomColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'border-bottom-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderBottomLeftRadius_uwoyv5$ = function (radius) {
    var $receiver = this.props;
    var key = 'border-bottom-left-radius';
    var value = prp(radius.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderBottomRightRadius_uwoyv5$ = function (radius) {
    var $receiver = this.props;
    var key = 'border-bottom-right-radius';
    var value = prp(radius.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderBottomStyle_7p6pjz$ = function (style) {
    var $receiver = this.props;
    var key = 'border-bottom-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderBottomWidth_7n6zey$ = function (width) {
    var $receiver = this.props;
    var key = 'border-bottom-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderBottomWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'border-bottom-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderCollapse_6wg27x$ = function (collapse) {
    var $receiver = this.props;
    var key = 'border-collapse';
    var value = prp([collapse]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderColor_ifqg3e$ = function (color) {
    var $receiver = this.props;
    var key = 'border-color';
    var value = prp(color.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderImage_61zpoe$ = function (image) {
    var $receiver = this.props;
    var key = 'border-image';
    var value = prp_0([image]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderImageOutset_dld68m$ = function (imageOutset) {
    var $receiver = this.props;
    var key = 'border-image-outset';
    var value = prp([imageOutset]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderImageRepeat_651pp5$ = function (repeat) {
    var $receiver = this.props;
    var key = 'border-image-repeat';
    var value = prp(repeat.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderImageSlice_ipjdfs$ = function (slice) {
    var $receiver = this.props;
    var key = 'border-image-slice';
    var value = prp(slice.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderImageSource_dcs3dz$ = function (source) {
    var $receiver = this.props;
    var key = 'border-image-source';
    var value = prp(source.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderImageWidth_jog5u0$ = function (width) {
    var $receiver = this.props;
    var key = 'border-image-width';
    var value = prp(width.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderLeft_61zpoe$ = function (left) {
    var $receiver = this.props;
    var key = 'border-left';
    var value = prp_0([left]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderLeftColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'border-left-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderLeftStyle_7p6pjz$ = function (style) {
    var $receiver = this.props;
    var key = 'border-left-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderLeftWidth_7n6zey$ = function (width) {
    var $receiver = this.props;
    var key = 'border-left-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderLeftWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'border-left-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRadius_l5dsl4$ = function (radius) {
    var $receiver = this.props;
    var key = 'border-radius';
    var value = prp([radius]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRadius_xih1kc$ = function (topLeftBottomRight, topRightBottomLeft) {
    var $receiver = this.props;
    var key = 'border-radius';
    var value = listOf_0([topLeftBottomRight, topRightBottomLeft]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRadius_luu260$ = function (topLeft, topRightBottomLeft, bottomRight) {
    var $receiver = this.props;
    var key = 'border-radius';
    var value = listOf_0([topLeft, topRightBottomLeft, bottomRight]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRadius_z703mc$ = function (topLeft, topRight, bottomRight, bottomLeft) {
    var $receiver = this.props;
    var key = 'border-radius';
    var value = listOf_0([topLeft, topRight, bottomRight, bottomLeft]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRight_61zpoe$ = function (border) {
    var $receiver = this.props;
    var key = 'border-right';
    var value = prp_0([border]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRightColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'border-right-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRightStyle_7p6pjz$ = function (style) {
    var $receiver = this.props;
    var key = 'border-right-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRightWidth_7n6zey$ = function (width) {
    var $receiver = this.props;
    var key = 'border-right-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderRightWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'border-right-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderSpacing_tkr9ga$ = function (spacing) {
    var $receiver = this.props;
    var key = 'border-spacing';
    var value = prp(spacing.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderStyle_b1lzt4$ = function (style) {
    var $receiver = this.props;
    var key = 'border-style';
    var value = prp(style.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTop_61zpoe$ = function (border) {
    var $receiver = this.props;
    var key = 'border-top';
    var value = prp_0([border]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTopColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'border-top-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTopLeftRadius_l5dsl4$ = function (radius) {
    var $receiver = this.props;
    var key = 'border-top-left-radius';
    var value = prp([radius]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTopRightRadius_l5dsl4$ = function (radius) {
    var $receiver = this.props;
    var key = 'border-top-right-radius';
    var value = prp([radius]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTopStyle_7p6pjz$ = function (style) {
    var $receiver = this.props;
    var key = 'border-top-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTopWidth_7n6zey$ = function (width) {
    var $receiver = this.props;
    var key = 'border-top-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderTopWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'border-top-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'border-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.borderWidth_7n6zey$ = function (width) {
    var $receiver = this.props;
    var key = 'border-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.bottom_l5dsl4$ = function (measurement) {
    var $receiver = this.props;
    var value = prp([measurement]);
    $receiver.put_xwzc9p$('bottom', value);
  };
  Style.prototype.boxDecorationBreak_x4tn14$ = function (brk) {
    var $receiver = this.props;
    var key = 'box-decoration-break';
    var value = prp([brk]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.boxShadow_2qicqh$ = function (shadow) {
    var $receiver = this.props;
    var key = 'box-shadow';
    var value = prp([shadow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.boxSizing_2pihsr$ = function (sizing) {
    var $receiver = this.props;
    var key = 'box-sizing';
    var value = prp([sizing]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.breakAfter_9r0bt1$ = function (brk) {
    var $receiver = this.props;
    var key = 'break-after';
    var value = prp([brk]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.breakBefore_9r0bt1$ = function (brk) {
    var $receiver = this.props;
    var key = 'break-before';
    var value = prp([brk]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.breakInside_9r0bt1$ = function (brk) {
    var $receiver = this.props;
    var key = 'break-inside';
    var value = prp([brk]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.captionSide_igyeu1$ = function (side) {
    var $receiver = this.props;
    var key = 'caption-side';
    var value = prp([side]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.caretColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'caret-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.clear_9qkd4n$ = function (clear) {
    var $receiver = this.props;
    var value = prp([clear]);
    $receiver.put_xwzc9p$('clear', value);
  };
  Style.prototype.clip_b54n84$ = function (clip) {
    var $receiver = this.props;
    var value = prp([clip]);
    $receiver.put_xwzc9p$('clip', value);
  };
  Style.prototype.clipPath_aigmxz$ = function (path) {
    var $receiver = this.props;
    var key = 'clip-path';
    var value = prp([path]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.color_9qian5$ = function (color) {
    var $receiver = this.props;
    var value = listOf(color);
    $receiver.put_xwzc9p$('color', value);
  };
  Style.prototype.columnCount_9qi3zp$ = function (count) {
    var $receiver = this.props;
    var key = 'column-count';
    var value = prp([count]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnFill_b56i13$ = function (fill) {
    var $receiver = this.props;
    var key = 'column-fill';
    var value = prp([fill]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnGap_l5dsl4$ = function (gap) {
    var $receiver = this.props;
    var key = 'column-gap';
    var value = prp([gap]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnRule_61zpoe$ = function (rule) {
    var $receiver = this.props;
    var key = 'column-rule';
    var value = prp_0([rule]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnRuleColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'column-rule-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnRuleStyle_7p6pjz$ = function (style) {
    var $receiver = this.props;
    var key = 'column-rule-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnRuleWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'column-rule-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnSpan_b5exse$ = function (span) {
    var $receiver = this.props;
    var key = 'column-span';
    var value = prp([span]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.columnWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'column-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.column_61zpoe$ = function (column) {
    var $receiver = this.props;
    var value = prp_0([column]);
    $receiver.put_xwzc9p$('column', value);
  };
  Style.prototype.content_jhnq9h$ = function (content) {
    var $receiver = this.props;
    var value = prp([content]);
    $receiver.put_xwzc9p$('content', value);
  };
  Style.prototype.counterIncrement_61zpoe$ = function (increment) {
    var $receiver = this.props;
    var key = 'counter-increment';
    var value = prp_0([increment]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.counterReset_61zpoe$ = function (reset) {
    var $receiver = this.props;
    var key = 'counter-reset';
    var value = prp_0([reset]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.cursor_61zpoe$ = function (cursor) {
    var $receiver = this.props;
    var value = prp_0([cursor]);
    $receiver.put_xwzc9p$('cursor', value);
  };
  Style.prototype.direction_uy09j9$ = function (direction) {
    var $receiver = this.props;
    var key = 'direction';
    var value = prp([direction]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.display_vegu0u$ = function (display) {
    var $receiver = this.props;
    var value = prp([display]);
    $receiver.put_xwzc9p$('display', value);
  };
  Style.prototype.emptyCells_dhgwug$ = function (cells) {
    var $receiver = this.props;
    var key = 'empty-cells';
    var value = prp([cells]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.filter_61zpoe$ = function (filter) {
    var $receiver = this.props;
    var value = prp_0([filter]);
    $receiver.put_xwzc9p$('filter', value);
  };
  Style.prototype.flex_61zpoe$ = function (flex) {
    var $receiver = this.props;
    var value = prp_0([flex]);
    $receiver.put_xwzc9p$('flex', value);
  };
  Style.prototype.flexBasis_l5dsl4$ = function (basis) {
    var $receiver = this.props;
    var key = 'flex-basis';
    var value = prp([basis]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.flexDirection_xn54ce$ = function (direction) {
    var $receiver = this.props;
    var key = 'flex-direction';
    var value = prp([direction]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.flexFlow_61zpoe$ = function (flow) {
    var $receiver = this.props;
    var key = 'flex-flow';
    var value = prp_0([flow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.flexGrow_f8i4mf$ = function (grow) {
    var $receiver = this.props;
    var key = 'flex-grow';
    var value = prp([grow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.flexShrink_f8i4mf$ = function (shrink) {
    var $receiver = this.props;
    var key = 'flex-shrink';
    var value = prp([shrink]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.flexWrap_35nehz$ = function (wrap) {
    var $receiver = this.props;
    var key = 'flex-wrap';
    var value = prp([wrap]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.float_pb2b8d$ = function (cssFloat) {
    var $receiver = this.props;
    var value = prp([cssFloat]);
    $receiver.put_xwzc9p$('float', value);
  };
  Style.prototype.font_61zpoe$ = function (font) {
    var $receiver = this.props;
    var value = prp_0([font]);
    $receiver.put_xwzc9p$('font', value);
  };
  Style.prototype.fontFace_fw05iv$ = function (face) {
    this.fontFace = new FontFace();
    face(ensureNotNull(this.fontFace));
  };
  Style.prototype.fontFamily_61zpoe$ = function (font) {
    var $receiver = this.props;
    var key = 'font-family';
    var value = prp_0([font]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontFeatureSettings_vqirvp$ = function (setting) {
    var $receiver = this.props;
    var key = 'font-feature-settings';
    var value = prp_0(setting.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontKerning_469ptz$ = function (kerning) {
    var $receiver = this.props;
    var key = 'font-kerking';
    var value = prp([kerning]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontSize_jn53nw$ = function (size) {
    var $receiver = this.props;
    var key = 'font-size';
    var value = prp([size]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontSize_l5dsl4$ = function (size) {
    var $receiver = this.props;
    var key = 'font-size';
    var value = prp([size]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontSizeAdjust_14dthe$ = function (number) {
    var $receiver = this.props;
    var key = 'font-size-adjust';
    var value = prp([new CssProperty(number.toString())]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontSizeAdjust_rfkyqr$ = function (adjust) {
    var $receiver = this.props;
    var key = 'font-size-adjust';
    var value = prp([adjust]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontStretch_lpsr2m$ = function (stretch) {
    var $receiver = this.props;
    var key = 'font-stretch';
    var value = prp([stretch]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontStyle_uctcke$ = function (style) {
    var $receiver = this.props;
    var key = 'font-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontVariant_dblg8i$ = function (variant) {
    var $receiver = this.props;
    var key = 'font-variant';
    var value = prp([variant]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontVariantCaps_hgzatp$ = function (caps) {
    var $receiver = this.props;
    var key = 'font-variant-caps';
    var value = prp([caps]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.fontWeight_jagd7v$ = function (weight) {
    var $receiver = this.props;
    var key = 'font-weight';
    var value = prp([weight]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.grid_61zpoe$ = function (grid) {
    var $receiver = this.props;
    var value = prp_0([grid]);
    $receiver.put_xwzc9p$('grid', value);
  };
  Style.prototype.gridArea_61zpoe$ = function (area) {
    var $receiver = this.props;
    var key = 'grid-area';
    var value = prp_0([area]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridAutoColumns_kfrwdj$ = function (columns) {
    var $receiver = this.props;
    var key = 'grid-auto-columns';
    var value = prp([columns]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridAutoFlow_kfow88$ = function (flow) {
    var $receiver = this.props;
    var key = 'grid-auto-flow';
    var value = prp([flow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridAutoRows_kfrwdj$ = function (autoRows) {
    var $receiver = this.props;
    var key = 'grid-auto-rows';
    var value = prp([autoRows]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridAutoRows_l5dsl4$ = function (size) {
    var $receiver = this.props;
    var key = 'grid-auto-rows';
    var value = prp([size]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridColumn_y7zr0s$ = function (start, end) {
    var $receiver = this.props;
    var key = 'grid-column';
    var value = prp([new CssProperty(start.css() + '/' + end.css())]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridColumnEnd_606d53$ = function (end) {
    var $receiver = this.props;
    var key = 'grid-column-end';
    var value = prp([end]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridColumnGap_606d53$ = function (gap) {
    var $receiver = this.props;
    var key = 'grid-column-gap';
    var value = prp([gap]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridColumnStart_606d53$ = function (start) {
    var $receiver = this.props;
    var key = 'grid-column-start';
    var value = prp([start]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridGap_xih1kc$ = function (rowGap, columnGap) {
    if (rowGap === void 0)
      rowGap = Measurement$Companion_getInstance().px_za3lpa$(0);
    if (columnGap === void 0)
      columnGap = Measurement$Companion_getInstance().px_za3lpa$(0);
    var $receiver = this.props;
    var key = 'grid-gap';
    var value = prp([rowGap, columnGap]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridRow_y7zr0s$ = function (start, end) {
    var $receiver = this.props;
    var key = 'grid-row';
    var value = prp([new CssProperty(start.css() + '/' + end.css())]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridRowEnd_606d53$ = function (end) {
    var $receiver = this.props;
    var key = 'grid-row-end';
    var value = prp([end]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridRowGap_606d53$ = function (gap) {
    var $receiver = this.props;
    var key = 'grid-row-end';
    var value = prp([gap]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridRowStart_606d53$ = function (start) {
    var $receiver = this.props;
    var key = 'grid-row-start';
    var value = prp([start]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplate_61zpoe$ = function (template) {
    var $receiver = this.props;
    var key = 'grid-template';
    var value = prp_0([template]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplateAreas_61zpoe$ = function (template) {
    var $receiver = this.props;
    var key = 'grid-template-areas';
    var value = prp_0([template]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplateColumn_u7ang9$ = function (columns) {
    var $receiver = this.props;
    var key = 'grid-template-columns';
    var value = prp(columns.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplateColumns_u7ang9$ = function (columns) {
    var $receiver = this.props;
    var key = 'grid-template-columns';
    var value = prp(columns.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplateColumns_uwoyv5$ = function (columns) {
    var $receiver = this.props;
    var key = 'grid-template-columns';
    var value = prp(columns.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplateRows_u7ang9$ = function (rows) {
    var $receiver = this.props;
    var key = 'grid-template-rows';
    var value = prp(rows.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.gridTemplateRows_uwoyv5$ = function (rows) {
    var $receiver = this.props;
    var key = 'grid-template-rows';
    var value = prp(rows.slice());
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.hangingPunctuation_3yerxy$ = function (punctuation) {
    var $receiver = this.props;
    var key = 'hanging-punctuation';
    var value = prp([punctuation]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.height_l5dsl4$ = function (height) {
    var $receiver = this.props;
    var value = prp([height]);
    $receiver.put_xwzc9p$('height', value);
  };
  Style.prototype.hyphens_qlv8ot$ = function (hyphens) {
    var $receiver = this.props;
    var value = prp([hyphens]);
    $receiver.put_xwzc9p$('hyphens', value);
  };
  Style.prototype.import_8xi0to$ = function (style) {
    style(this);
  };
  Style.prototype.isolation_3yerxy$ = function (isolation) {
    var $receiver = this.props;
    var key = 'isolation';
    var value = prp([isolation]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.justifyContent_ezha7n$ = function (content) {
    var $receiver = this.props;
    var key = 'justify-content';
    var value = prp([content]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.keyFrames_oygzg2$ = function (animationName, frames) {
    var frameCss = new KeyFrames();
    frames(frameCss);
    this.keyFrames.put_xwzc9p$(animationName, frameCss);
  };
  Style.prototype.left_l5dsl4$ = function (left) {
    var $receiver = this.props;
    var value = prp([left]);
    $receiver.put_xwzc9p$('left', value);
  };
  Style.prototype.letterSpacing_l5dsl4$ = function (length) {
    var $receiver = this.props;
    var key = 'letter-spacing';
    var value = prp([length]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.letterSpacing_hebxq1$ = function (spacing) {
    var $receiver = this.props;
    var key = 'letter-spacing';
    var value = prp([spacing]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.lineHeight_14dthe$ = function (number) {
    var $receiver = this.props;
    var key = 'line-height';
    var value = prp_0([number.toString()]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.lineHeight_l5dsl4$ = function (measurement) {
    var $receiver = this.props;
    var key = 'line-height';
    var value = prp([measurement]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.lineHeight_mwm5xb$ = function (height) {
    var $receiver = this.props;
    var key = 'line-height';
    var value = prp([height]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.listStyle_61zpoe$ = function (style) {
    var $receiver = this.props;
    var key = 'list-style';
    var value = prp_0([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.listStyleImage_61zpoe$ = function (url) {
    var $receiver = this.props;
    var key = 'list-style-image';
    var value = prp_0(["url('" + url + "')"]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.listStylePosition_8kbmt4$ = function (position) {
    var $receiver = this.props;
    var key = 'list-style-position';
    var value = prp([position]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.listStyleType_97r5j$ = function (position) {
    var $receiver = this.props;
    var key = 'list-style-type';
    var value = prp([position]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.margin_l5dsl4$ = function (all) {
    var $receiver = this.props;
    var value = prp([all]);
    $receiver.put_xwzc9p$('margin', value);
  };
  Style.prototype.margin_xih1kc$ = function (topBottom, leftRight) {
    var $receiver = this.props;
    var value = prp([topBottom, leftRight]);
    $receiver.put_xwzc9p$('margin', value);
  };
  Style.prototype.margin_z703mc$ = function (top, right, bottom, left) {
    var $receiver = this.props;
    var value = prp([top, right, bottom, left]);
    $receiver.put_xwzc9p$('margin', value);
  };
  Style.prototype.marginBottom_l5dsl4$ = function (bottom) {
    var $receiver = this.props;
    var key = 'margin-bottom';
    var value = prp([bottom]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.marginLeft_l5dsl4$ = function (left) {
    var $receiver = this.props;
    var key = 'margin-left';
    var value = prp([left]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.marginRight_l5dsl4$ = function (right) {
    var $receiver = this.props;
    var key = 'margin-right';
    var value = prp([right]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.marginTop_l5dsl4$ = function (top) {
    var $receiver = this.props;
    var key = 'margin-top';
    var value = prp([top]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.maxHeight_l5dsl4$ = function (height) {
    var $receiver = this.props;
    var key = 'max-height';
    var value = prp([height]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.maxWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'max-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.minHeight_l5dsl4$ = function (height) {
    var $receiver = this.props;
    var key = 'min-height';
    var value = prp([height]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.minWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'min-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.mixBlendMode_b164h0$ = function (blendMode) {
    var $receiver = this.props;
    var key = 'mix-blend-mode';
    var value = prp([blendMode]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.objectFit_vdbq8e$ = function (fit) {
    var $receiver = this.props;
    var key = 'object-fit';
    var value = prp([fit]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.objectPosition_61zpoe$ = function (position) {
    var $receiver = this.props;
    var key = 'object-position';
    var value = prp_0([position]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.opacity_14dthe$ = function (opacity) {
    var $receiver = this.props;
    var value = prp_0([opacity.toString()]);
    $receiver.put_xwzc9p$('opacity', value);
  };
  Style.prototype.opacity_ab89cr$ = function (opacity) {
    var $receiver = this.props;
    var value = prp_0([opacity.toString()]);
    $receiver.put_xwzc9p$('opacity', value);
  };
  Style.prototype.order_za3lpa$ = function (order) {
    var $receiver = this.props;
    var value = prp_0([order.toString()]);
    $receiver.put_xwzc9p$('order', value);
  };
  Style.prototype.order_ab89cr$ = function (order) {
    var $receiver = this.props;
    var value = prp([order]);
    $receiver.put_xwzc9p$('order', value);
  };
  Style.prototype.outline_61zpoe$ = function (outline) {
    var $receiver = this.props;
    var value = prp_0([outline]);
    $receiver.put_xwzc9p$('outline', value);
  };
  Style.prototype.outlineColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'outline-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.outlineOffset_l5dsl4$ = function (offset) {
    var $receiver = this.props;
    var key = 'outline-offset';
    var value = prp([offset]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.outlineStyle_7p6pjz$ = function (style) {
    var $receiver = this.props;
    var key = 'outline-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.outlineWidth_1zckd4$ = function (width) {
    var $receiver = this.props;
    var key = 'outline-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.outlineWidth_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var key = 'outline-width';
    var value = prp([width]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.overflow_gxh4fu$ = function (overflow) {
    var $receiver = this.props;
    var key = 'overflow';
    var value = prp([overflow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.overflowX_gxh4fu$ = function (overflow) {
    var $receiver = this.props;
    var key = 'overflow-x';
    var value = prp([overflow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.overflowY_gxh4fu$ = function (overflow) {
    var $receiver = this.props;
    var key = 'overflow-y';
    var value = prp([overflow]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.padding_l5dsl4$ = function (padding) {
    var $receiver = this.props;
    var value = prp([padding]);
    $receiver.put_xwzc9p$('padding', value);
  };
  Style.prototype.padding_xih1kc$ = function (vertical, horizontal) {
    var $receiver = this.props;
    var value = prp([vertical, horizontal]);
    $receiver.put_xwzc9p$('padding', value);
  };
  Style.prototype.padding_z703mc$ = function (top, right, bottom, left) {
    var $receiver = this.props;
    var value = prp([top, right, bottom, left]);
    $receiver.put_xwzc9p$('padding', value);
  };
  Style.prototype.padding_ab89cr$ = function (padding) {
    var $receiver = this.props;
    var value = prp([padding]);
    $receiver.put_xwzc9p$('padding', value);
  };
  Style.prototype.paddingBottom_l5dsl4$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-bottom';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingBottom_ab89cr$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-bottom';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingLeft_l5dsl4$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-left';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingLeft_ab89cr$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-left';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingRight_l5dsl4$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-right';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingRight_ab89cr$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-right';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingTop_l5dsl4$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-top';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.paddingTop_ab89cr$ = function (padding) {
    var $receiver = this.props;
    var key = 'padding-top';
    var value = prp([padding]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.pageBreakAfter_unf2s$ = function (pageBreak) {
    var $receiver = this.props;
    var key = 'page-break-after';
    var value = prp([pageBreak]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.pageBreakBefore_unf2s$ = function (pageBreak) {
    var $receiver = this.props;
    var key = 'page-break-before';
    var value = prp([pageBreak]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.pageBreakInside_unf2s$ = function (pageBreak) {
    var $receiver = this.props;
    var key = 'page-break-inside';
    var value = prp([pageBreak]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.perspective_l5dsl4$ = function (length) {
    var $receiver = this.props;
    var key = 'perspective';
    var value = prp([length]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.perspective_ggmc20$ = function (perspective) {
    var $receiver = this.props;
    var key = 'perspective';
    var value = prp([perspective]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.perspectiveOrigin_61zpoe$ = function (po) {
    var $receiver = this.props;
    var key = 'perspective-origin';
    var value = prp_0([po]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.pointerEvents_mdad5a$ = function (pe) {
    var $receiver = this.props;
    var key = 'pointer-events';
    var value = prp([pe]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.position_dbl577$ = function (poition) {
    var $receiver = this.props;
    var key = 'position';
    var value = prp([poition]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.quotes_61zpoe$ = function (value) {
    var $receiver = this.props;
    var value_0 = prp_0([value]);
    $receiver.put_xwzc9p$('quotes', value_0);
  };
  Style.prototype.resize_ar07bc$ = function (resize) {
    var $receiver = this.props;
    var value = prp([resize]);
    $receiver.put_xwzc9p$('resize', value);
  };
  Style.prototype.right_l5dsl4$ = function (right) {
    var $receiver = this.props;
    var value = prp([right]);
    $receiver.put_xwzc9p$('right', value);
  };
  Style.prototype.scrollBehavior_186dtv$ = function (sb) {
    var $receiver = this.props;
    var key = 'scroll-behavior';
    var value = prp([sb]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.tabSize_za3lpa$ = function (number) {
    var $receiver = this.props;
    var key = 'tab-size';
    var value = prp_0([number.toString()]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.tabSize_l5dsl4$ = function (length) {
    var $receiver = this.props;
    var key = 'tab-size';
    var value = prp([length]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.tabSize_ab89cr$ = function (ts) {
    var $receiver = this.props;
    var key = 'tab-size';
    var value = prp([ts]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.tableLayout_j54zzg$ = function (tl) {
    var $receiver = this.props;
    var key = 'table-layout';
    var value = prp([tl]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textAlign_wna7l8$ = function (ta) {
    var $receiver = this.props;
    var key = 'text-align';
    var value = prp([ta]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textAlignLast_g92eve$ = function (tal) {
    var $receiver = this.props;
    var key = 'text-align-last';
    var value = prp([tal]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textDecoration_61zpoe$ = function (decoration) {
    var $receiver = this.props;
    var key = 'text-decoration';
    var value = prp_0([decoration]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textDecorationColor_9qian5$ = function (color) {
    var $receiver = this.props;
    var key = 'text-decoration-color';
    var value = prp([color]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textDecorationLine_asnzpx$ = function (tdc) {
    var $receiver = this.props;
    var key = 'text-decoration-line';
    var value = prp([tdc]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textDecorationStyle_kcup5c$ = function (tds) {
    var $receiver = this.props;
    var key = 'text-decoration-style';
    var value = prp([tds]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textIndent_l5dsl4$ = function (length) {
    var $receiver = this.props;
    var key = 'text-indent';
    var value = prp([length]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textIndent_ab89cr$ = function (indent) {
    var $receiver = this.props;
    var key = 'text-indent';
    var value = prp([indent]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textJustify_gkowrj$ = function (tj) {
    var $receiver = this.props;
    var key = 'text-justify';
    var value = prp([tj]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textOverflow_61zpoe$ = function (to) {
    var $receiver = this.props;
    var key = 'text-overflow';
    var value = prp_0([to]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textShadow_61zpoe$ = function (ts) {
    var $receiver = this.props;
    var key = 'text-shadow';
    var value = prp_0([ts]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.textTransform_4fu60r$ = function (tt) {
    var $receiver = this.props;
    var key = 'text-transform';
    var value = prp([tt]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.top_l5dsl4$ = function (top) {
    var $receiver = this.props;
    var value = prp([top]);
    $receiver.put_xwzc9p$('top', value);
  };
  Style.prototype.transform_2dtp60$ = function (transform) {
    var $receiver = this.props;
    var key = 'transform';
    var value = prp([transform]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transformOrigin_61zpoe$ = function (origin) {
    var $receiver = this.props;
    var key = 'transform-origin';
    var value = prp_0([origin]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transformStyle_2krs47$ = function (style) {
    var $receiver = this.props;
    var key = 'transform-style';
    var value = prp([style]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transition_61zpoe$ = function (transition) {
    var $receiver = this.props;
    var key = 'transition';
    var value = prp_0([transition]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionDelay_14dthe$ = function (timeInSeconds) {
    var $receiver = this.props;
    var key = 'transition-delay';
    var value = prp_0([timeInSeconds.toString() + 's']);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionDelay_za3lpa$ = function (timeInMillis) {
    var $receiver = this.props;
    var key = 'transition-delay';
    var value = prp_0([timeInMillis.toString() + 'ms']);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionDelay_2ipz0t$ = function (delay) {
    var $receiver = this.props;
    var key = 'transition-delay';
    var value = prp([delay]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionDuration_14dthe$ = function (timeInSeconds) {
    var $receiver = this.props;
    var key = 'transition-duration';
    var value = prp_0([timeInSeconds.toString() + 's']);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionDuration_za3lpa$ = function (timeInMillis) {
    var $receiver = this.props;
    var key = 'transition-duration';
    var value = prp_0([timeInMillis.toString() + 'ms']);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionDuration_2ipz0t$ = function (td) {
    var $receiver = this.props;
    var key = 'transition-duration';
    var value = prp([td]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionProperty_61zpoe$ = function (property) {
    var $receiver = this.props;
    var key = 'transition-property';
    var value = prp_0([property]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.transitionTimingFunction_bxb81m$ = function (function_0) {
    var $receiver = this.props;
    var key = 'transition-timing-function';
    var value = prp([function_0]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.unicodeBidi_olk4w5$ = function (ub) {
    var $receiver = this.props;
    var key = 'unicode-bidi';
    var value = prp([ub]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.userSelect_dhuc5x$ = function (us) {
    var $receiver = this.props;
    var key = 'user-select';
    var value = prp([us]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.verticalAlign_l5dsl4$ = function (length) {
    var $receiver = this.props;
    var key = 'vertical-align';
    var value = prp([length]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.verticalAlign_ynw6sr$ = function (va) {
    var $receiver = this.props;
    var key = 'vertical-align';
    var value = prp([va]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.visibility_7hkucq$ = function (visibility) {
    var $receiver = this.props;
    var key = 'visibility';
    var value = prp([visibility]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.whiteSpace_zi4ktb$ = function (whiteSpace) {
    var $receiver = this.props;
    var key = 'white-space';
    var value = prp([whiteSpace]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.width_l5dsl4$ = function (width) {
    var $receiver = this.props;
    var value = prp([width]);
    $receiver.put_xwzc9p$('width', value);
  };
  Style.prototype.wordBreak_qxpkf$ = function (wordBreak) {
    var $receiver = this.props;
    var key = 'word-break';
    var value = prp([wordBreak]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.wordSpacing_l5dsl4$ = function (wordSpacing) {
    var $receiver = this.props;
    var key = 'word-spacing';
    var value = prp([wordSpacing]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.wordSpacing_qoeln9$ = function (wordSpacing) {
    var $receiver = this.props;
    var key = 'word-spacing';
    var value = prp([wordSpacing]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.wordWrap_p7uxc8$ = function (wordWrap) {
    var $receiver = this.props;
    var key = 'word-wrap';
    var value = prp([wordWrap]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.writingMode_3p9hwb$ = function (writingMode) {
    var $receiver = this.props;
    var key = 'writing-mode';
    var value = prp([writingMode]);
    $receiver.put_xwzc9p$(key, value);
  };
  Style.prototype.zIndex_za3lpa$ = function (zIndex) {
    var $receiver = this.props;
    var value = prp_0([zIndex.toString()]);
    $receiver.put_xwzc9p$('z-index', value);
  };
  Style.prototype.zIndex_7e4rwk$ = function (zIndex) {
    var $receiver = this.props;
    var value = prp([zIndex]);
    $receiver.put_xwzc9p$('z-index', value);
  };
  Style.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Style',
    interfaces: [CssGenerator]
  };
  function ConditionalStyle() {
    Style.call(this);
    this.media = LinkedHashMap_init();
    this.supports = LinkedHashMap_init();
  }
  ConditionalStyle.prototype.media_amfabu$ = function (definition, style) {
    this.media.put_xwzc9p$(definition, style);
  };
  ConditionalStyle.prototype.supports_amfabu$ = function (query, style) {
    this.supports.put_xwzc9p$(query, style);
  };
  ConditionalStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConditionalStyle',
    interfaces: [Style]
  };
  function Validator() {
  }
  Validator.prototype.validate_pen8qx$ = function (properties) {
    return true;
  };
  Validator.prototype.getMessage_61zpoe$ = function (name) {
    return "'" + name + "' validation message not defined for " + this;
  };
  Validator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Validator',
    interfaces: []
  };
  function MaxCountValidator(number) {
    Validator.call(this);
    this.number = number;
  }
  MaxCountValidator.prototype.validate_pen8qx$ = function (property) {
    return property.size <= this.number;
  };
  MaxCountValidator.prototype.getMessage_61zpoe$ = function (name) {
    return "'" + name + "' should not have more than 4 entries";
  };
  MaxCountValidator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MaxCountValidator',
    interfaces: [Validator]
  };
  function InitialInheritSingleValue() {
    Validator.call(this);
  }
  InitialInheritSingleValue.prototype.validate_pen8qx$ = function (properties) {
    var tmp$;
    tmp$ = properties.iterator();
    while (tmp$.hasNext()) {
      var prop = tmp$.next();
      if (equals(prop.css(), 'initial') || equals(prop.css(), 'inherit')) {
        return properties.size === 1;
      }}
    return true;
  };
  InitialInheritSingleValue.prototype.getMessage_61zpoe$ = function (name) {
    return "'" + name + "' can only have single value when 'initial' or 'inherit'";
  };
  InitialInheritSingleValue.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InitialInheritSingleValue',
    interfaces: [Validator]
  };
  var package$nl = _.nl || (_.nl = {});
  var package$astraeus = package$nl.astraeus || (package$nl.astraeus = {});
  var package$css = package$astraeus.css || (package$astraeus.css = {});
  package$css.css_8xi0to$ = css;
  package$css.style_rgk2wo$ = style;
  package$css.CssBuilder = CssBuilder;
  Object.defineProperty(AlignContent, 'Companion', {
    get: AlignContent$Companion_getInstance
  });
  var package$properties = package$css.properties || (package$css.properties = {});
  package$properties.AlignContent = AlignContent;
  Object.defineProperty(AlignItems, 'Companion', {
    get: AlignItems$Companion_getInstance
  });
  package$properties.AlignItems = AlignItems;
  Object.defineProperty(AlignSelf, 'Companion', {
    get: AlignSelf$Companion_getInstance
  });
  package$properties.AlignSelf = AlignSelf;
  Object.defineProperty(All, 'Companion', {
    get: All$Companion_getInstance
  });
  package$properties.All = All;
  Object.defineProperty(AnimationDirection, 'Companion', {
    get: AnimationDirection$Companion_getInstance
  });
  package$properties.AnimationDirection = AnimationDirection;
  Object.defineProperty(AnimationFillMode, 'Companion', {
    get: AnimationFillMode$Companion_getInstance
  });
  package$properties.AnimationFillMode = AnimationFillMode;
  Object.defineProperty(AnimationFrame, 'Companion', {
    get: AnimationFrame$Companion_getInstance
  });
  package$properties.AnimationFrame = AnimationFrame;
  Object.defineProperty(AnimationPlayState, 'Companion', {
    get: AnimationPlayState$Companion_getInstance
  });
  package$properties.AnimationPlayState = AnimationPlayState;
  Object.defineProperty(BackfaceVisibility, 'Companion', {
    get: BackfaceVisibility$Companion_getInstance
  });
  package$properties.BackfaceVisibility = BackfaceVisibility;
  Object.defineProperty(BackgroundAttachment, 'Companion', {
    get: BackgroundAttachment$Companion_getInstance
  });
  package$properties.BackgroundAttachment = BackgroundAttachment;
  Object.defineProperty(BackgroundBlendMode, 'Companion', {
    get: BackgroundBlendMode$Companion_getInstance
  });
  package$properties.BackgroundBlendMode = BackgroundBlendMode;
  Object.defineProperty(BackgroundPosition, 'Companion', {
    get: BackgroundPosition$Companion_getInstance
  });
  package$properties.BackgroundPosition = BackgroundPosition;
  Object.defineProperty(BackgroundRepeat, 'Companion', {
    get: BackgroundRepeat$Companion_getInstance
  });
  package$properties.BackgroundRepeat = BackgroundRepeat;
  Object.defineProperty(BackgroundSize, 'Companion', {
    get: BackgroundSize$Companion_getInstance
  });
  package$properties.BackgroundSize = BackgroundSize;
  Object.defineProperty(BorderStyle, 'Companion', {
    get: BorderStyle$Companion_getInstance
  });
  package$properties.BorderStyle = BorderStyle;
  Object.defineProperty(BorderWidth, 'Companion', {
    get: BorderWidth$Companion_getInstance
  });
  package$properties.BorderWidth = BorderWidth;
  Object.defineProperty(BorderCollapse, 'Companion', {
    get: BorderCollapse$Companion_getInstance
  });
  package$properties.BorderCollapse = BorderCollapse;
  Object.defineProperty(BorderImageWidth, 'Companion', {
    get: BorderImageWidth$Companion_getInstance
  });
  package$properties.BorderImageWidth = BorderImageWidth;
  Object.defineProperty(BorderSpacing, 'Companion', {
    get: BorderSpacing$Companion_getInstance
  });
  package$properties.BorderSpacing = BorderSpacing;
  Object.defineProperty(BoxDecorationBreak, 'Companion', {
    get: BoxDecorationBreak$Companion_getInstance
  });
  package$properties.BoxDecorationBreak = BoxDecorationBreak;
  Object.defineProperty(BoxShadow, 'Companion', {
    get: BoxShadow$Companion_getInstance
  });
  package$properties.BoxShadow = BoxShadow;
  Object.defineProperty(BoxSizing, 'Companion', {
    get: BoxSizing$Companion_getInstance
  });
  package$properties.BoxSizing = BoxSizing;
  Object.defineProperty(Break, 'Companion', {
    get: Break$Companion_getInstance
  });
  package$properties.Break = Break;
  Object.defineProperty(CaptionSide, 'Companion', {
    get: CaptionSide$Companion_getInstance
  });
  package$properties.CaptionSide = CaptionSide;
  Object.defineProperty(Clear, 'Companion', {
    get: Clear$Companion_getInstance
  });
  package$properties.Clear = Clear;
  Object.defineProperty(Clip, 'Companion', {
    get: Clip$Companion_getInstance
  });
  package$properties.Clip = Clip;
  Object.defineProperty(ClipPath, 'Companion', {
    get: ClipPath$Companion_getInstance
  });
  package$properties.ClipPath = ClipPath;
  Object.defineProperty(ClipOrigin, 'Companion', {
    get: ClipOrigin$Companion_getInstance
  });
  package$properties.ClipOrigin = ClipOrigin;
  Color.RGBA = Color$RGBA;
  Color.HSLA = Color$HSLA;
  Object.defineProperty(Color, 'Companion', {
    get: Color$Companion_getInstance
  });
  package$properties.Color = Color;
  package$properties.hex_za3lpa$ = hex;
  package$properties.rgb_qt1dr2$ = rgb;
  package$properties.rgba_gb4hak$ = rgba;
  package$properties.hsl_qt1dr2$ = hsl;
  package$properties.hsla_gb4hak$ = hsla;
  package$properties.blackAlpha_14dthe$ = blackAlpha;
  package$properties.whiteAlpha_14dthe$ = whiteAlpha;
  Object.defineProperty(Length, 'Companion', {
    get: Length$Companion_getInstance
  });
  package$properties.Length = Length;
  Object.defineProperty(Fill, 'Companion', {
    get: Fill$Companion_getInstance
  });
  package$properties.Fill = Fill;
  Object.defineProperty(Content, 'Companion', {
    get: Content$Companion_getInstance
  });
  package$properties.Content = Content;
  Object.defineProperty(Count, 'Companion', {
    get: Count$Companion_getInstance
  });
  package$properties.Count = Count;
  Object.defineProperty(CssFloat, 'Companion', {
    get: CssFloat$Companion_getInstance
  });
  package$properties.CssFloat = CssFloat;
  package$properties.CssValue = CssValue;
  package$properties.CssProperty = CssProperty;
  package$properties.text_61zpoe$ = text;
  package$properties.TextProperty = TextProperty;
  Object.defineProperty(DelayDuration, 'Companion', {
    get: DelayDuration$Companion_getInstance
  });
  package$properties.DelayDuration = DelayDuration;
  Object.defineProperty(Direction, 'Companion', {
    get: Direction$Companion_getInstance
  });
  package$properties.Direction = Direction;
  Object.defineProperty(Display, 'Companion', {
    get: Display$Companion_getInstance
  });
  package$properties.Display = Display;
  Object.defineProperty(EmptyCells, 'Companion', {
    get: EmptyCells$Companion_getInstance
  });
  package$properties.EmptyCells = EmptyCells;
  Object.defineProperty(FlexDirection, 'Companion', {
    get: FlexDirection$Companion_getInstance
  });
  package$properties.FlexDirection = FlexDirection;
  Object.defineProperty(FlexGrowShrink, 'Companion', {
    get: FlexGrowShrink$Companion_getInstance
  });
  package$properties.FlexGrowShrink = FlexGrowShrink;
  Object.defineProperty(FlexWrap, 'Companion', {
    get: FlexWrap$Companion_getInstance
  });
  package$properties.FlexWrap = FlexWrap;
  Object.defineProperty(FontSize, 'Companion', {
    get: FontSize$Companion_getInstance
  });
  package$properties.FontSize = FontSize;
  Object.defineProperty(FontStretch, 'Companion', {
    get: FontStretch$Companion_getInstance
  });
  package$properties.FontStretch = FontStretch;
  Object.defineProperty(FontStyle, 'Companion', {
    get: FontStyle$Companion_getInstance
  });
  package$properties.FontStyle = FontStyle;
  Object.defineProperty(FontWeight, 'Companion', {
    get: FontWeight$Companion_getInstance
  });
  package$properties.FontWeight = FontWeight;
  Object.defineProperty(FontKerning, 'Companion', {
    get: FontKerning$Companion_getInstance
  });
  package$properties.FontKerning = FontKerning;
  Object.defineProperty(FontSizeAdjust, 'Companion', {
    get: FontSizeAdjust$Companion_getInstance
  });
  package$properties.FontSizeAdjust = FontSizeAdjust;
  Object.defineProperty(FontVariant, 'Companion', {
    get: FontVariant$Companion_getInstance
  });
  package$properties.FontVariant = FontVariant;
  Object.defineProperty(FontVariantCaps, 'Companion', {
    get: FontVariantCaps$Companion_getInstance
  });
  package$properties.FontVariantCaps = FontVariantCaps;
  Object.defineProperty(Grid, 'Companion', {
    get: Grid$Companion_getInstance
  });
  package$properties.Grid = Grid;
  Object.defineProperty(GridAuto, 'Companion', {
    get: GridAuto$Companion_getInstance
  });
  package$properties.GridAuto = GridAuto;
  Object.defineProperty(GridFlow, 'Companion', {
    get: GridFlow$Companion_getInstance
  });
  package$properties.GridFlow = GridFlow;
  Object.defineProperty(GridValue, 'Companion', {
    get: GridValue$Companion_getInstance
  });
  package$properties.GridValue = GridValue;
  Object.defineProperty(TemplateRowColumn, 'Companion', {
    get: TemplateRowColumn$Companion_getInstance
  });
  package$properties.TemplateRowColumn = TemplateRowColumn;
  Object.defineProperty(Hyphens, 'Companion', {
    get: Hyphens$Companion_getInstance
  });
  package$properties.Hyphens = Hyphens;
  Object.defineProperty(Image, 'Companion', {
    get: Image$Companion_getInstance
  });
  package$properties.Image = Image;
  Object.defineProperty(ImageRepeat, 'Companion', {
    get: ImageRepeat$Companion_getInstance
  });
  package$properties.ImageRepeat = ImageRepeat;
  Object.defineProperty(ImageSlice, 'Companion', {
    get: ImageSlice$Companion_getInstance
  });
  package$properties.ImageSlice = ImageSlice;
  Object.defineProperty(ImageSource, 'Companion', {
    get: ImageSource$Companion_getInstance
  });
  package$properties.ImageSource = ImageSource;
  Object.defineProperty(InitialInherit, 'Companion', {
    get: InitialInherit$Companion_getInstance
  });
  package$properties.InitialInherit = InitialInherit;
  Object.defineProperty(Isolation, 'Companion', {
    get: Isolation$Companion_getInstance
  });
  package$properties.Isolation = Isolation;
  Object.defineProperty(JustifyContent, 'Companion', {
    get: JustifyContent$Companion_getInstance
  });
  package$properties.JustifyContent = JustifyContent;
  Object.defineProperty(LetterSpacing, 'Companion', {
    get: LetterSpacing$Companion_getInstance
  });
  package$properties.LetterSpacing = LetterSpacing;
  Object.defineProperty(ListStylePosition, 'Companion', {
    get: ListStylePosition$Companion_getInstance
  });
  package$properties.ListStylePosition = ListStylePosition;
  Object.defineProperty(ListStyleType, 'Companion', {
    get: ListStyleType$Companion_getInstance
  });
  package$properties.ListStyleType = ListStyleType;
  Object.defineProperty(MeasurementUoM, 'NONE', {
    get: MeasurementUoM$NONE_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'PX', {
    get: MeasurementUoM$PX_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'EM', {
    get: MeasurementUoM$EM_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'REL', {
    get: MeasurementUoM$REL_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'REM', {
    get: MeasurementUoM$REM_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'PC', {
    get: MeasurementUoM$PC_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'PRC', {
    get: MeasurementUoM$PRC_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'CM', {
    get: MeasurementUoM$CM_getInstance
  });
  Object.defineProperty(MeasurementUoM, 'FR', {
    get: MeasurementUoM$FR_getInstance
  });
  package$properties.MeasurementUoM = MeasurementUoM;
  Object.defineProperty(Measurement, 'Companion', {
    get: Measurement$Companion_getInstance
  });
  package$properties.Measurement = Measurement;
  package$properties.get_px_s8ev3n$ = get_px;
  package$properties.get_em_s8ev3n$ = get_em;
  package$properties.get_rem_s8ev3n$ = get_rem;
  package$properties.get_prc_s8ev3n$ = get_prc;
  package$properties.get_pc_s8ev3n$ = get_pc;
  package$properties.get_cm_s8ev3n$ = get_cm;
  package$properties.get_fr_s8ev3n$ = get_fr;
  package$properties.px_s8ev3n$ = px;
  package$properties.get_px_yrwdxr$ = get_px_0;
  package$properties.get_em_yrwdxr$ = get_em_0;
  package$properties.get_rem_yrwdxr$ = get_rem_0;
  package$properties.get_prc_yrwdxr$ = get_prc_0;
  package$properties.get_pc_yrwdxr$ = get_pc_0;
  package$properties.get_cm_yrwdxr$ = get_cm_0;
  package$properties.px_yrwdxr$ = px_0;
  Object.defineProperty(LineHeight, 'Companion', {
    get: LineHeight$Companion_getInstance
  });
  package$properties.LineHeight = LineHeight;
  Object.defineProperty(MixBlendMode, 'Companion', {
    get: MixBlendMode$Companion_getInstance
  });
  package$properties.MixBlendMode = MixBlendMode;
  Object.defineProperty(ObjectFit, 'Companion', {
    get: ObjectFit$Companion_getInstance
  });
  package$properties.ObjectFit = ObjectFit;
  Object.defineProperty(OutlineWidth, 'Companion', {
    get: OutlineWidth$Companion_getInstance
  });
  package$properties.OutlineWidth = OutlineWidth;
  Object.defineProperty(Overflow, 'Companion', {
    get: Overflow$Companion_getInstance
  });
  package$properties.Overflow = Overflow;
  Object.defineProperty(PageBreak, 'Companion', {
    get: PageBreak$Companion_getInstance
  });
  package$properties.PageBreak = PageBreak;
  Object.defineProperty(Perspective, 'Companion', {
    get: Perspective$Companion_getInstance
  });
  package$properties.Perspective = Perspective;
  Object.defineProperty(PointerEvents, 'Companion', {
    get: PointerEvents$Companion_getInstance
  });
  package$properties.PointerEvents = PointerEvents;
  Object.defineProperty(Position, 'Companion', {
    get: Position$Companion_getInstance
  });
  package$properties.Position = Position;
  Object.defineProperty(HangingPunctuation, 'Companion', {
    get: HangingPunctuation$Companion_getInstance
  });
  package$properties.HangingPunctuation = HangingPunctuation;
  Object.defineProperty(Resize, 'Companion', {
    get: Resize$Companion_getInstance
  });
  package$properties.Resize = Resize;
  Object.defineProperty(ScrollBehavior, 'Companion', {
    get: ScrollBehavior$Companion_getInstance
  });
  package$properties.ScrollBehavior = ScrollBehavior;
  Object.defineProperty(Span, 'Companion', {
    get: Span$Companion_getInstance
  });
  package$properties.Span = Span;
  Object.defineProperty(TableLayout, 'Companion', {
    get: TableLayout$Companion_getInstance
  });
  package$properties.TableLayout = TableLayout;
  Object.defineProperty(TextAlign, 'Companion', {
    get: TextAlign$Companion_getInstance
  });
  package$properties.TextAlign = TextAlign;
  Object.defineProperty(TextAlignLast, 'Companion', {
    get: TextAlignLast$Companion_getInstance
  });
  package$properties.TextAlignLast = TextAlignLast;
  Object.defineProperty(TextDecorationLine, 'Companion', {
    get: TextDecorationLine$Companion_getInstance
  });
  package$properties.TextDecorationLine = TextDecorationLine;
  Object.defineProperty(TextDecorationStyle, 'Companion', {
    get: TextDecorationStyle$Companion_getInstance
  });
  package$properties.TextDecorationStyle = TextDecorationStyle;
  Object.defineProperty(TextJustify, 'Companion', {
    get: TextJustify$Companion_getInstance
  });
  package$properties.TextJustify = TextJustify;
  Object.defineProperty(TextTransform, 'Companion', {
    get: TextTransform$Companion_getInstance
  });
  package$properties.TextTransform = TextTransform;
  Object.defineProperty(TimingFunction, 'Companion', {
    get: TimingFunction$Companion_getInstance
  });
  package$properties.TimingFunction = TimingFunction;
  Object.defineProperty(Transform, 'Companion', {
    get: Transform$Companion_getInstance
  });
  package$properties.Transform = Transform;
  Object.defineProperty(TransformStyle, 'Companion', {
    get: TransformStyle$Companion_getInstance
  });
  package$properties.TransformStyle = TransformStyle;
  Object.defineProperty(UnicodeBidi, 'Companion', {
    get: UnicodeBidi$Companion_getInstance
  });
  package$properties.UnicodeBidi = UnicodeBidi;
  Object.defineProperty(UserSelect, 'Companion', {
    get: UserSelect$Companion_getInstance
  });
  package$properties.UserSelect = UserSelect;
  Object.defineProperty(VerticalAlign, 'Companion', {
    get: VerticalAlign$Companion_getInstance
  });
  package$properties.VerticalAlign = VerticalAlign;
  Object.defineProperty(Visibility, 'Companion', {
    get: Visibility$Companion_getInstance
  });
  package$properties.Visibility = Visibility;
  Object.defineProperty(WhiteSpace, 'Companion', {
    get: WhiteSpace$Companion_getInstance
  });
  package$properties.WhiteSpace = WhiteSpace;
  Object.defineProperty(WordBreak, 'Companion', {
    get: WordBreak$Companion_getInstance
  });
  package$properties.WordBreak = WordBreak;
  Object.defineProperty(WordSpacing, 'Companion', {
    get: WordSpacing$Companion_getInstance
  });
  package$properties.WordSpacing = WordSpacing;
  Object.defineProperty(WordWrap, 'Companion', {
    get: WordWrap$Companion_getInstance
  });
  package$properties.WordWrap = WordWrap;
  Object.defineProperty(WritingMode, 'Companion', {
    get: WritingMode$Companion_getInstance
  });
  package$properties.WritingMode = WritingMode;
  Object.defineProperty(ZIndex, 'Companion', {
    get: ZIndex$Companion_getInstance
  });
  package$properties.ZIndex = ZIndex;
  var package$style = package$css.style || (package$css.style = {});
  package$style.CssBlock = CssBlock;
  Object.defineProperty(package$style, 'CssFunctions', {
    get: CssFunctions_getInstance
  });
  package$style.FontFace = FontFace;
  package$style.KeyFrames = KeyFrames;
  package$style.CssTagMarker = CssTagMarker;
  package$style.CssGenerator = CssGenerator;
  package$style.DescriptionProvider = DescriptionProvider;
  package$style.ValueDescriptionProvider = ValueDescriptionProvider;
  package$style.txt_61zpoe$ = txt;
  package$style.id_61zpoe$ = id;
  package$style.cls_61zpoe$ = cls;
  package$style.attr_61zpoe$ = attr;
  package$style.attrEquals_puj7f4$ = attrEquals;
  package$style.attrContains_puj7f4$ = attrContains;
  package$style.attrEntriesContain_puj7f4$ = attrEntriesContain;
  package$style.attrEndsWith_puj7f4$ = attrEndsWith;
  package$style.attrStartsWith_puj7f4$ = attrStartsWith;
  package$style.id_88kgjr$ = id_0;
  package$style.cls_88kgjr$ = cls_0;
  package$style.attr_88kgjr$ = attr_0;
  package$style.attrEquals_4ckl11$ = attrEquals_0;
  package$style.attrContains_4ckl11$ = attrContains_0;
  package$style.attrEntriesContain_4ckl11$ = attrEntriesContain_0;
  package$style.attrEndsWith_4ckl11$ = attrEndsWith_0;
  package$style.attrStartsWith_4ckl11$ = attrStartsWith_0;
  package$style.Style = Style;
  package$style.ConditionalStyle = ConditionalStyle;
  package$style.Validator = Validator;
  package$style.MaxCountValidator = MaxCountValidator;
  package$style.InitialInheritSingleValue = InitialInheritSingleValue;
  hexString = '0123456789abcdef';
  Kotlin.defineModule('kotlin-css-generator-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kotlin-css-generator-js-legacy.js.map
