/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.delegation.WrapperWithContext;

public class BiPredicateWithContext<IN1, IN2>
extends WrapperWithContext<BiPredicate<IN1, IN2>>
implements BiPredicate<IN1, IN2> {
    private static final Logger LOGGER = Logger.getLogger(BiPredicateWithContext.class.getName());

    public BiPredicateWithContext(ContextSnapshot snapshot, BiPredicate<IN1, IN2> delegate) {
        super(snapshot, delegate);
    }

    @Override
    public boolean test(IN1 in1, IN2 in2) {
        try (Context context = this.snapshot.reactivate();){
            LOGGER.log(Level.FINEST, "Delegating test method with {0} to {1}.", new Object[]{context, this.delegate()});
            boolean bl = ((BiPredicate)this.nonNullDelegate()).test(in1, in2);
            return bl;
        }
    }

    @Override
    public BiPredicate<IN1, IN2> and(BiPredicate<? super IN1, ? super IN2> other) {
        Objects.requireNonNull(other, "Cannot combine bi-predicate with 'and' <null>.");
        return (in1, in2) -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating 'and' method with {0} to {1}.", new Object[]{context, this.delegate()});
                boolean bl = ((BiPredicate)this.nonNullDelegate()).test(in1, in2) && other.test((IN1)in1, (IN2)in2);
                return bl;
            }
        };
    }

    @Override
    public BiPredicate<IN1, IN2> or(BiPredicate<? super IN1, ? super IN2> other) {
        Objects.requireNonNull(other, "Cannot combine bi-predicate with 'or' <null>.");
        return (in1, in2) -> {
            try (Context context = this.snapshot.reactivate();){
                LOGGER.log(Level.FINEST, "Delegating 'or' method with {0} to {1}.", new Object[]{context, this.delegate()});
                boolean bl = ((BiPredicate)this.nonNullDelegate()).test(in1, in2) || other.test((IN1)in1, (IN2)in2);
                return bl;
            }
        };
    }
}

