/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class BiFunctionWithContext<IN1, IN2, OUT>
extends WrapperWithContextAndConsumer<BiFunction<IN1, IN2, OUT>>
implements BiFunction<IN1, IN2, OUT> {
    private static final Logger LOGGER = Logger.getLogger(BiFunctionWithContext.class.getName());

    public BiFunctionWithContext(ContextSnapshot snapshot, BiFunction<IN1, IN2, OUT> delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public BiFunctionWithContext(ContextSnapshot snapshot, BiFunction<IN1, IN2, OUT> delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected BiFunctionWithContext(Supplier<ContextSnapshot> supplier, BiFunction<IN1, IN2, OUT> delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUT apply(IN1 in1, IN2 in2) {
        Throwable throwable = null;
        try (Context context = this.snapshot().reactivate();){
            Object r;
            try {
                LOGGER.log(Level.FINEST, "Delegating apply method with {0} to {1}.", new Object[]{context, this.delegate()});
                r = ((BiFunction)this.nonNullDelegate()).apply(in1, in2);
                this.consumer().ifPresent(consumer -> {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    consumer.accept(resultSnapshot);
                });
            }
            catch (Throwable throwable2) {
                try {
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            return (OUT)r;
        }
    }

    @Override
    public <V> BiFunction<IN1, IN2, V> andThen(Function<? super OUT, ? extends V> after) {
        Objects.requireNonNull(after, "Cannot post-process bi-function with after function <null>.");
        return (in1, in2) -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                    Object r = after.apply((OUT)((BiFunction)this.nonNullDelegate()).apply(in1, in2));
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    return r;
                }
                catch (Throwable throwable2) {
                    try {
                        this.consumer().ifPresent(consumer -> {
                            ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                            LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                            consumer.accept(resultSnapshot);
                        });
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        };
    }
}

