/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class PredicateWithContext<T>
extends WrapperWithContextAndConsumer<Predicate<T>>
implements Predicate<T> {
    private static final Logger LOGGER = Logger.getLogger(PredicateWithContext.class.getName());

    public PredicateWithContext(ContextSnapshot snapshot, Predicate<T> delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public PredicateWithContext(ContextSnapshot snapshot, Predicate<T> delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected PredicateWithContext(Supplier<ContextSnapshot> supplier, Predicate<T> delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(T t) {
        Throwable throwable = null;
        try (Context context = this.snapshot().reactivate();){
            try {
                LOGGER.log(Level.FINEST, "Delegating test method with {0} to {1}.", new Object[]{context, this.delegate()});
                boolean bl = ((Predicate)this.nonNullDelegate()).test(t);
                this.consumer().ifPresent(consumer -> {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    consumer.accept(resultSnapshot);
                });
                return bl;
            }
            catch (Throwable throwable2) {
                try {
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    @Override
    public Predicate<T> and(Predicate<? super T> other) {
        Objects.requireNonNull(other, "Cannot combine predicate with 'and' <null>.");
        return t -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating 'and' method with {0} to {1}.", new Object[]{context, this.delegate()});
                    boolean bl = ((Predicate)this.nonNullDelegate()).test(t) && other.test(t);
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    return bl;
                }
                catch (Throwable throwable2) {
                    try {
                        this.consumer().ifPresent(consumer -> {
                            ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                            LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                            consumer.accept(resultSnapshot);
                        });
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        };
    }

    @Override
    public Predicate<T> or(Predicate<? super T> other) {
        Objects.requireNonNull(other, "Cannot combine predicate with 'or' <null>.");
        return t -> {
            Throwable throwable = null;
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating 'or' method with {0} to {1}.", new Object[]{context, this.delegate()});
                    boolean bl = ((Predicate)this.nonNullDelegate()).test(t) || other.test(t);
                    this.consumer().ifPresent(consumer -> {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        consumer.accept(resultSnapshot);
                    });
                    return bl;
                }
                catch (Throwable throwable2) {
                    try {
                        this.consumer().ifPresent(consumer -> {
                            ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                            LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                            consumer.accept(resultSnapshot);
                        });
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        };
    }
}

