/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.functions;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.ContextSnapshot;
import nl.talsmasoftware.context.functions.WrapperWithContextAndConsumer;

public class ConsumerWithContext<T>
extends WrapperWithContextAndConsumer<Consumer<T>>
implements Consumer<T> {
    private static final Logger LOGGER = Logger.getLogger(ConsumerWithContext.class.getName());

    public ConsumerWithContext(ContextSnapshot snapshot, Consumer<T> delegate) {
        this(snapshot, delegate, (Consumer<ContextSnapshot>)null);
    }

    public ConsumerWithContext(ContextSnapshot snapshot, Consumer<T> delegate, Consumer<ContextSnapshot> consumer) {
        super(snapshot, delegate, consumer);
    }

    protected ConsumerWithContext(Supplier<ContextSnapshot> supplier, Consumer<T> delegate, Consumer<ContextSnapshot> consumer) {
        super(supplier, delegate, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t) {
        try (Context context = this.snapshot().reactivate();){
            try {
                LOGGER.log(Level.FINEST, "Delegating accept method with {0} to {1}.", new Object[]{context, this.delegate()});
                ((Consumer)this.nonNullDelegate()).accept(t);
            }
            finally {
                if (this.contextSnapshotConsumer != null) {
                    ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                    LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                    this.contextSnapshotConsumer.accept(resultSnapshot);
                }
            }
        }
    }

    @Override
    public Consumer<T> andThen(Consumer<? super T> after) {
        Objects.requireNonNull(after, "Cannot follow ConsumerWithContext with after consumer <null>.");
        return t -> {
            try (Context context = this.snapshot().reactivate();){
                try {
                    LOGGER.log(Level.FINEST, "Delegating andThen method with {0} to {1}.", new Object[]{context, this.delegate()});
                    ((Consumer)this.nonNullDelegate()).accept(t);
                    after.accept(t);
                }
                finally {
                    if (this.contextSnapshotConsumer != null) {
                        ContextSnapshot resultSnapshot = ContextManagers.createContextSnapshot();
                        LOGGER.log(Level.FINEST, "Captured context snapshot after delegation: {0}", resultSnapshot);
                        this.contextSnapshotConsumer.accept(resultSnapshot);
                    }
                }
            }
        };
    }
}

