/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.servletrequest;

import javax.servlet.ServletRequest;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.ContextManagers;
import nl.talsmasoftware.context.servletrequest.ServletRequestContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletRequestContext
implements Context<ServletRequest> {
    private static final ThreadLocal<ServletRequestContext> CONTEXT = new ThreadLocal();
    volatile ServletRequest servletRequest;

    ServletRequestContext(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        CONTEXT.set(this);
        ContextManagers.onActivate(ServletRequestContextManager.class, (Object)servletRequest, null);
    }

    static Context<ServletRequest> current() {
        return CONTEXT.get();
    }

    public ServletRequest getValue() {
        return this.servletRequest;
    }

    public void close() {
        ServletRequest deactivated = this.servletRequest;
        this.servletRequest = null;
        CONTEXT.set(null);
        ContextManagers.onDeactivate(ServletRequestContextManager.class, (Object)deactivated, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + (this.servletRequest == null ? "{closed}" : "{value=" + this.servletRequest + "}");
    }
}

