/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.servletrequest;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import nl.talsmasoftware.context.servletrequest.ServletRequestContext;
import nl.talsmasoftware.context.servletrequest.ServletRequestContextAsyncListener;
import nl.talsmasoftware.context.servletrequest.ServletRequestContextManager;

public class ServletRequestContextFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(ServletRequestContextFilter.class.getName());

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            new ServletRequestContext(request);
            if (request.isAsyncStarted()) {
                try {
                    request.getAsyncContext().addListener((AsyncListener)new ServletRequestContextAsyncListener());
                }
                catch (IllegalStateException e) {
                    LOGGER.log(Level.FINE, "Could not register servletrequest asynchronous listener: " + e.getMessage(), e);
                }
            }
            chain.doFilter(request, response);
        }
        finally {
            ServletRequestContextManager.clear();
        }
    }

    public void destroy() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

