/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.context.springsecurity;

import java.util.concurrent.atomic.AtomicBoolean;
import nl.talsmasoftware.context.Context;
import nl.talsmasoftware.context.clearable.ClearableContextManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityContextManager
implements ClearableContextManager<Authentication> {
    public Context<Authentication> initializeNewContext(Authentication value) {
        SecurityContext previous = SecurityContextHolder.getContext();
        SecurityContext current = SecurityContextHolder.createEmptyContext();
        current.setAuthentication(value);
        SecurityContextHolder.setContext((SecurityContext)current);
        return new AuthenticationContext(current, previous, false);
    }

    public Context<Authentication> getActiveContext() {
        return new AuthenticationContext(SecurityContextHolder.getContext(), null, true);
    }

    public void clear() {
        SecurityContextHolder.clearContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AuthenticationContext
    implements Context<Authentication> {
        private volatile SecurityContext current;
        private final SecurityContext previous;
        private final AtomicBoolean closed;

        private AuthenticationContext(SecurityContext current, SecurityContext previous, boolean alreadyClosed) {
            this.current = current;
            this.previous = previous;
            this.closed = new AtomicBoolean(alreadyClosed);
        }

        public Authentication getValue() {
            return this.current == null ? null : this.current.getAuthentication();
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                SecurityContextHolder.setContext((SecurityContext)this.previous);
            }
        }
    }
}

