/*
 * Copyright 2012, Emanuel Rabina (http://www.ultraq.net.nz/)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nz.net.ultraq.lesscss;

/**
 * Exception type thrown by the LESS compiler.
 * 
 * @author Emanuel Rabina
 */
public class LessCSSException extends RuntimeException {

	/**
	 * Constructor, set the exception message.
	 * 
	 * @param message
	 */
	LessCSSException(String message) {

		super(message);
	}

	/**
	 * Constructor, set the exception message and cause.
	 * 
	 * @param message
	 * @param cause
	 */
	LessCSSException(String message, Throwable cause) {

		super(message, cause);
	}
}
