/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.lesscss;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;
import nz.net.ultraq.lesscss.LessCSSException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class LessCSSCompiler {
    private static final String ENV_RHINO_JS = "nz/net/ultraq/lesscss/env.rhino-1.2.13.js";
    private static final String LESS_JS = "nz/net/ultraq/lesscss/less-1.7.0.js";
    private static final String compilejs = "(function() { var result = null; var parser = new less.Parser({ filename: '{0}' }); parser.parse('{1}', function(err, tree) { result = err ? err : tree.toCSS(); }); return result; })();";
    private final Scriptable scope;

    public LessCSSCompiler() throws LessCSSException {
        try {
            Context context = Context.enter();
            context.setLanguageVersion(180);
            context.setOptimizationLevel(-1);
            Global global = new Global();
            global.init(context);
            this.scope = context.initStandardObjects((ScriptableObject)global);
            context.evaluateReader(this.scope, (Reader)new BufferedReader(new InputStreamReader(LessCSSCompiler.class.getClassLoader().getResource(ENV_RHINO_JS).openStream())), "env.rhino.js", 1, null);
            context.evaluateReader(this.scope, (Reader)new BufferedReader(new InputStreamReader(LessCSSCompiler.class.getClassLoader().getResource(LESS_JS).openStream())), "less.js", 1, null);
        }
        catch (IOException ex) {
            throw new LessCSSException("Unable to initialize LESS compiler.", ex);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(File input, File output) throws LessCSSException {
        String result;
        Scanner scanner = null;
        try {
            scanner = new Scanner(input);
            scanner.useDelimiter("\\A");
            String inputstring = scanner.hasNext() ? scanner.next() : "";
            result = this.compile(input.getName(), inputstring);
        }
        catch (FileNotFoundException ex) {
            throw new LessCSSException("Input file " + input.getName() + " doesn't exist", ex);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(output));
                writer.write(result);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ex) {
            throw new LessCSSException("Unable to write compiled CSS", ex);
        }
    }

    public String compile(String input) {
        return this.compile("(inline input)", input);
    }

    protected String compile(String filename, String input) throws LessCSSException {
        try {
            Context context = Context.enter();
            context.setLanguageVersion(180);
            String processless = compilejs.replace("{0}", filename).replace("{1}", input.replace("'", "\\'").replaceAll("\\s", " "));
            String string = context.evaluateString(this.scope, processless, "process-less.js", 1, null).toString();
            return string;
        }
        catch (JavaScriptException ex) {
            throw new LessCSSException("Unable to process LESS input from " + filename, ex);
        }
        finally {
            Context.exit();
        }
    }
}

