/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Observable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.AppConnectRepositoryProtocol;
import one.credify.core.entity.ApproveAttachingClaimRequest;
import one.credify.core.entity.AuthorizeAppRequest;
import one.credify.core.entity.CommonResponse;
import one.credify.core.entity.GetOIDCInfoResponse;
import one.credify.core.entity.OIDCListResponse;
import one.credify.core.model.OIDCServiceModel;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.NetworkClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016J>\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\n2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\t2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006H\u0016J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lone/credify/core/data/AppConnectRepository;", "Lone/credify/core/data/AppConnectRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "approveAttachingClaim", "Lio/reactivex/Observable;", "Lone/credify/core/entity/CommonResponse;", "claims", "", "", "", "authorize", "challenge", "approvedScopeMap", "approvalToken", "deauthorize", "app", "Lone/credify/core/model/OIDCServiceModel;", "getInfo", "Lone/credify/core/entity/GetOIDCInfoResponse;", "code", "getList", "Lone/credify/core/entity/OIDCListResponse;", "rejectAttachingClaim", "credify-core_release"})
public final class AppConnectRepository
implements AppConnectRepositoryProtocol {
    private final CredifyApiServices credifyApiServices = NetworkClient.INSTANCE.getCredifyApiService();

    @Override
    @NotNull
    public Observable<GetOIDCInfoResponse> getInfo(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.credifyApiServices.getOIDCInformation(code);
    }

    @Override
    @NotNull
    public Observable<CommonResponse> authorize(@NotNull String challenge, @NotNull Map<String, ? extends Map<String, ? extends Object>> approvedScopeMap, @NotNull String approvalToken) {
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        Intrinsics.checkNotNullParameter(approvedScopeMap, (String)"approvedScopeMap");
        Intrinsics.checkNotNullParameter((Object)approvalToken, (String)"approvalToken");
        AuthorizeAppRequest authorizeAppRequest = new AuthorizeAppRequest(challenge, null, approvedScopeMap, approvalToken);
        return this.credifyApiServices.authorizeApp(authorizeAppRequest);
    }

    @Override
    @NotNull
    public Observable<CommonResponse> deauthorize(@NotNull OIDCServiceModel app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        return this.credifyApiServices.deauthorizeOIDC(app.getId());
    }

    @Override
    @NotNull
    public Observable<OIDCListResponse> getList() {
        return CredifyApiServices.DefaultImpls.getOIDCList$default(this.credifyApiServices, 0, 0, 3, null);
    }

    @Override
    @NotNull
    public Observable<CommonResponse> approveAttachingClaim(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return this.credifyApiServices.approveAttachingClaim(new ApproveAttachingClaimRequest(true, claims));
    }

    @Override
    @NotNull
    public Observable<CommonResponse> rejectAttachingClaim(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return this.credifyApiServices.approveAttachingClaim(new ApproveAttachingClaimRequest(false, claims));
    }
}

