/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Maybe;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.EmailRepositoryProtocol;
import one.credify.core.entity.CommonResponse;
import one.credify.core.entity.EmailRequest;
import one.credify.core.entity.IdentityResponse;
import one.credify.core.entity.UpdateEmailRequest;
import one.credify.core.entity.VerifyEmailRequest;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.NetworkClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lone/credify/core/data/EmailRepository;", "Lone/credify/core/data/EmailRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "sendConfirmationEmail", "Lio/reactivex/Maybe;", "Lone/credify/core/entity/CommonResponse;", "email", "", "updateEmail", "verifyEmail", "Lio/reactivex/Single;", "Lone/credify/core/entity/IdentityResponse;", "code", "credify-core_release"})
public final class EmailRepository
implements EmailRepositoryProtocol {
    private final CredifyApiServices credifyApiServices = NetworkClient.INSTANCE.getCredifyApiService();

    @Override
    @NotNull
    public Maybe<CommonResponse> updateEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return this.credifyApiServices.updateEmail(new UpdateEmailRequest(email));
    }

    @Override
    @NotNull
    public Maybe<CommonResponse> sendConfirmationEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return this.credifyApiServices.resendEmail(new EmailRequest(email));
    }

    @Override
    @NotNull
    public Single<IdentityResponse> verifyEmail(@NotNull String email, @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.credifyApiServices.verifyEmail(new VerifyEmailRequest(email, code));
    }
}

