/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Maybe;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.HistoryRepository;
import one.credify.core.data.HistoryRepositoryProtocol;
import one.credify.core.data.SharedPrefs;
import one.credify.core.data.TransferCacheItem;
import one.credify.core.entity.ActivityHistoryResponse;
import one.credify.core.model.AccountModel;
import one.credify.core.model.AssetModel;
import one.credify.core.model.HistoryDetailModel;
import one.credify.core.model.HistoryModel;
import one.credify.core.model.HistoryType;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.NetworkClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J7\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lone/credify/core/data/HistoryRepository;", "Lone/credify/core/data/HistoryRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "cacheTransferringItem", "", "hash", "", "asset", "Lone/credify/core/model/AssetModel;", "to", "getCachedTransferringItems", "", "Lone/credify/core/model/HistoryModel;", "getHistories", "Lio/reactivex/Maybe;", "Lone/credify/core/entity/ActivityHistoryResponse;", "type", "Lone/credify/core/model/HistoryType;", "page", "", "limit", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;)Lio/reactivex/Maybe;", "removeCachedTransferringItem", "credify-core_release"})
public final class HistoryRepository
implements HistoryRepositoryProtocol {
    private final CredifyApiServices credifyApiServices = NetworkClient.INSTANCE.getCredifyApiService();

    @Override
    @NotNull
    public Maybe<ActivityHistoryResponse> getHistories(@Nullable List<? extends HistoryType> type, @Nullable Integer page, @Nullable Integer limit) {
        List<? extends HistoryType> list = type;
        Integer n2 = page;
        Integer n3 = limit;
        return this.credifyApiServices.getActivityHistory(list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)getHistories.1.INSTANCE, (int)30, null) : null, n2 != null ? n2 : 1, n3 != null ? n3 : 20);
    }

    @Override
    public void cacheTransferringItem(@NotNull String hash, @NotNull AssetModel asset, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        List txs = SharedPrefs.INSTANCE.getTransferringTxs();
        List list = txs;
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            boolean bl = false;
            list = new ArrayList();
        }
        List newValue = list;
        newValue.add(0, new TransferCacheItem(asset, to, hash));
        SharedPrefs.INSTANCE.setTransferringTxs(newValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeCachedTransferringItem(@NotNull String hash, @NotNull AssetModel asset, @NotNull String to) {
        List list;
        List<TransferCacheItem> txs;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        List<TransferCacheItem> list2 = txs = SharedPrefs.INSTANCE.getTransferringTxs();
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TransferCacheItem it = (TransferCacheItem)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getAsset().getAmount(), (Object)asset.getAmount()) || !Intrinsics.areEqual((Object)it.getAsset().getSymbol(), (Object)asset.getSymbol()) || it.getAsset().getDecimals() != it.getAsset().getDecimals() || !Intrinsics.areEqual((Object)it.getTo(), (Object)to))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List newValue = list;
        SharedPrefs.INSTANCE.setTransferringTxs(newValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<HistoryModel> getCachedTransferringItems() {
        List list;
        Object object = SharedPrefs.INSTANCE.getAccount();
        if (object == null || (object = ((AccountModel)object).getId()) == null) {
            object = "";
        }
        Object accountId = object;
        List<TransferCacheItem> list2 = SharedPrefs.INSTANCE.getTransferringTxs();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TransferCacheItem transferCacheItem = (TransferCacheItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Calendar calendar = Calendar.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
                HistoryModel historyModel = new HistoryModel((String)accountId, HistoryType.ASSET_TRANSFERRING, calendar.getTime(), new HistoryDetailModel(null, null, it.getAsset(), null, it.getTo(), null, null, 107, null));
                collection.add(historyModel);
            }
            list = (List)destination$iv$iv;
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

