/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Maybe;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.KYCRepositoryProtocol;
import one.credify.core.data.SharedPrefs;
import one.credify.core.entity.KYCStartRequest;
import one.credify.core.entity.KYCStartResponse;
import one.credify.core.entity.KYCStatusResponse;
import one.credify.core.entity.OnfidoSdkTokenRequest;
import one.credify.core.entity.OnfidoSdkTokenResponse;
import one.credify.core.entity.ProfileEntity;
import one.credify.core.entity.RefreshKYCStatusRequest;
import one.credify.core.entity.SubmitCheckKycRequest;
import one.credify.core.entity.SubmitCheckKycResponse;
import one.credify.core.entity.UploadKYCRequest;
import one.credify.core.model.IdentityProvider;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.NetworkClient;
import one.credify.core.network.restapi.OnfidoApiServices;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lone/credify/core/data/KYCRepository;", "Lone/credify/core/data/KYCRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "kycProcessingId", "", "getKycProcessingId", "()Ljava/lang/String;", "onfidoApiServices", "Lone/credify/core/network/restapi/OnfidoApiServices;", "addIdentityError", "", "identityName", "generateSdkToken", "Lio/reactivex/Maybe;", "Lone/credify/core/entity/OnfidoSdkTokenResponse;", "applicantId", "applicationId", "isKYCProcessing", "", "recordKYCProcessing", "id", "refreshKYCStatus", "Lone/credify/core/entity/KYCStatusResponse;", "provider", "Lone/credify/core/model/IdentityProvider;", "resetKYCProcessing", "startKYC", "Lio/reactivex/Single;", "Lone/credify/core/entity/KYCStartResponse;", "profile", "Lone/credify/core/entity/ProfileEntity;", "submitCheckKyc", "Lone/credify/core/entity/SubmitCheckKycResponse;", "uploadKYCResult", "params", "Lone/credify/core/entity/UploadKYCRequest;", "credify-core_release"})
public final class KYCRepository
implements KYCRepositoryProtocol {
    private final OnfidoApiServices onfidoApiServices = NetworkClient.INSTANCE.getOnfidoApiService();
    private final CredifyApiServices credifyApiServices = NetworkClient.INSTANCE.getCredifyApiService();

    @Override
    @NotNull
    public String getKycProcessingId() {
        String string2 = SharedPrefs.INSTANCE.getKycProcessingId();
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Override
    @NotNull
    public Maybe<OnfidoSdkTokenResponse> generateSdkToken(@NotNull String applicantId, @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        OnfidoSdkTokenRequest request = new OnfidoSdkTokenRequest(applicantId, applicationId);
        return this.onfidoApiServices.requestToken(request);
    }

    @Override
    @NotNull
    public Maybe<SubmitCheckKycResponse> submitCheckKyc(@NotNull String applicantId, @NotNull IdentityProvider provider) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        return this.credifyApiServices.submitCheckKyc(new SubmitCheckKycRequest(applicantId, provider.name()));
    }

    @Override
    @NotNull
    public Maybe<KYCStatusResponse> refreshKYCStatus(@NotNull String applicantId, @NotNull IdentityProvider provider) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        RefreshKYCStatusRequest request = new RefreshKYCStatusRequest(applicantId, provider.name());
        return this.credifyApiServices.refreshKYCStatus(request);
    }

    @Override
    public void recordKYCProcessing(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        SharedPrefs.INSTANCE.setKycProcessingId(id2);
    }

    @Override
    public void resetKYCProcessing() {
        SharedPrefs.INSTANCE.setKycProcessingId(null);
    }

    @Override
    public boolean isKYCProcessing() {
        CharSequence charSequence = SharedPrefs.INSTANCE.getKycProcessingId();
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0);
    }

    @Override
    public void addIdentityError(@NotNull String identityName) {
        Intrinsics.checkNotNullParameter((Object)identityName, (String)"identityName");
        SharedPrefs.INSTANCE.addIdentityError(identityName);
    }

    @Override
    @NotNull
    public Single<KYCStartResponse> startKYC(@NotNull ProfileEntity profile, @NotNull IdentityProvider provider) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        return this.credifyApiServices.startKYC(new KYCStartRequest(profile, provider));
    }

    @Override
    @NotNull
    public Single<KYCStatusResponse> uploadKYCResult(@NotNull UploadKYCRequest params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.credifyApiServices.uploadKYCResult(params);
    }
}

