/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import one.credify.core.data.KeyManagementRepository;
import one.credify.core.data.KeyManagementRepositoryProtocol;
import one.credify.core.data.SharedPrefs;
import one.credify.core.entity.EncryptedKeyResponse;
import one.credify.core.entity.EncryptionKeyPairEntity;
import one.credify.core.entity.SigningKeyPairEntity;
import one.credify.core.extensions.CommonExtensionsKt;
import one.credify.core.model.NewClaimModel;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.utilities.GlobalSubjects;
import one.credify.crypto.Base64Option;
import one.credify.crypto.CryptoHelper;
import one.credify.crypto.Encryption;
import one.credify.crypto.KeyCreator;
import one.credify.crypto.Signing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J.\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\u0006\u0010%\u001a\u00020\u001bH\u0016J6\u0010 \u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\u0006\u0010%\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\nH\u0016J \u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001bH\u0016J\u001a\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120.0-H\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J\u0012\u00100\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u00010\u001bH\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002030-H\u0016J\u0010\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\n0-H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u0002060-H\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010:\u001a\u00020\u001bH\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0016J\u0018\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001bH\u0016J\u0010\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020\nH\u0016J\u0018\u0010C\u001a\u00020<2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u001bH\u0016J\u0010\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020\u0012H\u0016J\u0010\u0010G\u001a\u00020\u001b2\u0006\u0010H\u001a\u00020\u001bH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006I"}, d2={"Lone/credify/core/data/KeyManagementRepository;", "Lone/credify/core/data/KeyManagementRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "getCredifyApiServices", "()Lone/credify/core/network/restapi/CredifyApiServices;", "credifyApiServices$delegate", "Lkotlin/Lazy;", "encryptionKeyPair", "Lone/credify/crypto/Encryption;", "getEncryptionKeyPair", "()Lone/credify/crypto/Encryption;", "realmEncryptionKey", "", "getRealmEncryptionKey", "()[B", "signingKeyPair", "Lone/credify/crypto/Signing;", "getSigningKeyPair", "()Lone/credify/crypto/Signing;", "signingKeyPairEntity", "Lone/credify/core/entity/SigningKeyPairEntity;", "getSigningKeyPairEntity", "()Lone/credify/core/entity/SigningKeyPairEntity;", "createEncryptionPrivateKeyFromPem", "pem", "", "decryptEncryptionPrivateKey", "encryptedKey", "password", "decryptSigningKey", "generateApprovalToken", "id", "clientId", "scopeList", "", "offerCode", "signingKey", "generateEncryptionKeyPair", "generateIdentityToken", "entityId", "source", "hash", "generateKeys", "Lio/reactivex/Single;", "Lkotlin/Pair;", "generateSigningKeyPair", "getCommitment", "key", "getEncryptedKey", "Lone/credify/core/entity/EncryptedKeyResponse;", "getMnemonic", "isHash", "", "getOrGenerateEncryptionKeyPairAsSingle", "hasSession", "hashPassword", "loginToken", "removeEncryptionKeyPair", "", "removeSigningKeyPair", "saveEncryptionKey", "privateKey", "publicKey", "saveEncryptionKeyPair", "encryptionKeys", "saveSigningKey", "verificationKey", "saveSigningKeyPair", "signingKeys", "signMessage", "message", "credify-core_release"})
public final class KeyManagementRepository
implements KeyManagementRepositoryProtocol {
    private final Lazy credifyApiServices$delegate = LazyKt.lazy((Function0)credifyApiServices.2.INSTANCE);

    private final CredifyApiServices getCredifyApiServices() {
        Lazy lazy = this.credifyApiServices$delegate;
        KeyManagementRepository keyManagementRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CredifyApiServices)lazy.getValue();
    }

    @Override
    @NotNull
    public String getMnemonic(boolean isHash) {
        String string2;
        if (isHash) {
            string2 = SharedPrefs.INSTANCE.getMnemonic();
            if (string2 == null || (string2 = CommonExtensionsKt.hash256(string2)) == null) {
                string2 = "";
            }
        } else {
            string2 = SharedPrefs.INSTANCE.getMnemonic();
            if (string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    @Override
    @NotNull
    public Single<Boolean> hasSession() {
        Single single = Single.create((SingleOnSubscribe)hasSession.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.create {\n        \u2026)\n            }\n        }");
        return single;
    }

    @Override
    @NotNull
    public byte[] getRealmEncryptionKey() {
        return SharedPrefs.INSTANCE.getRealmEncryptionKey();
    }

    @Override
    @Nullable
    public SigningKeyPairEntity getSigningKeyPairEntity() {
        return SharedPrefs.INSTANCE.getSigningKeyPair();
    }

    @Override
    @Nullable
    public Signing getSigningKeyPair() {
        SigningKeyPairEntity signingKeyPairEntity = this.getSigningKeyPairEntity();
        if (signingKeyPairEntity == null) {
            return null;
        }
        SigningKeyPairEntity signingKeyEntity = signingKeyPairEntity;
        KeyCreator keyCreator = new KeyCreator();
        boolean bl = false;
        boolean bl2 = false;
        KeyCreator $this$apply = keyCreator;
        boolean bl3 = false;
        CharSequence charSequence = signingKeyEntity.getSigningKey();
        boolean bl4 = false;
        if (charSequence.length() > 0) {
            $this$apply.setPrivateKey(signingKeyEntity.getSigningKey());
        }
        charSequence = signingKeyEntity.getVerificationKey();
        bl4 = false;
        if (charSequence.length() > 0) {
            $this$apply.setPublicKey(signingKeyEntity.getVerificationKey());
        }
        return keyCreator.createSigningKey();
    }

    @Override
    @NotNull
    public Signing generateSigningKeyPair() {
        return new KeyCreator().createSigningKey();
    }

    @Override
    public void saveSigningKeyPair(@NotNull Signing signingKeys) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)signingKeys, (String)"signingKeys");
        String string3 = signingKeys.getPrivateKeyAsPKCS8();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = signingKeys.getPublicKeyAsPKSC8()) == null) {
            string2 = "";
        }
        this.saveSigningKey(string3, string2);
    }

    @Override
    public void saveSigningKey(@NotNull String signingKey, @NotNull String verificationKey) {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)verificationKey, (String)"verificationKey");
        SharedPrefs.INSTANCE.setSigningKeyPair(new SigningKeyPairEntity(signingKey, verificationKey));
    }

    @Override
    public void removeSigningKeyPair() {
        SharedPrefs.INSTANCE.setSigningKeyPair(null);
    }

    @Override
    @Nullable
    public Encryption getEncryptionKeyPair() {
        EncryptionKeyPairEntity encryptionKeyPairEntity = SharedPrefs.INSTANCE.getEncryptionKeyPair();
        if (encryptionKeyPairEntity == null) {
            return null;
        }
        EncryptionKeyPairEntity encryptionKeyEntity = encryptionKeyPairEntity;
        KeyCreator keyCreator = new KeyCreator();
        boolean bl = false;
        boolean bl2 = false;
        KeyCreator $this$apply = keyCreator;
        boolean bl3 = false;
        CharSequence charSequence = encryptionKeyEntity.getPrivateKey();
        boolean bl4 = false;
        if (charSequence.length() > 0) {
            $this$apply.setPrivateKey(encryptionKeyEntity.getPrivateKey());
        }
        charSequence = encryptionKeyEntity.getPublicKey();
        bl4 = false;
        if (charSequence.length() > 0) {
            $this$apply.setPublicKey(encryptionKeyEntity.getPublicKey());
        }
        return keyCreator.createEncryptionKey();
    }

    @Override
    @NotNull
    public Encryption generateEncryptionKeyPair() {
        return new KeyCreator().createEncryptionKey();
    }

    @Override
    @NotNull
    public Single<Encryption> getOrGenerateEncryptionKeyPairAsSingle() {
        Single single = Single.create((SingleOnSubscribe)((SingleOnSubscribe)new SingleOnSubscribe<Encryption>(this){
            final /* synthetic */ KeyManagementRepository this$0;

            public final void subscribe(@NotNull SingleEmitter<Encryption> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Encryption encryption = this.this$0.getEncryptionKeyPair();
                if (encryption == null) {
                    encryption = this.this$0.generateEncryptionKeyPair();
                }
                Encryption keyPair = encryption;
                this.this$0.saveEncryptionKeyPair(keyPair);
                it.onSuccess((Object)keyPair);
            }
            {
                this.this$0 = keyManagementRepository;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.create {\n        \u2026uccess(keyPair)\n        }");
        return single;
    }

    @Override
    public void saveEncryptionKeyPair(@NotNull Encryption encryptionKeys) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)encryptionKeys, (String)"encryptionKeys");
        String string3 = encryptionKeys.getPrivateKeyAsPKCS8();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = encryptionKeys.getPublicKeyAsPKSC8()) == null) {
            string2 = "";
        }
        this.saveEncryptionKey(string3, string2);
    }

    @Override
    public void saveEncryptionKey(@NotNull String privateKey, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        SharedPrefs.INSTANCE.setEncryptionKeyPair(new EncryptionKeyPairEntity(privateKey, publicKey));
    }

    @Override
    public void removeEncryptionKeyPair() {
        SharedPrefs.INSTANCE.setEncryptionKeyPair(null);
    }

    @Override
    @NotNull
    public String signMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] decodedMessage = CryptoHelper.INSTANCE.decodeBase64(message, Base64Option.URL);
        Object object = this.getSigningKeyPair();
        if (object == null || (object = object.signAsBase64(decodedMessage, Base64Option.URL)) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public String loginToken() {
        Object object = this.getSigningKeyPair();
        if (object == null || (object = object.generateLoginToken()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public Encryption createEncryptionPrivateKeyFromPem(@NotNull String pem) {
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        return new KeyCreator().setPrivateKey(pem).createEncryptionKey();
    }

    @Override
    @NotNull
    public String getCommitment(@Nullable String key) {
        NewClaimModel claim;
        Object v0;
        block5: {
            List claimList;
            block7: {
                block6: {
                    claimList = (List)GlobalSubjects.INSTANCE.getClaimListSubject().getValue();
                    Object object = key;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (object == null || object.length() == 0) break block6;
                    object = claimList;
                    bl = false;
                    bl2 = false;
                    if (!(object == null || object.isEmpty())) break block7;
                }
                return CryptoHelper.INSTANCE.generateSaltAsBase64(Base64Option.URL);
            }
            Iterable $this$firstOrNull$iv = claimList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NewClaimModel it = (NewClaimModel)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClaimName(), (Object)key)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        NewClaimModel newClaimModel = claim = (NewClaimModel)v0;
        String commitment = newClaimModel != null ? newClaimModel.getClaimValue() : null;
        CharSequence charSequence = commitment;
        boolean bl = false;
        boolean bl3 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return CryptoHelper.INSTANCE.generateSaltAsBase64(Base64Option.URL);
        }
        return commitment;
    }

    @Override
    @NotNull
    public Signing decryptSigningKey(@NotNull String encryptedKey, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)encryptedKey, (String)"encryptedKey");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return new KeyCreator().setPrivateKey(encryptedKey).setPassword(password).createSigningKey();
    }

    @Override
    @NotNull
    public Encryption decryptEncryptionPrivateKey(@NotNull String encryptedKey, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)encryptedKey, (String)"encryptedKey");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return new KeyCreator().setPrivateKey(encryptedKey).setPassword(password).createEncryptionKey();
    }

    @Override
    @NotNull
    public Single<EncryptedKeyResponse> getEncryptedKey() {
        return this.getCredifyApiServices().getEncryptedKey();
    }

    @Override
    @NotNull
    public String generateApprovalToken(@NotNull String id2, @NotNull String clientId, @NotNull List<String> scopeList2, @NotNull String offerCode) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter(scopeList2, (String)"scopeList");
        Intrinsics.checkNotNullParameter((Object)offerCode, (String)"offerCode");
        Object object = this.getSigningKeyPair();
        if (object == null || (object = object.generateApprovalToken(id2, clientId, scopeList2, offerCode)) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public String generateApprovalToken(@NotNull Signing signingKey, @NotNull String id2, @NotNull String clientId, @NotNull List<String> scopeList2, @NotNull String offerCode) {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter(scopeList2, (String)"scopeList");
        Intrinsics.checkNotNullParameter((Object)offerCode, (String)"offerCode");
        return signingKey.generateApprovalToken(id2, clientId, scopeList2, offerCode);
    }

    @Override
    @NotNull
    public String generateIdentityToken(@NotNull String entityId, @NotNull String source, @NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Object object = this.getSigningKeyPair();
        if (object == null || (object = object.generateIdentityToken(entityId, source, hash)) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public String hashPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string2 = password;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return CryptoHelper.INSTANCE.hashAsBase64(byArray, Base64Option.URL);
    }

    @Override
    @NotNull
    public Single<Pair<Encryption, Signing>> generateKeys() {
        Single single = Single.create((SingleOnSubscribe)((SingleOnSubscribe)new SingleOnSubscribe<Pair<? extends Encryption, ? extends Signing>>(this){
            final /* synthetic */ KeyManagementRepository this$0;

            public final void subscribe(@NotNull SingleEmitter<Pair<Encryption, Signing>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Encryption encryptionKey = this.this$0.generateEncryptionKeyPair();
                Signing signingKey = this.this$0.generateSigningKeyPair();
                it.onSuccess((Object)new Pair((Object)encryptionKey, (Object)signingKey));
            }
            {
                this.this$0 = keyManagementRepository;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.create {\n        \u2026y, signingKey))\n        }");
        return single;
    }
}

