/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Maybe;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.PhoneNumberRepositoryProtocol;
import one.credify.core.entity.CommonResponse;
import one.credify.core.entity.IdentityResponse;
import one.credify.core.entity.VerifyPhoneNumberRequest;
import one.credify.core.extensions.RequestMappingExtensionsKt;
import one.credify.core.model.PhoneModel;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.NetworkClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lone/credify/core/data/PhoneNumberRepository;", "Lone/credify/core/data/PhoneNumberRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "resendSMS", "Lio/reactivex/Maybe;", "Lone/credify/core/entity/CommonResponse;", "phone", "Lone/credify/core/model/PhoneModel;", "sendNewPhoneNumber", "sendPhoneNumber", "verifyPhoneNumber", "Lio/reactivex/Single;", "Lone/credify/core/entity/IdentityResponse;", "code", "", "credify-core_release"})
public final class PhoneNumberRepository
implements PhoneNumberRepositoryProtocol {
    private final CredifyApiServices credifyApiServices = NetworkClient.INSTANCE.getCredifyApiService();

    @Override
    @NotNull
    public Maybe<CommonResponse> sendPhoneNumber(@NotNull PhoneModel phone) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        return this.credifyApiServices.registerPhoneNumber(RequestMappingExtensionsKt.toRequest(phone));
    }

    @Override
    @NotNull
    public Maybe<CommonResponse> sendNewPhoneNumber(@NotNull PhoneModel phone) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        return this.credifyApiServices.sendNewPhoneNumber(RequestMappingExtensionsKt.toRequest(phone));
    }

    @Override
    @NotNull
    public Single<IdentityResponse> verifyPhoneNumber(@NotNull PhoneModel phone, @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        VerifyPhoneNumberRequest body = new VerifyPhoneNumberRequest(phone.getPhoneNumber(), phone.getCountryCode(), code);
        return this.credifyApiServices.verifyPhoneNumber(body);
    }

    @Override
    @NotNull
    public Maybe<CommonResponse> resendSMS(@NotNull PhoneModel phone) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        return this.credifyApiServices.resendPhoneNumber(RequestMappingExtensionsKt.toRequest(phone));
    }
}

