/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.data;

import io.reactivex.Observable;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.SharedPrefs;
import one.credify.core.data.WalletRepositoryProtocol;
import one.credify.core.entity.AssetEntity;
import one.credify.core.entity.BroadcastPaymentTxRestResponse;
import one.credify.core.entity.BroadcastTxRequest;
import one.credify.core.entity.CreatePaymentTxRequest;
import one.credify.core.entity.CreatePaymentTxResponse;
import one.credify.core.entity.GetWalletResponse;
import one.credify.core.entity.PendingTransferTxsResponse;
import one.credify.core.entity.TxHistoryEntity;
import one.credify.core.model.ChainType;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.NetworkClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lone/credify/core/data/WalletRepository;", "Lone/credify/core/data/WalletRepositoryProtocol;", "()V", "credifyApiServices", "Lone/credify/core/network/restapi/CredifyApiServices;", "isWalletAvailable", "", "()Z", "broadcastTx", "Lio/reactivex/Observable;", "Lone/credify/core/entity/BroadcastPaymentTxRestResponse;", "txId", "", "tx", "chainType", "Lone/credify/core/model/ChainType;", "network", "createTx", "Lone/credify/core/entity/CreatePaymentTxResponse;", "asset", "Lone/credify/core/entity/AssetEntity;", "to", "source", "getBTCHistory", "Lone/credify/core/entity/TxHistoryEntity;", "address", "getETHHistory", "getPendingTransferTxs", "Lone/credify/core/entity/PendingTransferTxsResponse;", "getWallet", "Lone/credify/core/entity/GetWalletResponse;", "credify-core_release"})
public final class WalletRepository
implements WalletRepositoryProtocol {
    private final CredifyApiServices credifyApiServices = NetworkClient.INSTANCE.getCredifyApiService();

    @Override
    public boolean isWalletAvailable() {
        return SharedPrefs.INSTANCE.getWalletKeyPair() != null;
    }

    @Override
    @NotNull
    public Observable<GetWalletResponse> getWallet() {
        return CredifyApiServices.DefaultImpls.getCurrencies$default(this.credifyApiServices, false, false, true, false, 11, null);
    }

    @Override
    @NotNull
    public Observable<CreatePaymentTxResponse> createTx(@NotNull ChainType chainType, @NotNull AssetEntity asset, @NotNull String to, @NotNull String network, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        CreatePaymentTxRequest request = new CreatePaymentTxRequest(chainType, asset, to, source, network, 0, 32, null);
        return this.credifyApiServices.createPaymentTx(request);
    }

    @Override
    @NotNull
    public Observable<BroadcastPaymentTxRestResponse> broadcastTx(@NotNull String txId, @NotNull String tx, @NotNull ChainType chainType, @NotNull String network) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)((Object)chainType), (String)"chainType");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        BroadcastTxRequest request = new BroadcastTxRequest(tx, chainType, network);
        return this.credifyApiServices.broadcastTx(request);
    }

    @Override
    @NotNull
    public Observable<PendingTransferTxsResponse> getPendingTransferTxs(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.credifyApiServices.fetchPendingTransferTxs(address);
    }

    @Override
    @NotNull
    public Observable<TxHistoryEntity> getBTCHistory(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String string2 = "not implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public Observable<TxHistoryEntity> getETHHistory(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String string2 = "not implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }
}

