/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.extensions;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import one.credify.core.model.ValueType;
import one.credify.core.utilities.CommonUtils;
import one.credify.crypto.Base64Option;
import one.credify.crypto.Encryption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"CLASS_NAME", "", "", "getCLASS_NAME", "(Ljava/lang/Object;)Ljava/lang/String;", "valueType", "Lone/credify/core/model/ValueType;", "getValueType", "(Ljava/lang/Object;)Lone/credify/core/model/ValueType;", "convertCountryCodeA2ToA3", "convertCountryCodeA3ToA2", "decryptBase64", "privateKey", "Lone/credify/crypto/Encryption;", "formatTo", "Ljava/util/Date;", "dateFormat", "timeZone", "Ljava/util/TimeZone;", "hash256", "parseToDate", "format", "credify-core_release"})
public final class CommonExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String hash256(@NotNull Object $this$hash256) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hash256, (String)"$this$hash256");
        String string2 = $this$hash256.toString();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        byte[] byArray2 = digest;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        void var8_9 = $this$fold$iv;
        int n2 = ((void)var8_9).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void it;
            void element$iv;
            void var12_13 = element$iv = var8_9[i2];
            String str = accumulator$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(str);
            String string4 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            boolean bl3 = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
            accumulator$iv = stringBuilder.append(string5).toString();
        }
        return accumulator$iv;
    }

    @NotNull
    public static final String getCLASS_NAME(@NotNull Object $this$CLASS_NAME) {
        Intrinsics.checkNotNullParameter((Object)$this$CLASS_NAME, (String)"$this$CLASS_NAME");
        String string2 = $this$CLASS_NAME.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
        return string2;
    }

    @Nullable
    public static final Date parseToDate(@NotNull String $this$parseToDate, @NotNull String format, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$parseToDate, (String)"$this$parseToDate");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.getDefault());
        sdf.setTimeZone(timeZone);
        return sdf.parse($this$parseToDate);
    }

    public static /* synthetic */ Date parseToDate$default(String string2, String string3, TimeZone timeZone, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string3 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        if ((n2 & 2) != 0) {
            TimeZone timeZone2 = TimeZone.getTimeZone("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"TimeZone.getTimeZone(\"UTC\")");
            timeZone = timeZone2;
        }
        return CommonExtensionsKt.parseToDate(string2, string3, timeZone);
    }

    @NotNull
    public static final String formatTo(@NotNull Date $this$formatTo, @NotNull String dateFormat, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTo, (String)"$this$formatTo");
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, Locale.getDefault());
        formatter.setTimeZone(timeZone);
        String string2 = formatter.format($this$formatTo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatter.format(this)");
        return string2;
    }

    public static /* synthetic */ String formatTo$default(Date date, String string2, TimeZone timeZone, int n2, Object object) {
        if ((n2 & 2) != 0) {
            TimeZone timeZone2 = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"TimeZone.getDefault()");
            timeZone = timeZone2;
        }
        return CommonExtensionsKt.formatTo(date, string2, timeZone);
    }

    @NotNull
    public static final String convertCountryCodeA2ToA3(@NotNull String $this$convertCountryCodeA2ToA3) {
        Intrinsics.checkNotNullParameter((Object)$this$convertCountryCodeA2ToA3, (String)"$this$convertCountryCodeA2ToA3");
        String string2 = $this$convertCountryCodeA2ToA3;
        boolean bl = false;
        String string3 = new Locale("", ((Object)StringsKt.trim((CharSequence)string2)).toString()).getISO3Country();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Locale(\"\", this.trim()).isO3Country");
        return string3;
    }

    @NotNull
    public static final String convertCountryCodeA3ToA2(@NotNull String $this$convertCountryCodeA3ToA2) {
        Intrinsics.checkNotNullParameter((Object)$this$convertCountryCodeA3ToA2, (String)"$this$convertCountryCodeA3ToA2");
        Object object = CommonUtils.INSTANCE.getIsoCodeMap().get($this$convertCountryCodeA3ToA2);
        if (object == null || (object = ((Locale)object).getCountry()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final ValueType getValueType(@NotNull Object $this$valueType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueType, (String)"$this$valueType");
        Object object = $this$valueType;
        return object instanceof Boolean ? ValueType.BOOLEAN : (object instanceof String ? ValueType.TEXT : (object instanceof Integer ? ValueType.INTEGER : (object instanceof Long ? ValueType.INTEGER : (object instanceof Float ? ValueType.FLOAT : (object instanceof Double ? ValueType.FLOAT : ValueType.OBJECT)))));
    }

    @NotNull
    public static final String decryptBase64(@NotNull String $this$decryptBase64, @NotNull Encryption privateKey) {
        Intrinsics.checkNotNullParameter((Object)$this$decryptBase64, (String)"$this$decryptBase64");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        CharSequence charSequence = $this$decryptBase64;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        return privateKey.decryptBase64($this$decryptBase64, Base64Option.URL);
    }
}

