/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.extensions;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Set;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import one.credify.core.extensions.CommonExtensionsKt;
import one.credify.core.utilities.Logger;
import one.credify.core.utilities.SymmetricUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u001c\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a$\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"clearSharedPreference", "", "Landroid/content/SharedPreferences;", "getEncryptionString", "", "context", "Landroid/content/Context;", "KEY_NAME", "removeValue", "save", "value", "", "saveEncryptionString", "saveStringSet", "key", "", "credify-core_release"})
public final class SharedPreferencesExtensionsKt {
    public static final void save(@NotNull SharedPreferences $this$save, @NotNull String KEY_NAME, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$save, (String)"$this$save");
        Intrinsics.checkNotNullParameter((Object)KEY_NAME, (String)"KEY_NAME");
        if (value == null) {
            SharedPreferencesExtensionsKt.removeValue($this$save, KEY_NAME);
            return;
        }
        SharedPreferences.Editor editor = $this$save.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"this.edit()");
        SharedPreferences.Editor editor2 = editor;
        Object object = value;
        if (object instanceof Integer) {
            editor2.putInt(KEY_NAME, ((Number)value).intValue());
        } else if (object instanceof String) {
            editor2.putString(KEY_NAME, (String)value);
        } else if (object instanceof Boolean) {
            editor2.putBoolean(KEY_NAME, ((Boolean)value).booleanValue());
        }
        editor2.apply();
    }

    public static final void saveStringSet(@NotNull SharedPreferences $this$saveStringSet, @NotNull String key, @Nullable Set<String> value) {
        Intrinsics.checkNotNullParameter((Object)$this$saveStringSet, (String)"$this$saveStringSet");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            SharedPreferencesExtensionsKt.removeValue($this$saveStringSet, key);
            return;
        }
        SharedPreferences.Editor editor = $this$saveStringSet.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$run = editor;
        boolean bl3 = false;
        $this$run.putStringSet(key, value);
        $this$run.apply();
    }

    public static final void saveEncryptionString(@NotNull SharedPreferences $this$saveEncryptionString, @NotNull Context context, @NotNull String KEY_NAME, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$saveEncryptionString, (String)"$this$saveEncryptionString");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)KEY_NAME, (String)"KEY_NAME");
        Pair<byte[], byte[]> pair = null;
        if (value != null) {
            Key key = SymmetricUtil.INSTANCE.generateSymmetricKey(context, KEY_NAME);
            String string2 = value;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            pair = SymmetricUtil.INSTANCE.encrypt(byArray, key);
        }
        if (pair != null) {
            String encodeValue = Base64.encodeToString((byte[])((byte[])pair.getFirst()), (int)2);
            String encodeIV = Base64.encodeToString((byte[])((byte[])pair.getSecond()), (int)2);
            SharedPreferencesExtensionsKt.save($this$saveEncryptionString, KEY_NAME, encodeValue);
            SharedPreferencesExtensionsKt.save($this$saveEncryptionString, KEY_NAME + "_iv", encodeIV);
        } else {
            SharedPreferencesExtensionsKt.removeValue($this$saveEncryptionString, KEY_NAME);
            SharedPreferencesExtensionsKt.removeValue($this$saveEncryptionString, KEY_NAME + "_iv");
        }
    }

    @Nullable
    public static final String getEncryptionString(@NotNull SharedPreferences $this$getEncryptionString, @NotNull Context context, @NotNull String KEY_NAME) {
        Intrinsics.checkNotNullParameter((Object)$this$getEncryptionString, (String)"$this$getEncryptionString");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)KEY_NAME, (String)"KEY_NAME");
        try {
            byte[] data;
            String string2 = $this$getEncryptionString.getString(KEY_NAME + "_iv", null);
            if (string2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\"${KEY_NAME}_iv\", null) ?: return null");
            String iv = string2;
            String string3 = $this$getEncryptionString.getString(KEY_NAME, null);
            if (string3 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(KEY_NAME, null) ?: return null");
            String cipherText = string3;
            Key key = SymmetricUtil.INSTANCE.generateSymmetricKey(context, KEY_NAME);
            byte[] byArray = Base64.decode((String)cipherText, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(cipherText, Base64.NO_WRAP)");
            byte[] byArray2 = SymmetricUtil.INSTANCE.decrypt(byArray, key, new IvParameterSpec(Base64.decode((String)iv, (int)2)));
            if (byArray2 == null) {
                return null;
            }
            byte[] byArray3 = data = byArray2;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            boolean bl2 = false;
            return new String(byArray3, charset);
        }
        catch (Exception e2) {
            Logger.INSTANCE.e(CommonExtensionsKt.getCLASS_NAME($this$getEncryptionString), "SharedPreferences.getEncryptionString fail " + e2.getMessage(), e2);
            return null;
        }
    }

    public static final void clearSharedPreference(@NotNull SharedPreferences $this$clearSharedPreference) {
        Intrinsics.checkNotNullParameter((Object)$this$clearSharedPreference, (String)"$this$clearSharedPreference");
        SharedPreferences.Editor editor = $this$clearSharedPreference.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"this.edit()");
        SharedPreferences.Editor editor2 = editor;
        editor2.clear();
        editor2.apply();
    }

    public static final void removeValue(@NotNull SharedPreferences $this$removeValue, @NotNull String KEY_NAME) {
        Intrinsics.checkNotNullParameter((Object)$this$removeValue, (String)"$this$removeValue");
        Intrinsics.checkNotNullParameter((Object)KEY_NAME, (String)"KEY_NAME");
        SharedPreferences.Editor editor = $this$removeValue.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"this.edit()");
        SharedPreferences.Editor editor2 = editor;
        editor2.remove(KEY_NAME);
        editor2.apply();
    }
}

