/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.network.restapi;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import one.credify.core.data.AccountRepository;
import one.credify.core.entity.AccessTokeResponse;
import one.credify.core.extensions.CommonExtensionsKt;
import one.credify.core.utilities.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lone/credify/core/network/restapi/CredifyErrorInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "credify-core_release"})
public final class CredifyErrorInterceptor
implements Interceptor {
    public static final int AUTH_ERROR_LIMIT = 5;
    private static int authErrorCount;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Response response = chain.proceed(chain.request());
        if (response.code() == 401 && authErrorCount < 5) {
            response.close();
            Logger.INSTANCE.d(CommonExtensionsKt.getCLASS_NAME(this), "Got 401 Error: should request a new access token, count = " + authErrorCount);
            int n2 = authErrorCount;
            authErrorCount = n2 + 1;
            AccountRepository accountRepository = new AccountRepository();
            AccessTokeResponse accountResponse = (AccessTokeResponse)accountRepository.retrieveAccessToken().blockingSingle();
            if (accountResponse.getData() == null) {
                throw (Throwable)new Exception("getAccessToken fail, accountResponse.data is null");
            }
            String accessToken = accountResponse.getData().getAccessToken();
            accountRepository.cacheAccessToken(accessToken);
            Request newRequest = chain.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
            response = chain.proceed(newRequest);
            if (response.code() != 401) {
                authErrorCount = 0;
            }
        }
        return response;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lone/credify/core/network/restapi/CredifyErrorInterceptor$Companion;", "", "()V", "AUTH_ERROR_LIMIT", "", "authErrorCount", "getAuthErrorCount", "()I", "setAuthErrorCount", "(I)V", "credify-core_release"})
    public static final class Companion {
        public final int getAuthErrorCount() {
            return authErrorCount;
        }

        public final void setAuthErrorCount(int n2) {
            authErrorCount = n2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

