/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.network.restapi;

import com.squareup.moshi.Moshi;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import one.credify.core.data.SharedPrefs;
import one.credify.core.network.restapi.CredifyApiServices;
import one.credify.core.network.restapi.CredifyErrorInterceptor;
import one.credify.core.network.restapi.OnfidoApiServices;
import one.credify.core.network.restapi.ProviderRestApiServices;
import one.credify.core.utilities.MoshiAdapters;
import one.credify.core.utilities.SignerUtils;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\fH\u0002J\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\fH\u0002J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\fH\u0002J&\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006J.\u0010)\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u0010\u0010\u0014\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\nR\u001a\u0010\u0018\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\nR\u001a\u0010\u001b\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\b\"\u0004\b\u001d\u0010\n\u00a8\u0006*"}, d2={"Lone/credify/core/network/restapi/NetworkClient;", "", "()V", "TIME_OUT", "", "credifyApiKey", "", "getCredifyApiKey", "()Ljava/lang/String;", "setCredifyApiKey", "(Ljava/lang/String;)V", "credifyRetrofit", "Lretrofit2/Retrofit;", "logLevel", "Lokhttp3/logging/HttpLoggingInterceptor$Level;", "getLogLevel", "()Lokhttp3/logging/HttpLoggingInterceptor$Level;", "onfidoRestUrl", "getOnfidoRestUrl", "setOnfidoRestUrl", "onfidoRetrofit", "onfidoToken", "getOnfidoToken", "setOnfidoToken", "providerRestUrl", "getProviderRestUrl", "setProviderRestUrl", "restUrl", "getRestUrl", "setRestUrl", "getCredifyApiService", "Lone/credify/core/network/restapi/CredifyApiServices;", "getCredifyClient", "getOnfidoApiService", "Lone/credify/core/network/restapi/OnfidoApiServices;", "getOnfidoClient", "getProviderApiService", "Lone/credify/core/network/restapi/ProviderRestApiServices;", "getProviderClient", "init", "", "initForSDK", "credify-core_release"})
public final class NetworkClient {
    public static String restUrl;
    public static String credifyApiKey;
    public static String onfidoToken;
    public static String onfidoRestUrl;
    public static String providerRestUrl;
    private static final int TIME_OUT = 30;
    private static Retrofit credifyRetrofit;
    private static Retrofit onfidoRetrofit;
    @NotNull
    public static final NetworkClient INSTANCE;

    @NotNull
    public final String getRestUrl() {
        String string2 = restUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"restUrl");
        }
        return string2;
    }

    public final void setRestUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        restUrl = string2;
    }

    @NotNull
    public final String getCredifyApiKey() {
        String string2 = credifyApiKey;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"credifyApiKey");
        }
        return string2;
    }

    public final void setCredifyApiKey(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        credifyApiKey = string2;
    }

    @NotNull
    public final String getOnfidoToken() {
        String string2 = onfidoToken;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"onfidoToken");
        }
        return string2;
    }

    public final void setOnfidoToken(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        onfidoToken = string2;
    }

    @NotNull
    public final String getOnfidoRestUrl() {
        String string2 = onfidoRestUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"onfidoRestUrl");
        }
        return string2;
    }

    public final void setOnfidoRestUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        onfidoRestUrl = string2;
    }

    @NotNull
    public final String getProviderRestUrl() {
        String string2 = providerRestUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"providerRestUrl");
        }
        return string2;
    }

    public final void setProviderRestUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        providerRestUrl = string2;
    }

    private final HttpLoggingInterceptor.Level getLogLevel() {
        return Intrinsics.areEqual((Object)"release", (Object)"release") ? HttpLoggingInterceptor.Level.NONE : HttpLoggingInterceptor.Level.BODY;
    }

    public final void init(@NotNull String restUrl, @NotNull String credifyApiKey, @NotNull String onfidoRestUrl, @NotNull String onfidoToken) {
        Intrinsics.checkNotNullParameter((Object)restUrl, (String)"restUrl");
        Intrinsics.checkNotNullParameter((Object)credifyApiKey, (String)"credifyApiKey");
        Intrinsics.checkNotNullParameter((Object)onfidoRestUrl, (String)"onfidoRestUrl");
        Intrinsics.checkNotNullParameter((Object)onfidoToken, (String)"onfidoToken");
        NetworkClient.credifyApiKey = credifyApiKey;
        NetworkClient.restUrl = restUrl;
        NetworkClient.onfidoRestUrl = onfidoRestUrl;
        NetworkClient.onfidoToken = onfidoToken;
    }

    public final void initForSDK(@NotNull String restUrl, @NotNull String credifyApiKey, @NotNull String providerRestUrl, @NotNull String onfidoRestUrl, @NotNull String onfidoToken) {
        Intrinsics.checkNotNullParameter((Object)restUrl, (String)"restUrl");
        Intrinsics.checkNotNullParameter((Object)credifyApiKey, (String)"credifyApiKey");
        Intrinsics.checkNotNullParameter((Object)providerRestUrl, (String)"providerRestUrl");
        Intrinsics.checkNotNullParameter((Object)onfidoRestUrl, (String)"onfidoRestUrl");
        Intrinsics.checkNotNullParameter((Object)onfidoToken, (String)"onfidoToken");
        NetworkClient.restUrl = restUrl;
        NetworkClient.credifyApiKey = credifyApiKey;
        NetworkClient.providerRestUrl = providerRestUrl;
        NetworkClient.onfidoRestUrl = onfidoRestUrl;
        NetworkClient.onfidoToken = onfidoToken;
    }

    @NotNull
    public final CredifyApiServices getCredifyApiService() {
        Object object = this.getCredifyClient().create(CredifyApiServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCredifyClient().creat\u2026yApiServices::class.java)");
        return (CredifyApiServices)object;
    }

    @NotNull
    public final OnfidoApiServices getOnfidoApiService() {
        Object object = this.getOnfidoClient().create(OnfidoApiServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOnfidoClient().create\u2026oApiServices::class.java)");
        return (OnfidoApiServices)object;
    }

    @NotNull
    public final ProviderRestApiServices getProviderApiService() {
        Object object = this.getProviderClient().create(ProviderRestApiServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProviderClient().crea\u2026tApiServices::class.java)");
        return (ProviderRestApiServices)object;
    }

    private final Retrofit getCredifyClient() {
        OkHttpClient.Builder okHttpClientBuilder;
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null);
        logging.level(this.getLogLevel());
        OkHttpClient.Builder this_$iv = okHttpClientBuilder = new OkHttpClient.Builder();
        boolean bl = false;
        Interceptor.Companion companion = Interceptor.Companion;
        OkHttpClient.Builder builder = this_$iv;
        boolean $i$f$invoke = false;
        Interceptor interceptor = new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Interceptor.Chain chain3 = chain2;
                boolean bl2 = false;
                Request.Builder newRequestBuilder = chain3.request().newBuilder();
                String accessToken = SharedPrefs.INSTANCE.getAccessToken();
                if (accessToken != null) {
                    newRequestBuilder.header("Authorization", "Bearer " + accessToken);
                }
                newRequestBuilder.header("X-API-KEY", NetworkClient.INSTANCE.getCredifyApiKey());
                if (Intrinsics.areEqual((Object)chain3.request().url().uri().getPath(), (Object)"/v1/entity/access-token")) {
                    newRequestBuilder.header("Signature", SignerUtils.INSTANCE.getSignature());
                }
                return chain3.proceed(newRequestBuilder.build());
            }
        };
        builder.addInterceptor(interceptor);
        okHttpClientBuilder.addInterceptor((Interceptor)new CredifyErrorInterceptor());
        okHttpClientBuilder.connectTimeout((long)30, TimeUnit.SECONDS).readTimeout((long)30, TimeUnit.SECONDS).writeTimeout((long)30, TimeUnit.SECONDS);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        Retrofit.Builder builder2 = new Retrofit.Builder();
        String string2 = restUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"restUrl");
        }
        Retrofit retrofit = credifyRetrofit = builder2.baseUrl(string2).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)MoshiAdapters.INSTANCE.getMoshi())).client(okHttpClientBuilder.build()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io())).build();
        Intrinsics.checkNotNull((Object)retrofit);
        return retrofit;
    }

    private final Retrofit getOnfidoClient() {
        OkHttpClient.Builder okHttpClientBuilder;
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null);
        logging.level(this.getLogLevel());
        OkHttpClient.Builder this_$iv = okHttpClientBuilder = new OkHttpClient.Builder();
        boolean bl = false;
        Interceptor.Companion companion = Interceptor.Companion;
        OkHttpClient.Builder builder = this_$iv;
        boolean $i$f$invoke = false;
        Interceptor interceptor = new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Interceptor.Chain chain3 = chain2;
                boolean bl2 = false;
                Request.Builder newRequestBuilder = chain3.request().newBuilder();
                newRequestBuilder.header("Authorization", "Token token=" + NetworkClient.INSTANCE.getOnfidoToken());
                return chain3.proceed(newRequestBuilder.build());
            }
        };
        builder.addInterceptor(interceptor);
        okHttpClientBuilder.connectTimeout((long)30, TimeUnit.SECONDS).readTimeout((long)30, TimeUnit.SECONDS).writeTimeout((long)30, TimeUnit.SECONDS);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        Retrofit.Builder builder2 = new Retrofit.Builder();
        String string2 = onfidoRestUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"onfidoRestUrl");
        }
        Retrofit retrofit = onfidoRetrofit = builder2.baseUrl(string2).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)MoshiAdapters.INSTANCE.getMoshi())).client(okHttpClientBuilder.build()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io())).build();
        Intrinsics.checkNotNull((Object)retrofit);
        return retrofit;
    }

    private final Retrofit getProviderClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null);
        logging.level(this.getLogLevel());
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.addInterceptor((Interceptor)new CredifyErrorInterceptor());
        okHttpClientBuilder.connectTimeout((long)30, TimeUnit.SECONDS).readTimeout((long)30, TimeUnit.SECONDS).writeTimeout((long)30, TimeUnit.SECONDS);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        Retrofit.Builder builder = new Retrofit.Builder();
        String string2 = providerRestUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"providerRestUrl");
        }
        Retrofit retrofit = credifyRetrofit = builder.baseUrl(string2).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)MoshiAdapters.INSTANCE.getMoshi())).client(okHttpClientBuilder.build()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io())).build();
        Intrinsics.checkNotNull((Object)retrofit);
        return retrofit;
    }

    private NetworkClient() {
    }

    static {
        NetworkClient networkClient;
        INSTANCE = networkClient = new NetworkClient();
    }
}

