/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.network.websocket;

import com.tinder.scarlet.MessageAdapter;
import com.tinder.scarlet.Scarlet;
import com.tinder.scarlet.StreamAdapter;
import com.tinder.scarlet.messageadapter.moshi.MoshiMessageAdapter;
import com.tinder.scarlet.streamadapter.rxjava2.RxJava2StreamAdapterFactory;
import com.tinder.scarlet.websocket.okhttp.OkHttpClientUtils;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.rxkotlin.DisposableKt;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import one.credify.core.data.SharedPrefs;
import one.credify.core.extensions.CommonExtensionsKt;
import one.credify.core.network.websocket.CredifyWebSocketService;
import one.credify.core.network.websocket.WebSocketClient;
import one.credify.core.utilities.Logger;
import one.credify.core.utilities.SignerUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lone/credify/core/network/websocket/WebSocketClient;", "", "()V", "PIN_INTERVAL_SECONDS", "", "isWebSocketRunning", "", "()Z", "setWebSocketRunning", "(Z)V", "mDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "mIsStarted", "mLock", "mService", "Lone/credify/core/network/websocket/CredifyWebSocketService;", "service", "getService", "()Lone/credify/core/network/websocket/CredifyWebSocketService;", "wsUrl", "", "getWsUrl", "()Ljava/lang/String;", "setWsUrl", "(Ljava/lang/String;)V", "connect", "", "disconnect", "getScarletInstance", "Lcom/tinder/scarlet/Scarlet;", "url", "init", "restUrl", "credify-core_release"})
public final class WebSocketClient {
    private static final long PIN_INTERVAL_SECONDS = 10L;
    private static final Object mLock;
    private static CompositeDisposable mDisposable;
    private static boolean mIsStarted;
    private static CredifyWebSocketService mService;
    public static String wsUrl;
    private static boolean isWebSocketRunning;
    @NotNull
    public static final WebSocketClient INSTANCE;

    @NotNull
    public final CredifyWebSocketService getService() {
        CredifyWebSocketService s = mService;
        if (s == null) {
            String string2 = wsUrl;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wsUrl");
            }
            mService = s = (CredifyWebSocketService)this.getScarletInstance(string2).create(CredifyWebSocketService.class);
        }
        return s;
    }

    @NotNull
    public final String getWsUrl() {
        String string2 = wsUrl;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wsUrl");
        }
        return string2;
    }

    public final void setWsUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        wsUrl = string2;
    }

    public final boolean isWebSocketRunning() {
        return isWebSocketRunning;
    }

    public final void setWebSocketRunning(boolean bl) {
        isWebSocketRunning = bl;
    }

    public final void init(@NotNull String restUrl) {
        Intrinsics.checkNotNullParameter((Object)restUrl, (String)"restUrl");
        wsUrl = restUrl;
    }

    private final Scarlet getScarletInstance(String url) {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null).setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        OkHttpClient.Builder this_$iv = okHttpClientBuilder;
        boolean bl = false;
        Interceptor.Companion companion = Interceptor.Companion;
        OkHttpClient.Builder builder = this_$iv;
        boolean $i$f$invoke = false;
        Interceptor interceptor = new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Interceptor.Chain chain3 = chain2;
                boolean bl2 = false;
                Request.Builder newRequestBuilder = chain3.request().newBuilder();
                String accessToken = SharedPrefs.INSTANCE.getAccessToken();
                if (accessToken != null) {
                    newRequestBuilder.addHeader("Authorization", "Bearer " + accessToken);
                }
                newRequestBuilder.addHeader("Signature", SignerUtils.INSTANCE.getSignature());
                return chain3.proceed(newRequestBuilder.build());
            }
        };
        builder.addInterceptor(interceptor);
        this_$iv = okHttpClientBuilder;
        bl = false;
        Interceptor.Companion this_$iv$iv = Interceptor.Companion;
        builder = this_$iv;
        $i$f$invoke = false;
        interceptor = new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Interceptor.Chain chain3 = chain2;
                boolean bl2 = false;
                Request.Builder newRequestBuilder = chain3.request().newBuilder();
                return chain3.proceed(newRequestBuilder.build());
            }
        };
        builder.addInterceptor(interceptor);
        okHttpClientBuilder.pingInterval(10L, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = okHttpClientBuilder.build();
        return new Scarlet.Builder().webSocketFactory(OkHttpClientUtils.newWebSocketFactory((OkHttpClient)okHttpClient, (String)url)).addMessageAdapterFactory((MessageAdapter.Factory)new MoshiMessageAdapter.Factory(null, null, 3, null)).addStreamAdapterFactory((StreamAdapter.Factory)new RxJava2StreamAdapterFactory()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect() {
        Object object = mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (mIsStarted) {
                Logger.INSTANCE.d(CommonExtensionsKt.getCLASS_NAME(INSTANCE), "The WS is started");
                return;
            }
            mIsStarted = true;
            CompositeDisposable disposable = mDisposable;
            if (disposable == null) {
                mDisposable = disposable = new CompositeDisposable();
                Logger.INSTANCE.d(CommonExtensionsKt.getCLASS_NAME(INSTANCE), "Create a new CompositeDisposable");
            }
            Logger.INSTANCE.d(CommonExtensionsKt.getCLASS_NAME(INSTANCE), "Start to connect WS");
            Disposable disposable2 = INSTANCE.getService().observeEvent().subscribeOn(Schedulers.io()).subscribe((Consumer)connect.1.1.INSTANCE, (Consumer)connect.1.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"service.observeEvent()\n \u2026\"\", e)\n                })");
            DisposableKt.addTo((Disposable)disposable2, (CompositeDisposable)disposable);
            Disposable disposable3 = INSTANCE.getService().observeText().subscribeOn(Schedulers.io()).subscribe((Consumer)connect.1.3.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"service.observeText()\n  \u2026t $it\")\n                }");
            DisposableKt.addTo((Disposable)disposable3, (CompositeDisposable)disposable);
            Disposable disposable4 = INSTANCE.getService().observeNotification().subscribeOn(Schedulers.io()).subscribe((Consumer)connect.1.4.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"service.observeNotificat\u2026blish()\n                }");
            DisposableKt.addTo((Disposable)disposable4, (CompositeDisposable)disposable);
            Disposable disposable5 = INSTANCE.getService().observeState().subscribeOn(Schedulers.io()).subscribe((Consumer)connect.1.5.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)disposable5, (String)"service.observeState()\n \u2026NAME}\")\n                }");
            Disposable disposable6 = DisposableKt.addTo((Disposable)disposable5, (CompositeDisposable)disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        Object object = mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            CompositeDisposable compositeDisposable = mDisposable;
            if (compositeDisposable != null) {
                compositeDisposable.dispose();
            }
            mDisposable = null;
            mService = null;
            mIsStarted = false;
            Logger.INSTANCE.d(CommonExtensionsKt.getCLASS_NAME(INSTANCE), "Disconnected WS");
            Unit unit = Unit.INSTANCE;
        }
    }

    private WebSocketClient() {
    }

    static {
        WebSocketClient webSocketClient;
        INSTANCE = webSocketClient = new WebSocketClient();
        mLock = new Object();
    }
}

