/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.utilities;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lone/credify/core/utilities/DeviceHelper;", "", "()V", "deviceLanguageCode", "", "getDeviceLanguageCode", "()Ljava/lang/String;", "deviceLocale", "Ljava/util/Locale;", "getDeviceLocale", "()Ljava/util/Locale;", "credify-core_release"})
public final class DeviceHelper {
    @NotNull
    public static final DeviceHelper INSTANCE;

    @NotNull
    public final Locale getDeviceLocale() {
        Locale locale;
        try {
            Locale locale2;
            if (Build.VERSION.SDK_INT >= 24) {
                Resources resources = Resources.getSystem();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
                Configuration configuration = resources.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Resources.getSystem().configuration");
                locale2 = configuration.getLocales().get(0);
            } else {
                Resources resources = Resources.getSystem();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
                locale2 = resources.getConfiguration().locale;
            }
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"if (Build.VERSION.SDK_IN\u2026.locale\n                }");
            locale = locale2;
        }
        catch (Exception ex) {
            Locale locale3 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.getDefault()");
            locale = locale3;
        }
        return locale;
    }

    @NotNull
    public final String getDeviceLanguageCode() {
        String string2 = this.getDeviceLocale().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"deviceLocale.language");
        return string2;
    }

    private DeviceHelper() {
    }

    static {
        DeviceHelper deviceHelper;
        INSTANCE = deviceHelper = new DeviceHelper();
    }
}

