/*
 * Decompiled with CFR 0.152.
 */
package one.credify.core.utilities;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.extensions.CommonExtensionsKt;
import one.credify.core.utilities.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ$\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lone/credify/core/utilities/SymmetricUtil;", "", "()V", "CIPHER_AES", "", "decrypt", "", "cipherText", "key", "Ljava/security/Key;", "iv", "Ljavax/crypto/spec/IvParameterSpec;", "encrypt", "Lkotlin/Pair;", "plainText", "generateSymmetricKey", "context", "Landroid/content/Context;", "keyAlias", "credify-core_release"})
public final class SymmetricUtil {
    private static final String CIPHER_AES = "AES/CBC/PKCS7Padding";
    @NotNull
    public static final SymmetricUtil INSTANCE;

    @NotNull
    public final Key generateSymmetricKey(@NotNull Context context, @NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        boolean bl = false;
        boolean bl2 = false;
        KeyStore $this$apply = keyStore;
        boolean bl3 = false;
        $this$apply.load(null);
        KeyStore keyStore2 = keyStore;
        if (!keyStore2.containsAlias(keyAlias)) {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(keyAlias, 3);
            boolean bl4 = false;
            boolean bl5 = false;
            KeyGenParameterSpec.Builder $this$apply2 = builder;
            boolean bl6 = false;
            $this$apply2.setBlockModes(new String[]{"CBC"});
            $this$apply2.setEncryptionPaddings(new String[]{"PKCS7Padding"});
            if (Build.VERSION.SDK_INT >= 28 && context.getPackageManager().hasSystemFeature("android.hardware.strongbox_keystore")) {
                $this$apply2.setIsStrongBoxBacked(true);
            }
            KeyGenParameterSpec keyGenParameterSpec = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"KeyGenParameterSpec.Buil\u2026 }\n\n            }.build()");
            KeyGenParameterSpec keyGenParameterSpec2 = keyGenParameterSpec;
            keyGenerator.init((AlgorithmParameterSpec)keyGenParameterSpec2);
            SecretKey secretKey = keyGenerator.generateKey();
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"keyGenerator.generateKey()");
            return secretKey;
        }
        Key key = keyStore2.getKey(keyAlias, null);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"keyStore.getKey(keyAlias, null)");
        return key;
    }

    @Nullable
    public final Pair<byte[], byte[]> encrypt(@NotNull byte[] plainText, @NotNull Key key) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_AES);
            cipher.init(1, key);
            byte[] cipherText = cipher.doFinal(plainText);
            Cipher cipher2 = cipher;
            Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"cipher");
            pair = new Pair((Object)cipherText, (Object)cipher2.getIV());
        }
        catch (Exception e2) {
            Logger.INSTANCE.e(CommonExtensionsKt.getCLASS_NAME(this), "=== encrypt " + CommonExtensionsKt.getCLASS_NAME(e2) + ", " + e2.getMessage(), e2);
            pair = null;
        }
        return pair;
    }

    @Nullable
    public final byte[] decrypt(@NotNull byte[] cipherText, @NotNull Key key, @Nullable IvParameterSpec iv) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_AES);
            cipher.init(2, key, iv);
            byArray = cipher.doFinal(cipherText);
        }
        catch (Exception e2) {
            Logger.INSTANCE.e(CommonExtensionsKt.getCLASS_NAME(this), "=== decrypt " + CommonExtensionsKt.getCLASS_NAME(e2) + ", " + e2.getMessage(), e2);
            byArray = null;
        }
        return byArray;
    }

    public static /* synthetic */ byte[] decrypt$default(SymmetricUtil symmetricUtil, byte[] byArray, Key key, IvParameterSpec ivParameterSpec, int n2, Object object) {
        if ((n2 & 4) != 0) {
            ivParameterSpec = null;
        }
        return symmetricUtil.decrypt(byArray, key, ivParameterSpec);
    }

    private SymmetricUtil() {
    }

    static {
        SymmetricUtil symmetricUtil;
        INSTANCE = symmetricUtil = new SymmetricUtil();
    }
}

