/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk;

import android.app.Activity;
import android.content.Context;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import one.credify.sdk.CredifySDK;
import one.credify.sdk.R;
import one.credify.sdk.SharedObject;
import one.credify.sdk.core.CredifyAPI;
import one.credify.sdk.core.CredifyError;
import one.credify.sdk.core.PreconditionKt;
import one.credify.sdk.core.callback.AuthenticateWithPasswordCallback;
import one.credify.sdk.core.callback.OfferListCallback;
import one.credify.sdk.core.model.Authentication;
import one.credify.sdk.core.model.Environment;
import one.credify.sdk.core.model.Offer;
import one.credify.sdk.core.model.OfferList;
import one.credify.sdk.core.model.Phone;
import one.credify.sdk.core.model.UserProfile;
import one.credify.sdk.core.protocol.AccountProtocol;
import one.credify.sdk.core.protocol.KYCProtocol;
import one.credify.sdk.core.protocol.OfferProtocol;
import one.credify.sdk.core.request.GetOfferListParam;
import one.credify.sdk.protocol.UIEKYCProtocol;
import one.credify.sdk.protocol.UIOfferProtocol;
import one.credify.sdk.scenes.CredifyActivity;
import one.credify.sdk.scenes.ekyc.model.DocumentType;
import one.credify.sdk.scenes.ekyc.vnpt.VNPTKYCActivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u000212B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020!H\u0016J2\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Lone/credify/sdk/CredifySDK;", "Lone/credify/sdk/protocol/UIOfferProtocol;", "Lone/credify/sdk/protocol/UIEKYCProtocol;", "Lone/credify/sdk/core/protocol/AccountProtocol;", "()V", "mAccountApi", "getMAccountApi", "()Lone/credify/sdk/core/protocol/AccountProtocol;", "mKYCApi", "Lone/credify/sdk/core/protocol/KYCProtocol;", "getMKYCApi", "()Lone/credify/sdk/core/protocol/KYCProtocol;", "mOfferApi", "Lone/credify/sdk/core/protocol/OfferProtocol;", "getMOfferApi", "()Lone/credify/sdk/core/protocol/OfferProtocol;", "authenticateWithPassword", "Lio/reactivex/Single;", "Lone/credify/sdk/core/model/Authentication;", "credifyId", "", "password", "", "callback", "Lone/credify/sdk/core/callback/AuthenticateWithPasswordCallback;", "phone", "Lone/credify/sdk/core/model/Phone;", "clearCache", "getOfferList", "Lio/reactivex/Observable;", "Lone/credify/sdk/core/model/OfferList;", "params", "Lone/credify/sdk/core/request/GetOfferListParam;", "Lone/credify/sdk/core/callback/OfferListCallback;", "showOffer", "context", "Landroid/content/Context;", "offer", "Lone/credify/sdk/core/model/Offer;", "userProfile", "Lone/credify/sdk/core/model/UserProfile;", "createUrl", "startKYCForResult", "activity", "Landroid/app/Activity;", "documentType", "Lone/credify/sdk/scenes/ekyc/model/DocumentType;", "requestCode", "", "Builder", "Companion", "credify-sdk_release"})
public final class CredifySDK
implements UIOfferProtocol,
UIEKYCProtocol,
AccountProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final OfferProtocol getMOfferApi() {
        return SharedObject.Companion.getInstance().getApi();
    }

    private final KYCProtocol getMKYCApi() {
        return SharedObject.Companion.getInstance().getApi();
    }

    private final AccountProtocol getMAccountApi() {
        return SharedObject.Companion.getInstance().getApi();
    }

    @Override
    @NotNull
    public Observable<OfferList> getOfferList(@NotNull GetOfferListParam params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Observable observable = this.getMOfferApi().getOfferList(params).doOnNext((Consumer)getOfferList.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mOfferApi.getOfferList(p\u2026.credifyId)\n            }");
        return observable;
    }

    @Override
    public void getOfferList(@NotNull GetOfferListParam params, @NotNull OfferListCallback callback) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getMOfferApi().getOfferList(params, new OfferListCallback(callback){
            final /* synthetic */ OfferListCallback $callback;

            public void onSuccess(@NotNull OfferList model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                SharedObject.Companion.getInstance().cacheCredifyId(model.getCredifyId());
                this.$callback.onSuccess(model);
            }

            public void onError(@NotNull CredifyError throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$callback.onError(throwable);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @Override
    public void showOffer(@NotNull Context context, @NotNull Offer offer, @NotNull UserProfile userProfile, @NotNull String createUrl, @Nullable String credifyId) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)offer, (String)"offer");
        Intrinsics.checkNotNullParameter((Object)userProfile, (String)"userProfile");
        Intrinsics.checkNotNullParameter((Object)createUrl, (String)"createUrl");
        String cachedCredifyId = SharedObject.Companion.getInstance().getCredifyId();
        CharSequence charSequence = cachedCredifyId;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            string2 = cachedCredifyId;
        } else {
            SharedObject.Companion.getInstance().cacheCredifyId(credifyId);
            string2 = credifyId;
        }
        String useCredifyId = string2;
        CredifyActivity.Companion.showOffer(context, offer, userProfile, createUrl, useCredifyId);
    }

    public final void clearCache() {
        SharedObject.Companion.getInstance().clearCredifyId();
    }

    @Override
    public void startKYCForResult(@NotNull Activity activity, @NotNull DocumentType documentType, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        String string2 = activity.getString(R.string.credify_sdk_vnpt_token_id);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026redify_sdk_vnpt_token_id)");
        String string3 = activity.getString(R.string.credify_sdk_vnpt_token_key);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026edify_sdk_vnpt_token_key)");
        String string4 = activity.getString(R.string.credify_sdk_vnpt_access_token);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"activity.getString(R.str\u2026fy_sdk_vnpt_access_token)");
        VNPTKYCActivity.Companion.startActivityForResult(activity, string2, string3, string4, documentType, requestCode);
    }

    @Override
    @NotNull
    public Single<Authentication> authenticateWithPassword(@NotNull Phone phone, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.getMAccountApi().authenticateWithPassword(phone, password);
    }

    @Override
    public void authenticateWithPassword(@NotNull Phone phone, @NotNull String password, @NotNull AuthenticateWithPasswordCallback callback) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getMAccountApi().authenticateWithPassword(phone, password, callback);
    }

    @Override
    @NotNull
    public Single<Authentication> authenticateWithPassword(@NotNull String credifyId, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)credifyId, (String)"credifyId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.getMAccountApi().authenticateWithPassword(credifyId, password);
    }

    @Override
    public void authenticateWithPassword(@NotNull String credifyId, @NotNull String password, @NotNull AuthenticateWithPasswordCallback callback) {
        Intrinsics.checkNotNullParameter((Object)credifyId, (String)"credifyId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getMAccountApi().authenticateWithPassword(credifyId, password, callback);
    }

    private CredifySDK() {
    }

    public /* synthetic */ CredifySDK(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lone/credify/sdk/CredifySDK$Builder;", "", "()V", "mApiKey", "", "mContext", "Landroid/content/Context;", "mEnvironment", "Lone/credify/sdk/core/model/Environment;", "build", "Lone/credify/sdk/CredifySDK;", "withApiKey", "apiKey", "withContext", "context", "withEnvironment", "environment", "credify-sdk_release"})
    public static final class Builder {
        private Context mContext;
        private String mApiKey;
        private Environment mEnvironment = Environment.DEVELOP;

        @NotNull
        public final Builder withContext(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.mContext = context.getApplicationContext();
            return this;
        }

        @NotNull
        public final Builder withApiKey(@NotNull String apiKey) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            this.mApiKey = apiKey;
            return this;
        }

        @NotNull
        public final Builder withEnvironment(@NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            this.mEnvironment = environment;
            return this;
        }

        @NotNull
        public final CredifySDK build() {
            Context context = this.mContext;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (context == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            PreconditionKt.requireStringNotEmpty(this.mApiKey, (Function0<? extends Object>)((Function0)build.1.INSTANCE));
            CredifySDK sdk = new CredifySDK(null);
            CredifyAPI.Builder builder = new CredifyAPI.Builder();
            Context context2 = this.mContext;
            Intrinsics.checkNotNull((Object)context2);
            Context context3 = context2.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"mContext!!.applicationContext");
            CredifyAPI.Builder builder2 = builder.withContext(context3);
            String string3 = this.mApiKey;
            Intrinsics.checkNotNull((Object)string3);
            CredifyAPI api = builder2.withApiKey(string3).withEnvironment(this.mEnvironment).build();
            SharedObject.Companion.getInstance().setSDK(sdk);
            SharedObject.Companion.getInstance().setAPI(api);
            return sdk;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lone/credify/sdk/CredifySDK$Companion;", "", "()V", "instance", "Lone/credify/sdk/CredifySDK;", "getInstance", "()Lone/credify/sdk/CredifySDK;", "credify-sdk_release"})
    public static final class Companion {
        @NotNull
        public final CredifySDK getInstance() {
            if (!SharedObject.Companion.getInstance().isSDKInitialized()) {
                throw (Throwable)new IllegalAccessException("The SDK is not initialized yet. Using " + Reflection.getOrCreateKotlinClass(Builder.class).getSimpleName() + " for building the SDK");
            }
            return SharedObject.Companion.getInstance().getSdk();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

