/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk.core;

import android.annotation.SuppressLint;
import android.content.Context;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.AccountRepositoryProtocol;
import one.credify.core.data.ClaimRepositoryProtocol;
import one.credify.core.data.KYCRepositoryProtocol;
import one.credify.core.data.KeyManagementRepositoryProtocol;
import one.credify.core.data.OfferRepositoryProtocol;
import one.credify.core.data.SharedPrefs;
import one.credify.core.network.restapi.NetworkClient;
import one.credify.sdk.core.CredifyAPI;
import one.credify.sdk.core.CredifyAPI$WhenMappings;
import one.credify.sdk.core.PreconditionKt;
import one.credify.sdk.core.callback.AuthenticateWithPasswordCallback;
import one.credify.sdk.core.callback.GetOnfidoKYCApplicantIdCallback;
import one.credify.sdk.core.callback.GetOnfidoKYCStatusCallback;
import one.credify.sdk.core.callback.GetOnfidoKYCTokenCallback;
import one.credify.sdk.core.callback.OfferListCallback;
import one.credify.sdk.core.callback.SubmitOnfidoKYCCallback;
import one.credify.sdk.core.callback.VNPTKYCResultCallback;
import one.credify.sdk.core.domain.AccountUseCase;
import one.credify.sdk.core.domain.AccountUseCaseProtocol;
import one.credify.sdk.core.domain.ClaimUseCase;
import one.credify.sdk.core.domain.ClaimUseCaseProtocol;
import one.credify.sdk.core.domain.KYCUseCase;
import one.credify.sdk.core.domain.KYCUseCaseProtocol;
import one.credify.sdk.core.domain.KeyManagementUseCase;
import one.credify.sdk.core.domain.KeyManagementUseCaseProtocol;
import one.credify.sdk.core.domain.OfferUseCase;
import one.credify.sdk.core.domain.OfferUseCaseProtocol;
import one.credify.sdk.core.extension.DataMappingExtensionKt;
import one.credify.sdk.core.model.Authentication;
import one.credify.sdk.core.model.Environment;
import one.credify.sdk.core.model.KYCStatus;
import one.credify.sdk.core.model.OfferList;
import one.credify.sdk.core.model.Phone;
import one.credify.sdk.core.model.Profile;
import one.credify.sdk.core.protocol.AccountProtocol;
import one.credify.sdk.core.protocol.KYCProtocol;
import one.credify.sdk.core.protocol.OfferProtocol;
import one.credify.sdk.core.request.GetOfferListParam;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001nB\u001f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L2\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u0007H\u0016J \u0010K\u001a\u00020P2\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020RH\u0017J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L2\u0006\u0010S\u001a\u00020T2\u0006\u0010O\u001a\u00020\u0007H\u0016J \u0010K\u001a\u00020P2\u0006\u0010S\u001a\u00020T2\u0006\u0010O\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020RH\u0017J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020W0V2\u0006\u0010X\u001a\u00020YH\u0016J\u0018\u0010U\u001a\u00020P2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Q\u001a\u00020ZH\u0017J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00070L2\u0006\u0010\\\u001a\u00020]H\u0016J\u0018\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020]2\u0006\u0010Q\u001a\u00020^H\u0017J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020`0L2\u0006\u0010a\u001a\u00020\u0007H\u0016J\u0018\u0010_\u001a\u00020P2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020bH\u0017J\u001e\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00070L2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u0007H\u0016J \u0010c\u001a\u00020P2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020eH\u0017J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020g0L2\u0006\u0010a\u001a\u00020\u0007H\u0016J\u0018\u0010f\u001a\u00020P2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020hH\u0017J&\u0010i\u001a\b\u0012\u0004\u0012\u00020`0L2\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u00020\u0007H\u0016J(\u0010i\u001a\u00020P2\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020mH\u0017R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010!\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010 \u001a\u0004\b\"\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010 \u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010 \u001a\u0004\b*\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010 \u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010 \u001a\u0004\b3\u00104R\u001b\u00106\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010 \u001a\u0004\b7\u0010\u001aR\u001b\u00109\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010 \u001a\u0004\b:\u0010\u0016R\u001b\u0010<\u001a\u00020=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010 \u001a\u0004\b>\u0010?R\u001b\u0010A\u001a\u00020B8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010 \u001a\u0004\bC\u0010DR\u000e\u0010F\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020B8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010D\u00a8\u0006o"}, d2={"Lone/credify/sdk/core/CredifyAPI;", "Lone/credify/sdk/core/protocol/OfferProtocol;", "Lone/credify/sdk/core/protocol/KYCProtocol;", "Lone/credify/sdk/core/protocol/AccountProtocol;", "mAppContext", "Landroid/content/Context;", "mApiKey", "", "mEnvironment", "Lone/credify/sdk/core/model/Environment;", "(Landroid/content/Context;Ljava/lang/String;Lone/credify/sdk/core/model/Environment;)V", "accountUseCase", "Lone/credify/sdk/core/domain/AccountUseCaseProtocol;", "getAccountUseCase", "()Lone/credify/sdk/core/domain/AccountUseCaseProtocol;", "claimUseCase", "Lone/credify/sdk/core/domain/ClaimUseCaseProtocol;", "getClaimUseCase", "()Lone/credify/sdk/core/domain/ClaimUseCaseProtocol;", "keyManagementUseCase", "Lone/credify/sdk/core/domain/KeyManagementUseCaseProtocol;", "getKeyManagementUseCase", "()Lone/credify/sdk/core/domain/KeyManagementUseCaseProtocol;", "kycUseCase", "Lone/credify/sdk/core/domain/KYCUseCaseProtocol;", "getKycUseCase", "()Lone/credify/sdk/core/domain/KYCUseCaseProtocol;", "mAccountRepository", "Lone/credify/core/data/AccountRepositoryProtocol;", "getMAccountRepository", "()Lone/credify/core/data/AccountRepositoryProtocol;", "mAccountRepository$delegate", "Lkotlin/Lazy;", "mAccountUseCase", "getMAccountUseCase", "mAccountUseCase$delegate", "mClaimRepository", "Lone/credify/core/data/ClaimRepositoryProtocol;", "getMClaimRepository", "()Lone/credify/core/data/ClaimRepositoryProtocol;", "mClaimRepository$delegate", "mClaimUseCase", "getMClaimUseCase", "mClaimUseCase$delegate", "mKMRepository", "Lone/credify/core/data/KeyManagementRepositoryProtocol;", "getMKMRepository", "()Lone/credify/core/data/KeyManagementRepositoryProtocol;", "mKMRepository$delegate", "mKYCRepository", "Lone/credify/core/data/KYCRepositoryProtocol;", "getMKYCRepository", "()Lone/credify/core/data/KYCRepositoryProtocol;", "mKYCRepository$delegate", "mKYCUseCase", "getMKYCUseCase", "mKYCUseCase$delegate", "mKeyManagementUseCase", "getMKeyManagementUseCase", "mKeyManagementUseCase$delegate", "mOfferRepository", "Lone/credify/core/data/OfferRepositoryProtocol;", "getMOfferRepository", "()Lone/credify/core/data/OfferRepositoryProtocol;", "mOfferRepository$delegate", "mOfferUseCase", "Lone/credify/sdk/core/domain/OfferUseCaseProtocol;", "getMOfferUseCase", "()Lone/credify/sdk/core/domain/OfferUseCaseProtocol;", "mOfferUseCase$delegate", "mOnfidoRestUrl", "mOnfidoToken", "mRestUrl", "offerUseCase", "getOfferUseCase", "authenticateWithPassword", "Lio/reactivex/Single;", "Lone/credify/sdk/core/model/Authentication;", "credifyId", "password", "", "callback", "Lone/credify/sdk/core/callback/AuthenticateWithPasswordCallback;", "phone", "Lone/credify/sdk/core/model/Phone;", "getOfferList", "Lio/reactivex/Observable;", "Lone/credify/sdk/core/model/OfferList;", "params", "Lone/credify/sdk/core/request/GetOfferListParam;", "Lone/credify/sdk/core/callback/OfferListCallback;", "getOnfidoKYCApplicantId", "profile", "Lone/credify/sdk/core/model/Profile;", "Lone/credify/sdk/core/callback/GetOnfidoKYCApplicantIdCallback;", "getOnfidoKYCStatus", "Lone/credify/sdk/core/model/KYCStatus;", "applicantId", "Lone/credify/sdk/core/callback/GetOnfidoKYCStatusCallback;", "getOnfidoKYCToken", "packageName", "Lone/credify/sdk/core/callback/GetOnfidoKYCTokenCallback;", "submitOnfidoKYC", "", "Lone/credify/sdk/core/callback/SubmitOnfidoKYCCallback;", "uploadVNPTKYCResult", "infoResultJson", "compareResultJson", "livenessCardFrontResultJson", "Lone/credify/sdk/core/callback/VNPTKYCResultCallback;", "Builder", "credify-sdk-core_release"})
public final class CredifyAPI
implements OfferProtocol,
KYCProtocol,
AccountProtocol {
    private final String mRestUrl;
    private final String mOnfidoRestUrl;
    private final String mOnfidoToken;
    private final Lazy mKMRepository$delegate;
    private final Lazy mAccountRepository$delegate;
    private final Lazy mOfferRepository$delegate;
    private final Lazy mClaimRepository$delegate;
    private final Lazy mKYCRepository$delegate;
    private final Lazy mOfferUseCase$delegate;
    private final Lazy mAccountUseCase$delegate;
    private final Lazy mClaimUseCase$delegate;
    private final Lazy mKeyManagementUseCase$delegate;
    private final Lazy mKYCUseCase$delegate;
    private final Context mAppContext;
    private final String mApiKey;
    private final Environment mEnvironment;

    private final KeyManagementRepositoryProtocol getMKMRepository() {
        Lazy lazy = this.mKMRepository$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KeyManagementRepositoryProtocol)lazy.getValue();
    }

    private final AccountRepositoryProtocol getMAccountRepository() {
        Lazy lazy = this.mAccountRepository$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AccountRepositoryProtocol)lazy.getValue();
    }

    private final OfferRepositoryProtocol getMOfferRepository() {
        Lazy lazy = this.mOfferRepository$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OfferRepositoryProtocol)lazy.getValue();
    }

    private final ClaimRepositoryProtocol getMClaimRepository() {
        Lazy lazy = this.mClaimRepository$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ClaimRepositoryProtocol)lazy.getValue();
    }

    private final KYCRepositoryProtocol getMKYCRepository() {
        Lazy lazy = this.mKYCRepository$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KYCRepositoryProtocol)lazy.getValue();
    }

    private final OfferUseCaseProtocol getMOfferUseCase() {
        Lazy lazy = this.mOfferUseCase$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OfferUseCaseProtocol)lazy.getValue();
    }

    @NotNull
    public final OfferUseCaseProtocol getOfferUseCase() {
        return this.getMOfferUseCase();
    }

    private final AccountUseCaseProtocol getMAccountUseCase() {
        Lazy lazy = this.mAccountUseCase$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AccountUseCaseProtocol)lazy.getValue();
    }

    @NotNull
    public final AccountUseCaseProtocol getAccountUseCase() {
        return this.getMAccountUseCase();
    }

    private final ClaimUseCaseProtocol getMClaimUseCase() {
        Lazy lazy = this.mClaimUseCase$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ClaimUseCaseProtocol)lazy.getValue();
    }

    @NotNull
    public final ClaimUseCaseProtocol getClaimUseCase() {
        return this.getMClaimUseCase();
    }

    private final KeyManagementUseCaseProtocol getMKeyManagementUseCase() {
        Lazy lazy = this.mKeyManagementUseCase$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KeyManagementUseCaseProtocol)lazy.getValue();
    }

    @NotNull
    public final KeyManagementUseCaseProtocol getKeyManagementUseCase() {
        return this.getMKeyManagementUseCase();
    }

    private final KYCUseCaseProtocol getMKYCUseCase() {
        Lazy lazy = this.mKYCUseCase$delegate;
        CredifyAPI credifyAPI = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KYCUseCaseProtocol)lazy.getValue();
    }

    @NotNull
    public final KYCUseCaseProtocol getKycUseCase() {
        return this.getMKYCUseCase();
    }

    @Override
    @NotNull
    public Observable<OfferList> getOfferList(@NotNull GetOfferListParam params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.getMOfferUseCase().getOfferList(params);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void getOfferList(@NotNull GetOfferListParam params, @NotNull OfferListCallback callback) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getOfferList(params).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<OfferList>(callback){
            final /* synthetic */ OfferListCallback $callback;

            public final void accept(OfferList it) {
                OfferList offerList = it;
                Intrinsics.checkNotNullExpressionValue((Object)offerList, (String)"it");
                this.$callback.onSuccess(offerList);
            }
            {
                this.$callback = offerListCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ OfferListCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = offerListCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<KYCStatus> uploadVNPTKYCResult(@NotNull String infoResultJson, @NotNull String compareResultJson, @NotNull String livenessCardFrontResultJson) {
        Intrinsics.checkNotNullParameter((Object)infoResultJson, (String)"infoResultJson");
        Intrinsics.checkNotNullParameter((Object)compareResultJson, (String)"compareResultJson");
        Intrinsics.checkNotNullParameter((Object)livenessCardFrontResultJson, (String)"livenessCardFrontResultJson");
        return this.getMKYCUseCase().uploadVNPTKYCResult(infoResultJson, compareResultJson, livenessCardFrontResultJson);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void uploadVNPTKYCResult(@NotNull String infoResultJson, @NotNull String compareResultJson, @NotNull String livenessCardFrontResultJson, @NotNull VNPTKYCResultCallback callback) {
        Intrinsics.checkNotNullParameter((Object)infoResultJson, (String)"infoResultJson");
        Intrinsics.checkNotNullParameter((Object)compareResultJson, (String)"compareResultJson");
        Intrinsics.checkNotNullParameter((Object)livenessCardFrontResultJson, (String)"livenessCardFrontResultJson");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.uploadVNPTKYCResult(infoResultJson, compareResultJson, livenessCardFrontResultJson).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<KYCStatus>(callback){
            final /* synthetic */ VNPTKYCResultCallback $callback;

            public final void accept(KYCStatus it) {
                KYCStatus kYCStatus = it;
                Intrinsics.checkNotNullExpressionValue((Object)kYCStatus, (String)"it");
                this.$callback.onSuccess(kYCStatus);
            }
            {
                this.$callback = vNPTKYCResultCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ VNPTKYCResultCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = vNPTKYCResultCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<String> getOnfidoKYCApplicantId(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getMKYCUseCase().getOnfidoKYCApplicantId(profile);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void getOnfidoKYCApplicantId(@NotNull Profile profile, @NotNull GetOnfidoKYCApplicantIdCallback callback) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getOnfidoKYCApplicantId(profile).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<String>(callback){
            final /* synthetic */ GetOnfidoKYCApplicantIdCallback $callback;

            public final void accept(String it) {
                String string2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                this.$callback.onSuccess(string2);
            }
            {
                this.$callback = getOnfidoKYCApplicantIdCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ GetOnfidoKYCApplicantIdCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = getOnfidoKYCApplicantIdCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<String> getOnfidoKYCToken(@NotNull String applicantId, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.getMKYCUseCase().getOnfidoKYCToken(applicantId, packageName);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void getOnfidoKYCToken(@NotNull String applicantId, @NotNull String packageName, @NotNull GetOnfidoKYCTokenCallback callback) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getOnfidoKYCToken(applicantId, packageName).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<String>(callback){
            final /* synthetic */ GetOnfidoKYCTokenCallback $callback;

            public final void accept(String it) {
                String string2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                this.$callback.onSuccess(string2);
            }
            {
                this.$callback = getOnfidoKYCTokenCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ GetOnfidoKYCTokenCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = getOnfidoKYCTokenCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<Boolean> submitOnfidoKYC(@NotNull String applicantId) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        return this.getMKYCUseCase().submitOnfidoKYC(applicantId);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void submitOnfidoKYC(@NotNull String applicantId, @NotNull SubmitOnfidoKYCCallback callback) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.submitOnfidoKYC(applicantId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(callback){
            final /* synthetic */ SubmitOnfidoKYCCallback $callback;

            public final void accept(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"it");
                this.$callback.onSuccess(bl);
            }
            {
                this.$callback = submitOnfidoKYCCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ SubmitOnfidoKYCCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = submitOnfidoKYCCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<KYCStatus> getOnfidoKYCStatus(@NotNull String applicantId) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        return this.getMKYCUseCase().getOnfidoKYCStatus(applicantId);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void getOnfidoKYCStatus(@NotNull String applicantId, @NotNull GetOnfidoKYCStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.getOnfidoKYCStatus(applicantId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<KYCStatus>(callback){
            final /* synthetic */ GetOnfidoKYCStatusCallback $callback;

            public final void accept(KYCStatus it) {
                KYCStatus kYCStatus = it;
                Intrinsics.checkNotNullExpressionValue((Object)kYCStatus, (String)"it");
                this.$callback.onSuccess(kYCStatus);
            }
            {
                this.$callback = getOnfidoKYCStatusCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ GetOnfidoKYCStatusCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = getOnfidoKYCStatusCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<Authentication> authenticateWithPassword(@NotNull String credifyId, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)credifyId, (String)"credifyId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.getMAccountUseCase().authenticateWithPassword(credifyId, password);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void authenticateWithPassword(@NotNull String credifyId, @NotNull String password, @NotNull AuthenticateWithPasswordCallback callback) {
        Intrinsics.checkNotNullParameter((Object)credifyId, (String)"credifyId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.authenticateWithPassword(credifyId, password).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Authentication>(callback){
            final /* synthetic */ AuthenticateWithPasswordCallback $callback;

            public final void accept(Authentication it) {
                Authentication authentication = it;
                Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"it");
                this.$callback.onSuccess(authentication);
            }
            {
                this.$callback = authenticateWithPasswordCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ AuthenticateWithPasswordCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = authenticateWithPasswordCallback;
            }
        });
    }

    @Override
    @NotNull
    public Single<Authentication> authenticateWithPassword(@NotNull Phone phone, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.getMAccountUseCase().authenticateWithPassword(phone, password);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void authenticateWithPassword(@NotNull Phone phone, @NotNull String password, @NotNull AuthenticateWithPasswordCallback callback) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.authenticateWithPassword(phone, password).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Authentication>(callback){
            final /* synthetic */ AuthenticateWithPasswordCallback $callback;

            public final void accept(Authentication it) {
                Authentication authentication = it;
                Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"it");
                this.$callback.onSuccess(authentication);
            }
            {
                this.$callback = authenticateWithPasswordCallback;
            }
        }, (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ AuthenticateWithPasswordCallback $callback;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$callback.onError(DataMappingExtensionKt.getCredifyError(throwable));
            }
            {
                this.$callback = authenticateWithPasswordCallback;
            }
        });
    }

    private CredifyAPI(Context mAppContext, String mApiKey, Environment mEnvironment) {
        String string2;
        String string3;
        String string4;
        this.mAppContext = mAppContext;
        this.mApiKey = mApiKey;
        this.mEnvironment = mEnvironment;
        switch (CredifyAPI$WhenMappings.$EnumSwitchMapping$0[this.mEnvironment.ordinal()]) {
            case 1: {
                string4 = "https://dev-api.credify.one";
                break;
            }
            case 2: {
                string4 = "https://uat-api.credify.one";
                break;
            }
            case 3: {
                string4 = "https://sit-api.credify.one";
                break;
            }
            case 4: {
                string4 = "https://sandbox-api.credify.one";
                break;
            }
            case 5: {
                string4 = "https://api.credify.one";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.mRestUrl = string4;
        switch (CredifyAPI$WhenMappings.$EnumSwitchMapping$1[this.mEnvironment.ordinal()]) {
            case 1: {
                string3 = "https://api.onfido.com";
                break;
            }
            case 2: {
                string3 = "https://api.onfido.com";
                break;
            }
            case 3: {
                string3 = "https://api.onfido.com";
                break;
            }
            case 4: {
                string3 = "https://api.onfido.com";
                break;
            }
            case 5: {
                string3 = "https://api.onfido.com";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.mOnfidoRestUrl = string3;
        switch (CredifyAPI$WhenMappings.$EnumSwitchMapping$2[this.mEnvironment.ordinal()]) {
            case 1: {
                string2 = "api_sandbox.QKnDjXAL6p2.DNl3C9JLr6nnSWAC2qboRnQ0Zh-WeZ4x";
                break;
            }
            case 2: {
                string2 = "api_sandbox.6RG_X_Cv3zi.xzh_mXKL38nQJMga6UFni8gK0JYaiGbD";
                break;
            }
            case 3: {
                string2 = "api_sandbox.QKnDjXAL6p2.DNl3C9JLr6nnSWAC2qboRnQ0Zh-WeZ4x";
                break;
            }
            case 4: {
                string2 = "api_sandbox.Wcwiy3NHyn0.wW2_d0qJzhuRAwOrqNqJxzrQzauC2-cV";
                break;
            }
            case 5: {
                string2 = "api_live.x26vkyaRdW2.MLWlTG_pm94nSQYOKBQGHH7wwArs42Mv";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.mOnfidoToken = string2;
        this.mKMRepository$delegate = LazyKt.lazy((Function0)mKMRepository.2.INSTANCE);
        this.mAccountRepository$delegate = LazyKt.lazy((Function0)mAccountRepository.2.INSTANCE);
        this.mOfferRepository$delegate = LazyKt.lazy((Function0)mOfferRepository.2.INSTANCE);
        this.mClaimRepository$delegate = LazyKt.lazy((Function0)mClaimRepository.2.INSTANCE);
        this.mKYCRepository$delegate = LazyKt.lazy((Function0)mKYCRepository.2.INSTANCE);
        this.mOfferUseCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OfferUseCase>(this){
            final /* synthetic */ CredifyAPI this$0;

            @NotNull
            public final OfferUseCase invoke() {
                return new OfferUseCase(CredifyAPI.access$getMOfferRepository$p(this.this$0), CredifyAPI.access$getMKMRepository$p(this.this$0), CredifyAPI.access$getMAccountRepository$p(this.this$0), CredifyAPI.access$getMClaimRepository$p(this.this$0));
            }
            {
                this.this$0 = credifyAPI;
                super(0);
            }
        }));
        this.mAccountUseCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AccountUseCase>(this){
            final /* synthetic */ CredifyAPI this$0;

            @NotNull
            public final AccountUseCase invoke() {
                return new AccountUseCase(CredifyAPI.access$getMAccountRepository$p(this.this$0), CredifyAPI.access$getMKMRepository$p(this.this$0));
            }
            {
                this.this$0 = credifyAPI;
                super(0);
            }
        }));
        this.mClaimUseCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClaimUseCase>(this){
            final /* synthetic */ CredifyAPI this$0;

            @NotNull
            public final ClaimUseCase invoke() {
                ClaimRepositoryProtocol claimRepositoryProtocol = CredifyAPI.access$getMClaimRepository$p(this.this$0);
                AccountRepositoryProtocol accountRepositoryProtocol = CredifyAPI.access$getMAccountRepository$p(this.this$0);
                KeyManagementRepositoryProtocol keyManagementRepositoryProtocol = CredifyAPI.access$getMKMRepository$p(this.this$0);
                return new ClaimUseCase(accountRepositoryProtocol, keyManagementRepositoryProtocol, claimRepositoryProtocol);
            }
            {
                this.this$0 = credifyAPI;
                super(0);
            }
        }));
        this.mKeyManagementUseCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KeyManagementUseCase>(this){
            final /* synthetic */ CredifyAPI this$0;

            @NotNull
            public final KeyManagementUseCase invoke() {
                return new KeyManagementUseCase(CredifyAPI.access$getMKMRepository$p(this.this$0));
            }
            {
                this.this$0 = credifyAPI;
                super(0);
            }
        }));
        this.mKYCUseCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KYCUseCase>(this){
            final /* synthetic */ CredifyAPI this$0;

            @NotNull
            public final KYCUseCase invoke() {
                return new KYCUseCase(CredifyAPI.access$getMKYCRepository$p(this.this$0));
            }
            {
                this.this$0 = credifyAPI;
                super(0);
            }
        }));
        SharedPrefs.INSTANCE.init(this.mAppContext, "one.credify.sdk.corerelease");
        NetworkClient.INSTANCE.initForSDK(this.mRestUrl, this.mApiKey, this.mRestUrl, this.mOnfidoRestUrl, this.mOnfidoToken);
    }

    public /* synthetic */ CredifyAPI(Context mAppContext, String mApiKey, Environment mEnvironment, DefaultConstructorMarker $constructor_marker) {
        this(mAppContext, mApiKey, mEnvironment);
    }

    public static final /* synthetic */ OfferRepositoryProtocol access$getMOfferRepository$p(CredifyAPI $this) {
        return $this.getMOfferRepository();
    }

    public static final /* synthetic */ KeyManagementRepositoryProtocol access$getMKMRepository$p(CredifyAPI $this) {
        return $this.getMKMRepository();
    }

    public static final /* synthetic */ AccountRepositoryProtocol access$getMAccountRepository$p(CredifyAPI $this) {
        return $this.getMAccountRepository();
    }

    public static final /* synthetic */ ClaimRepositoryProtocol access$getMClaimRepository$p(CredifyAPI $this) {
        return $this.getMClaimRepository();
    }

    public static final /* synthetic */ KYCRepositoryProtocol access$getMKYCRepository$p(CredifyAPI $this) {
        return $this.getMKYCRepository();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lone/credify/sdk/core/CredifyAPI$Builder;", "", "()V", "mApiKey", "", "mContext", "Landroid/content/Context;", "mEnvironment", "Lone/credify/sdk/core/model/Environment;", "build", "Lone/credify/sdk/core/CredifyAPI;", "withApiKey", "apiKey", "withContext", "context", "withEnvironment", "environment", "credify-sdk-core_release"})
    public static final class Builder {
        private Context mContext;
        private String mApiKey;
        private Environment mEnvironment = Environment.DEVELOP;

        @NotNull
        public final Builder withContext(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.mContext = context.getApplicationContext();
            return this;
        }

        @NotNull
        public final Builder withApiKey(@NotNull String apiKey) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            this.mApiKey = apiKey;
            return this;
        }

        @NotNull
        public final Builder withEnvironment(@NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            this.mEnvironment = environment;
            return this;
        }

        @NotNull
        public final CredifyAPI build() {
            Context context = this.mContext;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (context == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            PreconditionKt.requireStringNotEmpty(this.mApiKey, (Function0<? extends Object>)((Function0)build.1.INSTANCE));
            Context context2 = this.mContext;
            Intrinsics.checkNotNull((Object)context2);
            Context context3 = context2.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"mContext!!.applicationContext");
            String string3 = this.mApiKey;
            Intrinsics.checkNotNull((Object)string3);
            return new CredifyAPI(context3, string3, this.mEnvironment, null);
        }
    }
}

