/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk.core.domain;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.AccountRepositoryProtocol;
import one.credify.core.data.KeyManagementRepositoryProtocol;
import one.credify.core.entity.AccessTokeResponse;
import one.credify.core.entity.AccessTokenResponseData;
import one.credify.core.entity.CreateAccountFromProviderResponseData;
import one.credify.core.entity.EncryptedKeyResponseData;
import one.credify.core.entity.Entity;
import one.credify.core.entity.NewIdentityEntity;
import one.credify.core.model.LoginWithPasswordModel;
import one.credify.crypto.Encryption;
import one.credify.crypto.Signing;
import one.credify.sdk.core.domain.AccountUseCase;
import one.credify.sdk.core.domain.AccountUseCaseProtocol;
import one.credify.sdk.core.extension.DataMappingExtensionKt;
import one.credify.sdk.core.extension.ModelMappingExtensionKt;
import one.credify.sdk.core.model.AccountCreated;
import one.credify.sdk.core.model.Authentication;
import one.credify.sdk.core.model.Identity;
import one.credify.sdk.core.model.Phone;
import one.credify.sdk.core.model.UserProfile;
import one.credify.sdk.core.util.CryptoUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lone/credify/sdk/core/domain/AccountUseCase;", "Lone/credify/sdk/core/domain/AccountUseCaseProtocol;", "mAccountRepository", "Lone/credify/core/data/AccountRepositoryProtocol;", "mKMRepository", "Lone/credify/core/data/KeyManagementRepositoryProtocol;", "(Lone/credify/core/data/AccountRepositoryProtocol;Lone/credify/core/data/KeyManagementRepositoryProtocol;)V", "authenticateWithPassword", "Lio/reactivex/Single;", "Lone/credify/sdk/core/model/Authentication;", "credifyId", "", "password", "phone", "Lone/credify/sdk/core/model/Phone;", "createAccount", "Lio/reactivex/Observable;", "Lone/credify/sdk/core/model/AccountCreated;", "createAccountUrl", "profile", "Lone/credify/sdk/core/model/UserProfile;", "createAccountWithKeys", "getAuthentication", "accessToken", "login", "credify-sdk-core_release"})
public final class AccountUseCase
implements AccountUseCaseProtocol {
    private final AccountRepositoryProtocol mAccountRepository;
    private final KeyManagementRepositoryProtocol mKMRepository;

    @Override
    @NotNull
    public Single<String> login(@NotNull String credifyId, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)credifyId, (String)"credifyId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.login(credifyId, null, password);
    }

    @Override
    @NotNull
    public Single<String> login(@NotNull Phone phone, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.login(null, phone, password);
    }

    private final Single<String> login(String credifyId, Phone phone, String password) {
        Phone phone2 = phone;
        String string2 = this.mKMRepository.hashPassword(password);
        String string3 = password;
        String string4 = credifyId;
        String string5 = null;
        String string6 = null;
        Single single = this.mAccountRepository.login(new LoginWithPasswordModel(phone2 != null ? ModelMappingExtensionKt.toModel(phone2) : null, string5, string6, string4, string3, string2)).doOnSuccess((Consumer)new Consumer<AccessTokeResponse>(this){
            final /* synthetic */ AccountUseCase this$0;

            public final void accept(AccessTokeResponse response) {
                AccountRepositoryProtocol accountRepositoryProtocol = AccountUseCase.access$getMAccountRepository$p(this.this$0);
                AccessTokenResponseData accessTokenResponseData = response.getData();
                Intrinsics.checkNotNull((Object)accessTokenResponseData);
                accountRepositoryProtocol.cacheAccessToken(accessTokenResponseData.getAccessToken());
            }
            {
                this.this$0 = accountUseCase;
            }
        }).map((Function)login.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"mAccountRepository.login\u2026{ it.data!!.accessToken }");
        return single;
    }

    @Override
    @NotNull
    public Observable<AccountCreated> createAccount(@NotNull UserProfile profile, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Observable observable = this.mAccountRepository.createAccountFromProvider(profile.getId(), password).toObservable().map((Function)createAccount.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mAccountRepository.creat\u2026tityId = it.id)\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<AccountCreated> createAccount(@NotNull String createAccountUrl, @NotNull UserProfile profile, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)createAccountUrl, (String)"createAccountUrl");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Observable observable = this.mAccountRepository.createAccountFromProvider(createAccountUrl, profile.getId(), password).toObservable().map((Function)createAccount.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mAccountRepository.creat\u2026tityId = it.id)\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<AccountCreated> createAccountWithKeys(@NotNull UserProfile profile, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Observable observable = this.mKMRepository.generateKeys().toObservable().flatMap((Function)new Function<Pair<? extends Encryption, ? extends Signing>, ObservableSource<? extends CreateAccountFromProviderResponseData>>(this, profile, password){
            final /* synthetic */ AccountUseCase this$0;
            final /* synthetic */ UserProfile $profile;
            final /* synthetic */ String $password;

            public final ObservableSource<? extends CreateAccountFromProviderResponseData> apply(@NotNull Pair<? extends Encryption, ? extends Signing> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Encryption encryptionKey = (Encryption)it.getFirst();
                Signing signingKey = (Signing)it.getSecond();
                AccountRepositoryProtocol accountRepositoryProtocol = AccountUseCase.access$getMAccountRepository$p(this.this$0);
                String string2 = this.$profile.getId();
                String string3 = encryptionKey.getPublicKeyAsPKSC8();
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = encryptionKey.exportPrivateKey(this.$password);
                String string5 = signingKey.getPublicKeyAsPKSC8();
                if (string5 == null) {
                    string5 = "";
                }
                return (ObservableSource)accountRepositoryProtocol.createAccountFromProvider(string2, this.$password, string3, string4, string5, signingKey.exportPrivateKey(this.$password)).toObservable();
            }
            {
                this.this$0 = accountUseCase;
                this.$profile = userProfile;
                this.$password = string2;
            }
        }).map((Function)createAccountWithKeys.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mKMRepository.generateKe\u2026Id = it.id)\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<AccountCreated> createAccountWithKeys(@NotNull String createAccountUrl, @NotNull UserProfile profile, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)createAccountUrl, (String)"createAccountUrl");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Observable observable = this.mKMRepository.generateKeys().toObservable().flatMap((Function)new Function<Pair<? extends Encryption, ? extends Signing>, ObservableSource<? extends CreateAccountFromProviderResponseData>>(this, createAccountUrl, profile, password){
            final /* synthetic */ AccountUseCase this$0;
            final /* synthetic */ String $createAccountUrl;
            final /* synthetic */ UserProfile $profile;
            final /* synthetic */ String $password;

            public final ObservableSource<? extends CreateAccountFromProviderResponseData> apply(@NotNull Pair<? extends Encryption, ? extends Signing> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Encryption encryptionKey = (Encryption)it.getFirst();
                Signing signingKey = (Signing)it.getSecond();
                AccountRepositoryProtocol accountRepositoryProtocol = AccountUseCase.access$getMAccountRepository$p(this.this$0);
                String string2 = this.$profile.getId();
                String string3 = encryptionKey.getPublicKeyAsPKSC8();
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = encryptionKey.exportPrivateKey(this.$password);
                String string5 = signingKey.getPublicKeyAsPKSC8();
                if (string5 == null) {
                    string5 = "";
                }
                return (ObservableSource)accountRepositoryProtocol.createAccountFromProvider(this.$createAccountUrl, string2, this.$password, string3, string4, string5, signingKey.exportPrivateKey(this.$password)).toObservable();
            }
            {
                this.this$0 = accountUseCase;
                this.$createAccountUrl = string2;
                this.$profile = userProfile;
                this.$password = string3;
            }
        }).map((Function)createAccountWithKeys.4.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mKMRepository.generateKe\u2026Id = it.id)\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Single<Authentication> authenticateWithPassword(@NotNull String credifyId, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)credifyId, (String)"credifyId");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Single single = this.login(credifyId, password).flatMap((Function)new Function<String, SingleSource<? extends Authentication>>(this, password){
            final /* synthetic */ AccountUseCase this$0;
            final /* synthetic */ String $password;

            public final SingleSource<? extends Authentication> apply(@NotNull String accessToken) {
                Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
                return (SingleSource)AccountUseCase.access$getAuthentication(this.this$0, this.$password, accessToken);
            }
            {
                this.this$0 = accountUseCase;
                this.$password = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"login(credifyId = credif\u2026ccessToken)\n            }");
        return single;
    }

    @Override
    @NotNull
    public Single<Authentication> authenticateWithPassword(@NotNull Phone phone, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Single single = this.login(phone, password).flatMap((Function)new Function<String, SingleSource<? extends Authentication>>(this, password){
            final /* synthetic */ AccountUseCase this$0;
            final /* synthetic */ String $password;

            public final SingleSource<? extends Authentication> apply(@NotNull String accessToken) {
                Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
                return (SingleSource)AccountUseCase.access$getAuthentication(this.this$0, this.$password, accessToken);
            }
            {
                this.this$0 = accountUseCase;
                this.$password = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"login(phone = phone, pas\u2026ccessToken)\n            }");
        return single;
    }

    private final Single<Authentication> getAuthentication(String password, String accessToken) {
        Single single = Single.zip((SingleSource)((SingleSource)this.mKMRepository.getEncryptedKey().map((Function)getAuthentication.1.INSTANCE).map((Function)new Function<EncryptedKeyResponseData, Pair<? extends Signing, ? extends Encryption>>(this, password){
            final /* synthetic */ AccountUseCase this$0;
            final /* synthetic */ String $password;

            public final Pair<Signing, Encryption> apply(@NotNull EncryptedKeyResponseData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CryptoUtils.INSTANCE.decryptKey(AccountUseCase.access$getMKMRepository$p(this.this$0), this.$password, it);
            }
            {
                this.this$0 = accountUseCase;
                this.$password = string2;
            }
        })), (SingleSource)((SingleSource)this.mAccountRepository.getIndividualEncryptedIdentities().map((Function)getAuthentication.3.INSTANCE)), (BiFunction)((BiFunction)new BiFunction<Pair<? extends Signing, ? extends Encryption>, Entity, Authentication>(accessToken){
            final /* synthetic */ String $accessToken;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Authentication apply(@NotNull Pair<? extends Signing, ? extends Encryption> keyPair, @NotNull Entity encryptedIdentityList) {
                Collection<Identity> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(keyPair, (String)"keyPair");
                Intrinsics.checkNotNullParameter((Object)encryptedIdentityList, (String)"encryptedIdentityList");
                Entity entity = encryptedIdentityList.decrypt((Encryption)keyPair.getSecond());
                Iterable iterable = entity.getIdentities();
                String string2 = entity.getId();
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NewIdentityEntity newIdentityEntity = (NewIdentityEntity)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Identity identity = DataMappingExtensionKt.toData((NewIdentityEntity)it);
                    collection.add(identity);
                }
                collection = (List)destination$iv$iv;
                String string3 = this.$accessToken;
                List list = collection;
                String string4 = string2;
                return new Authentication(string4, list, string3);
            }
            {
                this.$accessToken = string2;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.zip(\n            \u2026)\n            }\n        )");
        return single;
    }

    public AccountUseCase(@NotNull AccountRepositoryProtocol mAccountRepository2, @NotNull KeyManagementRepositoryProtocol mKMRepository2) {
        Intrinsics.checkNotNullParameter((Object)mAccountRepository2, (String)"mAccountRepository");
        Intrinsics.checkNotNullParameter((Object)mKMRepository2, (String)"mKMRepository");
        this.mAccountRepository = mAccountRepository2;
        this.mKMRepository = mKMRepository2;
    }

    public static final /* synthetic */ AccountRepositoryProtocol access$getMAccountRepository$p(AccountUseCase $this) {
        return $this.mAccountRepository;
    }

    public static final /* synthetic */ Single access$getAuthentication(AccountUseCase $this, String password, String accessToken) {
        return $this.getAuthentication(password, accessToken);
    }

    public static final /* synthetic */ KeyManagementRepositoryProtocol access$getMKMRepository$p(AccountUseCase $this) {
        return $this.mKMRepository;
    }
}

