/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk.core.domain;

import io.reactivex.Single;
import io.reactivex.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.KYCRepositoryProtocol;
import one.credify.core.entity.KYCResultRequest;
import one.credify.core.entity.UploadKYCRequest;
import one.credify.core.model.IdentityProvider;
import one.credify.sdk.core.domain.KYCUseCase;
import one.credify.sdk.core.domain.KYCUseCaseProtocol;
import one.credify.sdk.core.extension.DataMappingExtensionKt;
import one.credify.sdk.core.extension.StringExtensionKt;
import one.credify.sdk.core.model.KYCStatus;
import one.credify.sdk.core.model.Profile;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\f\u001a\u00020\u0007H\u0016J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lone/credify/sdk/core/domain/KYCUseCase;", "Lone/credify/sdk/core/domain/KYCUseCaseProtocol;", "mKYCRepository", "Lone/credify/core/data/KYCRepositoryProtocol;", "(Lone/credify/core/data/KYCRepositoryProtocol;)V", "getOnfidoKYCApplicantId", "Lio/reactivex/Single;", "", "profile", "Lone/credify/sdk/core/model/Profile;", "getOnfidoKYCStatus", "Lone/credify/sdk/core/model/KYCStatus;", "applicantId", "getOnfidoKYCToken", "packageName", "submitOnfidoKYC", "", "uploadVNPTKYCResult", "infoResultJson", "compareResultJson", "livenessCardFrontResultJson", "credify-sdk-core_release"})
public final class KYCUseCase
implements KYCUseCaseProtocol {
    private final KYCRepositoryProtocol mKYCRepository;

    @Override
    @NotNull
    public Single<KYCStatus> uploadVNPTKYCResult(@NotNull String infoResultJson, @NotNull String compareResultJson, @NotNull String livenessCardFrontResultJson) {
        Intrinsics.checkNotNullParameter((Object)infoResultJson, (String)"infoResultJson");
        Intrinsics.checkNotNullParameter((Object)compareResultJson, (String)"compareResultJson");
        Intrinsics.checkNotNullParameter((Object)livenessCardFrontResultJson, (String)"livenessCardFrontResultJson");
        JSONObject infoResultObject = StringExtensionKt.vnptJsonStringToJSONObject(infoResultJson);
        JSONObject compareResultObject = StringExtensionKt.vnptJsonStringToJSONObject(compareResultJson);
        JSONObject livenessCardFrontResultObject = StringExtensionKt.vnptJsonStringToJSONObject(livenessCardFrontResultJson);
        UploadKYCRequest params = new UploadKYCRequest(new KYCResultRequest(infoResultObject, compareResultObject, livenessCardFrontResultObject), IdentityProvider.VNPT.name());
        Single single = this.mKYCRepository.uploadKYCResult(params).map((Function)uploadVNPTKYCResult.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"mKYCRepository.uploadKYC\u2026          )\n            }");
        return single;
    }

    @Override
    @NotNull
    public Single<String> getOnfidoKYCApplicantId(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Single single = this.mKYCRepository.startKYC(DataMappingExtensionKt.toEntity(profile), IdentityProvider.ONFIDO).map((Function)getOnfidoKYCApplicantId.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"mKYCRepository.startKYC(\u2026     .map { it.data?.id }");
        return single;
    }

    @Override
    @NotNull
    public Single<String> getOnfidoKYCToken(@NotNull String applicantId, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Single single = this.mKYCRepository.generateSdkToken(applicantId, packageName).toSingle().map((Function)getOnfidoKYCToken.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"mKYCRepository.generateS\u2026Single().map { it.token }");
        return single;
    }

    @Override
    @NotNull
    public Single<Boolean> submitOnfidoKYC(@NotNull String applicantId) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Single single = this.mKYCRepository.submitCheckKyc(applicantId, IdentityProvider.ONFIDO).toSingle().map((Function)submitOnfidoKYC.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"mKYCRepository.submitChe\u2026      .map { it.success }");
        return single;
    }

    @Override
    @NotNull
    public Single<KYCStatus> getOnfidoKYCStatus(@NotNull String applicantId) {
        Intrinsics.checkNotNullParameter((Object)applicantId, (String)"applicantId");
        Single single = this.mKYCRepository.refreshKYCStatus(applicantId, IdentityProvider.ONFIDO).toSingle().map((Function)getOnfidoKYCStatus.1.INSTANCE).map((Function)getOnfidoKYCStatus.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"mKYCRepository.refreshKY\u2026          )\n            }");
        return single;
    }

    public KYCUseCase(@NotNull KYCRepositoryProtocol mKYCRepository2) {
        Intrinsics.checkNotNullParameter((Object)mKYCRepository2, (String)"mKYCRepository");
        this.mKYCRepository = mKYCRepository2;
    }
}

