/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk.core.domain;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.AccountRepositoryProtocol;
import one.credify.core.data.ClaimRepositoryProtocol;
import one.credify.core.data.KeyManagementRepositoryProtocol;
import one.credify.core.data.OfferRepositoryProtocol;
import one.credify.core.model.OfferModel;
import one.credify.core.model.ScopeModel;
import one.credify.crypto.Signing;
import one.credify.sdk.core.domain.OfferUseCase;
import one.credify.sdk.core.domain.OfferUseCaseProtocol;
import one.credify.sdk.core.extension.ModelMappingExtensionKt;
import one.credify.sdk.core.extension.StringExtensionKt;
import one.credify.sdk.core.model.EvaluationResult;
import one.credify.sdk.core.model.OfferList;
import one.credify.sdk.core.model.OfferScope;
import one.credify.sdk.core.model.RedeemOffer;
import one.credify.sdk.core.request.EvaluateOfferParam;
import one.credify.sdk.core.request.GetOfferListParam;
import one.credify.sdk.core.request.RedeemOfferParam;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lone/credify/sdk/core/domain/OfferUseCase;", "Lone/credify/sdk/core/domain/OfferUseCaseProtocol;", "mOfferRepository", "Lone/credify/core/data/OfferRepositoryProtocol;", "mKMRepository", "Lone/credify/core/data/KeyManagementRepositoryProtocol;", "mAccountRepository", "Lone/credify/core/data/AccountRepositoryProtocol;", "mClaimRepository", "Lone/credify/core/data/ClaimRepositoryProtocol;", "(Lone/credify/core/data/OfferRepositoryProtocol;Lone/credify/core/data/KeyManagementRepositoryProtocol;Lone/credify/core/data/AccountRepositoryProtocol;Lone/credify/core/data/ClaimRepositoryProtocol;)V", "evaluateOffer", "Lio/reactivex/Observable;", "Lone/credify/sdk/core/model/EvaluationResult;", "params", "Lone/credify/sdk/core/request/EvaluateOfferParam;", "getOfferList", "Lone/credify/sdk/core/model/OfferList;", "Lone/credify/sdk/core/request/GetOfferListParam;", "redeemOffer", "Lone/credify/sdk/core/model/RedeemOffer;", "Lone/credify/sdk/core/request/RedeemOfferParam;", "credify-sdk-core_release"})
public final class OfferUseCase
implements OfferUseCaseProtocol {
    private final OfferRepositoryProtocol mOfferRepository;
    private final KeyManagementRepositoryProtocol mKMRepository;
    private final AccountRepositoryProtocol mAccountRepository;
    private final ClaimRepositoryProtocol mClaimRepository;

    @Override
    @NotNull
    public Observable<OfferList> getOfferList(@NotNull GetOfferListParam params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string2 = params.getPhoneNumber();
        String formattedPhoneNumber = string2 != null ? StringExtensionKt.formatPhoneNumber(string2) : null;
        String hashedPhoneNumber = formattedPhoneNumber != null ? this.mKMRepository.hashPassword(formattedPhoneNumber) : null;
        String string3 = params.getCountryCode();
        String formattedCountryCode = string3 != null ? StringExtensionKt.formatCountryCode(string3) : null;
        String hashedCountryCode = formattedCountryCode != null ? this.mKMRepository.hashPassword(formattedCountryCode) : null;
        Observable observable = this.mOfferRepository.getClaimProviderOfferList(params.getLocalId(), params.getCredifyId(), hashedPhoneNumber, hashedCountryCode).map((Function)getOfferList.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mOfferRepository.getClai\u2026data.credifyId)\n        }");
        return observable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Observable<EvaluationResult> evaluateOffer(@NotNull EvaluateOfferParam params) {
        Collection<ScopeModel> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Iterable iterable = params.getScopeList();
        OfferModel offerModel = ModelMappingExtensionKt.toModel(params.getOffer());
        OfferRepositoryProtocol offerRepositoryProtocol = this.mOfferRepository;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OfferScope offerScope = (OfferScope)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ScopeModel scopeModel = ModelMappingExtensionKt.toModel((OfferScope)it);
            collection.add(scopeModel);
        }
        collection = (List)destination$iv$iv;
        Observable observable = offerRepositoryProtocol.evaluateOffer(offerModel, (List<ScopeModel>)collection).map((Function)evaluateOffer.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mOfferRepository.evaluat\u2026    it.toData()\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<RedeemOffer> redeemOffer(@NotNull RedeemOfferParam params) {
        OfferScope it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Iterable iterable = params.getScopeList();
        Object object2 = params.getOffer().getConsumerId();
        Object object3 = params.getEntityId();
        Object object4 = params.getSigningKey();
        Object object5 = this.mKMRepository;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            OfferScope offerScope = (OfferScope)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            object.add(string2);
        }
        object = (List)destination$iv$iv;
        String approvalToken = object5.generateApprovalToken((Signing)object4, (String)object3, (String)object2, CollectionsKt.plus((Collection)((Collection)object), (Object)"openid"), params.getOffer().getOfferCode());
        $this$map$iv = params.getScopeList();
        object4 = ModelMappingExtensionKt.toModel(params.getOffer());
        object5 = this.mOfferRepository;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (OfferScope)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object2 = ModelMappingExtensionKt.toModel(it);
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv;
        $this$map$iv = params.getPersistedScopeList();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (OfferScope)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = ModelMappingExtensionKt.toModel(it);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        Observable observable = object5.redeemOffer((OfferModel)object4, (List<ScopeModel>)object3, (List<ScopeModel>)object2, approvalToken).map((Function)redeemOffer.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"mOfferRepository.redeemO\u2026    it.toData()\n        }");
        return observable;
    }

    public OfferUseCase(@NotNull OfferRepositoryProtocol mOfferRepository2, @NotNull KeyManagementRepositoryProtocol mKMRepository2, @NotNull AccountRepositoryProtocol mAccountRepository2, @NotNull ClaimRepositoryProtocol mClaimRepository2) {
        Intrinsics.checkNotNullParameter((Object)mOfferRepository2, (String)"mOfferRepository");
        Intrinsics.checkNotNullParameter((Object)mKMRepository2, (String)"mKMRepository");
        Intrinsics.checkNotNullParameter((Object)mAccountRepository2, (String)"mAccountRepository");
        Intrinsics.checkNotNullParameter((Object)mClaimRepository2, (String)"mClaimRepository");
        this.mOfferRepository = mOfferRepository2;
        this.mKMRepository = mKMRepository2;
        this.mAccountRepository = mAccountRepository2;
        this.mClaimRepository = mClaimRepository2;
    }
}

