/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import one.credify.core.data.KeyManagementRepositoryProtocol;
import one.credify.core.entity.EncryptedKeyResponseData;
import one.credify.core.extensions.CommonExtensionsKt;
import one.credify.core.utilities.MoshiAdapters;
import one.credify.crypto.Encryption;
import one.credify.crypto.Signing;
import one.credify.sdk.core.model.Claim;
import one.credify.sdk.core.model.ValueType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lone/credify/sdk/core/util/CryptoUtils;", "", "()V", "decryptClaim", "", "Lone/credify/sdk/core/model/Claim;", "claimMap", "", "", "privateKey", "Lone/credify/crypto/Encryption;", "decryptKey", "Lkotlin/Pair;", "Lone/credify/crypto/Signing;", "kmRepository", "Lone/credify/core/data/KeyManagementRepositoryProtocol;", "password", "encryptedKeys", "Lone/credify/core/entity/EncryptedKeyResponseData;", "credify-sdk-core_release"})
public final class CryptoUtils {
    @NotNull
    public static final CryptoUtils INSTANCE;

    @NotNull
    public final Pair<Signing, Encryption> decryptKey(@NotNull KeyManagementRepositoryProtocol kmRepository, @NotNull String password, @NotNull EncryptedKeyResponseData encryptedKeys) {
        Intrinsics.checkNotNullParameter((Object)kmRepository, (String)"kmRepository");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encryptedKeys, (String)"encryptedKeys");
        Signing signing = kmRepository.decryptSigningKey(encryptedKeys.getSigningSecret(), password);
        Encryption encryption = kmRepository.decryptEncryptionPrivateKey(encryptedKeys.getEncryptionSecret(), password);
        return new Pair((Object)signing, (Object)encryption);
    }

    @NotNull
    public final List<Claim> decryptClaim(@NotNull Map<String, String> claimMap, @NotNull Encryption privateKey) {
        Intrinsics.checkNotNullParameter(claimMap, (String)"claimMap");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        boolean bl = false;
        List list = new ArrayList();
        Iterable $this$forEach$iv = claimMap.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry scope = (Map.Entry)element$iv;
            boolean bl2 = false;
            String encryptedData = (String)scope.getValue();
            String decryptedData = CommonExtensionsKt.decryptBase64(encryptedData, privateKey);
            Map mapData = (Map)MoshiAdapters.INSTANCE.getMapObject().fromJson(decryptedData);
            Object object = mapData;
            if (object == null || (object = object.entrySet()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry claim = (Map.Entry)element$iv2;
                boolean bl3 = false;
                ValueType valueType = ValueType.valueOf(CommonExtensionsKt.getValueType(claim.getValue()).name());
                String string2 = (String)scope.getKey();
                list.add(new Claim((String)claim.getKey(), claim.getValue().toString(), valueType, string2));
            }
        }
        return list;
    }

    private CryptoUtils() {
    }

    static {
        CryptoUtils cryptoUtils;
        INSTANCE = cryptoUtils = new CryptoUtils();
    }
}

