/*
 * Decompiled with CFR 0.152.
 */
package one.credify.sdk.scenes.offer.detail;

import androidx.annotation.VisibleForTesting;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.rxkotlin.DisposableKt;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import one.credify.crypto.Encryption;
import one.credify.crypto.KeyCreator;
import one.credify.crypto.Signing;
import one.credify.sdk.core.domain.AccountUseCaseProtocol;
import one.credify.sdk.core.domain.ClaimUseCaseProtocol;
import one.credify.sdk.core.domain.KeyManagementUseCaseProtocol;
import one.credify.sdk.core.domain.OfferUseCaseProtocol;
import one.credify.sdk.core.extension.StringExtensionKt;
import one.credify.sdk.core.model.Claim;
import one.credify.sdk.core.model.EvaluationResult;
import one.credify.sdk.core.model.OfferDetail;
import one.credify.sdk.core.model.OfferScope;
import one.credify.sdk.core.model.RedeemOffer;
import one.credify.sdk.core.request.EvaluateOfferParam;
import one.credify.sdk.core.request.RedeemOfferParam;
import one.credify.sdk.core.util.CryptoUtils;
import one.credify.sdk.core.util.Logger;
import one.credify.sdk.scenes.base.BasePresenter;
import one.credify.sdk.scenes.base.ToastType;
import one.credify.sdk.scenes.offer.detail.OfferDetailContract;
import one.credify.sdk.scenes.offer.detail.OfferDetailPresenter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J,\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lone/credify/sdk/scenes/offer/detail/OfferDetailPresenter;", "Lone/credify/sdk/scenes/base/BasePresenter;", "Lone/credify/sdk/scenes/offer/detail/OfferDetailContract$View;", "Lone/credify/sdk/scenes/offer/detail/OfferDetailContract$Presenter;", "mAccountUseCase", "Lone/credify/sdk/core/domain/AccountUseCaseProtocol;", "mKMUseCase", "Lone/credify/sdk/core/domain/KeyManagementUseCaseProtocol;", "mClaimUseCase", "Lone/credify/sdk/core/domain/ClaimUseCaseProtocol;", "mOfferUseCase", "Lone/credify/sdk/core/domain/OfferUseCaseProtocol;", "mDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "(Lone/credify/sdk/core/domain/AccountUseCaseProtocol;Lone/credify/sdk/core/domain/KeyManagementUseCaseProtocol;Lone/credify/sdk/core/domain/ClaimUseCaseProtocol;Lone/credify/sdk/core/domain/OfferUseCaseProtocol;Lio/reactivex/disposables/CompositeDisposable;)V", "mKeyPair", "Lkotlin/Pair;", "Lone/credify/crypto/Signing;", "Lone/credify/crypto/Encryption;", "evaluateOffer", "Lio/reactivex/Observable;", "", "offerDetail", "Lone/credify/sdk/core/model/OfferDetail;", "scopeList", "", "Lone/credify/sdk/core/model/OfferScope;", "generateKeys", "", "loadRequireData", "password", "providerId", "redeemOffer", "Lio/reactivex/disposables/Disposable;", "persistedScopeList", "credify-sdk_release"})
public final class OfferDetailPresenter
extends BasePresenter<OfferDetailContract.View>
implements OfferDetailContract.Presenter {
    private Pair<? extends Signing, ? extends Encryption> mKeyPair;
    private final AccountUseCaseProtocol mAccountUseCase;
    private final KeyManagementUseCaseProtocol mKMUseCase;
    private final ClaimUseCaseProtocol mClaimUseCase;
    private final OfferUseCaseProtocol mOfferUseCase;
    private final CompositeDisposable mDisposable;

    @Override
    public void loadRequireData(@NotNull String password, @NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        OfferDetailContract.View view = (OfferDetailContract.View)this.getMView();
        if (view != null) {
            view.showProgressBar();
        }
        Disposable disposable = Single.zip((SingleSource)((SingleSource)this.mKMUseCase.getKey(password)), (SingleSource)((SingleSource)this.mClaimUseCase.getEncryptClaim()), (SingleSource)((SingleSource)this.mClaimUseCase.getAttachedCustomClaim(providerId)), (Function3)loadRequireData.1.INSTANCE).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(new Action(this){
            final /* synthetic */ OfferDetailPresenter this$0;

            public final void run() {
                block0: {
                    OfferDetailContract.View view = OfferDetailPresenter.access$getMView$p(this.this$0);
                    if (view == null) break block0;
                    view.dismissProgressBar();
                }
            }
            {
                this.this$0 = offerDetailPresenter;
            }
        }).subscribe((Consumer)new Consumer<Triple<? extends Pair<? extends Signing, ? extends Encryption>, ? extends Map<String, ? extends String>, ? extends List<? extends Claim>>>(this){
            final /* synthetic */ OfferDetailPresenter this$0;

            public final void accept(Triple<? extends Pair<? extends Signing, ? extends Encryption>, ? extends Map<String, String>, ? extends List<Claim>> it) {
                block0: {
                    OfferDetailPresenter.access$setMKeyPair$p(this.this$0, (Pair)it.getFirst());
                    Object object = it.getSecond();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.second");
                    Map encryptedClaimMap = (Map)object;
                    List<Claim> claimList = CryptoUtils.INSTANCE.decryptClaim(encryptedClaimMap, (Encryption)((Pair)it.getFirst()).getSecond());
                    boolean bl = false;
                    List finalList = new ArrayList<E>();
                    finalList.addAll((Collection)claimList);
                    Object object2 = it.getThird();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.third");
                    finalList.addAll((Collection)object2);
                    OfferDetailContract.View view = OfferDetailPresenter.access$getMView$p(this.this$0);
                    if (view == null) break block0;
                    view.updateClaimList(finalList);
                }
            }
            {
                this.this$0 = offerDetailPresenter;
            }
        }, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ OfferDetailPresenter this$0;

            public final void accept(Throwable it) {
                Logger.INSTANCE.d(StringExtensionKt.getCLASS_NAME(this.this$0), it.getMessage(), it);
            }
            {
                this.this$0 = offerDetailPresenter;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Single.zip(\n            \u2026          }\n            )");
        DisposableKt.addTo((Disposable)disposable, (CompositeDisposable)this.mDisposable);
    }

    @Override
    @NotNull
    public Observable<String> evaluateOffer(@NotNull OfferDetail offerDetail, @NotNull List<OfferScope> scopeList2) {
        Intrinsics.checkNotNullParameter((Object)offerDetail, (String)"offerDetail");
        Intrinsics.checkNotNullParameter(scopeList2, (String)"scopeList");
        Observable observable = Observable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).flatMap((Function)new Function<Long, ObservableSource<? extends EvaluationResult>>(this, offerDetail, scopeList2){
            final /* synthetic */ OfferDetailPresenter this$0;
            final /* synthetic */ OfferDetail $offerDetail;
            final /* synthetic */ List $scopeList;

            public final ObservableSource<? extends EvaluationResult> apply(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (ObservableSource)OfferDetailPresenter.access$getMOfferUseCase$p(this.this$0).evaluateOffer(new EvaluateOfferParam(this.$offerDetail.getOffer(), this.$scopeList));
            }
            {
                this.this$0 = offerDetailPresenter;
                this.$offerDetail = offerDetail;
                this.$scopeList = list;
            }
        }).map((Function)new Function<EvaluationResult, String>(offerDetail){
            final /* synthetic */ OfferDetail $offerDetail;

            public final String apply(@NotNull EvaluationResult evaluateModel) {
                Intrinsics.checkNotNullParameter((Object)evaluateModel, (String)"evaluateModel");
                String string2 = this.$offerDetail.getOffer().getLevelString(evaluateModel.getRank());
                if (string2 == null) {
                    string2 = "";
                }
                return string2;
            }
            {
                this.$offerDetail = offerDetail;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.timer(500, Ti\u2026rank) ?: \"\"\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Disposable redeemOffer(@NotNull OfferDetail offerDetail, @NotNull List<OfferScope> scopeList2, @NotNull List<OfferScope> persistedScopeList) {
        Intrinsics.checkNotNullParameter((Object)offerDetail, (String)"offerDetail");
        Intrinsics.checkNotNullParameter(scopeList2, (String)"scopeList");
        Intrinsics.checkNotNullParameter(persistedScopeList, (String)"persistedScopeList");
        OfferDetailContract.View view = (OfferDetailContract.View)this.getMView();
        if (view != null) {
            view.showProgressBar();
        }
        Pair<? extends Signing, ? extends Encryption> pair = this.mKeyPair;
        Intrinsics.checkNotNull(pair);
        Disposable disposable = this.mOfferUseCase.redeemOffer(new RedeemOfferParam((Signing)pair.getFirst(), offerDetail.getEntityId(), offerDetail.getOffer(), scopeList2, persistedScopeList)).observeOn(Schedulers.io()).subscribeOn(Schedulers.io()).doFinally(new Action(this){
            final /* synthetic */ OfferDetailPresenter this$0;

            public final void run() {
                block0: {
                    OfferDetailContract.View view = OfferDetailPresenter.access$getMView$p(this.this$0);
                    if (view == null) break block0;
                    view.dismissProgressBar();
                }
            }
            {
                this.this$0 = offerDetailPresenter;
            }
        }).subscribe((Consumer)new Consumer<RedeemOffer>(this, offerDetail){
            final /* synthetic */ OfferDetailPresenter this$0;
            final /* synthetic */ OfferDetail $offerDetail;

            public final void accept(RedeemOffer model) {
                block7: {
                    String redirectUrl;
                    String string2;
                    boolean bl;
                    CharSequence charSequence;
                    String string3 = model.getRedirectUrl();
                    if (string3 != null) {
                        charSequence = string3;
                        bl = false;
                        String string4 = charSequence;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                    } else {
                        string2 = redirectUrl = null;
                    }
                    if (this.$offerDetail.getOffer().getHasExtraStep()) {
                        String string5 = redirectUrl;
                        if (string5 != null) {
                            charSequence = string5;
                            bl = false;
                            if (charSequence.length() > 0) {
                                OfferDetailContract.View view = OfferDetailPresenter.access$getMView$p(this.this$0);
                                if (view != null) {
                                    view.goExtraStep(redirectUrl);
                                }
                                return;
                            }
                        }
                    }
                    OfferDetailContract.View view = OfferDetailPresenter.access$getMView$p(this.this$0);
                    if (view == null) break block7;
                    view.openRedeemOfferSuccessPage(this.$offerDetail, model.getApproval());
                }
            }
            {
                this.this$0 = offerDetailPresenter;
                this.$offerDetail = offerDetail;
            }
        }, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ OfferDetailPresenter this$0;

            public final void accept(Throwable error) {
                block0: {
                    Logger.INSTANCE.d(StringExtensionKt.getCLASS_NAME(this.this$0), error.getMessage(), error);
                    OfferDetailContract.View view = OfferDetailPresenter.access$getMView$p(this.this$0);
                    if (view == null) break block0;
                    view.showToast(null, String.valueOf(error.getMessage()), ToastType.ERROR);
                }
            }
            {
                this.this$0 = offerDetailPresenter;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"mOfferUseCase.redeemOffe\u2026          }\n            )");
        return disposable;
    }

    @VisibleForTesting(otherwise=2)
    public final void generateKeys() {
        this.mKeyPair = new Pair((Object)new KeyCreator().createSigningKey(), (Object)new KeyCreator().createEncryptionKey());
    }

    public OfferDetailPresenter(@NotNull AccountUseCaseProtocol mAccountUseCase2, @NotNull KeyManagementUseCaseProtocol mKMUseCase, @NotNull ClaimUseCaseProtocol mClaimUseCase2, @NotNull OfferUseCaseProtocol mOfferUseCase2, @NotNull CompositeDisposable mDisposable) {
        Intrinsics.checkNotNullParameter((Object)mAccountUseCase2, (String)"mAccountUseCase");
        Intrinsics.checkNotNullParameter((Object)mKMUseCase, (String)"mKMUseCase");
        Intrinsics.checkNotNullParameter((Object)mClaimUseCase2, (String)"mClaimUseCase");
        Intrinsics.checkNotNullParameter((Object)mOfferUseCase2, (String)"mOfferUseCase");
        Intrinsics.checkNotNullParameter((Object)mDisposable, (String)"mDisposable");
        this.mAccountUseCase = mAccountUseCase2;
        this.mKMUseCase = mKMUseCase;
        this.mClaimUseCase = mClaimUseCase2;
        this.mOfferUseCase = mOfferUseCase2;
        this.mDisposable = mDisposable;
    }

    public static final /* synthetic */ OfferDetailContract.View access$getMView$p(OfferDetailPresenter $this) {
        return (OfferDetailContract.View)$this.getMView();
    }

    public static final /* synthetic */ void access$setMView$p(OfferDetailPresenter $this, OfferDetailContract.View view) {
        $this.setMView(view);
    }

    public static final /* synthetic */ Pair access$getMKeyPair$p(OfferDetailPresenter $this) {
        return $this.mKeyPair;
    }

    public static final /* synthetic */ void access$setMKeyPair$p(OfferDetailPresenter $this, Pair pair) {
        $this.mKeyPair = pair;
    }

    public static final /* synthetic */ OfferUseCaseProtocol access$getMOfferUseCase$p(OfferDetailPresenter $this) {
        return $this.mOfferUseCase;
    }
}

